/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.modelqualitychecks;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.modelqualitychecks.PGuard;
import org.eclipse.comma.modelqualitychecks.PInput;
import org.eclipse.comma.modelqualitychecks.SnakesHelper;
import org.eclipse.comma.signature.interfaceSignature.Signal;

class PTransition {
    private static int nextID = 0;
    final String name = "T" + nextID;
    final Object event;
    final TriggeredTransition trigger;
    private final PGuard guard;

    static void resetIDCounter() {
        nextID = 0;
    }

    PTransition() {
        this(null, null, null);
    }

    PTransition(Object event) {
        this(event, null, null);
    }

    PTransition(Object event, TriggeredTransition trigger) {
        this(event, null, trigger);
    }

    PTransition(PGuard guard) {
        this(null, guard, null);
    }

    PTransition(Object event, PGuard guard) {
        this(event, guard, null);
    }

    PTransition(Object event, PGuard guard, TriggeredTransition trigger) {
        this.event = event;
        this.guard = guard;
        this.trigger = trigger;
        ++nextID;
    }

    String getSnakesName(Function<String, String> variablePrefix) {
        String name = this.name;
        if (this.event != null) {
            name = String.valueOf(name) + String.format("_event_%s", SnakesHelper.name(this.event, this.trigger));
        }
        return name;
    }

    String toSnakes(Function<String, String> variablePrefix, List<PInput> inputs) {
        String expr = "";
        if (this.guard != null) {
            expr = String.format(", Expression('%s')", this.guard.toSnakes(variablePrefix, inputs));
        }
        String eventMeta = "";
        if (this.event != null) {
            String name = SnakesHelper.name(this.event, this.trigger);
            String parameters = SnakesHelper.parameters(this.event, variablePrefix).stream().map(p -> String.format("'%s'", p)).collect(Collectors.joining(","));
            String type = this.event instanceof CommandReply ? "reply" : (this.event instanceof EventCall ? "notification" : (((TriggeredTransition)this.event).getTrigger() instanceof Signal ? "signal" : "command"));
            eventMeta = String.format(",'event': {'name': '%s', 'type': '%s', 'parameters': [%s]}", name, type, parameters);
        }
        String typeMeta = String.format("'type': '%s'", this.event != null ? "event" : "none");
        String meta = String.format("{%s%s}", typeMeta, eventMeta);
        return String.format("add_transition(Transition('%s'%s), %s)\n", this.getSnakesName(variablePrefix), expr, meta);
    }
}

