/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.concierge.AbstractBundle;
import org.eclipse.concierge.BundleImpl;
import org.eclipse.concierge.Concierge;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServiceReferenceImpl<S>
implements ServiceReference<S> {
    protected final Concierge framework;
    Bundle bundle;
    protected S service;
    final Map<String, Object> properties;
    final Map<Bundle, Integer> useCounters = new HashMap<Bundle, Integer>(0);
    private HashMap<Bundle, S> cachedServices = null;
    ServiceRegistration<S> registration;
    private static long nextServiceID = 0L;
    private final boolean isServiceFactory;
    protected static final HashSet<String> forbidden = new HashSet(2);
    private boolean marker = false;

    ServiceReferenceImpl(Concierge framework, Bundle bundle, S service, Dictionary<String, ?> props, String[] clazzes) {
        if (service instanceof ServiceFactory) {
            this.isServiceFactory = true;
        } else {
            this.isServiceFactory = false;
            this.checkService(service, clazzes);
        }
        this.framework = framework;
        this.bundle = bundle;
        this.service = service;
        this.properties = new HashMap<String, Object>(props == null ? 2 : props.size() + 2);
        if (props != null) {
            Enumeration<String> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                this.properties.put(key, props.get(key));
            }
        }
        this.properties.put("objectClass", clazzes);
        this.properties.put("service.id", new Long(++nextServiceID));
        Integer ranking = props == null ? null : (Integer)props.get("service.ranking");
        this.properties.put("service.ranking", ranking == null ? new Integer(0) : ranking);
        this.registration = new ServiceRegistrationImpl();
    }

    private void checkService(Object service, String[] clazzes) throws IllegalArgumentException {
        if (service == null) {
            throw new IllegalArgumentException("ServiceFactory produced /null/");
        }
        for (int i = 0; i < clazzes.length; ++i) {
            try {
                Class<?> current = Class.forName(clazzes[i], false, service.getClass().getClassLoader());
                if (current.isInstance(service)) continue;
                throw new IllegalArgumentException("Service " + service.getClass().getName() + " does not implement the interface " + clazzes[i]);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Interface " + clazzes[i] + " implemented by service " + service.getClass().getName() + " cannot be located: " + e.getMessage());
            }
        }
    }

    void invalidate() {
        this.service = null;
        this.useCounters.clear();
        this.bundle = null;
        this.registration = null;
        if (this.cachedServices != null) {
            this.cachedServices = null;
        }
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public Object getProperty(String key) {
        Object result = this.properties.get(key);
        if (result != null) {
            return result;
        }
        result = this.properties.get(key.toLowerCase());
        if (result != null) {
            return result;
        }
        for (String k : this.properties.keySet()) {
            if (!k.equalsIgnoreCase(key)) continue;
            result = this.properties.get(k);
            break;
        }
        return result;
    }

    @Override
    public String[] getPropertyKeys() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle[] getUsingBundles() {
        Map<Bundle, Integer> map = this.useCounters;
        synchronized (map) {
            if (this.useCounters.isEmpty()) {
                return null;
            }
            return this.useCounters.keySet().toArray(new Bundle[this.useCounters.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    S getService(Bundle theBundle) {
        if (this.service == null || this.marker) {
            return null;
        }
        Map<Bundle, Integer> map = this.useCounters;
        synchronized (map) {
            if (this.isServiceFactory) {
                S factoredService;
                S cachedService;
                if (this.cachedServices == null) {
                    this.cachedServices = new HashMap(1);
                }
                if ((cachedService = this.cachedServices.get(theBundle)) != null) {
                    this.incrementCounter(theBundle);
                    return cachedService;
                }
                ServiceFactory factory = (ServiceFactory)this.service;
                try {
                    this.incrementCounter(theBundle);
                    this.marker = true;
                    factoredService = factory.getService(theBundle, this.registration);
                    this.marker = false;
                    this.checkService(factoredService, (String[])this.properties.get("objectClass"));
                }
                catch (IllegalArgumentException iae) {
                    this.decrementCounter(theBundle);
                    this.framework.notifyFrameworkListeners(2, this.bundle, new ServiceException("Invalid service object", 2));
                    return null;
                }
                catch (Throwable t) {
                    this.decrementCounter(theBundle);
                    this.framework.notifyFrameworkListeners(2, this.bundle, new ServiceException("Exception while factoring the service", 3, t));
                    return null;
                }
                this.cachedServices.put(theBundle, factoredService);
                return factoredService;
            }
            this.incrementCounter(theBundle);
            return this.service;
        }
    }

    private void incrementCounter(Bundle theBundle) {
        Integer counter = this.useCounters.get(theBundle);
        counter = counter == null ? new Integer(1) : new Integer(counter + 1);
        this.useCounters.put(theBundle, counter);
    }

    private void decrementCounter(Bundle theBundle) {
        Integer counter = this.useCounters.get(theBundle);
        int newValue = counter - 1;
        counter = newValue == 0 ? null : new Integer(newValue);
        this.useCounters.put(theBundle, counter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ungetService(Bundle theBundle) {
        Map<Bundle, Integer> map = this.useCounters;
        synchronized (map) {
            if (this.service == null) {
                return false;
            }
            Integer counter = this.useCounters.get(theBundle);
            if (counter == null) {
                return false;
            }
            if (counter == 1) {
                if (this.isServiceFactory) {
                    try {
                        ((ServiceFactory)this.service).ungetService(theBundle, this.registration, this.cachedServices.get(theBundle));
                    }
                    catch (Throwable t) {
                        this.framework.notifyFrameworkListeners(2, this.bundle, t);
                    }
                    this.useCounters.remove(theBundle);
                    this.cachedServices.remove(theBundle);
                }
                return true;
            }
            counter = new Integer(counter - 1);
            this.useCounters.put(theBundle, counter);
            return true;
        }
    }

    public String toString() {
        return "ServiceReference{" + this.service + "}";
    }

    @Override
    public int compareTo(Object reference) {
        if (!(reference instanceof ServiceReferenceImpl) || ((ServiceReferenceImpl)reference).framework != this.framework) {
            throw new IllegalArgumentException("ServiceReference was not created by the same framework instance");
        }
        ServiceReferenceImpl other = (ServiceReferenceImpl)reference;
        int comparedServiceIds = ((Long)this.properties.get("service.id")).compareTo((Long)other.properties.get("service.id"));
        if (comparedServiceIds == 0) {
            return 0;
        }
        int res = ((Integer)this.properties.get("service.ranking")).compareTo((Integer)other.properties.get("service.ranking"));
        if (res < 0) {
            return -1;
        }
        if (res > 0) {
            return 1;
        }
        if (comparedServiceIds < 0) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isAssignableTo(Bundle theBundle, String className) {
        if (theBundle == this.bundle || this.bundle == this.framework || theBundle == this.framework) {
            return true;
        }
        BundleImpl otherBundle = (BundleImpl)theBundle;
        BundleImpl ourBundle = (BundleImpl)this.bundle;
        try {
            return otherBundle.loadClass(className) == ourBundle.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    boolean isAssignableTo(AbstractBundle otherBundle, String[] clazzes) {
        for (int j = 0; j < clazzes.length; ++j) {
            if (this.isAssignableTo((Bundle)otherBundle, clazzes[j])) continue;
            return false;
        }
        return true;
    }

    static {
        forbidden.add("service.id".toLowerCase());
        forbidden.add("objectClass".toLowerCase());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ServiceRegistrationImpl
    implements ServiceRegistration<S> {
        protected ServiceRegistrationImpl() {
        }

        @Override
        public ServiceReference<S> getReference() {
            if (ServiceReferenceImpl.this.service == null) {
                throw new IllegalStateException("Service has already been uninstalled");
            }
            return ServiceReferenceImpl.this;
        }

        @Override
        public void setProperties(Dictionary<String, ?> newProps) {
            if (ServiceReferenceImpl.this.service == null) {
                throw new IllegalStateException("Service has already been uninstalled");
            }
            HashMap<String, Object> oldProps = new HashMap<String, Object>(ServiceReferenceImpl.this.properties);
            HashMap<String, String> cases = new HashMap<String, String>(ServiceReferenceImpl.this.properties.size());
            for (String key : ServiceReferenceImpl.this.properties.keySet()) {
                String lower = key.toLowerCase();
                if (cases.containsKey(lower)) {
                    throw new IllegalArgumentException("Properties contain the same key in different case variants");
                }
                cases.put(lower, key);
            }
            Enumeration<String> keys = newProps.keys();
            while (keys.hasMoreElements()) {
                String key;
                key = keys.nextElement();
                Object value = newProps.get(key);
                String lower = key.toLowerCase();
                if (forbidden.contains(lower)) continue;
                Object existing = cases.get(lower);
                if (existing != null) {
                    if (existing.equals(key)) {
                        ServiceReferenceImpl.this.properties.remove(existing);
                    } else {
                        throw new IllegalArgumentException("Properties already exists in a different case variant");
                    }
                }
                ServiceReferenceImpl.this.properties.put(key, value);
            }
            ServiceReferenceImpl.this.framework.notifyServiceListeners(2, ServiceReferenceImpl.this, oldProps);
        }

        @Override
        public void unregister() {
            if (ServiceReferenceImpl.this.service == null) {
                throw new IllegalStateException("Service has already been uninstalled");
            }
            ServiceReferenceImpl.this.framework.unregisterService(ServiceReferenceImpl.this);
            ServiceReferenceImpl.this.service = null;
        }
    }
}

