/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge.compat.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.concierge.BundleImpl;
import org.eclipse.concierge.Concierge;
import org.eclipse.concierge.ConciergeCollections;
import org.eclipse.concierge.Resources;
import org.eclipse.concierge.Utils;
import org.eclipse.concierge.compat.LegacyBundleProcessing;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleManifestTwo
implements LegacyBundleProcessing {
    private static final String SPECIFICATION_VERSION = "specification-version";
    private static final String BUNDLE_REQUIREDEXECUTIONENVIRONMENT = "Bundle-RequiredExecutionEnvironment";
    private static final String FRAMEWORK_EXECUTIONENVIRONMENT = "org.osgi.framework.executionenvironment";
    private static final Pattern PARSE_EE = Pattern.compile("([^-|\\.]*)(?:\\-(\\d\\.\\d))(?:\\/([^\\d|\\.|\\/]*))|([^\\d|\\.|\\/]*)(?:\\/([^-|\\.]*)(?:\\-(\\d\\.\\d)))|([^\\.|\\d]*)");
    private static final Pattern PARSE_EE2 = Pattern.compile("([^-|\\.]*)(?:\\-(\\d\\.\\d))?(?:\\/([^-|\\.]*)(?:\\-(\\d\\.\\d))?)?");

    @Override
    public ConciergeCollections.Tuple<List<BundleCapability>, List<BundleRequirement>> processManifest(BundleImpl.Revision revision, Manifest manifest) throws BundleException {
        String requireBundleStr;
        String exportStr;
        ConciergeCollections.ParseResult parseResult;
        String dynImportStr;
        HashMap<String, String> dirs;
        ConciergeCollections.ParseResult parseResult2;
        Version bundleVersion;
        Attributes mfAttrs = manifest.getMainAttributes();
        ArrayList<Resources.BundleCapabilityImpl> caps = new ArrayList<Resources.BundleCapabilityImpl>();
        ArrayList<Resources.BundleRequirementImpl> reqs = new ArrayList<Resources.BundleRequirementImpl>();
        String symNameStr = mfAttrs.getValue("Bundle-SymbolicName");
        if (symNameStr == null) {
            throw new BundleException("Bundle with Bundle-ManifestVersion=2 must specify Bundle-SymbolicName");
        }
        String[] parts = Utils.splitString(symNameStr, ';');
        if (parts[0].contains(";")) {
            throw new IllegalArgumentException(symNameStr);
        }
        ConciergeCollections.ParseResult parseResult3 = Utils.parseLiterals(parts, 1);
        HashMap<String, Object> symbolicNameAttrs = parseResult3.getAttributes();
        String fragHostStr = mfAttrs.getValue("Fragment-Host");
        HashMap<String, Object> attrs = new HashMap<String, Object>(symbolicNameAttrs);
        HashMap<String, String> dirs2 = new HashMap<String, String>();
        String bundleSymbolicName = parts[0].trim();
        attrs.put("osgi.wiring.bundle", bundleSymbolicName);
        try {
            bundleVersion = Version.parseVersion(mfAttrs.getValue("Bundle-Version"));
            attrs.put("bundle-version", bundleVersion);
        }
        catch (IllegalArgumentException e) {
            throw new BundleException("Syntactic error in bundle manifest", e);
        }
        String singletonStr = parseResult3.getDirectives().get("singleton");
        dirs2.put("singleton", singletonStr == null ? "false" : singletonStr.trim());
        String mandatory = parseResult3.getDirectives().get("mandatory");
        if (mandatory != null) {
            dirs2.put("mandatory", mandatory);
        }
        if (fragHostStr == null) {
            Resources.BundleCapabilityImpl bundle = new Resources.BundleCapabilityImpl(revision, "osgi.wiring.bundle", dirs2, attrs, "Bundle " + bundleSymbolicName + ' ' + bundleVersion);
            caps.add(bundle);
        }
        HashMap<String, Object> attrs2 = new HashMap<String, Object>(attrs);
        HashMap<String, String> dirs22 = new HashMap<String, String>(dirs2);
        attrs2.remove("osgi.wiring.bundle");
        attrs2.put("osgi.identity", bundleSymbolicName);
        attrs2.remove("bundle-version");
        attrs2.put("version", bundleVersion);
        attrs2.put("type", fragHostStr != null ? "osgi.fragment" : "osgi.bundle");
        this.addAttributeIfPresent(attrs2, "copyright", mfAttrs, "Bundle-Copyright");
        this.addAttributeIfPresent(attrs2, "description", mfAttrs, "Bundle-Description");
        this.addAttributeIfPresent(attrs2, "documentation", mfAttrs, "Bundle-DocURL");
        this.addAttributeIfPresent(attrs2, "license", mfAttrs, "Bundle-License");
        Resources.BundleCapabilityImpl identity = new Resources.BundleCapabilityImpl(revision, "osgi.identity", dirs22, attrs2, "Identity " + bundleSymbolicName + ' ' + bundleVersion);
        caps.add(identity);
        if (fragHostStr != null) {
            boolean extension;
            HashMap<String, String> dirs23 = new HashMap<String, String>();
            String[] parts2 = Utils.splitString(fragHostStr, ';');
            if (parts2[0].contains(";")) {
                throw new IllegalArgumentException(fragHostStr);
            }
            ConciergeCollections.ParseResult parseResult22 = Utils.parseLiterals(parts2, 1);
            if (parseResult22.getDirectives() != null) {
                dirs23.putAll(parseResult22.getDirectives());
            }
            dirs23.remove("uses");
            dirs23.remove("effective");
            dirs23.put("filter", Utils.createFilter("osgi.wiring.host", parts2[0], parseResult22.getAttributes()));
            dirs23.put("cardinality", "multiple");
            dirs23.put("osgi.wiring.host", parts2[0]);
            String versionRange = (String)parseResult22.getAttributes().get("bundle-version");
            if (versionRange != null) {
                dirs23.put("bundle-version", versionRange);
            }
            boolean bl = extension = parts2[0].equals("system.bundle") || parts2[0].equals("org.eclipse.concierge");
            if (!Concierge.SUPPORTS_EXTENSIONS) {
                throw new BundleException("Framework does not support extensions");
            }
            if ("framework".equals(dirs23.get("extension")) || extension) {
                if (!extension) {
                    throw new BundleException("wrong host " + parts2[0] + " for an extension bundle");
                }
                if (mfAttrs.getValue("Import-Package") != null) {
                    throw new BundleException("Framework extension bundle must not declare package imports");
                }
                if (mfAttrs.getValue("Require-Bundle") != null) {
                    throw new BundleException("Framework extension bundle must not declare require bundle");
                }
                if (mfAttrs.getValue("Bundle-NativeCode") != null) {
                    throw new BundleException("Framework extension bundle must not declare native code");
                }
            }
            Resources.BundleRequirementImpl hostReq = new Resources.BundleRequirementImpl(revision, "osgi.wiring.host", dirs23, null, "Fragment-Host " + parts2[0] + ' ' + (versionRange == null ? "" : versionRange));
            reqs.add(hostReq);
        } else if (!"never".equals(parseResult3.getDirectives().get("fragment-attachment"))) {
            attrs = new HashMap();
            dirs2 = new HashMap();
            if (parseResult3.getDirectives() != null) {
                dirs2.putAll(parseResult3.getDirectives());
            }
            attrs.putAll(symbolicNameAttrs);
            attrs.put("osgi.wiring.host", bundleSymbolicName);
            attrs.put("bundle-version", bundleVersion);
            dirs2.remove("uses");
            dirs2.remove("effective");
            Resources.BundleCapabilityImpl hostCap = new Resources.BundleCapabilityImpl(revision, "osgi.wiring.host", dirs2, attrs, "Host " + bundleSymbolicName + ' ' + bundleVersion);
            caps.add(hostCap);
        }
        String requiredEEStr = mfAttrs.getValue(BUNDLE_REQUIREDEXECUTIONENVIRONMENT);
        if (requiredEEStr != null) {
            String[] requiredEEs = requiredEEStr.split(",");
            StringBuffer buffer = new StringBuffer();
            buffer.append("osgi.ee; filter:=\"");
            if (requiredEEs.length > 1) {
                buffer.append("(|");
            }
            for (int i = 0; i < requiredEEs.length; ++i) {
                String version;
                String ee2;
                String ee1;
                String requiredEE = requiredEEs[i].trim();
                Matcher matcher = PARSE_EE.matcher(requiredEE);
                if (matcher.matches()) {
                    if (matcher.group(1) != null) {
                        ee1 = matcher.group(1);
                        ee2 = matcher.group(3);
                        version = matcher.group(2);
                    } else if (matcher.group(4) != null) {
                        ee1 = matcher.group(4);
                        ee2 = matcher.group(5);
                        version = matcher.group(6);
                    } else {
                        String s = matcher.group(7);
                        int pos = s.indexOf(47);
                        ee1 = pos > -1 ? s.substring(0, pos) : s;
                        ee2 = pos > -1 ? s.substring(pos + 1, s.length()) : null;
                        version = null;
                    }
                } else {
                    Matcher matcher2 = PARSE_EE2.matcher(requiredEE);
                    if (matcher2.matches()) {
                        if (matcher2.group(4) == null || matcher2.group(2).equals(matcher2.group(4))) {
                            ee1 = matcher2.group(1);
                            version = matcher2.group(2);
                            ee2 = matcher2.group(3);
                        } else {
                            ee1 = matcher2.group(1) + "-" + matcher2.group(2);
                            ee2 = matcher2.group(3) + "-" + matcher2.group(4);
                            version = null;
                        }
                    } else {
                        throw new BundleException("invalid bree string " + requiredEE);
                    }
                }
                if (version != null) {
                    buffer.append("(&(");
                } else {
                    buffer.append('(');
                }
                buffer.append("osgi.ee");
                buffer.append('=');
                buffer.append("J2SE".equals(ee1) ? "JavaSE" : ee1);
                if (ee2 != null) {
                    buffer.append('/');
                    buffer.append(ee2);
                }
                if (version != null) {
                    buffer.append(")(version=");
                    buffer.append(version);
                    buffer.append("))");
                    continue;
                }
                buffer.append(')');
            }
            if (requiredEEs.length > 1) {
                buffer.append(')');
            }
            buffer.append('\"');
            reqs.add(new Resources.BundleRequirementImpl(revision, buffer.toString()));
        }
        HashSet<String> importSet = new HashSet<String>();
        String importStr = mfAttrs.getValue("Import-Package");
        if (importStr != null) {
            String[] imports = Utils.splitString(importStr, ',');
            for (int i = 0; i < imports.length; ++i) {
                String[] literals = Utils.splitString(imports[i], ';');
                if (literals[0].startsWith("java.")) {
                    throw new BundleException("Explicit import of java.* packages is not permitted", 3);
                }
                if (importSet.contains(literals[0])) {
                    throw new BundleException("Duplicate import " + literals[0], 3);
                }
                importSet.add(literals[0]);
                parseResult2 = Utils.parseLiterals(literals, 1);
                dirs = parseResult2.getDirectives();
                dirs.put("filter", Utils.createFilter("osgi.wiring.package", literals[0], parseResult2.getAttributes()));
                dirs.put("x-int", literals[0]);
                reqs.add(new Resources.BundleRequirementImpl(revision, "osgi.wiring.package", dirs, null, "Import-Package " + imports[i]));
            }
        }
        if ((dynImportStr = mfAttrs.getValue("DynamicImport-Package")) != null) {
            String[] dynImports = Utils.splitString(dynImportStr, ',');
            for (int i = 0; i < dynImports.length; ++i) {
                String[] literals = Utils.splitString(dynImports[i], ';');
                parseResult = Utils.parseLiterals(literals, 1);
                HashMap<String, String> dirs3 = parseResult.getDirectives();
                dirs3.put("filter", Utils.createFilter("osgi.wiring.package", literals[0], parseResult.getAttributes()));
                dirs3.put("resolution", "dynamic");
                dirs3.put("effective", "active");
                dirs3.put("x-int", literals[0].trim());
                if (literals[0].contains("*")) {
                    dirs3.put("cardinality", "multiple");
                }
                reqs.add(new Resources.BundleRequirementImpl(revision, "osgi.wiring.package", dirs3, null, "DynamicImport-Package " + dynImports[i]));
            }
        }
        if ((exportStr = mfAttrs.getValue("Export-Package")) != null) {
            String[] exports = Utils.splitString(exportStr, ',');
            for (int i = 0; i < exports.length; ++i) {
                String[] literals = Utils.splitString(exports[i], ';');
                parseResult = Utils.parseLiterals(literals, 1);
                HashMap<String, Object> attrs3 = parseResult.getAttributes();
                if (attrs3.containsKey("bundle-symbolic-name") || attrs3.containsKey("bundle-version")) {
                    throw new BundleException("Export statement contains illegal attributes");
                }
                String specVer = (String)attrs3.get(SPECIFICATION_VERSION);
                if (specVer != null) {
                    Version ver = (Version)attrs3.get("version");
                    Version specVerV = new Version(Utils.unQuote(specVer));
                    if (ver != null) {
                        if (!specVerV.equals(ver)) {
                            throw new BundleException("Both version and specificationVersion are given but versions are not identical");
                        }
                    } else {
                        attrs3.put("version", specVerV);
                    }
                }
                attrs3.put("osgi.wiring.package", literals[0].trim());
                if (literals[0].startsWith("java.")) {
                    throw new BundleException("Bundle must not export a java.* package");
                }
                attrs3.put("bundle-symbolic-name", bundleSymbolicName);
                attrs3.put("bundle-version", bundleVersion);
                caps.add(new Resources.BundleCapabilityImpl(revision, "osgi.wiring.package", parseResult.getDirectives(), attrs3, "Export-Package " + exports[i]));
            }
        }
        if ((requireBundleStr = mfAttrs.getValue("Require-Bundle")) != null) {
            String[] requires = Utils.splitString(requireBundleStr, ',');
            for (int i = 0; i < requires.length; ++i) {
                String[] literals = Utils.splitString(requires[i], ';');
                String requiredBundle = literals[0].trim();
                parseResult2 = Utils.parseLiterals(literals, 1);
                dirs = parseResult2.getDirectives();
                String visibility = parseResult2.getDirectives().get("visibility");
                if ("reexport".equals(visibility)) {
                    dirs.put("visibility", "reexport");
                } else {
                    dirs.put("visibility", "private");
                }
                if ("optional".equals(parseResult2.getDirectives().get("resolution"))) {
                    dirs.put("resolution", "optional");
                }
                dirs.put("filter", Utils.createFilter("osgi.wiring.bundle", requiredBundle, parseResult2.getAttributes()));
                dirs.put("x-int", literals[0]);
                reqs.add(new Resources.BundleRequirementImpl(revision, "osgi.wiring.bundle", dirs, null, "Require-Bundle " + requires[i]));
            }
        }
        return new ConciergeCollections.Tuple<List<BundleCapability>, List<BundleRequirement>>(caps, reqs);
    }

    void addAttributeIfPresent(Map<String, Object> attributes, String name, Attributes mfAttrs, String header) {
        String str = mfAttrs.getValue(header);
        if (str != null) {
            attributes.put(name, str);
        }
    }

    public static String parse(String requiredEEStr) throws BundleException {
        String[] requiredEEs = requiredEEStr.split(",");
        StringBuffer buffer = new StringBuffer();
        if (requiredEEs.length > 1) {
            buffer.append("(|");
        }
        for (int i = 0; i < requiredEEs.length; ++i) {
            String version;
            String ee2;
            String ee1;
            String requiredEE = requiredEEs[i].trim();
            Matcher matcher = PARSE_EE.matcher(requiredEE);
            if (matcher.matches()) {
                if (matcher.group(1) != null) {
                    ee1 = matcher.group(1);
                    ee2 = matcher.group(3);
                    version = matcher.group(2);
                } else if (matcher.group(4) != null) {
                    ee1 = matcher.group(4);
                    ee2 = matcher.group(5);
                    version = matcher.group(6);
                } else {
                    String s = matcher.group(7);
                    int pos = s.indexOf(47);
                    ee1 = pos > -1 ? s.substring(0, pos) : s;
                    ee2 = pos > -1 ? s.substring(pos + 1, s.length()) : null;
                    version = null;
                }
            } else {
                Matcher matcher2 = PARSE_EE2.matcher(requiredEE);
                if (matcher2.matches()) {
                    if (matcher2.group(4) == null || matcher2.group(2).equals(matcher2.group(4))) {
                        ee1 = matcher2.group(1);
                        version = matcher2.group(2);
                        ee2 = matcher2.group(3);
                    } else {
                        ee1 = matcher2.group(1) + "-" + matcher2.group(2);
                        ee2 = matcher2.group(3) + "-" + matcher2.group(4);
                        version = null;
                    }
                } else {
                    throw new BundleException("invalid bree string " + requiredEE);
                }
            }
            if (version != null) {
                buffer.append("(&(");
            } else {
                buffer.append('(');
            }
            buffer.append("osgi.ee");
            buffer.append('=');
            buffer.append("J2SE".equals(ee1) ? "JavaSE" : ee1);
            if (ee2 != null) {
                buffer.append('/');
                buffer.append(ee2);
            }
            if (version != null) {
                buffer.append(")(version=");
                buffer.append(version);
                buffer.append("))");
                continue;
            }
            buffer.append(')');
        }
        if (requiredEEs.length > 1) {
            buffer.append(')');
        }
        return buffer.toString();
    }

    @Override
    public List<BundleCapability> translateToCapability(Concierge framework, String attributeName, String valueStr) {
        if (FRAMEWORK_EXECUTIONENVIRONMENT.equals(attributeName)) {
            String[] fees = Utils.splitString(valueStr, ',');
            ArrayList<BundleCapability> caps = new ArrayList<BundleCapability>();
            for (String fee : fees) {
                String version;
                String ee2;
                String ee1;
                String requiredEE = fee.trim();
                Matcher matcher = PARSE_EE.matcher(requiredEE);
                if (matcher.matches()) {
                    if (matcher.group(1) != null) {
                        ee1 = matcher.group(1);
                        ee2 = matcher.group(3);
                        version = matcher.group(2);
                    } else if (matcher.group(4) != null) {
                        ee1 = matcher.group(4);
                        ee2 = matcher.group(5);
                        version = matcher.group(6);
                    } else {
                        String s = matcher.group(7);
                        int pos = s.indexOf(47);
                        ee1 = pos > -1 ? s.substring(0, pos) : s;
                        ee2 = pos > -1 ? s.substring(pos + 1, s.length()) : null;
                        version = null;
                    }
                } else {
                    Matcher matcher2 = PARSE_EE2.matcher(requiredEE);
                    if (matcher2.matches()) {
                        if (matcher2.group(4) == null || matcher2.group(2).equals(matcher2.group(4))) {
                            ee1 = matcher2.group(1);
                            version = matcher2.group(2);
                            ee2 = matcher2.group(3);
                        } else {
                            ee1 = matcher2.group(1) + "-" + matcher2.group(2);
                            ee2 = matcher2.group(3) + "-" + matcher2.group(4);
                            version = null;
                        }
                    } else {
                        throw new IllegalStateException("invalid framework execution environment " + requiredEE);
                    }
                }
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                String eeStr = ee2 == null ? ee1 : ee1 + "/" + ee2;
                attrs.put("osgi.ee", eeStr);
                if (version != null) {
                    attrs.put("version", new Version(version));
                }
                Resources.BundleCapabilityImpl cap = new Resources.BundleCapabilityImpl(framework, "osgi.ee", null, attrs, "ExecutionEnvironment " + eeStr + (version == null ? "" : ' ' + version));
                caps.add(cap);
            }
            return caps;
        }
        return null;
    }
}

