/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.concierge.AbstractBundle;
import org.eclipse.concierge.Concierge;
import org.eclipse.concierge.ConciergeCollections;
import org.eclipse.concierge.RFC1960Filter;
import org.eclipse.concierge.Resources;
import org.eclipse.concierge.ServiceReferenceImpl;
import org.eclipse.concierge.Utils;
import org.eclipse.concierge.compat.LegacyBundleProcessing;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.HostedCapability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleImpl
extends AbstractBundle
implements BundleStartLevel {
    protected static final Method dexFileLoader;
    protected static final Method dexClassLoader;
    protected static final Pattern DIRECTIVE_LIST;
    private static final int TIMEOUT = 10000;
    private static final String BUNDLE_FILE_NAME = "bundle";
    private static final String CONTENT_DIRECTORY_NAME = "content";
    private static final short FRAGMENT_ATTACHMENT_NEVER = -1;
    private static final short FRAGMENT_ATTACHMENT_RESOLVETIME = 1;
    private static final short FRAGMENT_ATTACHMENT_ALWAYS = 2;
    private String symbolicName;
    private Version version;
    protected static ThreadLocal<ArrayList<AbstractBundle>> activationChain;
    protected List<BundleImpl> hostBundles;
    protected final Concierge framework;
    protected boolean lazyActivation;
    protected boolean beingLazy = false;
    protected String[] activationIncludes;
    protected String[] activationExcludes;
    protected String bundleLocalizationBaseDir;
    protected String bundleLocalizationBaseFilename;
    protected HeaderDictionary headers;
    private Locale lastDefaultLocale;
    private int currentRevisionNumber = -1;

    public BundleImpl(Concierge concierge, BundleContext bundleContext, String string, long l, InputStream inputStream) throws BundleException {
        this.framework = concierge;
        this.location = string;
        this.bundleId = l;
        this.startlevel = concierge.initStartlevel;
        this.lastModified = System.currentTimeMillis();
        if (concierge.SECURITY_ENABLED) {
            try {
                Permissions permissions = new Permissions();
                ((PermissionCollection)permissions).add(new FilePermission(concierge.STORAGE_LOCATION + l, "read,write,execute,delete"));
                this.domain = new ProtectionDomain(new CodeSource(new URL("file:" + concierge.STORAGE_LOCATION + l), (Certificate[])null), permissions);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new BundleException("Exception while installing bundle", 7, exception);
            }
        }
        this.storageLocation = concierge.STORAGE_LOCATION + l + File.separatorChar;
        this.currentRevision = this.readAndProcessInputStream(inputStream);
        this.symbolicName = this.currentRevision.getSymbolicName();
        this.version = this.currentRevision.getVersion();
        this.revisions.add(0, this.currentRevision);
        concierge.checkForCollision(1, bundleContext.getBundle(), this.currentRevision);
        this.state = 2;
        if (concierge.state != 8 && concierge.state != 16) {
            this.updateMetadata();
        }
    }

    public BundleImpl(Concierge concierge, File file) throws IOException, BundleException {
        this.framework = concierge;
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        this.currentRevisionNumber = dataInputStream.readInt();
        this.bundleId = dataInputStream.readLong();
        this.location = dataInputStream.readUTF();
        this.storageLocation = concierge.STORAGE_LOCATION + this.bundleId + File.separatorChar;
        File file2 = new File(this.storageLocation, BUNDLE_FILE_NAME + this.currentRevisionNumber);
        File file3 = new File(this.storageLocation + CONTENT_DIRECTORY_NAME + this.currentRevisionNumber);
        if (file2.exists() && file2.isFile()) {
            JarFile jarFile = new JarFile(file2);
            Manifest manifest = jarFile.getManifest();
            String[] stringArray = BundleImpl.readProperties(manifest.getMainAttributes(), "Bundle-ClassPath", new String[]{"."});
            this.currentRevision = new JarBundleRevision(this.currentRevisionNumber, jarFile, manifest, stringArray);
        } else if (file3.exists() && file3.isDirectory()) {
            Manifest manifest = new Manifest(new FileInputStream(new File(file3, "META-INF/MANIFEST.MF")));
            String[] stringArray = BundleImpl.readProperties(manifest.getMainAttributes(), "Bundle-ClassPath", new String[]{"."});
            this.currentRevision = new ExplodedJarBundleRevision(this.currentRevisionNumber, file3.getAbsolutePath(), manifest, stringArray);
        } else {
            dataInputStream.close();
            throw new BundleException("Bundle revision " + this.currentRevisionNumber + " does not exist", 11);
        }
        this.symbolicName = this.currentRevision.getSymbolicName();
        this.version = this.currentRevision.getVersion();
        this.revisions.add(0, this.currentRevision);
        this.startlevel = dataInputStream.readInt();
        this.state = 2;
        this.autostart = dataInputStream.readShort();
        this.lazyActivation = dataInputStream.readBoolean();
        this.lastModified = dataInputStream.readLong();
        dataInputStream.close();
        this.context = concierge.createBundleContext(this);
        System.err.println("RESTORED BUNDLE " + this.toString() + " WITH SL " + this.startlevel + " and autostart " + this.autostart);
        if (concierge.SECURITY_ENABLED) {
            this.domain = new ProtectionDomain(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateMetadata() {
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new DataOutputStream(new FileOutputStream(new File(this.storageLocation, "meta")));
            ((DataOutputStream)filterOutputStream).writeInt(this.currentRevisionNumber);
            ((DataOutputStream)filterOutputStream).writeLong(this.bundleId);
            ((DataOutputStream)filterOutputStream).writeUTF(this.location);
            ((DataOutputStream)filterOutputStream).writeInt(this.startlevel);
            ((DataOutputStream)filterOutputStream).writeShort(this.autostart);
            ((DataOutputStream)filterOutputStream).writeBoolean(this.lazyActivation);
            ((DataOutputStream)filterOutputStream).writeLong(this.lastModified);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private Revision readAndProcessInputStream(InputStream inputStream) throws BundleException {
        int n = ++this.currentRevisionNumber;
        try {
            File file = new File(this.storageLocation, BUNDLE_FILE_NAME + n);
            BundleImpl.storeFile(file, inputStream);
            JarFile jarFile = new JarFile(file, false);
            Manifest manifest = jarFile.getManifest();
            String[] stringArray = BundleImpl.readProperties(manifest.getMainAttributes(), "Bundle-ClassPath", new String[]{"."});
            if (this.framework.ALWAYS_DECOMPRESS || this.framework.DECOMPRESS_EMBEDDED && stringArray.length > 1) {
                File file2 = new File(this.storageLocation + CONTENT_DIRECTORY_NAME + n);
                if (file2.exists()) {
                    Concierge.deleteDirectory(file2);
                }
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    if (jarEntry.isDirectory()) continue;
                    File file3 = new File(file2, jarEntry.getName());
                    BundleImpl.storeFile(file3, jarFile.getInputStream(jarEntry));
                }
                jarFile.close();
                new File(jarFile.getName()).delete();
                return new ExplodedJarBundleRevision(n, file2.getAbsolutePath(), manifest, stringArray);
            }
            return new JarBundleRevision(n, jarFile, manifest, stringArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Concierge.deleteDirectory(new File(this.storageLocation));
            throw new BundleException("Not a valid bundle: " + this.location + " (tried to write to " + new File(this.storageLocation, BUNDLE_FILE_NAME + n) + ")", 11, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void install() throws BundleException {
        Concierge concierge = this.framework;
        synchronized (concierge) {
            this.framework.bundles.add(this);
            this.framework.bundleID_bundles.put(new Long(this.getBundleId()), this);
            this.framework.symbolicName_bundles.insert(this.currentRevision.getSymbolicName(), this);
            this.framework.location_bundles.put(this.location, this);
        }
        if (this.currentRevision.isFrameworkExtension()) {
            this.currentRevision.resolve(false);
        }
    }

    @Override
    public void start() throws BundleException {
        this.start(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(int n) throws BundleException {
        if (this.framework.SECURITY_ENABLED) {
            // empty if block
        }
        if (this.state == 1) {
            throw new IllegalStateException("Cannot start uninstalled bundle " + this.toString());
        }
        if (this.currentRevision.isFragment()) {
            throw new BundleException("The fragment bundle " + this.toString() + " cannot be started", 2);
        }
        if (!(this.lazyActivation || this.state != 8 && this.state != 16)) {
            try {
                BundleImpl bundleImpl = this;
                synchronized (bundleImpl) {
                    this.wait(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.state == 8 || this.state == 16) {
                throw new BundleException("Timeout occurred. Bundle was unable to start.", 7);
            }
        }
        if ((n & 1) > 0) {
            if (this.startlevel > this.framework.startlevel) {
                throw new BundleException("Bundle (with start level " + this.startlevel + ") cannot be started due to the framework's current start level of " + this.framework.startlevel, 10);
            }
        } else {
            if ((n & 1) == 0) {
                this.autostart = (short)(n == 0 ? 2 : 1);
            }
            this.updateMetadata();
        }
        if (this.startlevel <= this.framework.startlevel) {
            this.activate(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void activate(int n) throws BundleException {
        if (this.state == 32) {
            return;
        }
        if (this.currentRevision.isFragment()) {
            return;
        }
        if (this.state == 2) {
            this.currentRevision.resolve(true);
        }
        this.context = this.framework.createBundleContext(this);
        if ((n & 2) > 0 && this.lazyActivation) {
            if (this.state != 8) {
                this.beingLazy = true;
                this.state = 8;
                this.framework.notifyBundleListeners(512, this);
            }
            BundleImpl bundleImpl = this;
            synchronized (bundleImpl) {
                this.notify();
            }
            return;
        }
        this.beingLazy = false;
        this.activate0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activate0() throws BundleException {
        assert (this.state != 2 && this.state != 1);
        this.state = 8;
        this.framework.notifyBundleListeners(128, this);
        try {
            Class<?> clazz;
            this.context.isValid = true;
            String string = this.currentRevision.activatorClassName;
            if (string != null) {
                clazz = this.currentRevision.classloader.loadClass(string);
                if (clazz == null) {
                    throw new ClassNotFoundException(string);
                }
                this.currentRevision.activatorInstance = (BundleActivator)clazz.newInstance();
                this.currentRevision.activatorInstance.start(this.context);
                if (this.state == 1) {
                    throw new BundleException("Activator.start uninstalled the bundle!", 5);
                }
            }
            this.state = 32;
            this.framework.notifyBundleListeners(2, this);
            if (this.framework.DEBUG_BUNDLES) {
                this.framework.logger.log(3, "framework: Bundle " + this.toString() + " started.");
            }
            clazz = this;
            synchronized (clazz) {
                this.notify();
            }
        }
        catch (Throwable throwable) {
            this.framework.notifyBundleListeners(256, this);
            this.framework.clearBundleTrace(this);
            this.state = 4;
            this.framework.notifyBundleListeners(4, this);
            throw new BundleException("Error starting bundle " + this.toString(), 5, throwable);
        }
    }

    @Override
    public void stop() throws BundleException {
        this.stop(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(int n) throws BundleException {
        if (this.framework.SECURITY_ENABLED) {
            // empty if block
        }
        if (this.state == 1) {
            throw new IllegalStateException("Cannot stop uninstalled bundle " + this.toString());
        }
        if (this.currentRevision.isFragment()) {
            throw new BundleException("The fragment bundle " + this.toString() + " cannot be stopped", 2);
        }
        if (this.state == 8 || this.state == 16) {
            try {
                BundleImpl bundleImpl = this;
                synchronized (bundleImpl) {
                    this.wait(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.state == 1) {
                throw new IllegalStateException("Cannot stop uninstalled bundle " + this.toString());
            }
            if (this.state == 8 || this.state == 16) {
                throw new BundleException("Timeout occurred. Bundle was unable to stop!", 7);
            }
        }
        if (n != 1) {
            this.autostart = 0;
            this.updateMetadata();
        }
        if (this.state != 32 && this.state != 8) {
            return;
        }
        this.stopBundle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void stopBundle() throws BundleException {
        BundleImpl bundleImpl;
        if (this.state == 2) {
            return;
        }
        int n = this.state;
        this.state = 16;
        this.framework.notifyBundleListeners(256, this);
        try {
            try {
                if (n == 32) {
                    if (this.currentRevision.activatorInstance != null) {
                        this.currentRevision.activatorInstance.stop(this.context);
                    }
                    if (this.state == 1) {
                        throw new BundleException("Activator.stop() uninstalled this bundle!", 5);
                    }
                }
                Object var4_2 = null;
                if (this.currentRevision != null && this.currentRevision.activatorInstance != null) {
                    this.currentRevision.activatorInstance = null;
                }
                this.framework.clearBundleTrace(this);
                this.state = 4;
                this.framework.notifyBundleListeners(4, this);
                if (this.framework.DEBUG_BUNDLES) {
                    this.framework.logger.log(3, "framework: Bundle " + this.toString() + " stopped.");
                }
                if (this.context != null) {
                    this.context.isValid = false;
                }
                this.context = null;
                bundleImpl = this;
            }
            catch (Throwable throwable) {
                throw new BundleException("Error stopping bundle " + this.toString(), 7, throwable);
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (this.currentRevision != null && this.currentRevision.activatorInstance != null) {
                this.currentRevision.activatorInstance = null;
            }
            this.framework.clearBundleTrace(this);
            this.state = 4;
            this.framework.notifyBundleListeners(4, this);
            if (this.framework.DEBUG_BUNDLES) {
                this.framework.logger.log(3, "framework: Bundle " + this.toString() + " stopped.");
            }
            if (this.context != null) {
                this.context.isValid = false;
            }
            this.context = null;
            BundleImpl bundleImpl2 = this;
            synchronized (bundleImpl2) {
                this.notify();
                throw throwable;
            }
        }
        synchronized (bundleImpl) {
            this.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void uninstall() throws BundleException {
        if (this.framework.SECURITY_ENABLED) {
            // empty if block
        }
        if (this.state == 1) {
            throw new IllegalStateException("Bundle " + this.toString() + " is already uninstalled.");
        }
        if (this.state == 32) {
            try {
                this.stopBundle();
            }
            catch (Throwable throwable) {
                this.framework.notifyFrameworkListeners(2, this, throwable);
            }
        }
        if (this.currentRevision.isFragment()) {
            this.framework.removeFragment(this.currentRevision);
        }
        this.lastDefaultLocale = Locale.getDefault();
        this.headers.headerCache = null;
        this.framework.notifyBundleListeners(64, this);
        this.state = 1;
        Concierge concierge = this.framework;
        synchronized (concierge) {
            this.updateLastModified();
            new File(this.storageLocation, "meta").delete();
            this.framework.symbolicName_bundles.remove(this.currentRevision.getSymbolicName(), this);
            this.currentRevision.cleanup(true);
            this.currentRevision = null;
            this.framework.location_bundles.remove(this.location);
        }
        this.framework.notifyBundleListeners(16, this);
        if (this.context != null) {
            this.context.isValid = false;
            this.context = null;
        }
    }

    @Override
    public synchronized void update() throws BundleException {
        String string = this.headers.get("Bundle-UpdateLocation");
        try {
            this.update(new URL(string == null ? this.location : string).openConnection().getInputStream());
        }
        catch (IOException iOException) {
            throw new BundleException("Could not update " + this.toString() + " from " + string, 11, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void update(InputStream inputStream) throws BundleException {
        this.lastModified = System.currentTimeMillis();
        try {
            if (this.framework.SECURITY_ENABLED) {
                // empty if block
            }
            if (this.state == 1) {
                throw new IllegalStateException("Cannot update uninstalled bundle " + this.toString());
            }
            boolean bl = false;
            if (this.state == 32) {
                bl = true;
                this.stop();
            }
            if (this.currentRevision.isFragment()) {
                this.state = 2;
                this.framework.removeFragment(this.currentRevision);
                this.framework.notifyBundleListeners(8, this);
            } else {
                this.updateLastModified();
                if (this.currentRevision != null) {
                    this.currentRevision.cleanup(false);
                }
            }
            Revision revision = this.readAndProcessInputStream(inputStream);
            this.framework.checkForCollision(2, this, revision);
            this.framework.symbolicName_bundles.remove(this.currentRevision.getSymbolicName(), this);
            this.currentRevision = revision;
            this.symbolicName = this.currentRevision.getSymbolicName();
            this.version = this.currentRevision.getVersion();
            this.revisions.add(0, revision);
            this.framework.symbolicName_bundles.insert(this.currentRevision.getSymbolicName(), this);
            if (!this.currentRevision.isFragment()) {
                this.currentRevision.resolve(false);
            }
            this.framework.notifyBundleListeners(8, this);
            if (bl) {
                try {
                    this.start();
                }
                catch (BundleException bundleException) {
                    // empty catch block
                }
            }
            if (this.framework.state != 8 && this.framework.state != 16) {
                this.updateMetadata();
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    void refresh() {
        for (BundleRevision object : this.revisions) {
            Revision revision = (Revision)object;
            if (revision.wiring == null) continue;
            revision.wiring.cleanup();
            revision.wiring = null;
        }
        this.revisions.clear();
        if (this.currentRevision != null) {
            this.revisions.add(this.currentRevision);
            this.currentRevision.refresh();
            this.framework.wirings.remove(this.currentRevision);
            this.currentRevision.dynamicImports.clear();
            for (BundleRequirement bundleRequirement : this.currentRevision.requirements.lookup("osgi.wiring.package")) {
                if (!"dynamic".equals(bundleRequirement.getDirectives().get("resolution"))) continue;
                this.currentRevision.dynamicImports.add(bundleRequirement);
            }
        }
    }

    boolean checkActivation(String string) {
        int n;
        if (this.activationExcludes != null) {
            for (n = 0; n < this.activationExcludes.length; ++n) {
                if (RFC1960Filter.stringCompare(this.activationExcludes[n].toCharArray(), 0, string.toCharArray(), 0) != 0) continue;
                return false;
            }
        }
        if (this.activationIncludes != null) {
            n = 0;
            for (int i = 0; i < this.activationIncludes.length; ++i) {
                if (RFC1960Filter.stringCompare(this.activationIncludes[i].toCharArray(), 0, string.toCharArray(), 0) != 0) continue;
                n = 1;
                break;
            }
            if (n == 0) {
                return false;
            }
        }
        return true;
    }

    void triggerActivation() {
        try {
            this.activate0();
        }
        catch (BundleException bundleException) {
            this.state = 16;
            this.framework.notifyBundleListeners(256, this);
            this.state = 4;
            this.framework.notifyBundleListeners(4, this);
        }
    }

    @Override
    public final String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public final Version getVersion() {
        return this.version;
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        if (this.framework.SECURITY_ENABLED) {
            // empty if block
        }
        return this.headers.localize(this.lastDefaultLocale == null ? Locale.getDefault() : this.lastDefaultLocale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceReference<?>[] getServicesInUse() {
        if (this.state == 1) {
            throw new IllegalStateException("Bundle " + this.toString() + "has been unregistered.");
        }
        if (this.registeredServices == null) {
            return null;
        }
        ArrayList<ServiceReference> arrayList = new ArrayList<ServiceReference>();
        ServiceReference[] serviceReferenceArray = this.registeredServices.toArray(new ServiceReference[this.registeredServices.size()]);
        for (int i = 0; i < serviceReferenceArray.length; ++i) {
            Map<Bundle, Integer> map = ((ServiceReferenceImpl)serviceReferenceArray[i]).useCounters;
            synchronized (map) {
                if (((ServiceReferenceImpl)serviceReferenceArray[i]).useCounters.get(this) != null) {
                    arrayList.add(serviceReferenceArray[i]);
                }
                continue;
            }
        }
        if (this.framework.SECURITY_ENABLED) {
            return BundleImpl.checkPermissions(arrayList.toArray(new ServiceReferenceImpl[arrayList.size()]));
        }
        return arrayList.toArray(new ServiceReference[arrayList.size()]);
    }

    @Override
    public URL getResource(String string) {
        block9: {
            if (this.state == 1) {
                throw new IllegalStateException("Bundle is uninstalled");
            }
            if (this.currentRevision.isFragment()) {
                return null;
            }
            if (this.state == 2) {
                try {
                    if (this.currentRevision.resolve(false)) break block9;
                    try {
                        if ("/".equals(string)) {
                            return this.currentRevision.createURL("/", null);
                        }
                        for (int i = 0; i < this.currentRevision.classpath.length; ++i) {
                            URL uRL = this.currentRevision.lookupFile(this.currentRevision.classpath[i], string);
                            if (uRL == null) continue;
                            return uRL;
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        return null;
                    }
                    return null;
                }
                catch (BundleException bundleException) {
                    bundleException.printStackTrace();
                    return null;
                }
            }
        }
        return this.currentRevision.classloader.findResource(string);
    }

    @Override
    public Dictionary<String, String> getHeaders(String string) {
        if (string == null || this.lastDefaultLocale != null) {
            return this.getHeaders();
        }
        if (string.length() == 0) {
            return this.headers;
        }
        String[] stringArray = string.split("_");
        Locale locale = stringArray.length > 2 ? new Locale(stringArray[0], stringArray[1], stringArray[2]) : (stringArray.length > 1 ? new Locale(stringArray[0], stringArray[1]) : new Locale(stringArray[0]));
        return this.headers.localize(locale);
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        if (this.state == 1) {
            throw new IllegalStateException("Bundle is uninstalled");
        }
        if (this.currentRevision.isFragment()) {
            throw new ClassNotFoundException("This bundle is a fragment and cannot load any classes.");
        }
        if (this.state == 2) {
            try {
                this.currentRevision.resolve(true);
            }
            catch (BundleException bundleException) {
                this.framework.notifyFrameworkListeners(2, this, bundleException);
                throw new ClassNotFoundException(string, bundleException);
            }
        }
        return this.currentRevision.classloader.findClass(string);
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        if (this.state == 1) {
            throw new IllegalStateException("Bundle is uninstalled");
        }
        if (this.currentRevision.isFragment()) {
            return null;
        }
        if (this.state == 2) {
            try {
                if (!this.currentRevision.resolve(false)) {
                    Vector<URL> vector = new Vector<URL>();
                    for (int i = 0; i < this.currentRevision.classpath.length; ++i) {
                        URL uRL = this.currentRevision.lookupFile(this.currentRevision.classpath[i], string);
                        if (uRL == null) continue;
                        vector.add(uRL);
                    }
                    return vector.isEmpty() ? null : vector.elements();
                }
            }
            catch (BundleException bundleException) {
                bundleException.printStackTrace();
                return null;
            }
        }
        return this.currentRevision.classloader.findResources0(string);
    }

    @Override
    public Enumeration<String> getEntryPaths(String string) throws IllegalStateException {
        Vector<URL> vector;
        if (this.state == 1) {
            throw new IllegalStateException("Bundle has been uninstalled. Cannot retrieve entry.");
        }
        if (this.framework.SECURITY_ENABLED) {
            // empty if block
        }
        return (vector = this.currentRevision.searchFiles(null, string, "*", false)).isEmpty() ? null : new Enumeration<String>(){
            final Enumeration<URL> urlEnumeration;
            {
                this.urlEnumeration = vector.elements();
            }

            @Override
            public boolean hasMoreElements() {
                return this.urlEnumeration.hasMoreElements();
            }

            @Override
            public String nextElement() {
                return this.urlEnumeration.nextElement().getFile().substring(1);
            }
        };
    }

    @Override
    public URL getEntry(String string) throws IllegalStateException {
        if (this.state == 1) {
            throw new IllegalStateException("Bundle has been uninstalled. Cannot retrieve entry.");
        }
        if (this.framework.SECURITY_ENABLED) {
            // empty if block
        }
        try {
            if ("/".equals(string)) {
                return this.currentRevision.createURL("/", null);
            }
            return this.currentRevision.lookupFile(null, string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    @Override
    public Enumeration<URL> findEntries(String string, String string2, boolean bl) {
        if (this.state == 2) {
            try {
                this.currentRevision.resolve(false);
            }
            catch (BundleException bundleException) {
                // empty catch block
            }
        }
        Revision revision = this.currentRevision == null ? (Revision)this.revisions.get(0) : this.currentRevision;
        return revision.findEntries(string, string2, bl);
    }

    @Override
    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int n) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    protected boolean isSecurityEnabled() {
        return this.framework.isSecurityEnabled();
    }

    final InputStream getURLResource(URL uRL, int n) throws IOException {
        String string;
        try {
            string = uRL.toURI().getFragment();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            string = null;
        }
        for (BundleRevision bundleRevision : this.revisions) {
            Revision revision = (Revision)bundleRevision;
            if (revision.revId != n) continue;
            if (string == null) {
                return revision.retrieveFile(null, uRL.getPath());
            }
            return revision.retrieveFile(uRL.getPath(), string);
        }
        return null;
    }

    final long getResourceLength(URL uRL, int n) {
        String string;
        try {
            string = uRL.toURI().getFragment();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            string = null;
        }
        try {
            for (BundleRevision bundleRevision : this.revisions) {
                Revision revision = (Revision)bundleRevision;
                if (revision.revId != n) continue;
                if (string == null) {
                    return revision.retrieveFileLength(null, uRL.getPath());
                }
                return revision.retrieveFileLength(uRL.getPath(), string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }

    @Override
    public int getStartLevel() {
        return this.startlevel;
    }

    @Override
    public boolean isPersistentlyStarted() {
        this.checkBundleNotUninstalled();
        return this.autostart != 0;
    }

    @Override
    public boolean isActivationPolicyUsed() {
        this.checkBundleNotUninstalled();
        return this.autostart == 1;
    }

    @Override
    public void setStartLevel(int n) {
        this.checkBundleNotUninstalled();
        if (n <= 0) {
            throw new IllegalArgumentException("Start level " + n + " is not a valid level");
        }
        int n2 = this.startlevel;
        this.startlevel = n;
        this.updateMetadata();
        if (n <= n2 && this.state != 32 && this.autostart != 0) {
            final int n3 = this.isActivationPolicyUsed() ? 0 : 1;
            new Thread(){

                public void run() {
                    try {
                        BundleImpl.this.activate(n3);
                    }
                    catch (BundleException bundleException) {
                        bundleException.printStackTrace();
                        BundleImpl.this.framework.notifyFrameworkListeners(2, BundleImpl.this, bundleException);
                    }
                }
            }.start();
        } else if (n > n2 && this.state != 4 && this.state != 2) {
            new Thread(){

                public void run() {
                    try {
                        BundleImpl.this.stopBundle();
                    }
                    catch (BundleException bundleException) {
                        BundleImpl.this.framework.notifyFrameworkListeners(2, BundleImpl.this, bundleException);
                    }
                }
            }.start();
        }
    }

    protected static String[] readProperties(Attributes attributes, String string, String[] stringArray) throws BundleException {
        String string2 = BundleImpl.readProperty(attributes, string);
        return string2 == null ? stringArray : Utils.splitString(string2, ',');
    }

    protected static String readProperty(Attributes attributes, String string) throws BundleException {
        String string2 = attributes.getValue(string);
        if (string2 != null && string2.equals("")) {
            throw new BundleException("Broken manifest, " + string + " is empty.", 3);
        }
        return string2;
    }

    protected Properties getLocalizationFile(Locale locale, String string, String string2) {
        int n;
        if (this.hostBundles != null) {
            return this.hostBundles.get(0).getLocalizationFile(locale, string, string2);
        }
        Locale[] localeArray = new Locale[]{this.lastDefaultLocale == null ? Locale.getDefault() : this.lastDefaultLocale, locale};
        Properties properties = new Properties();
        String[] stringArray = new String[7];
        int n2 = 0;
        stringArray[0] = "";
        for (n = 0; n < 2; ++n) {
            stringArray[++n2] = "_" + localeArray[n].getLanguage();
            if (localeArray[n].getCountry().length() <= 0) continue;
            stringArray[++n2] = stringArray[n2 - 1] + "_" + localeArray[n].getCountry();
            if (localeArray[n].getVariant().length() <= 0) continue;
            stringArray[++n2] = stringArray[n2 - 1] + "_" + localeArray[n].getVariant();
        }
        for (n = n2; n >= 0; --n) {
            Enumeration<URL> enumeration = this.findEntries(string, string2 + stringArray[n] + ".properties", false);
            if (enumeration == null) continue;
            while (enumeration.hasMoreElements()) {
                try {
                    URL uRL = enumeration.nextElement();
                    InputStream inputStream = uRL.openStream();
                    properties.load(inputStream);
                    return properties;
                }
                catch (IOException iOException) {
                }
            }
        }
        return null;
    }

    public String toString() {
        return "[" + this.getSymbolicName() + "-" + this.getVersion() + "]";
    }

    static String packageOf(String string) {
        int n = string.lastIndexOf(46);
        return n > -1 ? string.substring(0, n) : "";
    }

    protected static String classOf(String string) {
        int n = string.lastIndexOf(46);
        return n > -1 ? string.substring(n + 1, string.length()) : string;
    }

    protected static String pseudoClassname(String string) {
        return string.replace('.', '-').replace('/', '.').replace('\\', '.');
    }

    protected static String stripTrailing(String string) {
        return string.startsWith("/") || string.startsWith("\\") ? string.substring(1) : string;
    }

    protected static String classToFile(String string) {
        return string.replace('.', '/') + ".class";
    }

    static void storeFile(File file, InputStream inputStream) {
        try {
            int n;
            file.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[Concierge.CLASSLOADER_BUFFER_SIZE];
            while ((n = inputStream.read(byArray, 0, Concierge.CLASSLOADER_BUFFER_SIZE)) > -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static {
        Method method;
        Method method2;
        try {
            Class<?> clazz = Class.forName("dalvik.system.DexFile");
            method2 = clazz.getMethod("loadClass", String.class, ClassLoader.class);
            method = clazz.getMethod("loadDex", String.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {
            method2 = null;
            method = null;
        }
        dexClassLoader = method2;
        dexFileLoader = method;
        DIRECTIVE_LIST = Pattern.compile("\\s*([^:]*)\\s*:=\\s*\"\\s*(.+)*?\\s*\"\\s*");
        activationChain = new ThreadLocal();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExplodedJarBundleRevision
    extends Revision {
        private final String storageLocation;

        ExplodedJarBundleRevision(int n, String string, Manifest manifest, String[] stringArray) throws BundleException {
            super(n, manifest, stringArray);
            this.storageLocation = string;
        }

        @Override
        protected URL lookupFile(String string, String string2, HashSet<String> hashSet) throws IOException {
            return (URL)this.findFile(string, string2, 0);
        }

        @Override
        protected InputStream retrieveFile(String string, String string2) throws IOException {
            return (InputStream)this.findFile(string, string2, 1);
        }

        @Override
        protected long retrieveFileLength(String string, String string2) throws IOException {
            return (Long)this.findFile(string, string2, 2);
        }

        @Override
        protected URL lookupFile(String string, String string2) throws IOException {
            return (URL)this.findFile(string, string2, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Object findFile(String string, String string2, int n) throws IOException {
            if (string2.charAt(0) == '/') {
                string2 = string2.substring(1);
            }
            if (string == null || string.equals(".")) {
                File file = new File(this.storageLocation, string2);
                try {
                    if (!file.exists()) return null;
                    switch (n) {
                        case 0: {
                            return this.createURL(string2, null);
                        }
                        case 1: {
                            return new FileInputStream(file);
                        }
                        case 2: {
                            return file.length();
                        }
                    }
                    return null;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
            File file = new File(this.storageLocation, string);
            if (!file.exists()) return null;
            if (!file.isDirectory()) {
                ZipFile zipFile = new ZipFile(file);
                try {
                    ZipEntry zipEntry = zipFile.getEntry(string2);
                    if (zipEntry == null) {
                        Object var7_11 = null;
                        return var7_11;
                    }
                    switch (n) {
                        case 0: {
                            URL uRL = this.createURL(string, string2);
                            return uRL;
                        }
                        case 1: {
                            InputStream inputStream = zipFile.getInputStream(zipEntry);
                            return inputStream;
                        }
                        case 2: {
                            Long l = zipEntry.getSize();
                            return l;
                        }
                    }
                    return null;
                }
                finally {
                    if (n != 1) {
                        zipFile.close();
                    }
                }
            }
            try {
                File file2 = new File(file, string2);
                if (!file.exists()) return null;
                switch (n) {
                    case 0: {
                        return this.createURL(string2, null);
                    }
                    case 1: {
                        return new FileInputStream(file2);
                    }
                    case 2: {
                        return file2.length();
                    }
                }
                return null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }

        @Override
        public Vector<URL> searchFiles(String string, String string2, String string3, boolean bl) {
            Vector<URL> vector = new Vector<URL>();
            String string4 = string2;
            if (string4.length() > 0) {
                if (string4.charAt(0) == '/') {
                    string4 = string4.substring(0);
                }
                if (string4.charAt(string4.length() - 1) != '/') {
                    string4 = string4 + '/';
                }
            }
            this.testFiles(new File(this.storageLocation, string4), vector, bl, string3);
            return vector;
        }

        private void testFiles(File file, Vector<URL> vector, boolean bl, String string) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (BundleImpl.this.framework.DEBUG_CLASSLOADING) {
                        BundleImpl.this.framework.logger.log(4, "testing " + file2.getAbsolutePath() + (file2.isDirectory() ? "/" : ""));
                    }
                    String string2 = file2.getName();
                    if (string == null || RFC1960Filter.stringCompare(string.toCharArray(), 0, string2.toCharArray(), 0) == 0) {
                        try {
                            String string3 = file2.getAbsolutePath();
                            vector.add(this.createURL(string3.substring(string3.indexOf(this.storageLocation) + this.storageLocation.length() + 1) + (file2.isDirectory() ? "/" : ""), null));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!bl || !file2.isDirectory()) continue;
                    this.testFiles(file2, vector, bl, string);
                }
            }
        }

        @Override
        protected void close() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HeaderDictionary
    extends Hashtable<String, String> {
        private static final long serialVersionUID = 6688251578575649710L;
        protected WeakHashMap<Locale, HeaderDictionary> headerCache;
        private final HashMap<String, String> index;
        private boolean hasLocalizedValues;

        public HeaderDictionary(int n) {
            super(n);
            this.index = new HashMap();
        }

        HeaderDictionary localize(Locale locale) {
            Hashtable hashtable;
            if (!this.hasLocalizedValues) {
                return this;
            }
            if (this.headerCache != null && (hashtable = this.headerCache.get(locale)) != null) {
                return hashtable;
            }
            hashtable = BundleImpl.this.getLocalizationFile(locale, BundleImpl.this.bundleLocalizationBaseDir, BundleImpl.this.bundleLocalizationBaseFilename);
            HeaderDictionary headerDictionary = (HeaderDictionary)this.clone();
            Enumeration enumeration = headerDictionary.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = headerDictionary.get(string);
                if (string2 == null || string2.charAt(0) != '%') continue;
                String string3 = string2.substring(1).trim();
                String string4 = hashtable == null ? null : (String)((Properties)hashtable).get(string3);
                headerDictionary.put(string, string4 == null ? string3 : string4);
            }
            if (this.headerCache == null) {
                this.headerCache = new WeakHashMap();
                this.headerCache.put(locale, headerDictionary);
            }
            return headerDictionary;
        }

        @Override
        public String put(String string, String string2) {
            if (string2.length() > 0 && string2.charAt(0) == '%') {
                this.hasLocalizedValues = true;
            }
            this.index.put(string.toLowerCase(), string);
            return super.put(string, string2);
        }

        @Override
        public String get(Object object) {
            String string = (String)super.get(object);
            if (string != null) {
                return string;
            }
            String string2 = this.index.get(((String)object).toLowerCase());
            return string2 == null ? null : (String)super.get(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JarBundleRevision
    extends Revision {
        private final JarFile jarFile;

        protected JarBundleRevision(int n, JarFile jarFile, Manifest manifest, String[] stringArray) throws BundleException {
            super(n, manifest, stringArray);
            this.jarFile = jarFile;
        }

        @Override
        protected URL lookupFile(String string, String string2) throws IOException {
            return (URL)this.findFile(string, string2, 0);
        }

        @Override
        protected URL lookupFile(String string, String string2, HashSet<String> hashSet) throws IOException {
            return (URL)this.findFile(string, string2, 0);
        }

        @Override
        public InputStream retrieveFile(String string, String string2) throws IOException {
            return (InputStream)this.findFile(string, string2, 1);
        }

        @Override
        public long retrieveFileLength(String string, String string2) throws IOException {
            Object object = this.findFile(string, string2, 2);
            if (object == null) {
                if (BundleImpl.this.framework.DEBUG_CLASSLOADING) {
                    BundleImpl.this.framework.logger.log(4, "Could not retrieveFileLength for filename=" + string2 + " from bundle=" + this.toString());
                }
                return -1L;
            }
            return (Long)object;
        }

        private Object findFile(String string, String string2, int n) throws IOException {
            if (string2.charAt(0) == '/') {
                string2 = string2.substring(1);
            }
            if (string == null || string.equals(".")) {
                ZipEntry zipEntry = this.jarFile.getEntry(string2);
                if (zipEntry == null) {
                    return null;
                }
                switch (n) {
                    case 0: {
                        return this.createURL(zipEntry.getName(), null);
                    }
                    case 1: {
                        return this.jarFile.getInputStream(zipEntry);
                    }
                    case 2: {
                        return zipEntry.getSize();
                    }
                }
            } else {
                JarEntry jarEntry;
                ZipConstants zipConstants;
                ZipEntry zipEntry = this.jarFile.getEntry(string);
                if (zipEntry == null) {
                    return null;
                }
                InputStream inputStream = this.jarFile.getInputStream(zipEntry);
                if (inputStream == null) {
                    zipConstants = this.jarFile.getEntry(string + "/" + string2);
                    if (zipConstants == null) {
                        return null;
                    }
                    switch (n) {
                        case 0: {
                            return this.createURL(((ZipEntry)zipConstants).getName(), null);
                        }
                        case 1: {
                            return this.jarFile.getInputStream((ZipEntry)zipConstants);
                        }
                        case 2: {
                            return ((ZipEntry)zipConstants).getSize();
                        }
                    }
                }
                zipConstants = new JarInputStream(this.jarFile.getInputStream(zipEntry));
                while ((jarEntry = ((JarInputStream)zipConstants).getNextJarEntry()) != null) {
                    if (!jarEntry.getName().equals(string2)) continue;
                    switch (n) {
                        case 0: {
                            return this.createURL(zipEntry.getName(), jarEntry.getName());
                        }
                        case 1: {
                            return zipConstants;
                        }
                        case 2: {
                            return jarEntry.getSize();
                        }
                    }
                }
            }
            return null;
        }

        @Override
        protected Vector<URL> searchFiles(String string, String string2, String string3, boolean bl) {
            int n;
            Vector<URL> vector = new Vector<URL>();
            String string4 = string2.length() > 0 && string2.charAt(0) == '/' ? string2.substring(1) : string2;
            String string5 = string4 = string2.length() == 0 || string2.charAt(string2.length() - 1) == '/' ? string4 : string4 + "/";
            if (string != null && !".".equals(string)) {
                string4 = string + "/" + string4;
                n = string.length() + 1;
            } else {
                n = 0;
            }
            Enumeration<JarEntry> enumeration = this.jarFile.entries();
            while (enumeration.hasMoreElements()) {
                File file;
                String string6;
                String string7;
                JarEntry jarEntry = enumeration.nextElement();
                if (n == 0 || n >= jarEntry.getName().length()) {
                    string7 = jarEntry.getName().replace('\\', '/');
                } else {
                    if (jarEntry.getName().length() < n) continue;
                    string7 = jarEntry.getName().substring(n).replace('\\', '/');
                }
                if (!string7.startsWith(string5) || (string6 = string7.substring(string5.length(), string7.length())).length() <= 0 || (file = new File(string6)).getParent() != null & !bl || string3 != null && RFC1960Filter.stringCompare(string3.toCharArray(), 0, file.getName().toCharArray(), 0) != 0) continue;
                try {
                    vector.add(this.createURL(string7.charAt(0) == '/' ? string7.substring(1) : string7, null));
                }
                catch (IOException iOException) {}
            }
            return vector;
        }

        @Override
        protected void close() throws IOException {
            this.jarFile.close();
        }

        @Override
        public String toString() {
            return "JarBundleResource {" + this.jarFile.getName() + " of bundle " + BundleImpl.this.toString() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Revision
    implements BundleRevision,
    Comparable<Revision> {
        protected static final int GET_URL = 0;
        protected static final int RETRIEVE_INPUT_STREAM = 1;
        protected static final int GET_CONTENT_LENGTH = 2;
        protected final int revId;
        protected final ConciergeCollections.MultiMap<String, BundleCapability> capabilities;
        protected final ConciergeCollections.MultiMap<String, BundleRequirement> requirements;
        private final List<HostedCapability> hostedCapabilities = new ArrayList<HostedCapability>();
        protected final List<BundleRequirement> dynamicImports;
        private BundleCapability identity;
        BundleClassLoader classloader;
        protected final String activatorClassName;
        private String[] nativeCodeStrings;
        protected BundleActivator activatorInstance;
        protected String[] classpath;
        protected Map<String, String> nativeLibraries;
        protected List<Revision> fragments;
        private final String[] classpathStrings;
        private final short fragmentAttachmentPolicy;
        protected Resources.ConciergeBundleWiring wiring;
        protected HashMap<String, BundleWire> packageImportWires;
        protected List<BundleWire> requireBundleWires;
        protected final HashSet<String> exportIndex;

        /*
         * WARNING - void declaration
         */
        protected Revision(int n, Manifest manifest, String[] stringArray) throws BundleException {
            int n2;
            Object object;
            Object[] objectArray;
            Object object3;
            Object object4;
            int n3;
            this.revId = n;
            this.classpathStrings = stringArray;
            this.classloader = new BundleClassLoader();
            Attributes attributes = manifest.getMainAttributes();
            String string = attributes.getValue("Bundle-ManifestVersion");
            try {
                n3 = string == null ? 1 : Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new BundleException("Illegal value for Bundle-ManifestVersion: `" + string + "`", 3);
            }
            String string2 = attributes.getValue("Require-Capability");
            this.requirements = this.parseRequirements(string2);
            String string3 = attributes.getValue("Provide-Capability");
            this.capabilities = this.parseCapabilities(string3);
            this.dynamicImports = new ArrayList<BundleRequirement>();
            switch (n3) {
                default: {
                    LegacyBundleProcessing legacyBundleProcessing = BundleImpl.this.framework.getService(LegacyBundleProcessing.class, LegacyBundleProcessing.VERSION_ONE);
                    if (legacyBundleProcessing == null) {
                        throw new BundleException("Bundle manifest version 1 is not supported by this deployment", 1);
                    }
                    object4 = legacyBundleProcessing.processManifest(this, manifest);
                    for (BundleCapability object5 : ((ConciergeCollections.Tuple)object4).getFormer()) {
                        this.capabilities.insert(object5.getNamespace(), object5);
                    }
                    object3 = ((ConciergeCollections.Tuple)object4).getLatter().iterator();
                    while (object3.hasNext()) {
                        BundleRequirement n22 = object3.next();
                        String string4 = n22.getNamespace();
                        this.requirements.insert(string4, n22);
                        if (!"osgi.wiring.package".equals(string4) || !"dynamic".equals(n22.getDirectives().get("resolution"))) continue;
                        this.dynamicImports.add(n22);
                    }
                    break;
                }
                case 2: {
                    LegacyBundleProcessing legacyBundleProcessing = BundleImpl.this.framework.getService(LegacyBundleProcessing.class, LegacyBundleProcessing.VERSION_TWO);
                    if (legacyBundleProcessing == null) {
                        throw new BundleException("Bundle manifest version 2 is not supported by this deployment", 1);
                    }
                    object3 = legacyBundleProcessing.processManifest(this, manifest);
                    for (BundleCapability bundleCapability : ((ConciergeCollections.Tuple)object3).getFormer()) {
                        this.capabilities.insert(bundleCapability.getNamespace(), bundleCapability);
                    }
                    for (BundleRequirement bundleRequirement : (List)((ConciergeCollections.Tuple)object3).getLatter()) {
                        objectArray = bundleRequirement.getNamespace();
                        this.requirements.insert((String)objectArray, bundleRequirement);
                        if (!"osgi.wiring.package".equals(objectArray) || !"dynamic".equals(bundleRequirement.getDirectives().get("resolution"))) continue;
                        this.dynamicImports.add(bundleRequirement);
                    }
                }
            }
            this.exportIndex = this.createExportIndex();
            if (!this.dynamicImports.isEmpty()) {
                object4 = this.dynamicImports.iterator();
                while (object4.hasNext()) {
                    object3 = (BundleRequirement)object4.next();
                    if (!this.exportIndex.contains(object3.getDirectives().get("x-int"))) continue;
                    object4.remove();
                }
            }
            this.nativeCodeStrings = BundleImpl.readProperties(attributes, "Bundle-NativeCode", null);
            this.activatorClassName = attributes.getValue("Bundle-Activator");
            object4 = BundleImpl.readProperty(attributes, "Bundle-ActivationPolicy");
            if (object4 != null) {
                void var13_21;
                object3 = Utils.splitString((String)object4, ';');
                if ("lazy".equals(object3[0])) {
                    BundleImpl.this.lazyActivation = true;
                }
                boolean bl = true;
                while (var13_21 < ((String[])object3).length) {
                    Matcher matcher = DIRECTIVE_LIST.matcher((CharSequence)object3[var13_21]);
                    if (matcher.matches()) {
                        objectArray = matcher.group(1);
                        String string5 = matcher.group(2);
                        object = Utils.splitString(string5, ',');
                        if ("include".equals(objectArray)) {
                            BundleImpl.this.activationIncludes = object;
                        } else if ("exclude".equals(objectArray)) {
                            BundleImpl.this.activationExcludes = object;
                        }
                    }
                    ++var13_21;
                }
            }
            if ((object3 = attributes.getValue("Bundle-Localization")) == null) {
                object3 = "OSGI-INF/l10n/bundle";
            }
            if ((n2 = ((String)object3).lastIndexOf("/")) > -1) {
                BundleImpl.this.bundleLocalizationBaseDir = ((String)object3).substring(0, n2);
                BundleImpl.this.bundleLocalizationBaseFilename = ((String)object3).substring(n2 + 1);
            } else {
                BundleImpl.this.bundleLocalizationBaseDir = "/";
                BundleImpl.this.bundleLocalizationBaseFilename = object3;
            }
            HeaderDictionary headerDictionary = new HeaderDictionary(attributes.size());
            objectArray = attributes.keySet().toArray(new Object[attributes.keySet().size()]);
            for (int i = 0; i < objectArray.length; ++i) {
                headerDictionary.put(objectArray[i].toString(), attributes.get(objectArray[i]).toString());
            }
            BundleImpl.this.headers = headerDictionary;
            Object object2 = this.capabilities.get("osgi.identity");
            if (object2 != null) {
                this.identity = (BundleCapability)this.capabilities.get("osgi.identity").get(0);
            }
            if ((object = this.capabilities.get("osgi.wiring.host")) == null) {
                this.fragmentAttachmentPolicy = (short)-1;
            } else {
                String string6 = ((BundleCapability)object.get(0)).getDirectives().get("fragment-attachment");
                this.fragmentAttachmentPolicy = this.identity == null || string6 == null || "always".equals(string6) ? (short)2 : ("resolve-time".equals(string6) ? (short)1 : ("never".equals(string6) ? (short)-1 : (short)2));
            }
            if (this.isFragment()) {
                BundleImpl.this.framework.addFragment(this);
            } else {
                BundleImpl.this.framework.publishCapabilities(this.capabilities.getAllValues());
            }
        }

        protected void refresh() {
            if (this.fragments != null) {
                this.fragments = null;
            }
            this.classloader = new BundleClassLoader();
        }

        private ConciergeCollections.MultiMap<String, BundleRequirement> parseRequirements(String string) throws BundleException {
            ConciergeCollections.MultiMap<String, BundleRequirement> multiMap = new ConciergeCollections.MultiMap<String, BundleRequirement>();
            if (string == null) {
                return multiMap;
            }
            String[] stringArray = Utils.splitString(string, ',');
            for (int i = 0; i < stringArray.length; ++i) {
                Resources.BundleRequirementImpl bundleRequirementImpl = new Resources.BundleRequirementImpl(this, stringArray[i]);
                String string2 = bundleRequirementImpl.getNamespace();
                multiMap.insert(string2, bundleRequirementImpl);
            }
            return multiMap;
        }

        private ConciergeCollections.MultiMap<String, BundleCapability> parseCapabilities(String string) throws BundleException {
            ConciergeCollections.MultiMap<String, BundleCapability> multiMap = new ConciergeCollections.MultiMap<String, BundleCapability>();
            if (string == null) {
                return multiMap;
            }
            String[] stringArray = Utils.splitString(string, ',');
            for (int i = 0; i < stringArray.length; ++i) {
                Resources.BundleCapabilityImpl bundleCapabilityImpl = new Resources.BundleCapabilityImpl(this, stringArray[i]);
                String string2 = bundleCapabilityImpl.getNamespace();
                multiMap.insert(string2, bundleCapabilityImpl);
            }
            return multiMap;
        }

        private HashSet<String> createExportIndex() {
            Object object = this.capabilities.get("osgi.wiring.package");
            HashSet<String> hashSet = new HashSet<String>();
            if (object != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    BundleCapability bundleCapability = (BundleCapability)iterator.next();
                    hashSet.add((String)bundleCapability.getAttributes().get("osgi.wiring.package"));
                }
            }
            return hashSet;
        }

        public boolean isFragment() {
            return this.requirements.get("osgi.wiring.host") != null;
        }

        boolean isExtensionBundle() {
            String string = this.getFragmentHost();
            return string.equals("system.bundle") || string.equals("org.eclipse.concierge");
        }

        protected boolean isCurrent() {
            return BundleImpl.this.currentRevision == this;
        }

        @Override
        public Bundle getBundle() {
            return BundleImpl.this;
        }

        @Override
        public String getSymbolicName() {
            return this.identity == null ? null : (String)this.identity.getAttributes().get("osgi.identity");
        }

        @Override
        public Version getVersion() {
            return this.identity == null ? Version.emptyVersion : (Version)this.identity.getAttributes().get("version");
        }

        @Override
        public List<BundleCapability> getDeclaredCapabilities(String string) {
            return string == null ? this.capabilities.getAllValues() : this.capabilities.lookup(string);
        }

        @Override
        public List<BundleRequirement> getDeclaredRequirements(String string) {
            return string == null ? this.requirements.getAllValues() : this.requirements.lookup(string);
        }

        @Override
        public int getTypes() {
            return this.identity == null ? 0 : ("osgi.fragment".equals(this.identity.getAttributes().get("type")) ? 1 : 0);
        }

        @Override
        public BundleWiring getWiring() {
            return this.wiring;
        }

        @Override
        public List<Capability> getCapabilities(String string) {
            return Collections.unmodifiableList(new ArrayList<BundleCapability>(this.getDeclaredCapabilities(string)));
        }

        @Override
        public List<Requirement> getRequirements(String string) {
            return Collections.unmodifiableList(new ArrayList<BundleRequirement>(this.getDeclaredRequirements(string)));
        }

        protected boolean resolve(boolean bl) throws BundleException {
            if (!this.resolveMetadata(bl)) {
                return false;
            }
            if (!BundleImpl.this.framework.resolve(Collections.singletonList(this), bl)) {
                return false;
            }
            if (BundleImpl.this.state == 2) {
                BundleImpl.this.state = 4;
                BundleImpl.this.framework.notifyBundleListeners(32, BundleImpl.this);
            }
            return true;
        }

        protected boolean resolveMetadata(boolean bl) throws BundleException {
            try {
                if (this.classpath == null) {
                    for (int i = 0; i < this.classpathStrings.length; ++i) {
                        if (this.classpathStrings[i].equals(".")) continue;
                        try {
                            if (null != this.retrieveFile(null, this.classpathStrings[i])) continue;
                            BundleImpl.this.framework.notifyFrameworkListeners(2, BundleImpl.this, new BundleException("Missing file in bundle classpath " + this.classpathStrings[i], 4));
                            continue;
                        }
                        catch (IOException iOException) {
                            BundleImpl.this.framework.notifyFrameworkListeners(2, BundleImpl.this, iOException);
                        }
                    }
                    this.classpath = this.classpathStrings;
                }
                if (this.nativeCodeStrings != null) {
                    this.nativeLibraries = new HashMap<String, String>(this.nativeCodeStrings.length);
                    if (!this.processNativeLibraries(this.nativeCodeStrings)) {
                        if (bl) {
                            throw new BundleException("No matching native clause");
                        }
                        return false;
                    }
                }
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new BundleException("Error while resolving bundle " + BundleImpl.this.currentRevision.getSymbolicName(), 4, illegalArgumentException);
            }
        }

        protected boolean isFrameworkExtension() {
            Object object = this.requirements.get("osgi.wiring.host");
            if (object == null) {
                return false;
            }
            return "framework".equals(((BundleRequirement)object.get(0)).getDirectives().get("extension"));
        }

        private boolean processNativeLibraries(String[] stringArray) throws BundleException {
            int n = -1;
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = false;
            boolean bl4 = true;
            boolean bl5 = false;
            boolean bl6 = true;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            boolean bl10 = true;
            boolean bl11 = false;
            boolean bl12 = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                int n2;
                String[] stringArray2;
                if (stringArray[i].indexOf(";") == -1) {
                    if (stringArray[i].equals("*")) {
                        bl11 = true;
                        continue;
                    }
                    n = stringArray[i].lastIndexOf("/");
                    this.nativeLibraries.put(n > -1 ? stringArray[i].substring(n + 1) : stringArray[i], BundleImpl.stripTrailing(stringArray[i]));
                    continue;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], ";");
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray2 = stringTokenizer.nextToken();
                    n2 = stringArray2.indexOf("=");
                    if (n2 > -1) {
                        String string = stringArray2.substring(0, n2).trim().intern();
                        String string2 = stringArray2.substring(n2 + 1).trim();
                        if (string == "osname") {
                            if (BundleImpl.this.framework.osname.startsWith("Windows")) {
                                bl |= string2.toLowerCase().startsWith("win");
                            } else {
                                bl |= string2.equalsIgnoreCase(BundleImpl.this.framework.osname);
                                if (BundleImpl.this.framework.osname.equals("MacOSX")) {
                                    bl |= string2.equalsIgnoreCase("Mac OS X");
                                } else if (BundleImpl.this.framework.osname.equals("MacOS")) {
                                    bl |= string2.equalsIgnoreCase("Mac OS");
                                }
                            }
                            bl2 = false;
                            continue;
                        }
                        if (string == "osversion") {
                            bl5 |= new VersionRange(Utils.unQuote(string2)).includes(BundleImpl.this.framework.osversion);
                            bl6 = false;
                            continue;
                        }
                        if (string == "language") {
                            bl3 |= new Locale(string2, "").getLanguage().equals(BundleImpl.this.framework.language);
                            bl4 = false;
                            continue;
                        }
                        if (string == "processor") {
                            bl7 = BundleImpl.this.framework.processor.equals("x86") ? (bl7 |= string2.equals("x86") || string2.equals("pentium") || string2.equals("i386") || string2.equals("i486") || string2.equals("i586") || string2.equals("i686")) : (BundleImpl.this.framework.processor.equals("x86-64") ? (bl7 |= string2.equals("amd64") || string2.equals("em64t") || string2.equals("x86_64") || string2.equals("x86-64")) : (BundleImpl.this.framework.processor.equals("ppc") ? (bl7 |= string2.equals("ppc")) : (bl7 |= string2.equalsIgnoreCase(BundleImpl.this.framework.processor))));
                            bl8 = false;
                            continue;
                        }
                        if (string != "selection-filter") continue;
                        try {
                            bl9 |= RFC1960Filter.fromString(Utils.unQuote(string2)).match(Concierge.props2Dict(BundleImpl.this.framework.properties));
                            bl10 = false;
                        }
                        catch (InvalidSyntaxException invalidSyntaxException) {
                            invalidSyntaxException.printStackTrace();
                        }
                        continue;
                    }
                    if ("*".equals(stringArray2.trim()) && !stringTokenizer.hasMoreTokens()) {
                        bl12 = true;
                        continue;
                    }
                    arrayList.add(stringArray2.trim());
                }
                if (!arrayList.isEmpty() && (bl8 || bl7) && (bl2 || bl) && (bl6 || bl5) && (bl4 || bl3) && (bl10 || bl9)) {
                    stringArray2 = arrayList.toArray(new String[arrayList.size()]);
                    for (n2 = 0; n2 < stringArray2.length; ++n2) {
                        n = stringArray2[n2].lastIndexOf("/");
                        this.nativeLibraries.put(n > -1 ? stringArray2[n2].substring(n + 1) : stringArray2[n2], BundleImpl.stripTrailing(stringArray2[n2]));
                    }
                    bl12 = true;
                }
                bl9 = false;
                bl3 = false;
                bl5 = false;
                bl = false;
                bl7 = false;
                bl10 = true;
                bl4 = true;
                bl6 = true;
                bl2 = true;
                bl8 = true;
                arrayList.clear();
            }
            return bl12 || bl11;
        }

        void cleanup(boolean bl) {
            BundleImpl.this.framework.removeCapabilities(this);
            if (BundleImpl.this.currentRevision == null) {
                if (this.wiring != null) {
                    this.wiring.cleanup();
                    BundleImpl.this.framework.wirings.remove(this);
                }
                this.wiring = null;
                this.packageImportWires = null;
                this.requireBundleWires = null;
                this.fragments = null;
            }
            if (!bl) {
                BundleImpl.this.currentRevision = (Revision)BundleImpl.this.revisions.get(0);
            }
        }

        void markResolved() {
            BundleImpl.this.state = 4;
            BundleImpl.this.framework.notifyBundleListeners(32, BundleImpl.this);
        }

        void setWiring(Resources.ConciergeBundleWiring conciergeBundleWiring) {
            this.wiring = conciergeBundleWiring;
            this.packageImportWires = conciergeBundleWiring.getPackageImportWires();
            this.requireBundleWires = conciergeBundleWiring.getRequireBundleWires();
        }

        Resources.ConciergeBundleWiring addAdditionalWires(List<Wire> list) {
            for (Wire wire : list) {
                this.wiring.addWire((BundleWire)wire);
            }
            this.packageImportWires = this.wiring.getPackageImportWires();
            this.requireBundleWires = this.wiring.getRequireBundleWires();
            return this.wiring;
        }

        String getFragmentHost() {
            Object object = this.requirements.get("osgi.wiring.host");
            if (object == null) {
                return null;
            }
            return ((BundleRequirement)object.get(0)).getDirectives().get("osgi.wiring.host");
        }

        final boolean allowsFragmentAttachment() {
            return this.fragmentAttachmentPolicy != -1;
        }

        List<Revision> getAttachedFragments() {
            return this.fragments;
        }

        boolean attachFragment(Revision revision) throws BundleException {
            List<Capability> list;
            String[] stringArray;
            List<BundleRequirement> list2;
            Object object2;
            List<Requirement> list3;
            if (this.fragments != null && this.fragments.contains(revision)) {
                return false;
            }
            if (BundleImpl.this.state == 32 || BundleImpl.this.state == 8) {
                if (this.fragmentAttachmentPolicy == 1) {
                    throw new BundleException("Host bundle does not allow to attach fragment at runtime", 4);
                }
                list3 = revision.getRequirements("osgi.wiring.package");
                object2 = new HashSet();
                list2 = list3.iterator();
                while (list2.hasNext()) {
                    stringArray = list2.next();
                    object2.add(stringArray.getDirectives().get("x-int"));
                }
                object2.remove("org.osgi.framework");
                if (!object2.isEmpty()) {
                    list2 = this.wiring.getRequirements("osgi.wiring.package");
                    for (Requirement object3 : list2) {
                        object2.remove(object3.getDirectives().get("x-int"));
                    }
                    if (!object2.isEmpty()) {
                        throw new BundleException("Imports of this Fragment are not satisfiable without restart of the host bundle", 4);
                    }
                }
                if (!revision.getRequirements("osgi.wiring.bundle").isEmpty()) {
                    throw new BundleException("Fragment must not add new require bundle entries", 4);
                }
            }
            list3 = new ArrayList<Requirement>(this.classpath != null ? this.classpath.length : 0);
            if (this.classpath != null) {
                for (int i = 0; i < this.classpath.length; ++i) {
                    list3.add((Requirement)((Object)this.classpath[i]));
                }
            }
            if ((object2 = revision.requirements.get("osgi.wiring.package")) != null) {
                this.checkConflicts((List)object2, (List)this.requirements.get("osgi.wiring.package"), "osgi.wiring.package", "import");
            }
            if ((list2 = revision.requirements.get("osgi.wiring.bundle")) != null) {
                this.checkConflicts((List)list2, (List)this.requirements.get("osgi.wiring.bundle"), "osgi.wiring.bundle", "requireBundle");
            }
            if (revision.nativeCodeStrings == null) {
                stringArray = this.nativeCodeStrings;
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (this.nativeCodeStrings != null) {
                    arrayList.addAll(Arrays.asList(this.nativeCodeStrings));
                }
                arrayList.addAll(Arrays.asList(revision.nativeCodeStrings));
                stringArray = arrayList.toArray(new String[arrayList.size()]);
            }
            BundleImpl bundleImpl = (BundleImpl)revision.getBundle();
            if (object2 != null) {
                this.requirements.insertAll("osgi.wiring.package", (Collection<BundleRequirement>)object2);
            }
            if (list2 != null) {
                this.requirements.insertAll("osgi.wiring.bundle", list2);
            }
            if ((list = revision.getCapabilities("osgi.wiring.package")) != null) {
                for (Capability capability : list) {
                    this.exportIndex.add((String)capability.getAttributes().get("osgi.wiring.package"));
                }
            }
            if (this.fragments == null) {
                this.fragments = new ArrayList<Revision>();
            }
            this.fragments.add(revision);
            Collections.sort(this.fragments);
            if (bundleImpl.hostBundles == null) {
                bundleImpl.hostBundles = new ArrayList<BundleImpl>();
            }
            bundleImpl.hostBundles.add(BundleImpl.this);
            if (bundleImpl.state != 4) {
                revision.wiring = new Resources.ConciergeBundleWiring(revision, null);
                bundleImpl.state = 4;
                BundleImpl.this.framework.notifyBundleListeners(32, bundleImpl);
            }
            for (int i = 0; i < revision.classpathStrings.length; ++i) {
                if (list3.contains(revision.classpathStrings[i])) continue;
                list3.add((Requirement)((Object)revision.classpathStrings[i]));
            }
            if (list3.size() > 0) {
                this.classpath = list3.toArray(new String[list3.size()]);
            }
            this.nativeCodeStrings = stringArray;
            if (this.nativeCodeStrings != null) {
                this.nativeLibraries = new HashMap<String, String>(this.nativeCodeStrings.length);
                this.processNativeLibraries(stringArray);
            }
            return true;
        }

        private <T extends Requirement> void checkConflicts(List<T> list, List<T> list2, String string, String string2) throws BundleException {
            String string3;
            List<T> list3;
            List<T> list4;
            if (list == null) {
                throw new IllegalArgumentException("list1 == null");
            }
            if (list2 == null) {
                return;
            }
            int n = list.size();
            int n2 = list2.size();
            if (n == 0 || n2 == 0) {
                return;
            }
            if (n > n2) {
                list4 = list2;
                list3 = list;
            } else {
                list4 = list;
                list3 = list2;
            }
            HashMap<String, Requirement> hashMap = new HashMap<String, Requirement>();
            for (Requirement requirement : list3) {
                string3 = requirement.getDirectives().get("x-int");
                if (string3 == null) continue;
                hashMap.put(string3, requirement);
            }
            for (Requirement requirement : list4) {
                string3 = requirement.getDirectives().get("x-int");
                if (string3 == null || !hashMap.containsKey(string3)) continue;
                throw new BundleException("Conflicting " + string2 + " statement " + requirement.getAttributes().get(string) + " from " + requirement, 4);
            }
        }

        protected Object checkActivationChain(Object object) {
            ArrayList<AbstractBundle> arrayList = activationChain.get();
            if (arrayList != null && arrayList.size() > 0 && arrayList.get(0) == BundleImpl.this) {
                activationChain.set(new ArrayList());
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    BundleImpl bundleImpl = (BundleImpl)arrayList.get(i);
                    if (!bundleImpl.beingLazy) continue;
                    bundleImpl.triggerActivation();
                }
                activationChain.set(null);
            }
            return object;
        }

        public String toString() {
            return "[Revision " + this.revId + " of " + BundleImpl.this + "]";
        }

        protected Enumeration<URL> findEntries(String string, String string2, boolean bl) {
            Vector<URL> vector = this.searchFiles(null, string, string2, bl);
            if (this.fragments != null) {
                for (Revision revision : this.fragments) {
                    Vector<URL> vector2 = revision.searchFiles(null, string, string2, bl);
                    vector.addAll(vector2);
                }
            }
            return vector.isEmpty() ? null : vector.elements();
        }

        protected abstract URL lookupFile(String var1, String var2) throws IOException;

        protected abstract URL lookupFile(String var1, String var2, HashSet<String> var3) throws IOException;

        protected abstract Vector<URL> searchFiles(String var1, String var2, String var3, boolean var4);

        protected abstract InputStream retrieveFile(String var1, String var2) throws IOException;

        protected abstract long retrieveFileLength(String var1, String var2) throws IOException;

        protected abstract void close() throws IOException;

        URL createURL(String string, String string2) throws MalformedURLException {
            String string3 = string.replace('\\', '/');
            return new URL(BundleImpl.BUNDLE_FILE_NAME, BundleImpl.this.bundleId + "." + this.revId, (string3.charAt(0) == '/' ? string3 : "/" + string3) + (string2 == null ? "" : "#" + string2));
        }

        void addHostedCapability(HostedCapability hostedCapability) {
            this.hostedCapabilities.add(hostedCapability);
        }

        List<HostedCapability> getHostedCapabilities() {
            return this.hostedCapabilities;
        }

        @Override
        public int compareTo(Revision revision) {
            int n = (int)(BundleImpl.this.bundleId - revision.getBundle().getBundleId());
            return n != 0 ? n : this.revId - revision.revId;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class BundleClassLoader
        extends ClassLoader
        implements BundleReference {
            private Object dexFile;

            public BundleClassLoader() {
                super(BundleImpl.this.framework.parentClassLoader);
                this.dexFile = null;
            }

            @Override
            public final Class<?> loadClass(String string) throws ClassNotFoundException {
                return this.findClass(string);
            }

            @Override
            protected final Class<?> findClass(String string) throws ClassNotFoundException {
                Class clazz = (Class)this.findResource0(BundleImpl.packageOf(string), string, true, false);
                if (clazz == null) {
                    throw new ClassNotFoundException(string);
                }
                return clazz;
            }

            @Override
            public Enumeration<URL> getResources(String string) {
                return this.findResources(string);
            }

            @Override
            public URL getResource(String string) {
                return this.findResource(string);
            }

            @Override
            public Bundle getBundle() {
                return BundleImpl.this;
            }

            @Override
            protected URL findResource(String string) {
                String string2 = BundleImpl.stripTrailing(string);
                try {
                    return (URL)this.findResource0(BundleImpl.packageOf(BundleImpl.pseudoClassname(string2)), string2, false, false);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    return null;
                }
            }

            @Override
            protected Enumeration<URL> findResources(String string) {
                Enumeration<URL> enumeration = this.findResources0(string);
                return enumeration == null ? Collections.enumeration(Collections.emptyList()) : enumeration;
            }

            protected Enumeration<URL> findResources0(String string) {
                String string2 = BundleImpl.stripTrailing(string);
                try {
                    Vector vector = (Vector)this.findResource0(BundleImpl.packageOf(BundleImpl.pseudoClassname(string2)), string2, false, true);
                    return vector == null || vector.isEmpty() ? null : vector.elements();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    return null;
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private synchronized Object findResource0(String string, String string2, boolean bl, boolean bl2) throws ClassNotFoundException {
                Resources.BundleCapabilityImpl bundleCapabilityImpl;
                Object object;
                Vector<URL> vector;
                block13: {
                    Vector<URL> vector2 = vector = bl2 ? new Vector<URL>() : null;
                    if (BundleImpl.this.state == 1) {
                        throw new IllegalStateException("Cannot " + (bl ? "load class" : "find resource") + ", bundle " + Revision.this.getSymbolicName() + " has been uninstalled.");
                    }
                    if (BundleImpl.this.state == 2) {
                        try {
                            Revision.this.resolve(true);
                        }
                        catch (BundleException bundleException) {
                            if (!bl) break block13;
                            BundleImpl.this.framework.notifyFrameworkListeners(2, BundleImpl.this, bundleException);
                            throw new ClassNotFoundException(string2, bundleException);
                        }
                    }
                }
                if (string.startsWith("java.") || BundleImpl.this.framework.bootdelegation(string)) {
                    if (bl) {
                        return this.getParent().loadClass(string2);
                    }
                    if (!bl2) return this.getParent().getResource(string2);
                    try {
                        object = this.getParent().getResources(string2);
                        while (object.hasMoreElements()) {
                            vector.add(object.nextElement());
                        }
                    }
                    catch (IOException iOException) {}
                }
                if (Revision.this.wiring == null || (object = Revision.this.packageImportWires.get(string)) == null || (bundleCapabilityImpl = (Resources.BundleCapabilityImpl)object.getCapability()).hasExcludes() && !bundleCapabilityImpl.filter(BundleImpl.classOf(string2))) return this.findResource1(string, string2, bl, bl2, vector);
                if (object.getProvider().getBundle().getBundleId() != 0L) return ((Revision)object.getProvider()).classloader.findResource1(string, string2, bl, bl2, vector);
                if (bl) {
                    return BundleImpl.this.framework.systemBundleClassLoader.loadClass(string2);
                }
                if (!bl2) return BundleImpl.this.framework.systemBundleClassLoader.getResource(string2);
                try {
                    Enumeration<URL> enumeration = BundleImpl.this.framework.systemBundleClassLoader.getResources(string2);
                    while (enumeration.hasMoreElements()) {
                        vector.add(enumeration.nextElement());
                    }
                    return this.findResource1(string, string2, bl, bl2, vector);
                }
                catch (IOException iOException) {
                    return this.findResource1(string, string2, bl, bl2, vector);
                }
            }

            private synchronized Object findResource1(String string, String string2, boolean bl, boolean bl2, Vector<URL> vector) throws ClassNotFoundException {
                Serializable serializable;
                if (bl && BundleImpl.this.lazyActivation && BundleImpl.this.getState() == 8 && BundleImpl.this.checkActivation(string)) {
                    serializable = activationChain.get();
                    if (serializable == null) {
                        serializable = new ArrayList();
                        serializable.add(BundleImpl.this);
                        activationChain.set((ArrayList<AbstractBundle>)serializable);
                    } else if (!serializable.isEmpty() && !serializable.contains(BundleImpl.this)) {
                        serializable.add(BundleImpl.this);
                    }
                }
                if (Revision.this.requireBundleWires != null) {
                    serializable = new HashSet<BundleImpl>();
                    ((HashSet)serializable).add(BundleImpl.this);
                    for (BundleWire object : Revision.this.requireBundleWires) {
                        if (object.getProvider().getBundle().getBundleId() == 0L) continue;
                        Object object2 = ((Revision)object.getProvider()).classloader.requireBundleLookup(string, string2, bl, bl2, vector, (Set<Bundle>)((Object)serializable));
                        if (bl2 || object2 == null) continue;
                        return bl ? Revision.this.checkActivationChain(object2) : object2;
                    }
                }
                if (bl) {
                    serializable = this.findOwnClass(string2);
                    if (serializable != null) {
                        return Revision.this.checkActivationChain(serializable);
                    }
                } else {
                    serializable = this.findOwnResources(BundleImpl.stripTrailing(string2), true, bl2, vector);
                    if (!bl2 && serializable != null) {
                        return serializable;
                    }
                }
                if (Revision.this.exportIndex.contains(string)) {
                    return null;
                }
                if (!Revision.this.dynamicImports.isEmpty()) {
                    serializable = Revision.this.dynamicImports.iterator();
                    while (serializable.hasNext()) {
                        BundleRevision bundleRevision;
                        boolean bl3;
                        List<BundleCapability> list;
                        BundleRequirement bundleRequirement = (BundleRequirement)serializable.next();
                        String string3 = bundleRequirement.getDirectives().get("x-int");
                        if (RFC1960Filter.stringCompare(string3.toCharArray(), 0, string.toCharArray(), 0) != 0 || (list = BundleImpl.this.framework.resolveDynamic(Revision.this, string, string3, bundleRequirement, bl3 = "multiple".equals(bundleRequirement.getDirectives().get("cardinality")))) == null || list.size() <= 0) continue;
                        BundleCapability bundleCapability = list.get(0);
                        Resources.ConciergeBundleWire conciergeBundleWire = new Resources.ConciergeBundleWire(bundleCapability, bundleRequirement);
                        if (Revision.this.wiring == null) {
                            Revision.this.setWiring(new Resources.ConciergeBundleWiring(Revision.this, null));
                        }
                        Revision.this.wiring.addWire(conciergeBundleWire);
                        ((Resources.ConciergeBundleWiring)bundleCapability.getRevision().getWiring()).addWire(conciergeBundleWire);
                        Revision.this.packageImportWires.put((String)bundleCapability.getAttributes().get("osgi.wiring.package"), conciergeBundleWire);
                        if (!bl3) {
                            serializable.remove();
                        }
                        if (!((bundleRevision = bundleCapability.getRevision()) instanceof Revision)) {
                            if (bl) {
                                return BundleImpl.this.framework.systemBundleClassLoader.loadClass(string2);
                            }
                            if (bl2) {
                                try {
                                    Enumeration<URL> enumeration = BundleImpl.this.framework.systemBundleClassLoader.getResources(string2);
                                    while (enumeration.hasMoreElements()) {
                                        vector.add(enumeration.nextElement());
                                    }
                                    continue;
                                }
                                catch (IOException iOException) {
                                    continue;
                                }
                            }
                            return BundleImpl.this.framework.systemBundleClassLoader.getResource(string2);
                        }
                        return ((Revision)bundleCapability.getRevision()).classloader.findResource1(string, string2, bl, bl2, vector);
                    }
                }
                if ("".equals(string) && !bl && !bl2) {
                    return this.getParent().getResource(string2);
                }
                return vector;
            }

            Set<String> listResources(String string, String string2, int n, HashSet<String> hashSet) {
                String string3 = BundleImpl.pseudoClassname(BundleImpl.stripTrailing(string.endsWith("/") ? string.substring(0, string.length() - 1) : string));
                HashSet<String> hashSet2 = new HashSet<String>();
                if (Revision.this.wiring != null) {
                    if ((n & 1) != 0) {
                        for (Map.Entry object : Revision.this.packageImportWires.entrySet()) {
                            BundleWire bundleWire;
                            Resources.BundleCapabilityImpl bundleCapabilityImpl;
                            String string4 = (String)object.getKey();
                            if (!string4.startsWith(string3) || (bundleCapabilityImpl = (Resources.BundleCapabilityImpl)(bundleWire = (BundleWire)object.getValue()).getCapability()).hasExcludes() && !bundleCapabilityImpl.filter(BundleImpl.classOf(string2))) continue;
                            if ((n & 2) == 0) {
                                hashSet2.addAll(((Revision)bundleWire.getProvider()).classloader.listResources(string4.replace('.', '/'), string2, n, hashSet));
                            }
                            hashSet.add(string4);
                        }
                    } else {
                        Resources.BundleCapabilityImpl bundleCapabilityImpl;
                        BundleWire bundleWire = Revision.this.packageImportWires.get(string3);
                        if (bundleWire != null && (!(bundleCapabilityImpl = (Resources.BundleCapabilityImpl)bundleWire.getCapability()).hasExcludes() || bundleCapabilityImpl.filter(BundleImpl.classOf(string2)))) {
                            if ((n & 2) == 0) {
                                hashSet2.addAll(((Revision)bundleWire.getProvider()).classloader.listResources(string, string2, n, hashSet));
                            }
                            hashSet.add(string3);
                        }
                    }
                    if (Revision.this.requireBundleWires != null && (n & 2) == 0) {
                        for (BundleWire bundleWire : Revision.this.requireBundleWires) {
                            hashSet2.addAll(((Revision)bundleWire.getProvider()).classloader.listResources(string, string2, n, new HashSet<String>()));
                        }
                    }
                    hashSet2.addAll(this.listOwnResources(string, string2, n, hashSet));
                }
                return new HashSet<String>(hashSet2);
            }

            @Override
            protected String findLibrary(String string) {
                if (Revision.this.nativeLibraries == null) {
                    throw new UnsatisfiedLinkError(string);
                }
                String string2 = null;
                String[] stringArray = BundleImpl.this.framework.getLibraryName(string);
                for (int i = 0; i < stringArray.length && (string2 = Revision.this.nativeLibraries.get(stringArray[i])) == null; ++i) {
                }
                if (BundleImpl.this.framework.DEBUG_CLASSLOADING) {
                    BundleImpl.this.framework.logger.log(4, "Requested " + string);
                    BundleImpl.this.framework.logger.log(3, "Native libraries " + Revision.this.nativeLibraries);
                }
                if (string2 == null) {
                    throw new UnsatisfiedLinkError(string);
                }
                try {
                    File file = new File(BundleImpl.this.storageLocation + "lib", string2);
                    URL uRL = (URL)this.findOwnResources(string2, true, false, null);
                    BundleImpl.storeFile(file, uRL.openStream());
                    BundleImpl.this.framework.execPermission(file);
                    return file.getAbsolutePath();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return null;
                }
            }

            /*
             * Exception decompiling
             */
            private synchronized Class<?> findOwnClass(String var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private Class<?> findDexClass(String string) {
                try {
                    if (this.dexFile == null) {
                        String string2 = BundleImpl.this.storageLocation + BundleImpl.BUNDLE_FILE_NAME + Revision.this.revId;
                        this.dexFile = dexFileLoader.invoke(null, string2, BundleImpl.this.storageLocation + "classes.dex", new Integer(0));
                    }
                    if (this.dexFile != null) {
                        return (Class)dexClassLoader.invoke(this.dexFile, string.replace('.', '/'), this);
                    }
                }
                catch (Exception exception) {
                    return null;
                }
                return null;
            }

            List<String> listOwnResources(String string, String string2, int n, HashSet<String> hashSet) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < Revision.this.classpath.length; ++i) {
                    Vector<URL> vector = Revision.this.searchFiles(Revision.this.classpath[i], string, string2, (n & 1) != 0);
                    if (vector == null) continue;
                    for (URL uRL : vector) {
                        int n2 = uRL.getPath().lastIndexOf(47);
                        Object object = BundleImpl.pseudoClassname(uRL.getPath().substring(1, n2));
                        if (hashSet.contains(object)) continue;
                        arrayList.add(uRL.getPath().substring(1));
                    }
                }
                if (Revision.this.fragments != null) {
                    for (Revision revision : Revision.this.fragments) {
                        for (int i = 0; i < Revision.this.classpath.length; ++i) {
                            Vector<URL> vector = revision.searchFiles(Revision.this.classpath[i], string, string2, (n & 1) != 0);
                            if (vector == null) continue;
                            for (Object object : vector) {
                                int n3 = ((URL)object).getPath().lastIndexOf(47);
                                String string3 = BundleImpl.pseudoClassname(((URL)object).getPath().substring(1, n3));
                                if (hashSet.contains(string3)) continue;
                                arrayList.add(((URL)object).getPath().substring(1));
                            }
                        }
                    }
                }
                return arrayList;
            }

            Object findOwnResources(String string, boolean bl, boolean bl2, Vector<URL> vector) {
                if ("".equals(string)) {
                    return vector;
                }
                Vector<URL> vector2 = vector == null ? new Vector<URL>() : vector;
                try {
                    for (int i = 0; i < Revision.this.classpath.length; ++i) {
                        URL object = Revision.this.lookupFile(Revision.this.classpath[i], string);
                        if (object == null) continue;
                        if (!bl2) {
                            return object;
                        }
                        vector2.add(object);
                    }
                    if (bl && Revision.this.fragments != null) {
                        for (Revision revision : Revision.this.fragments) {
                            if (revision == null) {
                                throw new IllegalStateException("REVISION IS NULL");
                            }
                            for (int i = 0; i < Revision.this.classpath.length; ++i) {
                                URL uRL = revision.lookupFile(Revision.this.classpath[i], string);
                                if (uRL == null) continue;
                                if (!bl2) {
                                    return uRL;
                                }
                                vector2.add(uRL);
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return vector2.isEmpty() ? vector : vector2;
            }

            private Object requireBundleLookup(String string, String string2, boolean bl, boolean bl2, Vector<URL> vector, Set<Bundle> set) throws ClassNotFoundException {
                Object object;
                if (set.contains(BundleImpl.this)) {
                    return null;
                }
                set.add(BundleImpl.this);
                if (Revision.this.requireBundleWires != null) {
                    for (BundleWire bundleWire : Revision.this.requireBundleWires) {
                        if (!"reexport".equals(bundleWire.getRequirement().getDirectives().get("visibility"))) continue;
                        object = ((Revision)bundleWire.getProvider()).classloader.requireBundleLookup(string, string2, bl, bl2, vector, set);
                        if (!bl2 && object != null) {
                            return object;
                        }
                        if (object == null) continue;
                        vector.addAll((Vector)object);
                    }
                }
                if (Revision.this.exportIndex.contains(string)) {
                    BundleWire bundleWire;
                    bundleWire = Revision.this.packageImportWires.get(string);
                    BundleClassLoader bundleClassLoader = bundleWire != null ? ((Revision)bundleWire.getProvider()).classloader : this;
                    if (bl) {
                        return super.findOwnClass(string2);
                    }
                    object = bundleClassLoader.findOwnResources(string2, true, bl2, vector);
                    if (!bl2) {
                        return object;
                    }
                    if (object != null) {
                        vector.addAll((Vector)object);
                    }
                }
                return null;
            }

            private void definePackage(String string) {
                try {
                    this.definePackage(string, null, null, null, null, null, null, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WovenClassImpl
        implements WovenClass {
            private final String clazzName;
            private byte[] bytes;
            private boolean weavingComplete;
            private Class<?> clazz;
            private List<String> dynamicImports;
            protected List<BundleRequirement> dynamicImportRequirements;
            private ProtectionDomain domain;

            WovenClassImpl(String string, byte[] byArray, final Revision revision2, ProtectionDomain protectionDomain) {
                this.bytes = byArray;
                this.clazzName = string;
                this.dynamicImportRequirements = new ArrayList<BundleRequirement>();
                this.dynamicImports = new ArrayList<String>(){
                    private static final long serialVersionUID = 975783807443126126L;

                    @Override
                    public boolean add(String string) {
                        this.checkDynamicImport(string);
                        return super.add(string);
                    }

                    @Override
                    public boolean addAll(Collection<? extends String> collection) {
                        for (String string : collection) {
                            this.checkDynamicImport(string);
                        }
                        return super.addAll(collection);
                    }

                    private void checkDynamicImport(String string) throws IllegalArgumentException {
                        try {
                            String[] stringArray = Utils.splitString(string, ';');
                            if (stringArray[0].contains(";")) {
                                throw new IllegalArgumentException(string);
                            }
                            ConciergeCollections.ParseResult parseResult = Utils.parseLiterals(stringArray, 1);
                            HashMap<String, String> hashMap = parseResult.getDirectives();
                            hashMap.put("filter", Utils.createFilter("osgi.wiring.package", stringArray[0], (Map)parseResult.getLatter()));
                            hashMap.put("resolution", "dynamic");
                            hashMap.put("x-int", stringArray[0]);
                            Resources.BundleRequirementImpl bundleRequirementImpl = new Resources.BundleRequirementImpl(revision2, "osgi.wiring.package", hashMap, null, "DynamicImport-Package " + string);
                            WovenClassImpl.this.dynamicImportRequirements.add(bundleRequirementImpl);
                        }
                        catch (BundleException bundleException) {
                            throw new IllegalArgumentException("Unvalid dynamic import " + string);
                        }
                    }
                };
                this.domain = protectionDomain;
            }

            @Override
            public byte[] getBytes() {
                return this.bytes;
            }

            @Override
            public void setBytes(byte[] byArray) {
                if (byArray == null) {
                    throw new NullPointerException("newBytes");
                }
                if (this.weavingComplete) {
                    throw new IllegalStateException("Weaving is complete");
                }
                this.bytes = byArray;
            }

            @Override
            public List<String> getDynamicImports() {
                return this.dynamicImports;
            }

            @Override
            public boolean isWeavingComplete() {
                return this.weavingComplete;
            }

            @Override
            public String getClassName() {
                return this.clazzName;
            }

            @Override
            public ProtectionDomain getProtectionDomain() {
                return this.domain;
            }

            @Override
            public Class<?> getDefinedClass() {
                return this.clazz;
            }

            @Override
            public BundleWiring getBundleWiring() {
                return Revision.this.getWiring();
            }

            void setDefinedClass(Class<?> clazz) {
                this.clazz = clazz;
            }

            void setProtectionDomain(ProtectionDomain protectionDomain) {
                this.domain = protectionDomain;
            }

            void setComplete() {
                this.weavingComplete = true;
                this.bytes = (byte[])this.bytes.clone();
                this.dynamicImports = Collections.unmodifiableList(this.dynamicImports);
            }
        }
    }
}

