/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.concierge.AbstractBundle;
import org.eclipse.concierge.BundleImpl;
import org.eclipse.concierge.ConciergeCollections;
import org.eclipse.concierge.Factory;
import org.eclipse.concierge.RFC1960Filter;
import org.eclipse.concierge.Resources;
import org.eclipse.concierge.ServiceReferenceImpl;
import org.eclipse.concierge.Utils;
import org.eclipse.concierge.compat.LegacyBundleProcessing;
import org.eclipse.concierge.compat.service.XargsFileLauncher;
import org.eclipse.concierge.service.log.LogServiceImpl;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.UnfilteredServiceListener;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.bundle.CollisionHook;
import org.osgi.framework.hooks.bundle.EventHook;
import org.osgi.framework.hooks.bundle.FindHook;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.framework.hooks.weaving.WeavingException;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;
import org.osgi.service.resolver.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Concierge
extends AbstractBundle
implements Framework,
BundleRevision,
FrameworkWiring,
FrameworkStartLevel,
BundleActivator {
    private static final String FRAMEWORK_EXECUTIONENVIRONMENT = "org.osgi.framework.executionenvironment";
    private static final String BUNDLE_REQUIREDEXECUTIONENVIRONMENT = "Bundle-RequiredExecutionEnvironment";
    private static final String BUNDLE_SYMBOLIC_NAME = "org.eclipse.concierge";
    private static final String FRAMEWORK_VERSION = "5.0.0";
    private static Class<?> SERVICE_EVENT_HOOK_CLASS = org.osgi.framework.hooks.service.EventHook.class;
    private static ConciergeURLStreamHandlerFactory conciergeURLStreamHandlerFactory = new ConciergeURLStreamHandlerFactory();
    public static boolean SUPPORTS_EXTENSIONS;
    private String BASEDIR;
    public String BUNDLE_LOCATION = "file:.";
    private int BEGINNING_STARTLEVEL;
    String STORAGE_LOCATION;
    static int CLASSLOADER_BUFFER_SIZE;
    boolean LOG_ENABLED;
    LogService logger;
    int LOG_BUFFER_SIZE;
    boolean LOG_QUIET;
    boolean ALWAYS_DECOMPRESS;
    boolean DECOMPRESS_EMBEDDED;
    int LOG_LEVEL;
    boolean SECURITY_ENABLED;
    boolean DEBUG_BUNDLES;
    boolean DEBUG_PACKAGES;
    boolean DEBUG_CLASSLOADING;
    boolean DEBUG_SERVICES;
    boolean DEBUG_RESOLVER;
    private String PROFILE;
    private final String[] bootdelegationAbs;
    private final String[] bootdelegationPrefix;
    private String[] libraryExtensions;
    private String execPermission;
    private Pattern execPermissionPattern;
    private static final int COLLISION_POLICY_SINGLE = -1;
    private static final int COLLISION_POLICY_NONE = 0;
    private static final int COLLISION_POLICY_MULTIPLE = 1;
    private static final int COLLISION_POLICY_MANAGED = 2;
    int collisionPolicy;
    private Hashtable<String, String> headers;
    private final Version version = new Version("1.5.0");
    static final HashSet<String> SUPPORTED_EE;
    static Comparator<AbstractBundle> VERSION_COMPARATOR;
    protected static final Pattern FILTER_ASSERT_MATCHER;
    List<AbstractBundle> bundles = new ArrayList<AbstractBundle>(2);
    Map<Long, AbstractBundle> bundleID_bundles = new HashMap<Long, AbstractBundle>(2);
    Map<String, AbstractBundle> location_bundles = Collections.synchronizedMap(new HashMap(2));
    ConciergeCollections.MultiMap<String, AbstractBundle> symbolicName_bundles = new ConciergeCollections.MultiMap(2);
    final ConciergeCollections.MultiMap<String, ServiceReference<?>> serviceRegistry = new ConciergeCollections.MultiMap(3);
    final ConciergeCollections.MultiMap<String, ServiceReference<?>> microServices = new ConciergeCollections.MultiMap(3);
    protected final List<BundleListener> bundleListeners = new ArrayList<BundleListener>(1);
    protected final List<SynchronousBundleListener> syncBundleListeners = new ArrayList<SynchronousBundleListener>(1);
    protected final ConciergeCollections.MultiMap<BundleContext, BundleListener> bundleListenerMap = new ConciergeCollections.MultiMap();
    protected final List<ServiceListenerEntry> serviceListeners = new ArrayList<ServiceListenerEntry>(1);
    private final ConciergeCollections.MultiMap<String, BundleImpl.Revision> fragmentIndex = new ConciergeCollections.MultiMap(1);
    private final ArrayList<BundleImpl> extensionBundles = new ArrayList(0);
    protected final List<FrameworkListener> frameworkListeners = new ArrayList<FrameworkListener>(1);
    CapabilityRegistry capabilityRegistry = new CapabilityRegistry();
    Map<Resource, Wiring> wirings = new HashMap<Resource, Wiring>();
    private long nextBundleID = 1L;
    int initStartlevel = 1;
    public boolean restart = false;
    public static final String FRAMEWORK_SYMBOLIC_NAME = "org.eclipse.concierge";
    private final List<BundleCapability> systemBundleCapabilities = new ArrayList<BundleCapability>();
    private static Properties defaultProperties;
    String osname;
    Version osversion;
    String language;
    String processor;
    final Properties properties;
    private final List<ServiceReferenceImpl<CollisionHook>> bundleCollisionHooks = new ArrayList<ServiceReferenceImpl<CollisionHook>>(0);
    private final List<ServiceReferenceImpl<EventHook>> bundleEventHooks = new ArrayList<ServiceReferenceImpl<EventHook>>(0);
    protected final List<ServiceReferenceImpl<FindHook>> bundleFindHooks = new ArrayList<ServiceReferenceImpl<FindHook>>(0);
    protected List<ServiceReferenceImpl<ResolverHookFactory>> resolverHookFactories = new ArrayList<ServiceReferenceImpl<ResolverHookFactory>>(0);
    protected List<ServiceReferenceImpl<org.osgi.framework.hooks.service.EventHook>> serviceEventHooks = new ArrayList<ServiceReferenceImpl<org.osgi.framework.hooks.service.EventHook>>(0);
    protected List<ServiceReferenceImpl<ListenerHook>> serviceListenerHooks = new ArrayList<ServiceReferenceImpl<ListenerHook>>(0);
    protected List<ServiceReferenceImpl<EventListenerHook>> serviceEventListenerHooks = new ArrayList<ServiceReferenceImpl<EventListenerHook>>(0);
    protected List<ServiceReferenceImpl<org.osgi.framework.hooks.service.FindHook>> serviceFindHooks = new ArrayList<ServiceReferenceImpl<org.osgi.framework.hooks.service.FindHook>>(0);
    private final List<ServiceReferenceImpl<WeavingHook>> weavingHooks = new ArrayList<ServiceReferenceImpl<WeavingHook>>(0);
    protected final HashMap<String, List<?>> hooks = new HashMap();
    private FrameworkEvent stopEvent = new FrameworkEvent(64, this, null);
    private final BundleStartLevel systemBundleStartLevel = new SystemBundleStartLevel();
    private final ResolverImpl resolver = new ResolverImpl();
    private final Method addURL;
    final ClassLoader parentClassLoader;
    final ClassLoader systemBundleClassLoader;
    protected static final Comparator<? super Capability> BUNDLE_VERSION;
    protected static final Comparator<? super Capability> EXPORT_ORDER;
    public static final String DIR_INTERNAL = "x-int";
    private static final int MAIN_RC_OK = 0;
    private static final int MAIN_RC_USAGE = 1;
    private boolean firstInit = true;
    private boolean inResolve = false;

    static final Dictionary<String, Object> props2Dict(Properties properties) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        for (Object obj : Collections.list(properties.propertyNames())) {
            String string = (String)obj;
            hashtable.put(string, properties.getProperty(string));
        }
        return hashtable;
    }

    public static void main(String[] stringArray) throws Exception {
        Concierge concierge = Concierge.doMain(stringArray);
        if (concierge != null) {
            concierge.waitForStop(0L);
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public static Concierge doMain(String[] stringArray) throws Exception {
        Concierge concierge;
        XargsFileLauncher xargsFileLauncher = new XargsFileLauncher();
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if ("-help".equalsIgnoreCase(stringArray[i])) {
                System.err.println("Concierge usage: org.eclipse.concierge.Concierge {arguments}\n  {file.xargs}                                 Loads xargs file, must end with .xargs\n  {-install|-start|-istart} {bundle-jar-file}  Install and start one bundle (can be used multiple times, in specified order)\n  {-all} {directory}                           Install and start all bundles from specified directory\n  {-Dprop=value}                               Specify one or more props just for Concierge (can be used multiple times)\nSample: org.eclipse.concierge.Concierge -Dorg.osgi.framework.bootdelegation=sun.*,javax.* -istart mybundle.jar\n");
                return null;
            }
            if (stringArray[i].endsWith(".xargs")) {
                string = stringArray[i];
                break;
            }
            stringBuffer.append(stringArray[i]);
            if (stringArray[i].startsWith("-D")) {
                stringBuffer.append('\n');
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("-profile") && !stringArray[i].equalsIgnoreCase("-install") && !stringArray[i].equalsIgnoreCase("-istart") && !stringArray[i].equalsIgnoreCase("-start") && !stringArray[i].equalsIgnoreCase("-all") || i - 1 >= stringArray.length) continue;
            stringBuffer.append(' ');
            stringBuffer.append(stringArray[++i]);
            stringBuffer.append('\n');
        }
        if (string == null && stringBuffer.length() == 0 && (string = System.getProperty("org.eclipse.concierge.init.xargs")) == null) {
            string = "init.xargs";
        }
        if (string != null) {
            File file = new File(string);
            if (file.exists()) {
                concierge = xargsFileLauncher.processXargsFile(file);
            } else {
                System.err.println("Concierge: xargs file '" + file.toString() + "' not found, starting without arguments");
                concierge = (Concierge)new Factory().newFramework(null);
                concierge.init();
                concierge.start();
            }
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes(StandardCharsets.UTF_8));
            Map<String, String> map = xargsFileLauncher.getPropertiesFromXargsInputStream(byteArrayInputStream);
            byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes(StandardCharsets.UTF_8));
            concierge = xargsFileLauncher.processXargsInputStream(map, byteArrayInputStream);
        }
        return concierge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    Concierge(Map<String, String> map) {
        void var11_28;
        Object object;
        Object object2;
        String[] stringArray;
        Object object3;
        Object object5;
        Object object6;
        int n;
        Object object7;
        this.hooks.put(CollisionHook.class.getName(), this.bundleCollisionHooks);
        this.hooks.put(FindHook.class.getName(), this.bundleFindHooks);
        this.hooks.put(EventHook.class.getName(), this.bundleEventHooks);
        this.hooks.put(ResolverHookFactory.class.getName(), this.resolverHookFactories);
        this.hooks.put(SERVICE_EVENT_HOOK_CLASS.getName(), this.serviceEventHooks);
        this.hooks.put(EventListenerHook.class.getName(), this.serviceEventListenerHooks);
        this.hooks.put(org.osgi.framework.hooks.service.FindHook.class.getName(), this.serviceFindHooks);
        this.hooks.put(ListenerHook.class.getName(), this.serviceListenerHooks);
        this.hooks.put(WeavingHook.class.getName(), this.weavingHooks);
        defaultProperties = new Properties(System.getProperties());
        defaultProperties.setProperty("org.osgi.framework.bootdelegation", "java.*, sun.*, com.sun.*");
        defaultProperties.setProperty("org.osgi.framework.bundle.parent", "boot");
        defaultProperties.setProperty("org.osgi.framework.startlevel.beginning", "1");
        String string = defaultProperties.getProperty(FRAMEWORK_EXECUTIONENVIRONMENT);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n2 = 0;
        try {
            try {
                n2 = Integer.parseInt(System.getProperty("java.specification.version").substring(2));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                object7 = null;
                n = n2;
            }
            object7 = null;
            n = n2;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            int n3 = n2;
            throw throwable;
        }
        if (System.getProperty("java.specification.name").equals("J2ME Foundation Specification")) {
            switch (n) {
                case 1: {
                    stringBuffer.append("CDC-1.1/Foundation-1.1,");
                }
                case 0: {
                    stringBuffer.append("CDC-1.0/Foundation-1.0");
                }
            }
        } else {
            switch (n) {
                case 8: {
                    stringBuffer.append("J2SE-1.8,");
                    stringBuffer.append("JavaSE-1.8,");
                    stringBuffer2.append("1.8,");
                }
                case 7: {
                    stringBuffer.append("J2SE-1.7,");
                    stringBuffer.append("JavaSE-1.7,");
                    stringBuffer2.append("1.7,");
                }
                case 6: {
                    stringBuffer.append("J2SE-1.6,");
                    stringBuffer.append("JavaSE-1.6,");
                    stringBuffer2.append("1.6,");
                }
                case 5: {
                    stringBuffer.append("J2SE-1.5,");
                    stringBuffer2.append("1.5,");
                }
                case 4: {
                    stringBuffer.append("J2SE-1.4,");
                    stringBuffer.append("OSGi/Minimum-1.1,");
                    stringBuffer2.append("1.4,");
                    stringBuffer3.append("1.2,1.1,");
                }
                case 3: {
                    stringBuffer.append("J2SE-1.3,");
                    stringBuffer2.append("1.3,");
                }
                case 2: {
                    stringBuffer.append("J2SE-1.2,");
                    stringBuffer.append("OSGi/Minimum-1.0,");
                    stringBuffer2.append("1.2,");
                    stringBuffer3.append("1.0");
                }
                case 1: {
                    stringBuffer.append("JRE-1.1");
                    stringBuffer2.append("1.1");
                }
            }
        }
        defaultProperties.setProperty(FRAMEWORK_EXECUTIONENVIRONMENT, stringBuffer.toString());
        try {
            object6 = this.getClass().getClassLoader().getResourceAsStream("META-INF/micro-services");
            object5 = new BufferedReader(new InputStreamReader((InputStream)object6));
            while ((object7 = ((BufferedReader)object5).readLine()) != null) {
                try {
                    String[] exception = Utils.splitString((String)object7, ' ');
                    object3 = new Hashtable<String, Version>();
                    ((Dictionary)object3).put("version", Version.parseVersion(exception[2]));
                    stringArray = Class.forName(exception[1]);
                    object2 = stringArray.newInstance();
                    object = new ServiceReferenceImpl(this, this, object2, (Dictionary<String, ?>)object3, new String[]{exception[0]});
                    this.microServices.insert(exception[0], (ServiceReference<?>)object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.serviceRegistry.insertMap(this.microServices);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            if (stringBuffer2.length() > 0) {
                object6 = new Resources.BundleCapabilityImpl(this, "osgi.ee; osgi.ee=\"JavaSE\"; version:List<Version>=\"" + stringBuffer2.toString() + "\"");
                this.systemBundleCapabilities.add((BundleCapability)object6);
            }
            if (stringBuffer3.length() > 0) {
                object6 = new Resources.BundleCapabilityImpl(this, "osgi.ee; osgi.ee=\"OSGi/Minimum\"; version:List<Version>=\"" + stringBuffer3.toString() + "\"");
                this.systemBundleCapabilities.add((BundleCapability)object6);
            }
        }
        catch (BundleException bundleException) {
            bundleException.printStackTrace();
        }
        if (string != null) {
            object6 = this.getService(LegacyBundleProcessing.class, LegacyBundleProcessing.VERSION_TWO);
            if (object6 == null) {
                this.warning("Framework execution environment is ignored because no bundle manifest version 2 processor is available in this deployment");
            } else {
                object5 = object6.translateToCapability(this, FRAMEWORK_EXECUTIONENVIRONMENT, string);
                this.systemBundleCapabilities.addAll((Collection<BundleCapability>)object5);
            }
        }
        defaultProperties.setProperty("org.osgi.framework.system.packages", "org.osgi.framework;version=1.7,org.osgi.framework.hooks.bundle;version=1.1,org.osgi.framework.hooks.resolver;version=1.0,org.osgi.framework.hooks.service;version=1.1,org.osgi.framework.hooks.weaving;version=1.0,org.osgi.framework.launch;version=1.1,org.osgi.framework.namespace;version=1.0,org.osgi.framework.startlevel;version=1.0,org.osgi.framework.wiring;version=1.1,org.osgi.resource;version=1.0,org.osgi.service.log;version=1.3,org.osgi.service.packageadmin;version=1.2,org.osgi.service.startlevel;version=1.1,org.osgi.service.url;version=1.0,org.osgi.service.resolver;version=1.0,org.osgi.util.tracker;version=1.5.1,META-INF.services");
        object6 = System.getProperty("os.name");
        defaultProperties.put("org.osgi.framework.os.name", object6 != null ? object6 : "undefined");
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            defaultProperties.put("org.osgi.framework.os.name", "MacOSX");
        } else if ("Mac OS".equals(System.getProperty("os.name"))) {
            defaultProperties.put("org.osgi.framework.os.name", "MacOS");
        }
        object6 = System.getProperty("os.version");
        defaultProperties.put("org.osgi.framework.os.version", object6 != null ? object6 : "undefined");
        object6 = System.getProperty("os.arch");
        defaultProperties.put("org.osgi.framework.processor", object6 != null ? object6 : "undefined");
        object5 = Locale.getDefault().getLanguage();
        defaultProperties.setProperty("org.osgi.framework.language", (String)(object5 != null ? object5 : "en"));
        defaultProperties.setProperty("org.osgi.framework.startlevel.beginning", "3");
        defaultProperties.setProperty("org.osgi.framework.storage", "storage");
        this.properties = new Properties(defaultProperties){
            private static final long serialVersionUID = -3319768973242656809L;

            public String getProperty(String string) {
                String string2;
                Object object = this.get(string);
                String string3 = string2 = object instanceof String ? (String)object : null;
                if (string2 != null) {
                    return string2;
                }
                String string4 = System.getProperty(string);
                return string4 == null ? this.defaults.getProperty(string) : string4;
            }
        };
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                this.properties.put(entry.getKey(), entry.getValue());
            }
        }
        this.systemBundleClassLoader = this.getClass().getClassLoader();
        object7 = this.properties.getProperty("org.osgi.framework.bundle.parent");
        if ("app".equals(object7)) {
            this.parentClassLoader = ClassLoader.getSystemClassLoader();
        } else if ("framework".equals(object7)) {
            this.parentClassLoader = this.systemBundleClassLoader;
        } else if ("ext".equals(object7)) {
            void var11_23;
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            while (var11_23.getParent() != null) {
                ClassLoader classLoader2 = var11_23.getParent();
            }
            this.parentClassLoader = var11_23;
        } else {
            this.parentClassLoader = new ClassLoader(Object.class.getClassLoader()){};
        }
        this.properties.setProperty("org.osgi.supports.framework.extension", Boolean.toString(false));
        Object var11_26 = null;
        if (this.getClass().getClassLoader() instanceof URLClassLoader) {
            try {
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                this.properties.setProperty("org.osgi.supports.framework.extension", Boolean.toString(true));
                SUPPORTS_EXTENSIONS = true;
            }
            catch (Exception exception) {
                this.logger.log(2, "Could not hijack classloader for framework extensions", exception);
            }
        }
        this.addURL = var11_28;
        this.properties.setProperty("org.osgi.framework.version", this.version.toString());
        this.properties.setProperty("org.osgi.framework.vendor", "Eclipse Foundation");
        this.properties.setProperty("org.osgi.supports.bootclasspath.extension", Boolean.toString(false));
        this.properties.setProperty("org.osgi.supports.framework.fragment", Boolean.toString(true));
        this.properties.setProperty("org.osgi.supports.framework.requirebundle", Boolean.toString(true));
        this.PROFILE = this.properties.getProperty("org.eclipse.concierge.profile", "default");
        this.BASEDIR = this.properties.getProperty("org.eclipse.concierge.basedir", ".");
        this.BUNDLE_LOCATION = this.properties.getProperty("org.eclipse.concierge.jars", "file:" + this.BASEDIR);
        CLASSLOADER_BUFFER_SIZE = this.getProperty("org.eclipse.concierge.classloader.buffersize", 2048);
        this.LOG_ENABLED = this.getProperty("org.eclipse.concierge.log.enabled", false);
        this.LOG_QUIET = this.getProperty("org.eclipse.concierge.log.quiet", false);
        this.LOG_BUFFER_SIZE = this.getProperty("org.eclipse.concierge.log.buffersize", 10);
        this.LOG_LEVEL = this.getProperty("org.eclipse.concierge.log.level", 1);
        this.DEBUG_BUNDLES = this.getProperty("org.eclipse.concierge.debug.bundles", false);
        this.DEBUG_PACKAGES = this.getProperty("org.eclipse.concierge.debug.packages", false);
        this.DEBUG_SERVICES = this.getProperty("org.eclipse.concierge.debug.services", false);
        this.DEBUG_RESOLVER = this.getProperty("org.eclipse.concierge.debug.resolver", false);
        this.DEBUG_CLASSLOADING = this.getProperty("org.eclipse.concierge.debug.classloading", false);
        if (this.getProperty("org.eclipse.concierge.debug", false)) {
            System.out.println("SETTING ALL DEBUG FLAGS");
            this.LOG_ENABLED = true;
            this.LOG_LEVEL = 4;
            this.DEBUG_BUNDLES = true;
            this.DEBUG_PACKAGES = true;
            this.DEBUG_SERVICES = true;
            this.DEBUG_CLASSLOADING = true;
            this.DEBUG_RESOLVER = true;
            this.LOG_LEVEL = 4;
        }
        this.ALWAYS_DECOMPRESS = this.getProperty("org.eclipse.concierge.alwaysDecompress", false);
        this.DECOMPRESS_EMBEDDED = this.getProperty("org.eclipse.concierge.decompressEmbedded", true);
        this.SECURITY_ENABLED = this.getProperty("org.eclipse.concierge.security.enabled", false);
        object3 = this.properties.getProperty("org.osgi.framework.startlevel.beginning");
        try {
            this.BEGINNING_STARTLEVEL = Integer.parseInt((String)object3);
        }
        catch (NumberFormatException numberFormatException) {
            this.warning("Invalid initial startlevel " + (String)object3);
            System.err.println("FALLING BACK TO DEFAULT BEGINNING STARTLEVEL (=1)");
            this.BEGINNING_STARTLEVEL = 1;
        }
        stringArray = Utils.splitString(this.properties.getProperty("org.osgi.framework.bootdelegation"), ',');
        object2 = new ArrayList();
        object = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            int n3 = stringArray[i].indexOf(42);
            if (n3 < 0) {
                ((ArrayList)object2).add(stringArray[i]);
                continue;
            }
            if (n3 < stringArray[i].length() - 1) {
                throw new IllegalArgumentException("Framework bootdelegation " + stringArray[i] + " is not supported");
            }
            ((ArrayList)object).add(stringArray[i].substring(0, n3));
        }
        ((ArrayList)object).remove("java.");
        this.bootdelegationAbs = ((ArrayList)object2).toArray(new String[((ArrayList)object2).size()]);
        this.bootdelegationPrefix = ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
        if (!this.LOG_ENABLED && (this.DEBUG_BUNDLES || this.DEBUG_PACKAGES || this.DEBUG_SERVICES || this.DEBUG_CLASSLOADING)) {
            System.err.println("Logger disabled, ignoring debug flags.");
            this.DEBUG_BUNDLES = false;
            this.DEBUG_PACKAGES = false;
            this.DEBUG_SERVICES = false;
            this.DEBUG_CLASSLOADING = false;
        }
        if (System.getSecurityManager() == null && this.SECURITY_ENABLED) {
            this.warning("No security manager set, ignoring security flag.");
            this.SECURITY_ENABLED = false;
        }
        this.location = "System Bundle";
        this.state = 2;
        this.context = new BundleContextImpl(this);
        this.domain = Concierge.class.getProtectionDomain();
        this.headers = new Hashtable(5);
    }

    private boolean getProperty(String string, boolean bl) {
        String string2 = this.properties.getProperty(string);
        return string2 != null ? Boolean.valueOf(string2) : bl;
    }

    private int getProperty(String string, int n) {
        String string2 = this.properties.getProperty(string);
        return string2 != null ? Integer.parseInt(string2) : n;
    }

    private void warning(String string) throws RuntimeException {
        if (this.getProperty("org.eclipse.concierge.strictStartup", false)) {
            throw new RuntimeException(string);
        }
        System.err.println("WARNING: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws BundleException {
        Object object;
        Object object2;
        if (this.state == 32 || this.state == 8 || this.state == 16) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.properties.getProperty(FRAMEWORK_EXECUTIONENVIRONMENT), ",");
        while (stringTokenizer.hasMoreTokens()) {
            SUPPORTED_EE.add(stringTokenizer.nextToken().trim());
        }
        this.STORAGE_LOCATION = this.properties.getProperty("org.eclipse.concierge.storage", this.properties.getProperty("org.osgi.framework.storage", this.BASEDIR + File.separatorChar + "storage")) + File.separatorChar + this.PROFILE + File.separatorChar;
        File file = new File(this.STORAGE_LOCATION);
        if (file.exists()) {
            if (this.firstInit && "onFirstInit".equals(this.properties.getProperty("org.osgi.framework.storage.clean"))) {
                Concierge.deleteDirectory(file);
            } else {
                this.restart = true;
            }
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new BundleException("Could not create storage directory " + file);
        }
        this.firstInit = false;
        this.startlevel = 0;
        String string = this.properties.getProperty("org.osgi.framework.bsnversion");
        if (string == null) {
            this.collisionPolicy = 0;
        } else if (string.equals("single")) {
            this.collisionPolicy = -1;
        } else if (string.equals("multiple")) {
            this.collisionPolicy = 1;
        } else if (string.equals("managed")) {
            this.collisionPolicy = 2;
        }
        String string2 = this.properties.getProperty("org.osgi.framework.os.name");
        this.osversion = new Version(Concierge.sanitizeVersion(this.properties.getProperty("org.osgi.framework.os.version")));
        this.language = new Locale(this.properties.getProperty("org.osgi.framework.language"), "").getLanguage();
        String string3 = this.properties.getProperty("org.osgi.framework.processor").intern();
        this.osname = string2.toLowerCase().startsWith("win") ? "Windows" : string2;
        this.processor = string3 == "pentium" || string3 == "i386" || string3 == "i486" || string3 == "i586" || string3 == "i686" ? "x86" : (string3 == "amd64" || string3 == "em64t" || string3 == "x86_64" || string3 == "x86-64" ? "x86-64" : string3);
        String string4 = this.properties.getProperty("org.osgi.framework.library.extensions");
        if (string4 != null) {
            this.libraryExtensions = Utils.splitString(string4, ',');
        }
        this.execPermission = this.properties.getProperty("org.osgi.framework.command.execpermission");
        if (this.execPermission != null) {
            this.execPermissionPattern = Pattern.compile("\\$\\{" + this.properties.getProperty("abspath", "abspath") + "\\}");
        }
        this.headers.put("Bundle-ManifestVersion", "2");
        this.headers.put("Bundle-Name", "org.eclipse.concierge");
        this.headers.put("Bundle-Version", FRAMEWORK_VERSION);
        this.headers.put(BUNDLE_REQUIREDEXECUTIONENVIRONMENT, "OSGi/Minimum-1.1, CDC-1.1/Foundation-1.1");
        this.headers.put("Bundle-SymbolicName", "org.eclipse.concierge");
        String string5 = this.properties.getProperty("org.osgi.framework.system.packages.extra");
        String string6 = string5 == null ? this.properties.getProperty("org.osgi.framework.system.packages") : this.properties.getProperty("org.osgi.framework.system.packages") + "," + string5;
        String[] stringArray = Utils.splitString(string6, ',');
        this.exportSystemBundlePackages(stringArray);
        this.headers.put("Export-Package", string6);
        this.headers.put("Bundle-Vendor", "Eclipse Foundation");
        this.bundleID_bundles.put(new Long(0L), this);
        this.location_bundles.put("System Bundle", this);
        this.symbolicName_bundles.insert("system.bundle", this);
        this.symbolicName_bundles.insert("org.eclipse.concierge", this);
        String string7 = this.properties.getProperty("org.osgi.framework.system.capabilities.extra");
        if (string7 != null) {
            for (String string8 : object2 = Utils.splitString(string7, ',')) {
                try {
                    object = new Resources.BundleCapabilityImpl(this, string8);
                    this.systemBundleCapabilities.add((BundleCapability)object);
                }
                catch (BundleException bundleException) {
                    bundleException.printStackTrace();
                }
            }
        }
        object2 = new Resources.BundleCapabilityImpl(this, "osgi.wiring.bundle; osgi.wiring.bundle=system.bundle");
        this.systemBundleCapabilities.add((BundleCapability)object2);
        Resources.BundleCapabilityImpl bundleCapabilityImpl = new Resources.BundleCapabilityImpl(this, "osgi.wiring.host; osgi.wiring.host=system.bundle");
        this.systemBundleCapabilities.add(bundleCapabilityImpl);
        Resources.BundleCapabilityImpl bundleCapabilityImpl2 = new Resources.BundleCapabilityImpl(this, "osgi.wiring.host; osgi.wiring.host=org.eclipse.concierge");
        this.systemBundleCapabilities.add(bundleCapabilityImpl2);
        this.publishCapabilities(this.systemBundleCapabilities);
        this.wirings.put(this, new Resources.ConciergeBundleWiring(this, null));
        this.registeredServices = new ArrayList(2);
        if (this.LOG_ENABLED) {
            LogServiceImpl error = new LogServiceImpl(this.LOG_BUFFER_SIZE, this.LOG_LEVEL, this.LOG_QUIET);
            ServiceReferenceImpl<LogServiceImpl> serviceReferenceImpl = new ServiceReferenceImpl<LogServiceImpl>(this, this, error, null, new String[]{LogReaderService.class.getName()});
            this.logger = error.factory.getService(null, null);
            object = new ServiceReferenceImpl<ServiceFactory<LogService>>(this, this, error.factory, null, new String[]{LogService.class.getName()});
            ConciergeCollections.MultiMap<String, ServiceReference<?>> multiMap = this.serviceRegistry;
            synchronized (multiMap) {
                this.serviceRegistry.insert(LogReaderService.class.getName(), serviceReferenceImpl);
                this.serviceRegistry.insert(LogService.class.getName(), (ServiceReference<?>)object);
            }
            this.registeredServices.add(object);
            this.registeredServices.add(serviceReferenceImpl);
            if (this.DEBUG_SERVICES) {
                this.logger.log(4, "Framework has registered LogService and LogReaderService.");
            }
        }
        try {
            conciergeURLStreamHandlerFactory.setConcierge(this);
            URL.setURLStreamHandlerFactory(conciergeURLStreamHandlerFactory);
        }
        catch (Error error) {
            // empty catch block
        }
        this.properties.setProperty("org.osgi.framework.uuid", UUID.randomUUID().toString());
        this.state = 8;
        if (this.restart) {
            this.restoreProfile();
        }
    }

    private void exportSystemBundlePackages(String[] stringArray) throws BundleException {
        for (String string : stringArray) {
            String[] stringArray2 = Utils.splitString(string, ';');
            if (stringArray2.length <= 0) continue;
            ConciergeCollections.ParseResult parseResult = Utils.parseLiterals(stringArray2, 1);
            HashMap<String, Object> hashMap = parseResult.getAttributes();
            hashMap.put("osgi.wiring.package", stringArray2[0].trim());
            this.systemBundleCapabilities.add(new Resources.BundleCapabilityImpl(this, "osgi.wiring.package", parseResult.getDirectives(), hashMap, "Export-Package " + string));
        }
    }

    private static String sanitizeVersion(String string) {
        int n = 0;
        int n2 = string.length();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < n2; ++i) {
            if (cArray[i] == '.' && n < 2) {
                ++n;
                continue;
            }
            if (Character.isDigit(cArray[i])) continue;
            return string.substring(0, i);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized FrameworkEvent waitForStop(long l) throws InterruptedException {
        Object object;
        if (this.state == 8 || this.state == 16 || this.state == 32) {
            object = this;
            synchronized (object) {
                this.wait(l);
            }
            if (this.state != 4 && this.state != 2) {
                return new FrameworkEvent(512, this, null);
            }
        }
        object = this.stopEvent;
        this.stopEvent = new FrameworkEvent(64, this, null);
        return object;
    }

    @Override
    public void start() throws BundleException {
        if (this.state != 8) {
            this.init();
        }
        if (this.state == 32) {
            return;
        }
        try {
            System.out.println("---------------------------------------------------------");
            System.out.println("  Concierge OSGi 5.0.0 on " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " starting ... (" + this.PROFILE + ") startlevel=" + this.BEGINNING_STARTLEVEL);
            System.out.println("---------------------------------------------------------");
            long l = System.currentTimeMillis();
            for (BundleImpl bundleImpl : this.extensionBundles) {
                bundleImpl.state = 4;
            }
            this.start(this.context);
            this.setLevel(this.bundles.toArray(new Bundle[this.bundles.size()]), this.BEGINNING_STARTLEVEL, false);
            if (!this.restart) {
                this.storeProfile();
            }
            float f = (float)(System.currentTimeMillis() - l) / 1000.0f;
            System.out.println("---------------------------------------------------------");
            System.out.println("  Framework " + (this.restart ? "restarted" : "started") + " in " + f + " seconds.");
            System.out.println("---------------------------------------------------------");
            System.out.flush();
        }
        catch (Exception exception) {
            this.notifyFrameworkListeners(2, this, new BundleException("Exception during framework start", 7, exception));
        }
        this.state = 32;
        this.notifyFrameworkListeners(1, this, null);
    }

    private void storeProfile() {
        BundleImpl[] bundleImplArray = this.bundles.toArray(new BundleImpl[this.bundles.size()]);
        for (int i = 0; i < bundleImplArray.length; ++i) {
            if (bundleImplArray[i].state == 1) continue;
            bundleImplArray[i].updateMetadata();
        }
        this.storeMetadata();
    }

    void storeMetadata() {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(new File(this.STORAGE_LOCATION, "meta")));
            dataOutputStream.writeLong(this.nextBundleID);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void restoreProfile() {
        try {
            File file;
            if (this.DEBUG_BUNDLES) {
                this.logger.log(4, "restoring profile " + this.PROFILE);
            }
            if (!(file = new File(this.STORAGE_LOCATION, "meta")).exists()) {
                this.warning("Profile " + this.PROFILE + " not found, performing clean start ...");
                this.restart = false;
                return;
            }
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            this.nextBundleID = dataInputStream.readLong();
            dataInputStream.close();
            File file2 = new File(this.STORAGE_LOCATION);
            File[] fileArray = file2.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file3;
                if (!fileArray[i].isDirectory() || !(file3 = new File(fileArray[i], "meta")).exists()) continue;
                try {
                    BundleImpl bundleImpl = new BundleImpl(this, file3);
                    if (this.DEBUG_BUNDLES) {
                        this.logger.log(4, "RESTORED BUNDLE " + bundleImpl.location);
                    }
                    this.bundles.add(bundleImpl);
                    this.bundleID_bundles.put(new Long(bundleImpl.bundleId), bundleImpl);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    boolean bootdelegation(String string) {
        int n;
        for (n = 0; n < this.bootdelegationPrefix.length; ++n) {
            if (!string.startsWith(this.bootdelegationPrefix[n])) continue;
            return true;
        }
        for (n = 0; n < this.bootdelegationAbs.length; ++n) {
            if (!string.equals(this.bootdelegationAbs[n])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void start(int n) throws BundleException {
        this.start();
    }

    @Override
    public void stop() throws BundleException {
        new Thread(){

            public void run() {
                Concierge.this.stop0(false);
            }
        }.start();
    }

    @Override
    public void stop(int n) throws BundleException {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop0(boolean bl) {
        this.state = 16;
        if (!bl) {
            System.out.println("---------------------------------------------------------");
            System.out.println("  Concierge OSGi shutting down ...");
            System.out.println("  Bye !");
            System.out.println("---------------------------------------------------------");
            System.out.flush();
        }
        try {
            this.setLevel(this.bundles.toArray(new Bundle[this.bundles.size()]), 0, true);
            this.state = 4;
            this.stop(this.context);
            for (AbstractBundle abstractBundle : this.bundles) {
                for (BundleRevision bundleRevision : abstractBundle.getRevisions()) {
                    ((BundleImpl.Revision)bundleRevision).close();
                }
            }
            this.bundles.clear();
            this.bundleID_bundles.clear();
            this.serviceRegistry.clear();
            this.serviceRegistry.insertMap(this.microServices);
            conciergeURLStreamHandlerFactory.setConcierge(null);
            this.stopEvent = new FrameworkEvent(bl ? 128 : 64, this, null);
            Concierge concierge = this;
            synchronized (concierge) {
                this.notify();
            }
        }
        catch (Exception exception) {
            this.stopEvent = new FrameworkEvent(2, this, new BundleException("Exception during framework start", exception));
            this.notify();
        }
    }

    @Override
    public void uninstall() throws BundleException {
        throw new BundleException("System bundle cannot be uninstalled.");
    }

    @Override
    public void update() throws BundleException {
        final int n = this.state;
        new Thread(){

            public void run() {
                Concierge.this.stop0(true);
                try {
                    if (n == 8) {
                        Concierge.this.init();
                    } else if (n == 32) {
                        Concierge.this.start();
                    }
                }
                catch (BundleException bundleException) {
                    bundleException.printStackTrace();
                }
                Concierge.this.state = n;
            }
        }.start();
    }

    @Override
    public void update(InputStream inputStream) throws BundleException {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.update();
    }

    @Override
    public String getSymbolicName() {
        return "org.eclipse.concierge";
    }

    @Override
    public Enumeration<String> getEntryPaths(String string) {
        return null;
    }

    @Override
    public Enumeration<URL> findEntries(String string, String string2, boolean bl) {
        return null;
    }

    @Override
    public URL getEntry(String string) {
        return null;
    }

    @Override
    public <A> A adapt(Class<A> clazz) {
        if (clazz == BundleStartLevel.class) {
            return (A)this.systemBundleStartLevel;
        }
        if (clazz == BundleWiring.class) {
            return (A)this.wirings.get(this);
        }
        if (clazz.isInstance(this)) {
            return (A)this;
        }
        return null;
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public ServiceReference<?>[] getServicesInUse() {
        return null;
    }

    @Override
    public URL getResource(String string) {
        return this.systemBundleClassLoader.getResource(string);
    }

    @Override
    public Dictionary<String, String> getHeaders(String string) {
        return this.headers;
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.systemBundleClassLoader.loadClass(string);
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        return this.systemBundleClassLoader.getResources(string);
    }

    @Override
    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int n) {
        return null;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public String toString() {
        return "Concierge System Bundle";
    }

    @Override
    public int getStartLevel() {
        return this.startlevel;
    }

    @Override
    public void setStartLevel(final int n, final FrameworkListener ... frameworkListenerArray) {
        if (n <= 0) {
            throw new IllegalArgumentException("Start level " + n + " is not a valid level");
        }
        new Thread(){

            public void run() {
                Concierge.this.setLevel(Concierge.this.bundles.toArray(new Bundle[Concierge.this.bundles.size()]), n, false);
                Concierge.this.notifyFrameworkListeners(8, Concierge.this, null);
                if (frameworkListenerArray != null) {
                    Concierge.this.notifyFrameworkListeners(frameworkListenerArray, 8, Concierge.this, null);
                }
                Concierge.this.storeMetadata();
            }
        }.start();
    }

    @Override
    public int getInitialBundleStartLevel() {
        return this.initStartlevel;
    }

    @Override
    public void setInitialBundleStartLevel(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Start level " + n + " is not a valid level");
        }
        this.initStartlevel = n;
    }

    protected void setLevel(Bundle[] bundleArray, int n, boolean bl) {
        Object object;
        int n2;
        if (this.startlevel == n) {
            return;
        }
        boolean bl2 = n > this.startlevel;
        int n3 = bl2 ? n - this.startlevel : this.startlevel - n;
        ConciergeCollections.MultiMap<Integer, Object> multiMap = new ConciergeCollections.MultiMap<Integer, Object>(0);
        for (n2 = 0; n2 < bundleArray.length; ++n2) {
            int n4;
            object = (AbstractBundle)bundleArray[n2];
            if (object == this || ((AbstractBundle)object).state == 1 || bl2 && ((AbstractBundle)object).autostart == 0 || !bl2 && ((AbstractBundle)object).state == 4 || (n4 = bl2 ? ((AbstractBundle)object).startlevel - this.startlevel - 1 : this.startlevel - ((AbstractBundle)object).startlevel) < 0 || n4 >= n3) continue;
            multiMap.insert(new Integer(n4), object);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.startlevel = bl2 ? ++this.startlevel : --this.startlevel;
            object = multiMap.get(new Integer(n2));
            if (object == null) continue;
            BundleImpl[] bundleImplArray = object.toArray(new BundleImpl[object.size()]);
            for (int i = 0; i < bundleImplArray.length; ++i) {
                try {
                    if (bl2) {
                        bundleImplArray[i].activate(bundleImplArray[i].isActivationPolicyUsed() ? 2 : 0);
                        continue;
                    }
                    if (bundleImplArray[bundleImplArray.length - i - 1].getState() == 1) continue;
                    bundleImplArray[bundleImplArray.length - i - 1].stopBundle();
                    continue;
                }
                catch (BundleException bundleException) {
                    if (bundleException.getNestedException() != null) {
                        bundleException.getNestedException().printStackTrace();
                    }
                    bundleException.printStackTrace();
                    this.notifyFrameworkListeners(2, bl2 ? bundleImplArray[i] : bundleImplArray[bundleImplArray.length - i - 1], bundleException);
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    this.notifyFrameworkListeners(2, bl2 ? bundleImplArray[i] : bundleImplArray[bundleImplArray.length - i - 1], throwable);
                }
            }
        }
        this.startlevel = n;
    }

    @Override
    public List<BundleCapability> getDeclaredCapabilities(String string) {
        ArrayList<BundleCapability> arrayList = new ArrayList<BundleCapability>();
        if (string != null) {
            for (BundleCapability bundleCapability : this.systemBundleCapabilities) {
                if (!bundleCapability.getNamespace().equals(string)) continue;
                arrayList.add(bundleCapability);
            }
        } else {
            arrayList.addAll(this.systemBundleCapabilities);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public List<BundleRequirement> getDeclaredRequirements(String string) {
        return Collections.emptyList();
    }

    @Override
    public int getTypes() {
        return 0;
    }

    @Override
    public BundleWiring getWiring() {
        return (BundleWiring)this.wirings.get(this);
    }

    @Override
    public List<Capability> getCapabilities(String string) {
        return Collections.unmodifiableList(new ArrayList<BundleCapability>(this.getDeclaredCapabilities(string)));
    }

    @Override
    public List<Requirement> getRequirements(String string) {
        return Collections.emptyList();
    }

    @Override
    public void refreshBundles(final Collection<Bundle> collection, final FrameworkListener ... frameworkListenerArray) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Concierge concierge = Concierge.this;
                    synchronized (concierge) {
                        Bundle bundle2;
                        Object object2;
                        Bundle[] bundleArray = collection == null ? Concierge.this.bundles.toArray(new Bundle[Concierge.this.bundles.size()]) : collection.toArray(new Bundle[collection.size()]);
                        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
                        block11: for (int i = 0; i < bundleArray.length; ++i) {
                            if (bundleArray[i] == Concierge.this || bundleArray[i].getState() == 2) continue;
                            object2 = (BundleImpl)bundleArray[i];
                            if (collection == null) {
                                if (((BundleImpl)object2).currentRevision == null || ((BundleImpl)object2).currentRevision != ((BundleImpl)object2).revisions.get(0)) {
                                    arrayList.add((Bundle)object2);
                                    continue;
                                }
                                if (((BundleImpl)object2).currentRevision.fragments == null) continue;
                                for (BundleImpl.Revision object3 : ((BundleImpl)object2).currentRevision.fragments) {
                                    if (object3.getBundle().getState() != 1) continue;
                                    arrayList.add(bundleArray[i]);
                                    continue block11;
                                }
                                continue;
                            }
                            arrayList.add(bundleArray[i]);
                        }
                        if (arrayList.isEmpty()) {
                            this.notifyListeners(4, Concierge.this, null);
                            return;
                        }
                        if (Concierge.this.LOG_ENABLED && Concierge.this.DEBUG_PACKAGES) {
                            Concierge.this.logger.log(4, "REFRESHING PACKAGES FROM BUNDLES " + arrayList);
                        }
                        Collection<Bundle> collection2 = Concierge.this.getDependencyClosure(arrayList);
                        if (Concierge.this.LOG_ENABLED && Concierge.this.DEBUG_PACKAGES) {
                            Concierge.this.logger.log(4, "UPDATE GRAPH IS " + collection2);
                        }
                        object2 = new ArrayList<Bundle>(collection2);
                        Collections.sort(object2);
                        Bundle[] bundleArray2 = ((ArrayList)object2).toArray(new Bundle[((ArrayList)object2).size()]);
                        ArrayList<BundleImpl> arrayList2 = new ArrayList<BundleImpl>();
                        for (int iterator = 0; iterator < bundleArray2.length; ++iterator) {
                            bundle2 = (BundleImpl)bundleArray2[iterator];
                            try {
                                if (((BundleImpl)bundle2).state == 32) {
                                    ((BundleImpl)bundle2).stop();
                                    arrayList2.add(0, (BundleImpl)bundle2);
                                }
                                if (((BundleImpl)bundle2).state == 4) {
                                    ((BundleImpl)bundle2).state = 2;
                                }
                                ((BundleImpl)bundle2).refresh();
                                if (((BundleImpl)bundle2).state == 1) {
                                    Concierge.this.bundles.remove(bundle2);
                                    continue;
                                }
                                Concierge.this.notifyBundleListeners(64, bundle2);
                                continue;
                            }
                            catch (Exception bl) {
                                this.notifyListeners(2, (Bundle)bundleArray2[iterator], bl);
                            }
                        }
                        Iterator iterator = arrayList2.iterator();
                        while (iterator.hasNext()) {
                            bundle2 = (BundleImpl)iterator.next();
                            try {
                                boolean exception;
                                if (((BundleImpl)bundle2).state != 2 || (exception = ((BundleImpl)bundle2).currentRevision.resolve(false))) continue;
                                iterator.remove();
                            }
                            catch (Exception exception) {
                                iterator.remove();
                                this.notifyListeners(2, bundle2, exception);
                            }
                        }
                        for (Bundle bundle2 : arrayList2) {
                            try {
                                bundle2.start();
                            }
                            catch (Exception exception) {
                                this.notifyListeners(2, bundle2, exception);
                            }
                        }
                        this.notifyListeners(4, Concierge.this, null);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }

            private void notifyListeners(int n, Bundle bundle, Exception exception) {
                if (n == 2) {
                    exception.printStackTrace();
                }
                Concierge.this.notifyFrameworkListeners(n, bundle, exception);
                if (frameworkListenerArray != null) {
                    Concierge.this.notifyFrameworkListeners(frameworkListenerArray, n, bundle, exception);
                }
            }
        }.start();
    }

    @Override
    public boolean resolveBundles(Collection<Bundle> collection) {
        ArrayList<BundleRevision> arrayList = new ArrayList<BundleRevision>();
        boolean bl = true;
        for (Bundle bundle : collection == null ? this.bundles : collection) {
            if (bundle.getState() == 1) {
                bl = false;
                continue;
            }
            arrayList.add(bundle.adapt(BundleRevision.class));
        }
        try {
            return bl &= this.resolve(arrayList, false);
        }
        catch (BundleException bundleException) {
            return false;
        }
    }

    private HashMap<ResolverHook, ServiceReferenceImpl<ResolverHookFactory>> getResolverHooks(Collection<BundleRevision> collection) throws Throwable {
        LinkedHashMap<ResolverHook, ServiceReferenceImpl<ResolverHookFactory>> linkedHashMap = new LinkedHashMap<ResolverHook, ServiceReferenceImpl<ResolverHookFactory>>();
        ServiceReferenceImpl[] serviceReferenceImplArray = this.resolverHookFactories.toArray(new ServiceReferenceImpl[this.resolverHookFactories.size()]);
        try {
            for (int i = 0; i < serviceReferenceImplArray.length; ++i) {
                ServiceReferenceImpl serviceReferenceImpl = serviceReferenceImplArray[i];
                ResolverHookFactory resolverHookFactory = (ResolverHookFactory)serviceReferenceImpl.getService(this);
                if (resolverHookFactory == null) continue;
                ResolverHook resolverHook = resolverHookFactory.begin(Collections.unmodifiableCollection(collection));
                if (resolverHook != null) {
                    linkedHashMap.put(resolverHook, serviceReferenceImpl);
                }
                serviceReferenceImpl.ungetService(this);
            }
        }
        catch (Throwable throwable) {
            for (ResolverHook resolverHook : linkedHashMap.keySet()) {
                resolverHook.end();
            }
            throw throwable;
        }
        return linkedHashMap;
    }

    private void endResolverHooks(HashMap<ResolverHook, ServiceReferenceImpl<ResolverHookFactory>> hashMap) throws BundleException {
        if (hashMap == null) {
            return;
        }
        Throwable throwable = null;
        for (Map.Entry<ResolverHook, ServiceReferenceImpl<ResolverHookFactory>> entry : hashMap.entrySet()) {
            if (entry.getValue().service == null) {
                throwable = new BundleException("Something unregistered a hook that was in use.", 12);
                continue;
            }
            try {
                entry.getKey().end();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
        }
        if (throwable != null) {
            throw new BundleException("Error", 12, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<BundleCapability> resolveDynamic(BundleRevision bundleRevision, String string, String string2, BundleRequirement bundleRequirement, boolean bl) {
        String string3;
        List<Capability> list;
        block14: {
            list = null;
            if (this.resolver.hooks == null) {
                this.resolver.hooks = this.getResolverHooks(Arrays.asList(bundleRevision));
            }
            string3 = bundleRequirement.getDirectives().get("filter");
            if (bl) {
                list = this.capabilityRegistry.getAll("osgi.wiring.package");
            } else if (string3 == null) {
                list = this.capabilityRegistry.getByValue("osgi.wiring.package", string2);
            } else {
                try {
                    list = RFC1960Filter.filterWithIndex(bundleRequirement, string3, this.capabilityRegistry);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    invalidSyntaxException.printStackTrace();
                }
            }
            if (list != null && !list.isEmpty()) break block14;
            this.endResolverHooks(this.resolver.hooks);
            List<BundleCapability> list2 = null;
            Object var13_13 = null;
            this.resolver.hooks = null;
            return list2;
        }
        try {
            this.filterCandidates(this.resolver.hooks.keySet(), bundleRequirement, list);
            ArrayList<BundleCapability> arrayList = new ArrayList<BundleCapability>();
            for (Capability capability : list) {
                String string4 = (String)capability.getAttributes().get("osgi.wiring.package");
                assert (string4 != null);
                if (bl && RFC1960Filter.stringCompare(string.toCharArray(), 0, string4.toCharArray(), 0) != 0 || !(capability instanceof BundleCapability) || !Concierge.matches0("osgi.wiring.package", bundleRequirement, capability, string3) || ((BundleCapability)capability).getRevision().getBundle().getState() == 2 && !this.resolve(Collections.singletonList(((BundleCapability)capability).getRevision()), false)) continue;
                arrayList.add((BundleCapability)capability);
            }
            this.endResolverHooks(this.resolver.hooks);
            Collections.sort(arrayList, EXPORT_ORDER);
            ArrayList<BundleCapability> arrayList2 = arrayList;
            Object var13_14 = null;
            this.resolver.hooks = null;
            return arrayList2;
        }
        catch (Throwable throwable) {
            try {
                List<BundleCapability> list3 = null;
                Object var13_15 = null;
                this.resolver.hooks = null;
                return list3;
            }
            catch (Throwable throwable2) {
                Object var13_16 = null;
                this.resolver.hooks = null;
                throw throwable2;
            }
        }
    }

    protected void filterCandidates(Collection<ResolverHook> collection, BundleRequirement bundleRequirement, Collection<Capability> collection2) {
        ConciergeCollections.MultiMap<BundleRevision, BundleCapability> multiMap = new ConciergeCollections.MultiMap<BundleRevision, BundleCapability>();
        Object object = collection2.iterator();
        while (object.hasNext()) {
            Capability object2 = object.next();
            Resource resource = object2.getResource();
            if (!(resource instanceof BundleRevision)) continue;
            multiMap.insert((BundleRevision)object2.getResource(), (BundleCapability)object2);
            object.remove();
        }
        for (ResolverHook resolverHook : collection) {
            resolverHook.filterResolvable(multiMap.keySet());
        }
        object = new ConciergeCollections.RemoveOnlyList(multiMap.getAllValues());
        for (ResolverHook resolverHook : collection) {
            resolverHook.filterMatches(bundleRequirement, (Collection<BundleCapability>)object);
        }
        collection2.addAll((Collection<Capability>)object);
    }

    protected void filterResources(Collection<ResolverHook> collection, Collection<Resource> collection2, Collection<Resource> collection3) {
        ArrayList<BundleRevision> arrayList = new ArrayList<BundleRevision>();
        collection3.addAll(collection2);
        Object object = collection2.iterator();
        while (object.hasNext()) {
            Resource resource = object.next();
            if (!(resource instanceof BundleRevision)) continue;
            arrayList.add((BundleRevision)resource);
            object.remove();
        }
        object = new ConciergeCollections.RemoveOnlyList(arrayList);
        for (ResolverHook resolverHook : this.resolver.hooks.keySet()) {
            resolverHook.filterResolvable((Collection<BundleRevision>)object);
        }
        collection2.addAll((Collection<Resource>)object);
        collection3.removeAll((Collection<?>)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized boolean resolve(final Collection<BundleRevision> collection, boolean bl) throws BundleException {
        boolean bl2;
        boolean bl3;
        block35: {
            boolean bl4;
            block34: {
                if (this.inResolve) {
                    throw new IllegalStateException("nested resolve call");
                }
                bl3 = false;
                try {
                    try {
                        this.inResolve = true;
                        final ConciergeCollections.MultiMap multiMap = new ConciergeCollections.MultiMap();
                        if (this.resolver.hooks == null) {
                            this.resolver.hooks = this.getResolverHooks(collection);
                            bl3 = true;
                        }
                        ConciergeCollections.MultiMap<Resource, Wire> multiMap2 = new ConciergeCollections.MultiMap<Resource, Wire>();
                        ArrayList<Requirement> arrayList = new ArrayList<Requirement>();
                        ArrayList<Resource> arrayList2 = new ArrayList<Resource>();
                        this.resolver.resolve0(new ResolveContext(){

                            @Override
                            public Collection<Resource> getMandatoryResources() {
                                return new ArrayList<Resource>(collection);
                            }

                            @Override
                            public Collection<Resource> getOptionalResources() {
                                return Collections.emptyList();
                            }

                            @Override
                            public List<Capability> findProviders(Requirement requirement) {
                                List<Capability> list;
                                String string = requirement.getDirectives().get("filter");
                                if (string == null) {
                                    list = Concierge.this.capabilityRegistry.getAll(requirement.getNamespace());
                                } else {
                                    try {
                                        list = RFC1960Filter.filterWithIndex(requirement, string, Concierge.this.capabilityRegistry);
                                    }
                                    catch (InvalidSyntaxException invalidSyntaxException) {
                                        invalidSyntaxException.printStackTrace();
                                        return Collections.emptyList();
                                    }
                                }
                                this.sortProviders(list, requirement.getNamespace());
                                return list;
                            }

                            private void sortProviders(List<Capability> list, String string) {
                                if (list.isEmpty()) {
                                    return;
                                }
                                if ("osgi.wiring.package".equals(string)) {
                                    Collections.sort(list, EXPORT_ORDER);
                                }
                                if ("osgi.wiring.bundle".equals(string)) {
                                    Collections.sort(list, BUNDLE_VERSION);
                                }
                            }

                            @Override
                            public int insertHostedCapability(List<Capability> list, HostedCapability hostedCapability) {
                                Concierge.this.publishCapabilities(Collections.singletonList(hostedCapability));
                                list.add(hostedCapability);
                                multiMap.insert(hostedCapability.getResource(), hostedCapability);
                                if ("osgi.wiring.package".equals(hostedCapability.getNamespace())) {
                                    Collections.sort(list, EXPORT_ORDER);
                                    return list.indexOf(hostedCapability);
                                }
                                return list.size();
                            }

                            @Override
                            public boolean isEffective(Requirement requirement) {
                                String string = requirement.getDirectives().get("effective");
                                return string == null || string.equals("resolve");
                            }

                            @Override
                            public Map<Resource, Wiring> getWirings() {
                                return Concierge.this.wirings;
                            }
                        }, multiMap2, arrayList, arrayList2, false);
                        if (this.LOG_ENABLED && this.DEBUG_RESOLVER) {
                            this.logger.log(4, "Solution: " + multiMap2);
                        }
                        for (Resource resource : multiMap2.keySet()) {
                            Object object;
                            Comparable<BundleImpl.Revision> comparable;
                            Object object2 = multiMap2.get(resource);
                            if (resource instanceof BundleImpl.Revision) {
                                Resources.ConciergeBundleWiring conciergeBundleWiring;
                                Object object3;
                                Object object4;
                                comparable = (BundleImpl.Revision)resource;
                                boolean bl5 = ((BundleImpl.Revision)comparable).isFragment();
                                if (bl5) {
                                    boolean bl6 = false;
                                    object = object2.iterator();
                                    while (object.hasNext()) {
                                        object4 = (Wire)object.next();
                                        if (!"osgi.wiring.host".equals(object4.getRequirement().getNamespace())) continue;
                                        if (object4.getProvider() instanceof BundleImpl.Revision) {
                                            object3 = (BundleImpl.Revision)object4.getProvider();
                                            try {
                                                ((BundleImpl.Revision)object3).attachFragment((BundleImpl.Revision)comparable);
                                                bl6 = true;
                                            }
                                            catch (BundleException bundleException) {
                                                bundleException.printStackTrace();
                                            }
                                            continue;
                                        }
                                        if (!this.extensionBundles.contains(((BundleImpl.Revision)comparable).getBundle())) continue;
                                        bl6 = true;
                                    }
                                    if (!bl6) continue;
                                    ((BundleImpl.Revision)comparable).markResolved();
                                }
                                if (((BundleImpl.Revision)comparable).getWiring() == null) {
                                    conciergeBundleWiring = new Resources.ConciergeBundleWiring((BundleRevision)((Object)comparable), (List<Wire>)object2);
                                    ((BundleImpl.Revision)comparable).setWiring(conciergeBundleWiring);
                                } else {
                                    conciergeBundleWiring = ((BundleImpl.Revision)comparable).addAdditionalWires((List<Wire>)object2);
                                }
                                if (!bl5) {
                                    object = multiMap.lookup(resource);
                                    object4 = object.iterator();
                                    while (object4.hasNext()) {
                                        object3 = (HostedCapability)object4.next();
                                        conciergeBundleWiring.addCapability((HostedCapability)object3);
                                        ((BundleImpl.Revision)comparable).addHostedCapability((HostedCapability)object3);
                                    }
                                }
                                this.wirings.put(resource, conciergeBundleWiring);
                                continue;
                            }
                            comparable = (Concierge)resource;
                            Resources.ConciergeBundleWiring conciergeBundleWiring = (Resources.ConciergeBundleWiring)this.wirings.get(resource);
                            if (conciergeBundleWiring == null) {
                                conciergeBundleWiring = new Resources.ConciergeBundleWiring((BundleRevision)((Object)comparable), (List<Wire>)object2);
                                this.wirings.put((Resource)((Object)comparable), conciergeBundleWiring);
                                continue;
                            }
                            Iterator iterator = object2.iterator();
                            while (iterator.hasNext()) {
                                object = (Wire)iterator.next();
                                conciergeBundleWiring.addWire((BundleWire)object);
                            }
                        }
                        if (arrayList.isEmpty() && arrayList2.isEmpty()) {
                            bl4 = true;
                            Object var19_25 = null;
                            break block34;
                        }
                        if (bl) {
                            throw new BundleException("Resolution failed " + arrayList, 4);
                        }
                        if (this.LOG_ENABLED && this.DEBUG_RESOLVER) {
                            this.logger.log(4, "Unresolved Requirements: " + arrayList);
                        }
                        bl2 = false;
                        break block35;
                    }
                    catch (BundleException bundleException) {
                        throw bundleException;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        throw new BundleException("Resolve Error", 12, throwable);
                    }
                }
                catch (Throwable throwable) {
                    Object var19_27 = null;
                    try {
                        this.endResolverHooks(this.resolver.hooks);
                        Object var21_32 = null;
                        if (bl3) {
                            this.resolver.hooks = null;
                        }
                        this.inResolve = false;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        Object var21_33 = null;
                        if (bl3) {
                            this.resolver.hooks = null;
                        }
                        this.inResolve = false;
                        throw throwable2;
                    }
                }
            }
            try {}
            catch (Throwable throwable) {
                Object var21_29 = null;
                if (bl3) {
                    this.resolver.hooks = null;
                }
                this.inResolve = false;
                throw throwable;
            }
            this.endResolverHooks(this.resolver.hooks);
            Object var21_28 = null;
            if (bl3) {
                this.resolver.hooks = null;
            }
            this.inResolve = false;
            return bl4;
        }
        Object var19_26 = null;
        try {}
        catch (Throwable throwable) {
            Object var21_31 = null;
            if (bl3) {
                this.resolver.hooks = null;
            }
            this.inResolve = false;
            throw throwable;
        }
        this.endResolverHooks(this.resolver.hooks);
        Object var21_30 = null;
        if (bl3) {
            this.resolver.hooks = null;
        }
        this.inResolve = false;
        return bl2;
    }

    @Override
    public Collection<Bundle> getRemovalPendingBundles() {
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        block0: for (AbstractBundle abstractBundle : this.bundles) {
            if (!(abstractBundle instanceof BundleImpl)) continue;
            List<BundleRevision> list = abstractBundle.getRevisions();
            for (BundleRevision bundleRevision : list) {
                BundleWiring bundleWiring = bundleRevision.getWiring();
                if (bundleWiring == null || bundleWiring.isCurrent() || !bundleWiring.isInUse()) continue;
                arrayList.add(abstractBundle);
                continue block0;
            }
        }
        return arrayList;
    }

    @Override
    public Collection<Bundle> getDependencyClosure(Collection<Bundle> collection) {
        return this.getDependencies(collection, false);
    }

    private Collection<Bundle> getDependencies(Collection<Bundle> collection, boolean bl) {
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(collection);
        HashSet<Bundle> hashSet = new HashSet<Bundle>();
        while (!arrayList.isEmpty()) {
            Bundle bundle = arrayList.remove(0);
            if (bundle == this) {
                hashSet.add(bundle);
                continue;
            }
            if (hashSet.contains(bundle)) continue;
            if (!(bundle instanceof BundleImpl)) {
                throw new IllegalArgumentException("Bundles were not created by this framework instance " + bundle.getClass().getName());
            }
            hashSet.add(bundle);
            BundleImpl bundleImpl = (BundleImpl)bundle;
            for (BundleRevision bundleRevision : bundleImpl.revisions) {
                BundleWiring bundleWiring = bundleRevision.getWiring();
                if (bundleWiring == null) continue;
                for (BundleRevision bundleRevision2 : ((Resources.ConciergeBundleWiring)bundleWiring).inUseSet) {
                    arrayList.add(bundleRevision2.getBundle());
                }
                List<BundleWire> list = bundleWiring.getRequiredWires("osgi.wiring.host");
                if (list == null) continue;
                for (BundleWire bundleWire : list) {
                    arrayList.add(bundleWire.getProvider().getBundle());
                }
            }
        }
        return hashSet;
    }

    static boolean matches(Requirement requirement, Capability capability) {
        String string;
        String string2 = requirement.getNamespace();
        if (!string2.equals(string = capability.getNamespace())) {
            return false;
        }
        String string3 = requirement.getDirectives().get("filter");
        try {
            if (string3 != null && !RFC1960Filter.fromString(string3).matches(capability.getAttributes())) {
                return false;
            }
            return Concierge.matches0(string, requirement, capability, string3);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            invalidSyntaxException.printStackTrace();
            return false;
        }
    }

    static boolean matches0(String string, Requirement requirement, Capability capability, String string2) {
        if (!string.startsWith("osgi.wiring.")) {
            return true;
        }
        String string3 = capability.getDirectives().get("mandatory");
        if (string3 == null) {
            return true;
        }
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(Utils.splitString(Utils.unQuote(string3).toLowerCase(), ',')));
        Matcher matcher = FILTER_ASSERT_MATCHER.matcher(string2 == null ? "" : string2);
        while (matcher.find()) {
            hashSet.remove(matcher.group(1));
        }
        return hashSet.isEmpty();
    }

    BundleContextImpl createBundleContext(AbstractBundle abstractBundle) {
        return new BundleContextImpl(abstractBundle);
    }

    List<AbstractBundle> getBundleWithSymbolicName(String string) {
        List<AbstractBundle> list = this.symbolicName_bundles.lookup(string);
        return list;
    }

    void addFragment(BundleImpl.Revision revision) throws BundleException {
        if (revision.isExtensionBundle()) {
            try {
                this.addURL.invoke((Object)this.systemBundleClassLoader, revision.createURL("/", null));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.extensionBundles.add((BundleImpl)revision.getBundle());
        }
        String string = revision.getFragmentHost();
        this.fragmentIndex.insert(string, revision);
    }

    void removeFragment(BundleImpl.Revision revision) {
        this.fragmentIndex.remove(revision.getFragmentHost(), revision);
        String string = revision.getFragmentHost();
        if (string.equals("system.bundle") || string.equals("org.eclipse.concierge")) {
            this.extensionBundles.remove(revision.getBundle());
        }
    }

    List<BundleImpl.Revision> getFragments(BundleRevision bundleRevision) {
        ArrayList<BundleImpl.Revision> arrayList = new ArrayList<BundleImpl.Revision>(this.fragmentIndex.lookup(bundleRevision.getSymbolicName()));
        if (!arrayList.isEmpty()) {
            Capability capability = bundleRevision.getCapabilities("osgi.wiring.host").get(0);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Requirement requirement = ((BundleImpl.Revision)iterator.next()).getRequirements("osgi.wiring.host").get(0);
                if (Concierge.matches(requirement, capability)) continue;
                iterator.remove();
            }
        }
        return arrayList;
    }

    static void deleteDirectory(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                Concierge.deleteDirectory(fileArray[i]);
                continue;
            }
            fileArray[i].delete();
        }
        file.delete();
    }

    void unregisterService(ServiceReference<?> serviceReference) {
        String[] stringArray = (String[])serviceReference.getProperty("objectClass");
        this.serviceRegistry.removeAll((String[])stringArray, serviceReference);
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            List<?> list = this.hooks.get(stringArray[i]);
            if (list == null) continue;
            bl = true;
            list.remove(serviceReference);
        }
        AbstractBundle abstractBundle = (AbstractBundle)serviceReference.getBundle();
        abstractBundle.registeredServices.remove(serviceReference);
        if (abstractBundle.registeredServices.isEmpty()) {
            abstractBundle.registeredServices = null;
        }
        if (!bl) {
            this.notifyServiceListeners(4, serviceReference, null);
        }
        if (this.LOG_ENABLED && this.DEBUG_SERVICES) {
            this.logger.log(3, "Framework: UNREGISTERED SERVICE " + serviceReference);
        }
    }

    void notifyBundleListeners(int n, Bundle bundle) {
        this.notifyBundleListeners(n, bundle, bundle);
    }

    void notifyBundleListeners(int n, Bundle bundle, Bundle bundle2) {
        int n2;
        BundleListener[] bundleListenerArray;
        SynchronousBundleListener[] synchronousBundleListenerArray;
        if (this.syncBundleListeners.isEmpty() && this.bundleListeners.isEmpty()) {
            return;
        }
        BundleEvent bundleEvent = new BundleEvent(n, bundle, bundle2);
        if (!this.bundleEventHooks.isEmpty()) {
            Object object;
            ArrayList<SynchronousBundleListener> arrayList = new ArrayList<SynchronousBundleListener>(this.syncBundleListeners);
            ArrayList<BundleListener> arrayList2 = new ArrayList<BundleListener>(this.bundleListeners);
            ConciergeCollections.DeltaTrackingRemoveOnlyList<BundleContext> deltaTrackingRemoveOnlyList = new ConciergeCollections.DeltaTrackingRemoveOnlyList<BundleContext>((Collection<BundleContext>)this.bundleListenerMap.keySet());
            for (ServiceReferenceImpl<EventHook> serviceReferenceImpl : this.bundleEventHooks) {
                object = serviceReferenceImpl.getService(this);
                if (object != null) {
                    try {
                        object.event(bundleEvent, deltaTrackingRemoveOnlyList);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                serviceReferenceImpl.ungetService(this);
            }
            for (BundleContext bundleContext : deltaTrackingRemoveOnlyList.getRemoved()) {
                object = this.bundleListenerMap.get(bundleContext).iterator();
                while (object.hasNext()) {
                    BundleListener bundleListener = (BundleListener)object.next();
                    arrayList.remove(bundleListener);
                    arrayList2.remove(bundleListener);
                }
            }
            synchronousBundleListenerArray = arrayList.toArray(new SynchronousBundleListener[arrayList.size()]);
            bundleListenerArray = arrayList2.toArray(new BundleListener[arrayList2.size()]);
        } else {
            synchronousBundleListenerArray = this.syncBundleListeners.toArray(new SynchronousBundleListener[this.syncBundleListeners.size()]);
            bundleListenerArray = this.bundleListeners.toArray(new BundleListener[this.bundleListeners.size()]);
        }
        for (n2 = 0; n2 < synchronousBundleListenerArray.length; ++n2) {
            synchronousBundleListenerArray[n2].bundleChanged(bundleEvent);
        }
        n2 = bundleEvent.getType();
        if (this.bundleListeners.isEmpty() || (n2 & 0x380) > 0) {
            return;
        }
        for (int i = 0; i < bundleListenerArray.length; ++i) {
            bundleListenerArray[i].bundleChanged(bundleEvent);
        }
    }

    void notifyFrameworkListeners(int n, Bundle bundle, Throwable throwable) {
        this.notifyFrameworkListeners(this.frameworkListeners.toArray(new FrameworkListener[this.frameworkListeners.size()]), n, bundle, throwable);
    }

    void publishCapabilities(List<? extends Capability> list) {
        for (Capability capability : list) {
            this.capabilityRegistry.add(capability);
        }
    }

    void removeCapabilities(BundleImpl.Revision revision) {
        this.capabilityRegistry.removeAll(revision);
        for (HostedCapability hostedCapability : revision.getHostedCapabilities()) {
            this.capabilityRegistry.remove(hostedCapability);
        }
    }

    void checkForCollision(int n, Bundle bundle, BundleRevision bundleRevision) throws BundleException {
        assert (this.context != null);
        if (bundleRevision == null) {
            throw new IllegalArgumentException("revision==null");
        }
        if (this.collisionPolicy == 1) {
            return;
        }
        Version version = bundleRevision.getVersion();
        ArrayList<AbstractBundle> arrayList = new ArrayList<AbstractBundle>();
        Object object = this.symbolicName_bundles.get(bundleRevision.getSymbolicName());
        if (object == null) {
            return;
        }
        if (version == null) {
            throw new IllegalStateException("version==null");
        }
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            AbstractBundle abstractBundle = (AbstractBundle)object2.next();
            if (!version.equals(abstractBundle.getVersion())) continue;
            arrayList.add(abstractBundle);
        }
        if (n == 2) {
            arrayList.remove(bundleRevision.getBundle());
        }
        if (arrayList.isEmpty()) {
            return;
        }
        if (this.collisionPolicy == -1) {
            throw new BundleException("Bundle with same symbolic name and same version is already installed", 9);
        }
        if (this.collisionPolicy == 0) {
            object2 = new ConciergeCollections.RemoveOnlyList(arrayList);
            for (ServiceReferenceImpl serviceReferenceImpl : this.bundleCollisionHooks) {
                CollisionHook collisionHook = (CollisionHook)serviceReferenceImpl.getService(this);
                if (collisionHook != null) {
                    collisionHook.filterCollisions(n, bundle, (Collection<Bundle>)object2);
                }
                serviceReferenceImpl.ungetService(this);
            }
            if (!((ArrayList)object2).isEmpty()) {
                throw new BundleException("Bundle with same symbolic name and same version is already installed", 9);
            }
        }
    }

    protected void notifyFrameworkListeners(FrameworkListener[] frameworkListenerArray, int n, Bundle bundle, Throwable throwable) {
        if (frameworkListenerArray.length == 0) {
            return;
        }
        final FrameworkEvent frameworkEvent = new FrameworkEvent(n, bundle, throwable);
        for (int i = 0; i < frameworkListenerArray.length; ++i) {
            final FrameworkListener frameworkListener = frameworkListenerArray[i];
            if (this.SECURITY_ENABLED) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        frameworkListener.frameworkEvent(frameworkEvent);
                        return null;
                    }
                });
                continue;
            }
            frameworkListener.frameworkEvent(frameworkEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void notifyServiceListeners(int n, ServiceReference<?> serviceReference, Map<String, ?> map) {
        Object object2;
        ServiceListenerEntry[] serviceListenerEntryArray;
        ServiceEvent serviceEvent;
        if (this.serviceListeners.isEmpty()) {
            return;
        }
        final ServiceEvent serviceEvent2 = new ServiceEvent(n, serviceReference);
        ServiceEvent serviceEvent3 = serviceEvent = n == 2 ? new ServiceEvent(8, serviceReference) : null;
        if (this.serviceEventListenerHooks.isEmpty() && this.serviceEventHooks.isEmpty()) {
            serviceListenerEntryArray = this.serviceListeners.toArray(new ServiceListenerEntry[this.serviceListeners.size()]);
        } else {
            object2 = new ConciergeCollections.MultiMap<BundleContextImpl, ServiceListenerEntry>();
            for (ServiceListenerEntry object4 : this.serviceListeners) {
                ((ConciergeCollections.MultiMap)object2).insert(object4.bundle.context, object4);
            }
            ConciergeCollections.RemoveOnlyMap removeOnlyMap = new ConciergeCollections.RemoveOnlyMap();
            for (BundleContext bundleContext : ((ConciergeCollections.MultiMap)object2).keySet()) {
                ConciergeCollections.RemoveOnlyList removeOnlyList = new ConciergeCollections.RemoveOnlyList(((ConciergeCollections.MultiMap)object2).get(bundleContext));
                removeOnlyMap.put(bundleContext, removeOnlyList);
            }
            removeOnlyMap.seal();
            for (ServiceReferenceImpl<org.osgi.framework.hooks.service.EventHook> serviceReferenceImpl : this.serviceEventHooks) {
                Object var13_35;
                try {
                    try {
                        org.osgi.framework.hooks.service.EventHook eventHook = serviceReferenceImpl.getService(this);
                        eventHook.event(serviceEvent2, removeOnlyMap.keySet());
                    }
                    catch (Throwable throwable) {
                        this.notifyFrameworkListeners(2, this, throwable);
                        var13_35 = null;
                        serviceReferenceImpl.ungetService(this);
                        continue;
                    }
                    var13_35 = null;
                    serviceReferenceImpl.ungetService(this);
                }
                catch (Throwable throwable) {
                    var13_35 = null;
                    serviceReferenceImpl.ungetService(this);
                    throw throwable;
                }
            }
            for (ServiceReferenceImpl<EventListenerHook> serviceReferenceImpl : this.serviceEventListenerHooks) {
                Object var15_38;
                try {
                    try {
                        EventListenerHook eventListenerHook = serviceReferenceImpl.getService(this);
                        eventListenerHook.event(serviceEvent2, removeOnlyMap);
                    }
                    catch (Throwable throwable) {
                        this.notifyFrameworkListeners(2, this, throwable);
                        var15_38 = null;
                        serviceReferenceImpl.ungetService(this);
                        continue;
                    }
                    var15_38 = null;
                    serviceReferenceImpl.ungetService(this);
                }
                catch (Throwable throwable) {
                    var15_38 = null;
                    serviceReferenceImpl.ungetService(this);
                    throw throwable;
                }
            }
            ArrayList<ServiceListenerEntry> arrayList = new ArrayList<ServiceListenerEntry>();
            for (ServiceListenerEntry serviceListenerEntry : this.serviceListeners) {
                Collection collection = (Collection)removeOnlyMap.get(serviceListenerEntry.bundle.context);
                if (collection == null || !collection.contains(serviceListenerEntry)) continue;
                arrayList.add(serviceListenerEntry);
            }
            serviceListenerEntryArray = arrayList.toArray(new ServiceListenerEntry[arrayList.size()]);
        }
        object2 = (ServiceReferenceImpl)serviceReference;
        int i = 0;
        while (i < serviceListenerEntryArray.length) {
            String[] stringArray;
            if (serviceListenerEntryArray[i].listener instanceof AllServiceListener || ((ServiceReferenceImpl)object2).isAssignableTo(serviceListenerEntryArray[i].bundle, stringArray = (String[])serviceReference.getProperty("objectClass"))) {
                if (serviceListenerEntryArray[i].listener instanceof UnfilteredServiceListener || serviceListenerEntryArray[i].filter == null || serviceListenerEntryArray[i].filter.matches(((ServiceReferenceImpl)object2).properties)) {
                    final ServiceListener serviceListener = serviceListenerEntryArray[i].listener;
                    if (this.SECURITY_ENABLED) {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                serviceListener.serviceChanged(serviceEvent2);
                                return null;
                            }
                        });
                    } else {
                        serviceListener.serviceChanged(serviceEvent2);
                    }
                } else if (n == 2 && serviceListenerEntryArray[i].filter.matches(map)) {
                    serviceListenerEntryArray[i].listener.serviceChanged(serviceEvent);
                }
            }
            ++i;
        }
        return;
    }

    void clearBundleTrace(AbstractBundle abstractBundle) {
        ServiceReference<?>[] serviceReferenceArray;
        ServiceReference<?>[] serviceReferenceArray2;
        Object object;
        if (abstractBundle.registeredFrameworkListeners != null) {
            this.frameworkListeners.removeAll(abstractBundle.registeredFrameworkListeners);
            abstractBundle.registeredFrameworkListeners = null;
        }
        if (abstractBundle.registeredServiceListeners != null) {
            this.serviceListeners.removeAll(abstractBundle.registeredServiceListeners);
            abstractBundle.registeredServiceListeners = null;
        }
        if ((object = this.bundleListenerMap.get(abstractBundle.context)) != null) {
            object.removeAll((Collection<?>)object);
            this.syncBundleListeners.removeAll((Collection<?>)object);
            this.bundleListenerMap.remove(abstractBundle.context);
        }
        if ((serviceReferenceArray2 = abstractBundle.getRegisteredServices()) != null) {
            for (int i = 0; i < serviceReferenceArray2.length; ++i) {
                this.unregisterService(serviceReferenceArray2[i]);
                ((ServiceReferenceImpl)serviceReferenceArray2[i]).invalidate();
            }
            abstractBundle.registeredServices = null;
        }
        if ((serviceReferenceArray = abstractBundle.getServicesInUse()) != null) {
            for (int i = 0; i < serviceReferenceArray.length; ++i) {
                ((ServiceReferenceImpl)serviceReferenceArray[i]).ungetService(abstractBundle);
            }
        }
    }

    BundleImpl installNewBundle(BundleContext bundleContext, String string) throws BundleException {
        try {
            String string2 = string.indexOf(":") > -1 ? string : this.BUNDLE_LOCATION + File.separatorChar + string;
            return this.installNewBundle(bundleContext, string2, new URL(string2).openConnection().getInputStream());
        }
        catch (IOException iOException) {
            throw new BundleException("Cannot retrieve bundle from " + string, 11, iOException);
        }
    }

    synchronized BundleImpl installNewBundle(BundleContext bundleContext, String string, InputStream inputStream) throws BundleException {
        AbstractBundle abstractBundle = this.location_bundles.get(string);
        if (abstractBundle != null) {
            Bundle[] bundleArray;
            if (!this.bundleFindHooks.isEmpty() && (bundleArray = this.filterWithBundleHooks(bundleContext, Arrays.asList(abstractBundle))).length == 0) {
                throw new BundleException("Existing bundle rejected by find hooks", 12);
            }
            return (BundleImpl)abstractBundle;
        }
        BundleImpl bundleImpl = new BundleImpl(this, bundleContext, string, this.nextBundleID++, inputStream);
        bundleImpl.install();
        this.notifyBundleListeners(1, bundleImpl, bundleContext.getBundle());
        this.storeMetadata();
        return bundleImpl;
    }

    protected Bundle[] filterWithBundleHooks(BundleContext bundleContext, Collection<Bundle> collection) {
        ConciergeCollections.RemoveOnlyList<Bundle> removeOnlyList = new ConciergeCollections.RemoveOnlyList<Bundle>(collection);
        for (ServiceReferenceImpl<FindHook> serviceReferenceImpl : this.bundleFindHooks) {
            FindHook findHook = serviceReferenceImpl.getService(this);
            if (findHook != null) {
                try {
                    findHook.find(bundleContext, removeOnlyList);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            serviceReferenceImpl.ungetService(this);
        }
        return removeOnlyList.toArray(new Bundle[removeOnlyList.size()]);
    }

    protected <T> T getService(Class<T> clazz, Version version) {
        List<ServiceReference<?>> list = this.serviceRegistry.lookup(clazz.getName());
        for (ServiceReference<?> serviceReference : list) {
            Version version2 = (Version)serviceReference.getProperty("version");
            if (version2 == null || version2.compareTo(version) != 0) continue;
            return (T)((ServiceReferenceImpl)serviceReference).service;
        }
        return null;
    }

    @Override
    protected final boolean isSecurityEnabled() {
        return this.SECURITY_ENABLED;
    }

    boolean hasWeavingHooks() {
        return !this.weavingHooks.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void callWeavingHooks(BundleImpl.Revision.WovenClassImpl wovenClassImpl) {
        Collections.sort(this.weavingHooks, Collections.reverseOrder());
        ArrayList<ServiceReferenceImpl<WeavingHook>> arrayList = new ArrayList<ServiceReferenceImpl<WeavingHook>>();
        arrayList.addAll(this.weavingHooks);
        Iterator iterator = arrayList.iterator();
        while (true) {
            Object var9_6;
            if (!iterator.hasNext()) {
                wovenClassImpl.setComplete();
                return;
            }
            ServiceReferenceImpl serviceReferenceImpl = (ServiceReferenceImpl)iterator.next();
            WeavingHook weavingHook = (WeavingHook)serviceReferenceImpl.getService(this);
            try {
                try {
                    weavingHook.weave(wovenClassImpl);
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof WeavingException)) {
                        this.weavingHooks.remove(serviceReferenceImpl);
                    }
                    this.notifyFrameworkListeners(2, serviceReferenceImpl.bundle, throwable);
                    wovenClassImpl.setComplete();
                    ClassFormatError classFormatError = new ClassFormatError("Error while invoking weaving hook");
                    classFormatError.initCause(throwable);
                    throw classFormatError;
                }
                var9_6 = null;
                serviceReferenceImpl.ungetService(this);
            }
            catch (Throwable throwable) {
                var9_6 = null;
                serviceReferenceImpl.ungetService(this);
                throw throwable;
            }
        }
    }

    @Override
    public void start(BundleContext bundleContext) throws Exception {
        bundleContext.registerService(Resolver.class, this.resolver, null);
    }

    @Override
    public void stop(BundleContext bundleContext) throws Exception {
    }

    String[] getLibraryName(String string) {
        if (this.libraryExtensions == null) {
            return new String[]{System.mapLibraryName(string)};
        }
        String[] stringArray = new String[this.libraryExtensions.length + 1];
        stringArray[0] = System.mapLibraryName(string);
        for (int i = 0; i < this.libraryExtensions.length; ++i) {
            stringArray[i + 1] = string + "." + this.libraryExtensions[i];
        }
        return stringArray;
    }

    void execPermission(File file) {
        if (this.execPermission == null) {
            return;
        }
        String string = this.execPermissionPattern.matcher(this.execPermission).replaceAll(Matcher.quoteReplacement(file.getAbsolutePath()));
        try {
            Runtime.getRuntime().exec(string).waitFor();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static {
        SUPPORTED_EE = new HashSet();
        VERSION_COMPARATOR = new Comparator<AbstractBundle>(){

            @Override
            public int compare(AbstractBundle abstractBundle, AbstractBundle abstractBundle2) {
                return abstractBundle2.getVersion().compareTo(abstractBundle.getVersion());
            }
        };
        FILTER_ASSERT_MATCHER = Pattern.compile("\\(([^&\\!|=<>~\\(\\)]*)[=|<=|>=|~=]");
        BUNDLE_VERSION = new Comparator<Capability>(){

            @Override
            public int compare(Capability capability, Capability capability2) {
                Version version = (Version)capability.getAttributes().get("bundle-version");
                Version version2 = (Version)capability2.getAttributes().get("bundle-version");
                return version2.compareTo(version);
            }
        };
        EXPORT_ORDER = new Comparator<Capability>(){

            @Override
            public int compare(Capability capability, Capability capability2) {
                if (!(capability instanceof BundleCapability) || !(capability2 instanceof BundleCapability)) {
                    return 0;
                }
                BundleCapability bundleCapability = (BundleCapability)capability;
                BundleCapability bundleCapability2 = (BundleCapability)capability2;
                int n = bundleCapability.getResource().getWiring() == null ? 0 : 1;
                int n2 = bundleCapability2.getResource().getWiring() == null ? 0 : 1;
                int n3 = n2 - n;
                if (n3 != 0) {
                    return n3;
                }
                Version version = (Version)bundleCapability.getAttributes().get("version");
                Version version2 = (Version)bundleCapability2.getAttributes().get("version");
                n3 = version2.compareTo(version);
                if (n3 != 0) {
                    return n3;
                }
                long l = bundleCapability.getRevision().getBundle().getBundleId();
                long l2 = bundleCapability2.getRevision().getBundle().getBundleId();
                return (int)(l - l2);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class BundleContextImpl
    implements BundleContext {
        boolean isValid = true;
        final AbstractBundle bundle;

        protected BundleContextImpl(AbstractBundle abstractBundle) {
            this.bundle = abstractBundle;
        }

        private void checkValid() {
            if (!this.isValid) {
                throw new IllegalStateException("BundleContext of bundle " + this.bundle + " used after bundle has been stopped or uninstalled.");
            }
        }

        @Override
        public void addBundleListener(BundleListener bundleListener) {
            this.checkValid();
            Object object = Concierge.this.bundleListenerMap.get(this);
            if (object == null || !object.contains(bundleListener)) {
                if (bundleListener instanceof SynchronousBundleListener) {
                    Concierge.this.syncBundleListeners.add((SynchronousBundleListener)bundleListener);
                } else {
                    Concierge.this.bundleListeners.add(bundleListener);
                }
                Concierge.this.bundleListenerMap.insert(this, bundleListener);
            }
        }

        @Override
        public void addFrameworkListener(FrameworkListener frameworkListener) {
            this.checkValid();
            if (this.bundle.registeredFrameworkListeners == null) {
                this.bundle.registeredFrameworkListeners = new ArrayList<FrameworkListener>(1);
            }
            if (!this.bundle.registeredFrameworkListeners.contains(frameworkListener)) {
                Concierge.this.frameworkListeners.add(frameworkListener);
                this.bundle.registeredFrameworkListeners.add(frameworkListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addServiceListener(ServiceListener serviceListener, String string) throws InvalidSyntaxException {
            this.checkValid();
            ServiceListenerEntry serviceListenerEntry = new ServiceListenerEntry(this.bundle, serviceListener, string);
            if (this.bundle.registeredServiceListeners == null) {
                this.bundle.registeredServiceListeners = new ArrayList<ServiceListenerEntry>(1);
            }
            List<ServiceListenerEntry> list = this.bundle.registeredServiceListeners;
            synchronized (list) {
                ServiceListenerEntry serviceListenerEntry2 = this.getRegisteredServiceListener(serviceListener);
                if (serviceListenerEntry2 != null) {
                    this.removeServiceListener(serviceListener);
                }
                this.bundle.registeredServiceListeners.add(serviceListenerEntry);
                Concierge.this.serviceListeners.add(serviceListenerEntry);
            }
            this.informListenerHooks(Concierge.this.serviceListenerHooks, new ServiceListenerEntry[]{serviceListenerEntry}, true);
        }

        private void informListenerHooks(Collection<ServiceReferenceImpl<ListenerHook>> collection, ServiceListenerEntry[] serviceListenerEntryArray, boolean bl) {
            if (collection == null || collection.isEmpty()) {
                return;
            }
            if (!bl) {
                for (ServiceListenerEntry serviceListenerEntry : serviceListenerEntryArray) {
                    serviceListenerEntry.removed = true;
                }
            }
            ConciergeCollections.RemoveOnlyList<ListenerHook.ListenerInfo> removeOnlyList = new ConciergeCollections.RemoveOnlyList<ListenerHook.ListenerInfo>(Arrays.asList(serviceListenerEntryArray));
            for (ServiceReferenceImpl<ListenerHook> serviceReferenceImpl : collection) {
                ListenerHook listenerHook = this.getService(serviceReferenceImpl);
                try {
                    if (bl) {
                        listenerHook.added(removeOnlyList);
                    } else {
                        listenerHook.removed(removeOnlyList);
                    }
                }
                catch (Throwable throwable) {
                    Concierge.this.notifyFrameworkListeners(2, Concierge.this, throwable);
                }
                this.ungetService(serviceReferenceImpl);
            }
        }

        private ServiceListenerEntry getRegisteredServiceListener(ServiceListener serviceListener) {
            ServiceListenerEntry[] serviceListenerEntryArray = this.bundle.registeredServiceListeners.toArray(new ServiceListenerEntry[this.bundle.registeredServiceListeners.size()]);
            for (int i = 0; i < serviceListenerEntryArray.length; ++i) {
                if (serviceListenerEntryArray[i].bundle != this.bundle || serviceListenerEntryArray[i].listener != serviceListener) continue;
                return serviceListenerEntryArray[i];
            }
            return null;
        }

        @Override
        public void addServiceListener(ServiceListener serviceListener) {
            this.checkValid();
            try {
                this.addServiceListener(serviceListener, null);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }

        @Override
        public Filter createFilter(String string) throws InvalidSyntaxException {
            if (string == null) {
                throw new NullPointerException();
            }
            return RFC1960Filter.fromString(string);
        }

        @Override
        public Bundle getBundle() {
            return this.bundle;
        }

        @Override
        public Bundle getBundle(long l) {
            this.checkValid();
            Bundle bundle = Concierge.this.bundleID_bundles.get(new Long(l));
            if (bundle == null || Concierge.this.bundleFindHooks.isEmpty()) {
                return bundle;
            }
            Bundle[] bundleArray = Concierge.this.filterWithBundleHooks(this, Arrays.asList(bundle));
            return bundleArray.length == 0 ? null : bundleArray[0];
        }

        @Override
        public Bundle[] getBundles() {
            this.checkValid();
            ArrayList<Bundle> arrayList = new ArrayList<Bundle>(Concierge.this.bundles);
            arrayList.add(0, Concierge.this);
            if (Concierge.this.bundleFindHooks.isEmpty()) {
                return arrayList.toArray(new Bundle[arrayList.size()]);
            }
            return Concierge.this.filterWithBundleHooks(this, arrayList);
        }

        @Override
        public File getDataFile(String string) {
            this.checkValid();
            String string2 = this.bundle == Concierge.this ? Concierge.this.STORAGE_LOCATION : this.bundle.storageLocation;
            try {
                File file = new File(string2 + "/data", string);
                if (string.isEmpty()) {
                    file.mkdirs();
                } else {
                    file.getParentFile().mkdirs();
                }
                return file;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        @Override
        public String getProperty(String string) {
            return Concierge.this.properties.getProperty(string);
        }

        @Override
        public <S> S getService(ServiceReference<S> serviceReference) {
            this.checkValid();
            if (serviceReference == null) {
                throw new NullPointerException("Null service reference.");
            }
            if (Concierge.this.SECURITY_ENABLED) {
                String[] stringArray = (String[])serviceReference.getProperty("objectClass");
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        AccessController.checkPermission(new ServicePermission(stringArray[i], "get"));
                        return ((ServiceReferenceImpl)serviceReference).getService(this.bundle);
                    }
                    catch (SecurityException securityException) {
                        continue;
                    }
                }
                throw new SecurityException("Caller does not have permissions for getting service from " + serviceReference);
            }
            return ((ServiceReferenceImpl)serviceReference).getService(this.bundle);
        }

        @Override
        public ServiceReference<?>[] getAllServiceReferences(String string, String string2) throws InvalidSyntaxException {
            return this.getServiceReferences(string, string2, true);
        }

        @Override
        public ServiceReference<?>[] getServiceReferences(String string, String string2) throws InvalidSyntaxException {
            return this.getServiceReferences(string, string2, false);
        }

        private final ServiceReference<?>[] getServiceReferences(String string, String string2, boolean bl) throws InvalidSyntaxException {
            Object object;
            this.checkValid();
            Filter filter = RFC1960Filter.fromString(string2);
            Object object2 = string == null ? Concierge.this.serviceRegistry.getAllValues() : Concierge.this.serviceRegistry.get(string);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (object2 != null) {
                object = object2.toArray(new ServiceReferenceImpl[object2.size()]);
                for (int i = 0; i < ((ServiceReferenceImpl[])object).length; ++i) {
                    if (!filter.match(object[i]) || !bl && !((ServiceReferenceImpl)object[i]).isAssignableTo(this.bundle, (String[])((ServiceReferenceImpl)object[i]).getProperty("objectClass"))) continue;
                    arrayList.add(object[i]);
                }
            }
            if (!Concierge.this.serviceFindHooks.isEmpty()) {
                object = new ConciergeCollections.RemoveOnlyList(arrayList);
                for (ServiceReferenceImpl<org.osgi.framework.hooks.service.FindHook> serviceReferenceImpl : Concierge.this.serviceFindHooks) {
                    org.osgi.framework.hooks.service.FindHook findHook = this.getService(serviceReferenceImpl);
                    try {
                        findHook.find(this, string, string2, bl, (Collection<ServiceReference<?>>)object);
                    }
                    catch (Throwable throwable) {
                        Concierge.this.notifyFrameworkListeners(2, Concierge.this, throwable);
                    }
                    this.ungetService(serviceReferenceImpl);
                }
                return object.size() == 0 ? null : object.toArray(new ServiceReference[object.size()]);
            }
            if (Concierge.this.LOG_ENABLED && Concierge.this.DEBUG_SERVICES) {
                Concierge.this.logger.log(3, "Framework: REQUESTED SERVICES " + (string == null ? "(no class)" : string) + " " + (string2 == null ? "(no filter)" : "filter=" + string2));
                Concierge.this.logger.log(3, "\tRETURNED " + arrayList);
            }
            return arrayList.size() == 0 ? null : arrayList.toArray(new ServiceReference[arrayList.size()]);
        }

        @Override
        public ServiceReference<?> getServiceReference(String string) {
            this.checkValid();
            ServiceReference<?> serviceReference = null;
            int n = -1;
            long l = Long.MAX_VALUE;
            ServiceReference<?>[] serviceReferenceArray = null;
            try {
                serviceReferenceArray = this.getServiceReferences(string, null, true);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
            if (serviceReferenceArray == null) {
                return null;
            }
            ServiceReference<?>[] serviceReferenceArray2 = serviceReferenceArray;
            for (int i = 0; i < serviceReferenceArray2.length; ++i) {
                Integer n2 = (Integer)serviceReferenceArray2[i].getProperty("service.ranking");
                int n3 = n2 != null ? n2 : 0;
                long l2 = (Long)serviceReferenceArray2[i].getProperty("service.id");
                if (n3 <= n && (n3 != n || l2 >= l)) continue;
                serviceReference = serviceReferenceArray2[i];
                n = n3;
                l = l2;
            }
            if (Concierge.this.LOG_ENABLED && Concierge.this.DEBUG_SERVICES) {
                Concierge.this.logger.log(3, "Framework: REQUESTED SERVICE " + string);
                Concierge.this.logger.log(3, "\tRETURNED " + serviceReference);
            }
            return serviceReference;
        }

        @Override
        public Bundle installBundle(String string) throws BundleException {
            if (string == null) {
                throw new IllegalArgumentException("Location must not be null");
            }
            this.checkValid();
            return Concierge.this.installNewBundle(this, string);
        }

        @Override
        public Bundle installBundle(String string, InputStream inputStream) throws BundleException {
            if (string == null) {
                throw new IllegalArgumentException("Location must not be null");
            }
            this.checkValid();
            return Concierge.this.installNewBundle(this, string, inputStream);
        }

        @Override
        public ServiceRegistration<?> registerService(String[] stringArray, Object object, Dictionary<String, ?> dictionary) {
            this.checkValid();
            if (object == null) {
                throw new IllegalArgumentException("Cannot register a null service");
            }
            if (Concierge.this.SECURITY_ENABLED) {
                for (int i = 0; i < stringArray.length; ++i) {
                    AccessController.checkPermission(new ServicePermission(stringArray[i], "register"));
                }
            }
            ServiceReferenceImpl<Object> serviceReferenceImpl = new ServiceReferenceImpl<Object>(Concierge.this, this.bundle, object, dictionary, stringArray);
            if (this.bundle.registeredServices == null) {
                this.bundle.registeredServices = new ArrayList(1);
            }
            this.bundle.registeredServices.add(serviceReferenceImpl);
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                bl = this.checkHook(string, serviceReferenceImpl, true);
                Concierge.this.serviceRegistry.insert(string, serviceReferenceImpl);
            }
            if (Concierge.this.LOG_ENABLED && Concierge.this.DEBUG_SERVICES) {
                Concierge.this.logger.log(3, "Framework: REGISTERED SERVICE " + stringArray[0]);
            }
            if (!bl) {
                Concierge.this.notifyServiceListeners(1, serviceReferenceImpl, null);
            }
            return serviceReferenceImpl.registration;
        }

        private boolean checkHook(String string, ServiceReference<?> serviceReference, boolean bl) {
            List<?> list = Concierge.this.hooks.get(string);
            if (list == null) {
                return false;
            }
            if (bl) {
                list.add(serviceReference);
                Collections.sort(list, Collections.reverseOrder());
            }
            if (bl && list == Concierge.this.serviceListenerHooks) {
                ServiceReferenceImpl serviceReferenceImpl = (ServiceReferenceImpl)serviceReference;
                if (Concierge.this.serviceListeners != null) {
                    try {
                        this.informListenerHooks(Collections.singletonList(serviceReferenceImpl), Concierge.this.serviceListeners.toArray(new ServiceListenerEntry[Concierge.this.serviceListeners.size()]), true);
                    }
                    catch (Throwable throwable) {
                        Concierge.this.notifyFrameworkListeners(2, serviceReference.getBundle(), throwable);
                    }
                }
            }
            return true;
        }

        @Override
        public ServiceRegistration<?> registerService(String string, Object object, Dictionary<String, ?> dictionary) {
            return this.registerService(new String[]{string}, object, dictionary);
        }

        @Override
        public void removeBundleListener(BundleListener bundleListener) {
            this.checkValid();
            if (this.bundle == Concierge.this) {
                return;
            }
            (bundleListener instanceof SynchronousBundleListener ? Concierge.this.syncBundleListeners : Concierge.this.bundleListeners).remove(bundleListener);
            Concierge.this.bundleListenerMap.remove(this, bundleListener);
        }

        @Override
        public void removeFrameworkListener(FrameworkListener frameworkListener) {
            this.checkValid();
            if (this.bundle == Concierge.this) {
                return;
            }
            AbstractBundle abstractBundle = this.bundle;
            Concierge.this.frameworkListeners.remove(frameworkListener);
            if (abstractBundle.registeredFrameworkListeners != null) {
                abstractBundle.registeredFrameworkListeners.remove(frameworkListener);
                if (abstractBundle.registeredFrameworkListeners.isEmpty()) {
                    abstractBundle.registeredFrameworkListeners = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeServiceListener(ServiceListener serviceListener) {
            ServiceListenerEntry serviceListenerEntry;
            this.checkValid();
            List<ServiceListenerEntry> list = this.bundle.registeredServiceListeners;
            synchronized (list) {
                serviceListenerEntry = this.getRegisteredServiceListener(serviceListener);
                if (serviceListenerEntry == null) {
                    return;
                }
                serviceListenerEntry.removed = true;
                Concierge.this.serviceListeners.remove(serviceListenerEntry);
                this.bundle.registeredServiceListeners.remove(serviceListenerEntry);
                if (this.bundle.registeredServiceListeners.isEmpty()) {
                    this.bundle.registeredServiceListeners = null;
                }
            }
            this.informListenerHooks(Concierge.this.serviceListenerHooks, new ServiceListenerEntry[]{serviceListenerEntry}, false);
        }

        @Override
        public synchronized boolean ungetService(ServiceReference<?> serviceReference) {
            this.checkValid();
            return ((ServiceReferenceImpl)serviceReference).ungetService(this.bundle);
        }

        @Override
        public <S> ServiceRegistration<S> registerService(Class<S> clazz, S s, Dictionary<String, ?> dictionary) {
            return this.registerService(clazz.getName(), s, dictionary);
        }

        @Override
        public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
            return this.getServiceReference(clazz == null ? null : clazz.getName());
        }

        @Override
        public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String string) throws InvalidSyntaxException {
            ServiceReference<?>[] serviceReferenceArray = this.getServiceReferences(clazz.getName(), string);
            if (serviceReferenceArray == null) {
                return Collections.EMPTY_LIST;
            }
            return Arrays.asList(serviceReferenceArray);
        }

        @Override
        public Bundle getBundle(String string) {
            return Concierge.this.location_bundles.get(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CapabilityRegistry {
        private final ConciergeCollections.MultiMap<String, Capability> capabilities = new ConciergeCollections.MultiMap();
        private final HashMap<String, ConciergeCollections.MultiMap<String, Capability>> defaultAttributeIndex = new HashMap();

        CapabilityRegistry() {
        }

        void add(Capability capability) {
            String string = capability.getNamespace();
            this.capabilities.insert(string, capability);
            Object object = capability.getAttributes().get(string);
            if (object instanceof String) {
                ConciergeCollections.MultiMap<String, Capability> multiMap = this.defaultAttributeIndex.get(string);
                if (multiMap == null) {
                    multiMap = new ConciergeCollections.MultiMap();
                    this.defaultAttributeIndex.put(string, multiMap);
                }
                multiMap.insert((String)object, capability);
            }
        }

        void addAll(Resource resource) {
            for (Capability capability : resource.getCapabilities(null)) {
                this.add(capability);
            }
        }

        boolean remove(Capability capability) {
            String string = capability.getNamespace();
            this.capabilities.remove(string, capability);
            Object object = capability.getAttributes().get(string);
            ConciergeCollections.MultiMap<String, Capability> multiMap = this.defaultAttributeIndex.get(string);
            if (multiMap == null) {
                return false;
            }
            if (object != null && object instanceof String) {
                boolean bl = multiMap.remove(object, capability);
                if (bl && multiMap.isEmpty()) {
                    this.defaultAttributeIndex.remove(string);
                }
                return bl;
            }
            return false;
        }

        void removeAll(Resource resource) {
            for (Capability capability : resource.getCapabilities(null)) {
                this.remove(capability);
            }
        }

        public List<Capability> getByValue(String string, String string2) {
            ConciergeCollections.MultiMap<String, Capability> multiMap = this.defaultAttributeIndex.get(string);
            Object object = multiMap.get(string2);
            return object == null ? Collections.emptyList() : new ArrayList(object);
        }

        public List<Capability> getByKey(String string, String string2) {
            ConciergeCollections.MultiMap<String, Capability> multiMap = this.defaultAttributeIndex.get(string);
            return multiMap == null ? Collections.emptyList() : multiMap.get(string2);
        }

        public List<Capability> getAll(String string) {
            Object object = this.capabilities.get(string);
            return object == null ? Collections.emptyList() : new ArrayList(object);
        }

        public String toString() {
            return this.capabilities.toString();
        }
    }

    protected static class ConciergeURLStreamHandlerFactory
    implements URLStreamHandlerFactory {
        Concierge frameworkInstance = null;

        protected ConciergeURLStreamHandlerFactory() {
        }

        public void setConcierge(Concierge concierge) {
            this.frameworkInstance = concierge;
        }

        public URLStreamHandler createURLStreamHandler(String string) {
            if ("bundle".equals(string)) {
                return new URLStreamHandler(){

                    protected URLConnection openConnection(final URL uRL) throws IOException {
                        try {
                            String string = uRL.getHost();
                            String[] stringArray = Utils.splitString(string, '.');
                            Long l = Long.parseLong(stringArray[0]);
                            final int n = Integer.parseInt(stringArray[1]);
                            if (ConciergeURLStreamHandlerFactory.this.frameworkInstance == null) {
                                throw new IllegalStateException("ConciergeURLStreamHandlerFactory is not linked to a Concierge framework");
                            }
                            final BundleImpl bundleImpl = (BundleImpl)ConciergeURLStreamHandlerFactory.this.frameworkInstance.bundleID_bundles.get(l);
                            if (bundleImpl == null) {
                                throw new IllegalStateException("Bundle for URL " + uRL + " can not be found");
                            }
                            return new URLConnection(uRL){
                                private InputStream inputStream;
                                private boolean isConnected;

                                public void connect() throws IOException {
                                    this.inputStream = bundleImpl.getURLResource(uRL, n);
                                    this.isConnected = true;
                                }

                                public int getContentLength() {
                                    return (int)bundleImpl.getResourceLength(uRL, n);
                                }

                                public InputStream getInputStream() throws IOException {
                                    if (!this.isConnected) {
                                        this.connect();
                                    }
                                    return this.inputStream;
                                }
                            };
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IOException("Malformed host " + uRL.getHost());
                        }
                    }
                };
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ResolverImpl
    implements Resolver {
        protected HashMap<ResolverHook, ServiceReferenceImpl<ResolverHookFactory>> hooks;

        @Override
        public synchronized Map<Resource, List<Wire>> resolve(ResolveContext resolveContext) throws ResolutionException {
            if (resolveContext == null) {
                throw new IllegalArgumentException("context is null");
            }
            ConciergeCollections.MultiMap<Resource, Wire> multiMap = new ConciergeCollections.MultiMap<Resource, Wire>();
            ArrayList<Requirement> arrayList = new ArrayList<Requirement>();
            ArrayList<Resource> arrayList2 = new ArrayList<Resource>();
            this.resolve0(resolveContext, multiMap, arrayList, arrayList2, true);
            if (!arrayList.isEmpty() || !arrayList2.isEmpty()) {
                throw new ResolutionException("Could not resolve.", null, arrayList);
            }
            return multiMap.getFlatMap();
        }

        protected void resolve0(ResolveContext resolveContext, ConciergeCollections.MultiMap<Resource, Wire> multiMap, ArrayList<Requirement> arrayList, ArrayList<Resource> arrayList2, boolean bl) {
            Collection<Resource> collection = resolveContext.getMandatoryResources();
            Collection<Resource> collection2 = resolveContext.getOptionalResources();
            if (this.hooks != null && !this.hooks.isEmpty()) {
                Concierge.this.filterResources(this.hooks.keySet(), collection, arrayList2);
            }
            if (!collection.isEmpty() || !collection2.isEmpty()) {
                Map<Resource, Wiring> map = resolveContext.getWirings();
                for (Resource resource : collection) {
                    if (resource == null) continue;
                    try {
                        if (resource instanceof BundleImpl.Revision && !((BundleImpl.Revision)resource).resolveMetadata(false)) {
                            arrayList2.add(resource);
                            continue;
                        }
                    }
                    catch (BundleException bundleException) {
                        bundleException.printStackTrace();
                    }
                    if (resource instanceof BundleRevision && !this.checkSingleton((BundleRevision)resource)) {
                        arrayList2.add(resource);
                        continue;
                    }
                    Collection<Requirement> collection3 = this.resolveResource(resolveContext, resource, map, multiMap, new HashSet<Resource>(), bl);
                    arrayList.addAll(collection3);
                }
                if (!arrayList.isEmpty() || !arrayList2.isEmpty()) {
                    return;
                }
                for (Resource resource : collection2) {
                    this.resolveResource(resolveContext, resource, map, multiMap, new HashSet<Resource>(), bl);
                }
            }
        }

        private boolean checkSingleton(BundleRevision bundleRevision) {
            try {
                List<Capability> list = bundleRevision.getCapabilities("osgi.identity");
                if (list == null || list.isEmpty()) {
                    return true;
                }
                BundleCapability bundleCapability = (BundleCapability)list.get(0);
                if (!"true".equals(bundleCapability.getDirectives().get("singleton"))) {
                    return true;
                }
                ArrayList<BundleCapability> arrayList = new ArrayList<BundleCapability>();
                if (Concierge.this.DEBUG_BUNDLES) {
                    Concierge.this.logger.log(4, "RESOLVING " + bundleRevision.getSymbolicName() + " - " + bundleRevision.getVersion() + " /.//" + bundleRevision);
                }
                ArrayList<AbstractBundle> arrayList2 = new ArrayList<AbstractBundle>(Concierge.this.getBundleWithSymbolicName(bundleRevision.getSymbolicName()));
                arrayList2.remove(bundleRevision.getBundle());
                if (arrayList2.isEmpty()) {
                    return true;
                }
                for (AbstractBundle iterator : arrayList2) {
                    BundleCapability bundleCapability2;
                    if (iterator.state == 2 || !"true".equals((bundleCapability2 = (BundleCapability)iterator.currentRevision.getCapabilities("osgi.identity").get(0)).getDirectives().get("singleton"))) continue;
                    arrayList.add(bundleCapability2);
                }
                if (this.hooks != null && this.hooks.isEmpty()) {
                    return arrayList.isEmpty();
                }
                ConciergeCollections.RemoveOnlyList removeOnlyList = new ConciergeCollections.RemoveOnlyList(arrayList);
                for (ResolverHook resolverHook : this.hooks.keySet()) {
                    resolverHook.filterSingletonCollisions(bundleCapability, removeOnlyList);
                }
                if (!removeOnlyList.isEmpty()) {
                    return false;
                }
                for (BundleCapability bundleCapability3 : arrayList) {
                    ConciergeCollections.RemoveOnlyList<BundleCapability> removeOnlyList2 = new ConciergeCollections.RemoveOnlyList<BundleCapability>(Collections.singletonList(bundleCapability));
                    for (ResolverHook resolverHook : this.hooks.keySet()) {
                        resolverHook.filterSingletonCollisions(bundleCapability3, removeOnlyList2);
                    }
                    if (removeOnlyList2.isEmpty()) continue;
                    return false;
                }
                return true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new RuntimeException(throwable.getMessage());
            }
        }

        private final Collection<Requirement> resolveResource(ResolveContext resolveContext, Resource resource, Map<Resource, Wiring> map, ConciergeCollections.MultiMap<Resource, Wire> multiMap, HashSet<Resource> hashSet, boolean bl) {
            Object object;
            Object object3;
            hashSet.add(resource);
            if (multiMap.containsKey(resource)) {
                return Collections.emptyList();
            }
            ArrayList<Requirement> arrayList = new ArrayList<Requirement>();
            ConciergeCollections.MultiMap<Resource, Object> multiMap2 = new ConciergeCollections.MultiMap<Resource, Object>();
            boolean bl2 = false;
            if (resource instanceof BundleImpl.Revision) {
                object3 = (BundleImpl.Revision)resource;
                bl2 = ((BundleImpl.Revision)object3).isFragment();
                if (!bl2 && ((BundleImpl.Revision)object3).allowsFragmentAttachment()) {
                    for (BundleImpl.Revision object22 : Concierge.this.getFragments((BundleRevision)object3)) {
                        object = new ArrayList();
                        ((ArrayList)object).add(((BundleImpl.Revision)object3).getCapabilities("osgi.wiring.host").get(0));
                        if (this.hooks != null && !this.hooks.isEmpty()) {
                            Concierge.this.filterCandidates(this.hooks.keySet(), (BundleRequirement)object22.getRequirements("osgi.wiring.host").get(0), (Collection<Capability>)object);
                        }
                        if (((ArrayList)object).isEmpty()) continue;
                        try {
                            if (!((BundleImpl.Revision)object3).attachFragment(object22)) continue;
                            this.hostFragment(resolveContext, object22, (BundleRevision)object3, multiMap);
                        }
                        catch (BundleException list) {
                            if (!Concierge.this.LOG_ENABLED) continue;
                            Concierge.this.logger.log(1, "Unsuccessfully attempted to attach " + object22 + " to " + object3, list);
                        }
                    }
                }
            } else {
                bl2 = !resource.getRequirements("osgi.wiring.host").isEmpty();
            }
            object3 = resource.getRequirements(null);
            HashSet hashSet2 = new HashSet();
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                object = (Requirement)iterator.next();
                if (hashSet2.contains(object) || !resolveContext.isEffective((Requirement)object) || bl2 && !"osgi.wiring.host".equals(object.getNamespace())) continue;
                List<Capability> list = resolveContext.findProviders((Requirement)object);
                if (this.hooks != null && !this.hooks.isEmpty() && object instanceof BundleRequirement) {
                    Concierge.this.filterCandidates(this.hooks.keySet(), (BundleRequirement)object, list);
                }
                boolean bl3 = false;
                boolean bl4 = "multiple".equals(object.getDirectives().get("cardinality"));
                for (Capability capability : list) {
                    Object object2;
                    Object bundleException;
                    if (bl2) {
                        bundleException = (BundleImpl.Revision)resource;
                        if (capability.getResource() instanceof BundleImpl.Revision) {
                            object2 = (BundleImpl.Revision)capability.getResource();
                            try {
                                if (!((BundleImpl.Revision)object2).attachFragment((BundleImpl.Revision)bundleException)) {
                                    bl3 = true;
                                }
                            }
                            catch (BundleException bundleException2) {}
                            continue;
                        }
                        bl3 = true;
                        this.hostFragment(resolveContext, (BundleRevision)bundleException, (BundleRevision)capability.getResource(), multiMap);
                        continue;
                    }
                    if (capability instanceof BundleCapability) {
                        Object object4;
                        Object object5;
                        Object object6;
                        Object object7;
                        String[] stringArray;
                        Object object8;
                        Object object9;
                        bundleException = new ArrayList();
                        if ("osgi.wiring.bundle".equals(capability.getNamespace())) {
                            ((ArrayList)bundleException).addAll(((BundleCapability)capability).getResource().getDeclaredCapabilities("osgi.wiring.package"));
                        } else {
                            ((ArrayList)bundleException).add((BundleCapability)capability);
                        }
                        object2 = new ArrayList();
                        HashSet<Object> bundleException2 = new HashSet<Object>();
                        while (!((ArrayList)bundleException).isEmpty()) {
                            Object object10;
                            Object object112;
                            object9 = (BundleCapability)((ArrayList)bundleException).remove(0);
                            if (bundleException2.contains(object9)) continue;
                            bundleException2.add(object9);
                            object8 = object9.getDirectives().get("uses");
                            if (object8 == null) continue;
                            stringArray = Utils.splitString((String)object8, ',');
                            object7 = new HashSet();
                            ((AbstractCollection)object7).addAll(Arrays.asList(stringArray));
                            object6 = object9.getResource().getWiring();
                            if (object6 == null || !object6.isInUse()) continue;
                            List<BundleWire> list2 = object6.getRequiredWires("osgi.wiring.package");
                            object5 = new HashSet();
                            for (Object object112 : list2) {
                                object10 = object112.getCapability().getAttributes().get("osgi.wiring.package");
                                if (!((HashSet)object7).contains(object10)) continue;
                                ((ArrayList)object2).add(object112.getCapability());
                                ((ArrayList)bundleException).add(object112.getCapability());
                                ((HashSet)object5).add(object10);
                            }
                            object4 = object6.getCapabilities("osgi.wiring.package");
                            object112 = object4.iterator();
                            while (object112.hasNext()) {
                                object10 = (Capability)object112.next();
                                Object object12 = object10.getAttributes().get("osgi.wiring.package");
                                if (!((HashSet)object7).contains(object12) || ((HashSet)object5).contains(object12)) continue;
                                ((ArrayList)object2).add((BundleCapability)object10);
                                ((ArrayList)bundleException).add((BundleCapability)object10);
                            }
                        }
                        if (!((ArrayList)object2).isEmpty()) {
                            object9 = ((ArrayList)object2).iterator();
                            while (object9.hasNext()) {
                                object8 = (BundleCapability)object9.next();
                                stringArray = object3.iterator();
                                while (stringArray.hasNext()) {
                                    object7 = (Requirement)stringArray.next();
                                    if (!Concierge.matches((Requirement)object7, (Capability)object8)) continue;
                                    for (Map.Entry entry : multiMap2.entrySet()) {
                                        object5 = entry.getValue().iterator();
                                        while (object5.hasNext()) {
                                            object4 = (Wire)object5.next();
                                            if (object4.getRequirement() != object7) continue;
                                            object5.remove();
                                        }
                                    }
                                    hashSet2.add(object7);
                                    object6 = Resources.createWire((Capability)object8, (Requirement)object7);
                                    multiMap2.insert(resource, object6);
                                }
                            }
                        }
                    }
                    if (map.get(capability.getResource()) != null) {
                        bundleException = Resources.createWire(capability, (Requirement)object);
                        multiMap2.insert(resource, bundleException);
                        multiMap2.insertUnique(capability.getResource(), bundleException);
                        bl3 = true;
                        if (bl4) continue;
                        break;
                    }
                    try {
                        if (!hashSet.contains(capability.getResource()) && (capability.getResource() instanceof BundleImpl.Revision && !((BundleImpl.Revision)capability.getResource()).resolveMetadata(false) || !this.resolveResource(resolveContext, capability.getResource(), map, multiMap, hashSet, bl).isEmpty())) continue;
                        bundleException = Resources.createWire(capability, (Requirement)object);
                        multiMap2.insert(resource, bundleException);
                        if (!bl) {
                            multiMap2.insertUnique(capability.getResource(), bundleException);
                        }
                        bl3 = true;
                        if (bl4) continue;
                        break;
                    }
                    catch (BundleException bundleException3) {
                    }
                }
                if (bl3 || "optional".equals(object.getDirectives().get("resolution"))) continue;
                arrayList.add((Requirement)object);
            }
            if (arrayList.isEmpty()) {
                if (multiMap2.isEmpty()) {
                    multiMap.insertEmpty(resource);
                } else {
                    multiMap.insertMap(multiMap2);
                }
                if (resource instanceof BundleImpl.Revision) {
                    ((BundleImpl.Revision)resource).markResolved();
                }
            }
            return arrayList;
        }

        private void hostFragment(ResolveContext resolveContext, BundleRevision bundleRevision, BundleRevision bundleRevision2, ConciergeCollections.MultiMap<Resource, Wire> multiMap) {
            Object object;
            for (Capability object22 : bundleRevision.getCapabilities(null)) {
                if ("osgi.identity".equals(object22.getNamespace())) continue;
                object = new Resources.HostedBundleCapability(bundleRevision2, object22);
                resolveContext.insertHostedCapability(new ArrayList<Capability>(bundleRevision2.getCapabilities("osgi.wiring.package")), (HostedCapability)object);
            }
            Capability capability = bundleRevision2.getCapabilities("osgi.wiring.host").get(0);
            Requirement requirement = bundleRevision.getRequirements("osgi.wiring.host").get(0);
            object = Resources.createWire(capability, requirement);
            multiMap.insert(bundleRevision, (Wire)object);
            multiMap.insert(bundleRevision2, (Wire)object);
        }
    }

    static final class ServiceListenerEntry
    implements EventListener,
    ListenerHook.ListenerInfo {
        final AbstractBundle bundle;
        final ServiceListener listener;
        final Filter filter;
        boolean removed;

        protected ServiceListenerEntry(AbstractBundle abstractBundle, ServiceListener serviceListener, String string) throws InvalidSyntaxException {
            this.bundle = abstractBundle;
            this.listener = serviceListener;
            this.removed = false;
            this.filter = string == null ? null : RFC1960Filter.fromString(string);
        }

        public boolean equals(Object object) {
            if (object instanceof ServiceListenerEntry) {
                ServiceListenerEntry serviceListenerEntry = (ServiceListenerEntry)object;
                return this.bundle == serviceListenerEntry.bundle && this.listener.equals(serviceListenerEntry.listener);
            }
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode() + (this.filter != null ? this.filter.hashCode() >> 8 : 0);
        }

        public String toString() {
            return this.listener + " " + this.filter;
        }

        public BundleContext getBundleContext() {
            return this.bundle.context;
        }

        public String getFilter() {
            return this.filter == null ? null : this.filter.toString();
        }

        public boolean isRemoved() {
            return this.removed;
        }
    }

    final class SystemBundleStartLevel
    implements BundleStartLevel {
        SystemBundleStartLevel() {
        }

        public Bundle getBundle() {
            return Concierge.this;
        }

        public int getStartLevel() {
            return 0;
        }

        public void setStartLevel(int n) {
            throw new IllegalArgumentException();
        }

        public boolean isPersistentlyStarted() {
            return true;
        }

        public boolean isActivationPolicyUsed() {
            return true;
        }
    }
}

