/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.concierge.AbstractBundle;
import org.eclipse.concierge.BundleImpl;
import org.eclipse.concierge.Concierge;
import org.eclipse.concierge.ConciergeCollections;
import org.eclipse.concierge.RFC1960Filter;
import org.eclipse.concierge.Utils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;

public class Resources {
    static Wire createWire(Capability capability, Requirement requirement) {
        return capability instanceof BundleCapability && requirement instanceof BundleRequirement ? new ConciergeBundleWire((BundleCapability)capability, (BundleRequirement)requirement) : new ConciergeWire(capability, requirement);
    }

    static Wiring createWiring() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractWireImpl<C extends Capability, R extends Requirement>
    implements Wire {
        protected final C capability;
        protected final R requirement;

        protected AbstractWireImpl(C c, R r) {
            this.capability = c;
            this.requirement = r;
        }

        public C getCapability() {
            if (this.capability instanceof HostedCapability) {
                Capability capability = ((HostedCapability)this.capability).getDeclaredCapability();
                return (C)capability;
            }
            return this.capability;
        }

        public R getRequirement() {
            return this.requirement;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof AbstractWireImpl) {
                return object == this;
            }
            if (object instanceof Wire) {
                Wire wire = (Wire)object;
                return wire.getRequirer().equals(this.requirement.getResource()) && wire.getRequirement().equals(this.requirement) && wire.getProvider().equals(this.capability.getResource()) && wire.getCapability().equals(this.capability);
            }
            return false;
        }

        public String toString() {
            return "{" + this.requirement + "->" + this.capability + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BundleCapabilityImpl
    extends GenericReqCap
    implements BundleCapability {
        private final BundleRevision revision;
        private final String prettyPrint;
        private final String[] includes;
        private final String[] excludes;
        private final boolean hasExcludes;

        BundleCapabilityImpl(BundleRevision bundleRevision, String string) throws BundleException {
            super(string);
            this.revision = bundleRevision;
            this.prettyPrint = null;
            String string2 = this.getDirectives().get("exclude");
            if (string2 == null) {
                this.excludes = new String[1];
                this.excludes[0] = "";
                this.hasExcludes = false;
            } else {
                this.excludes = Utils.splitString(Utils.unQuote(string2), ',');
                this.hasExcludes = true;
            }
            String string3 = this.getDirectives().get("include");
            if (string3 == null) {
                this.includes = new String[1];
                this.includes[0] = "*";
            } else {
                this.includes = Utils.splitString(Utils.unQuote(string2), ',');
            }
        }

        public BundleCapabilityImpl(BundleRevision bundleRevision, String string, Map<String, String> map, Map<String, Object> map2, String string2) {
            super(string, map, map2);
            this.revision = bundleRevision;
            this.prettyPrint = string2;
            String string3 = this.getDirectives().get("exclude");
            if (string3 == null) {
                this.excludes = new String[1];
                this.excludes[0] = "";
                this.hasExcludes = false;
            } else {
                this.excludes = Utils.splitString(Utils.unQuote(string3), ',');
                this.hasExcludes = true;
            }
            String string4 = this.getDirectives().get("include");
            if (string4 == null) {
                this.includes = new String[1];
                this.includes[0] = "*";
            } else {
                this.includes = Utils.splitString(Utils.unQuote(string4), ',');
            }
            if ("osgi.wiring.package".equals(string) && map2.get("version") == null) {
                map2.put("version", Version.emptyVersion);
            }
        }

        @Override
        public BundleRevision getRevision() {
            return this.revision;
        }

        @Override
        public BundleRevision getResource() {
            return this.revision;
        }

        boolean filter(String string) {
            int n;
            boolean bl = false;
            for (n = 0; n < this.includes.length; ++n) {
                if (RFC1960Filter.stringCompare(this.includes[n].toCharArray(), 0, string.toCharArray(), 0) != 0) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
            bl = false;
            for (n = 0; n < this.excludes.length; ++n) {
                if (RFC1960Filter.stringCompare(string.toCharArray(), 0, this.excludes[n].toCharArray(), 0) != 0) continue;
                bl = true;
                break;
            }
            return !bl;
        }

        boolean hasExcludes() {
            return this.hasExcludes;
        }

        @Override
        public String toString() {
            return this.prettyPrint == null ? "BundleCapability {" + super.toString() + "}" : this.prettyPrint;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BundleRequirementImpl
    extends GenericReqCap
    implements BundleRequirement {
        private final BundleRevision revision;
        private final String prettyPrint;

        public BundleRequirementImpl(BundleRevision bundleRevision, String string) throws BundleException {
            super(string);
            this.revision = bundleRevision;
            this.prettyPrint = null;
        }

        public BundleRequirementImpl(BundleRevision bundleRevision, String string, Map<String, String> map, Map<String, Object> map2, String string2) {
            super(string, map, map2);
            this.revision = bundleRevision;
            this.prettyPrint = "BundleRequirement{" + string2 + "}";
        }

        @Override
        public BundleRevision getRevision() {
            return this.revision;
        }

        @Override
        public BundleRevision getResource() {
            return this.revision;
        }

        @Override
        public boolean matches(BundleCapability bundleCapability) {
            return Concierge.matches(this, bundleCapability);
        }

        @Override
        public String toString() {
            return this.prettyPrint == null ? "BundleRequirement {" + super.toString() + "}" : this.prettyPrint;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConciergeBundleWire
    extends AbstractWireImpl<BundleCapability, BundleRequirement>
    implements BundleWire {
        ConciergeBundleWiring providerWiring;
        ConciergeBundleWiring requirerWiring;

        protected ConciergeBundleWire(BundleCapability bundleCapability, BundleRequirement bundleRequirement) {
            super(bundleCapability, bundleRequirement);
        }

        @Override
        public BundleWiring getProviderWiring() {
            if (this.providerWiring == null) {
                this.providerWiring = (ConciergeBundleWiring)this.getProvider().getWiring();
            }
            return this.providerWiring;
        }

        @Override
        public BundleWiring getRequirerWiring() {
            return this.requirerWiring;
        }

        @Override
        public BundleRevision getProvider() {
            return ((BundleCapability)this.capability).getResource();
        }

        @Override
        public BundleRevision getRequirer() {
            return ((BundleRequirement)this.requirement).getResource();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConciergeBundleWiring
    implements BundleWiring {
        protected final BundleRevision revision;
        private final ConciergeCollections.MultiMap<String, BundleCapability> capabilities = new ConciergeCollections.MultiMap();
        private final ConciergeCollections.MultiMap<String, BundleRequirement> requirements = new ConciergeCollections.MultiMap();
        private final Comparator<BundleWire> provComp = new Comparator<BundleWire>(){

            @Override
            public int compare(BundleWire bundleWire, BundleWire bundleWire2) {
                BundleCapability bundleCapability = bundleWire.getCapability();
                BundleCapability bundleCapability2 = bundleWire2.getCapability();
                assert (bundleCapability.getNamespace().equals(bundleCapability2.getNamespace()));
                List<Capability> list = ConciergeBundleWiring.this.revision.getCapabilities(bundleCapability.getNamespace());
                return list.indexOf(bundleCapability) - list.indexOf(bundleCapability2);
            }
        };
        private final Comparator<BundleWire> reqComp = new Comparator<BundleWire>(){

            @Override
            public int compare(BundleWire bundleWire, BundleWire bundleWire2) {
                BundleRequirement bundleRequirement = bundleWire.getRequirement();
                BundleRequirement bundleRequirement2 = bundleWire2.getRequirement();
                assert (bundleRequirement.getNamespace().equals(bundleRequirement2.getNamespace()));
                List<Requirement> list = ConciergeBundleWiring.this.revision.getRequirements(bundleRequirement.getNamespace());
                return list.indexOf(bundleRequirement) - list.indexOf(bundleRequirement2);
            }
        };
        private final ConciergeCollections.MultiMap<String, BundleWire> providedWires = new ConciergeCollections.MultiMap(this.provComp);
        private final ConciergeCollections.MultiMap<String, BundleWire> requiredWires = new ConciergeCollections.MultiMap(this.reqComp);
        final HashSet<BundleRevision> inUseSet = new HashSet();

        ConciergeBundleWiring(BundleRevision bundleRevision, List<Wire> list) {
            String string;
            this.revision = bundleRevision;
            HashSet<Requirement> hashSet = new HashSet<Requirement>();
            if (list != null) {
                for (Wire object : list) {
                    this.addWire((BundleWire)object);
                    if (object.getRequirer() != bundleRevision) continue;
                    hashSet.add(object.getRequirement());
                }
            }
            for (BundleCapability bundleCapability : bundleRevision.getDeclaredCapabilities(null)) {
                string = bundleCapability.getDirectives().get("effective");
                if (string != null && !"resolve".equals(string)) continue;
                this.capabilities.insert(bundleCapability.getNamespace(), bundleCapability);
            }
            if (bundleRevision.getTypes() == 1) {
                this.capabilities.remove("osgi.identity");
            }
            for (BundleRequirement bundleRequirement : bundleRevision.getDeclaredRequirements(null)) {
                string = bundleRequirement.getDirectives().get("effective");
                boolean bl = "optional".equals(bundleRequirement.getDirectives().get("resolution"));
                if (string != null && !"resolve".equals(string) && !"dynamic".equals(bundleRequirement.getDirectives().get("resolution")) || bl && !hashSet.contains(bundleRequirement)) continue;
                this.requirements.insert(bundleRequirement.getNamespace(), bundleRequirement);
            }
        }

        void addWire(BundleWire bundleWire) {
            BundleCapability bundleCapability = bundleWire.getCapability();
            BundleRequirement bundleRequirement = bundleWire.getRequirement();
            if (bundleWire.getProvider() == this.revision) {
                this.providedWires.insert(bundleCapability.getNamespace(), bundleWire);
                this.inUseSet.add(bundleWire.getRequirer());
                ((ConciergeBundleWire)bundleWire).providerWiring = this;
            } else {
                this.requiredWires.insert(bundleRequirement.getNamespace(), bundleWire);
                if ("osgi.wiring.host".equals(bundleWire.getRequirement().getNamespace())) {
                    this.inUseSet.add(bundleWire.getProvider());
                }
                ((ConciergeBundleWire)bundleWire).requirerWiring = this;
            }
        }

        HashMap<String, BundleWire> getPackageImportWires() {
            List<BundleWire> list = this.getRequiredWires("osgi.wiring.package");
            HashMap<String, BundleWire> hashMap = new HashMap<String, BundleWire>();
            if (list != null) {
                for (BundleWire bundleWire : list) {
                    hashMap.put((String)bundleWire.getCapability().getAttributes().get("osgi.wiring.package"), bundleWire);
                }
            }
            return hashMap;
        }

        List<BundleWire> getRequireBundleWires() {
            return this.getRequiredWires("osgi.wiring.bundle");
        }

        @Override
        public Bundle getBundle() {
            return this.revision.getBundle();
        }

        @Override
        public boolean isCurrent() {
            if (this.revision.getBundle().getBundleId() == 0L) {
                return true;
            }
            return ((AbstractBundle)this.revision.getBundle()).currentRevision == this.revision && this.revision.getWiring() == this;
        }

        void cleanup() {
            ConciergeBundleWiring conciergeBundleWiring;
            for (BundleWire bundleWire : this.requiredWires.getAllValues()) {
                conciergeBundleWiring = ((ConciergeBundleWire)bundleWire).providerWiring;
                if (conciergeBundleWiring == null) continue;
                conciergeBundleWiring.inUseSet.remove(this.revision);
            }
            for (BundleWire bundleWire : this.providedWires.lookup("osgi.wiring.host")) {
                conciergeBundleWiring = ((ConciergeBundleWire)bundleWire).requirerWiring;
                if (conciergeBundleWiring == null) continue;
                conciergeBundleWiring.inUseSet.remove(this.revision);
            }
        }

        @Override
        public boolean isInUse() {
            return this.isCurrent() || !this.inUseSet.isEmpty();
        }

        @Override
        public List<BundleCapability> getCapabilities(String string) {
            if (!this.isInUse()) {
                return null;
            }
            return string == null ? this.capabilities.getAllValues() : this.capabilities.lookup(string);
        }

        @Override
        public List<BundleRequirement> getRequirements(String string) {
            if (!this.isInUse()) {
                return null;
            }
            return string == null ? this.requirements.getAllValues() : this.requirements.lookup(string);
        }

        @Override
        public List<BundleWire> getProvidedWires(String string) {
            if (!this.isInUse()) {
                return null;
            }
            return string == null ? this.providedWires.getAllValues() : this.providedWires.lookup(string);
        }

        @Override
        public List<BundleWire> getRequiredWires(String string) {
            if (!this.isInUse()) {
                return null;
            }
            return string == null ? this.requiredWires.getAllValues() : this.requiredWires.lookup(string);
        }

        @Override
        public BundleRevision getRevision() {
            return this.revision;
        }

        @Override
        public ClassLoader getClassLoader() {
            if (!this.isInUse()) {
                return null;
            }
            if (this.revision instanceof BundleImpl.Revision) {
                return ((BundleImpl.Revision)this.revision).classloader;
            }
            return null;
        }

        @Override
        public List<URL> findEntries(String string, String string2, int n) {
            if (!this.isInUse()) {
                return null;
            }
            Enumeration<URL> enumeration = null;
            if (this.revision instanceof BundleImpl.Revision) {
                BundleImpl.Revision revision = (BundleImpl.Revision)this.revision;
                enumeration = revision.findEntries(string, string2, n == 1);
            }
            return enumeration == null ? Collections.emptyList() : Collections.unmodifiableList(Collections.list(enumeration));
        }

        @Override
        public Collection<String> listResources(String string, String string2, int n) {
            if (!this.isInUse()) {
                return null;
            }
            return Collections.unmodifiableSet(((BundleImpl.Revision)this.revision).classloader.listResources(string, string2, n, new HashSet<String>()));
        }

        @Override
        public List<Capability> getResourceCapabilities(String string) {
            List<BundleCapability> list = this.getCapabilities(string);
            return list == null ? null : new ArrayList<BundleCapability>(list);
        }

        @Override
        public List<Requirement> getResourceRequirements(String string) {
            List<BundleRequirement> list = this.getRequirements(string);
            return list == null ? null : new ArrayList<BundleRequirement>(list);
        }

        @Override
        public List<Wire> getProvidedResourceWires(String string) {
            List<BundleWire> list = this.getProvidedWires(string);
            return list == null ? null : new ArrayList<BundleWire>(list);
        }

        @Override
        public List<Wire> getRequiredResourceWires(String string) {
            List<BundleWire> list = this.getRequiredWires(string);
            return list == null ? null : new ArrayList<BundleWire>(list);
        }

        @Override
        public BundleRevision getResource() {
            return this.revision;
        }

        void addCapability(HostedCapability hostedCapability) {
            this.capabilities.insert(hostedCapability.getNamespace(), (BundleCapability)hostedCapability.getDeclaredCapability());
        }

        public String toString() {
            return "[ConciergeBundleWiring of " + this.revision + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConciergeWire
    extends AbstractWireImpl<Capability, Requirement> {
        protected ConciergeWire(Capability capability, Requirement requirement) {
            super(capability, requirement);
        }

        @Override
        public Resource getProvider() {
            return this.capability.getResource();
        }

        @Override
        public Resource getRequirer() {
            return this.requirement.getResource();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConciergeWiring
    implements Wiring {
        private final Resource resource;
        private final ConciergeCollections.MultiMap<String, Capability> capabilities = new ConciergeCollections.MultiMap();
        private final ConciergeCollections.MultiMap<String, Requirement> requirements = new ConciergeCollections.MultiMap();
        private final ConciergeCollections.MultiMap<String, Wire> providedWires = new ConciergeCollections.MultiMap();
        private final ConciergeCollections.MultiMap<String, Wire> requiredWires = new ConciergeCollections.MultiMap();

        ConciergeWiring(Resource resource, List<Wire> list) {
            this.resource = resource;
            for (Wire wire : list) {
                this.addWire(wire);
            }
        }

        private void addWire(Wire wire) {
            if (wire.getProvider() == this.resource) {
                Capability capability = wire.getCapability();
                this.capabilities.insertUnique(capability.getNamespace(), capability);
                this.providedWires.insert(capability.getNamespace(), wire);
            } else {
                Requirement requirement = wire.getRequirement();
                this.requirements.insertUnique(requirement.getNamespace(), requirement);
                this.requiredWires.insert(requirement.getNamespace(), wire);
            }
        }

        @Override
        public List<Capability> getResourceCapabilities(String string) {
            return string == null ? this.capabilities.getAllValues() : this.capabilities.lookup(string);
        }

        @Override
        public List<Requirement> getResourceRequirements(String string) {
            return string == null ? this.requirements.getAllValues() : this.requirements.lookup(string);
        }

        @Override
        public List<Wire> getProvidedResourceWires(String string) {
            return string == null ? this.providedWires.getAllValues() : this.providedWires.lookup(string);
        }

        @Override
        public List<Wire> getRequiredResourceWires(String string) {
            return string == null ? this.requiredWires.getAllValues() : this.requiredWires.lookup(string);
        }

        @Override
        public Resource getResource() {
            return this.resource;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class GenericReqCap
    implements Requirement,
    Capability {
        private final String namespace;
        private final Map<String, String> directives;
        private final Map<String, Object> attributes;

        protected GenericReqCap(String string) throws BundleException {
            String[] stringArray = Utils.splitString(string, ';');
            this.namespace = stringArray[0].trim();
            ConciergeCollections.ParseResult parseResult = Utils.parseLiterals(stringArray, 1);
            this.directives = parseResult.getDirectives() == null ? Collections.emptyMap() : Collections.unmodifiableMap(parseResult.getDirectives());
            this.attributes = parseResult.getAttributes() == null ? Collections.emptyMap() : Collections.unmodifiableMap(parseResult.getAttributes());
        }

        public GenericReqCap(String string, Map<String, String> map, Map<String, Object> map2) {
            this.namespace = string;
            this.directives = map == null || map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map);
            this.attributes = map2 == null || map2.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map2);
        }

        @Override
        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Map<String, String> getDirectives() {
            return this.directives;
        }

        @Override
        public final Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public String toString() {
            if (this.directives.isEmpty() && this.attributes.isEmpty()) {
                return this.namespace;
            }
            String string = this.namespace + "; ";
            for (String string2 : this.directives.keySet()) {
                string = string + string2 + ":=" + this.directives.get(string2) + ", ";
            }
            for (String string2 : this.attributes.keySet()) {
                string = string + string2 + "=" + this.attributes.get(string2) + ", ";
            }
            return string.substring(0, string.length() - 2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HostedBundleCapability
    implements HostedCapability,
    BundleCapability {
        private final BundleRevision host;
        private final BundleCapability cap;

        HostedBundleCapability(BundleRevision bundleRevision, Capability capability) {
            this.host = bundleRevision;
            this.cap = (BundleCapability)capability;
        }

        @Override
        public String getNamespace() {
            return this.cap.getNamespace();
        }

        @Override
        public Map<String, String> getDirectives() {
            return this.cap.getDirectives();
        }

        @Override
        public Map<String, Object> getAttributes() {
            return this.cap.getAttributes();
        }

        @Override
        public BundleRevision getResource() {
            return this.host;
        }

        @Override
        public Capability getDeclaredCapability() {
            return this.cap;
        }

        @Override
        public BundleRevision getRevision() {
            return this.host;
        }

        public String toString() {
            return "HostedCapability{host=" + this.host + ", cap=" + this.cap + ")";
        }
    }
}

