/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.concierge.AbstractBundle;
import org.eclipse.concierge.BundleImpl;
import org.eclipse.concierge.Concierge;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServiceReferenceImpl<S>
implements ServiceReference<S> {
    protected final Concierge framework;
    Bundle bundle;
    protected S service;
    final Map<String, Object> properties;
    final Map<Bundle, Integer> useCounters = new HashMap<Bundle, Integer>(0);
    private HashMap<Bundle, S> cachedServices = null;
    ServiceRegistration<S> registration;
    private static long nextServiceID = 0L;
    private final boolean isServiceFactory;
    protected static final HashSet<String> forbidden = new HashSet(2);
    private boolean marker = false;

    ServiceReferenceImpl(Concierge concierge, Bundle bundle, S s, Dictionary<String, ?> dictionary, String[] stringArray) {
        Enumeration<String> enumeration;
        if (s instanceof ServiceFactory) {
            this.isServiceFactory = true;
        } else {
            this.isServiceFactory = false;
            this.checkService(s, stringArray);
        }
        this.framework = concierge;
        this.bundle = bundle;
        this.service = s;
        this.properties = new HashMap<String, Object>(dictionary == null ? 2 : dictionary.size() + 2);
        if (dictionary != null) {
            enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                this.properties.put(string, dictionary.get(string));
            }
        }
        this.properties.put("objectClass", stringArray);
        this.properties.put("service.id", new Long(++nextServiceID));
        enumeration = dictionary == null ? null : (Integer)dictionary.get("service.ranking");
        this.properties.put("service.ranking", enumeration == null ? new Integer(0) : enumeration);
        this.registration = new ServiceRegistrationImpl();
    }

    private void checkService(Object object, String[] stringArray) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("ServiceFactory produced /null/");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Class<?> clazz = Class.forName(stringArray[i], false, object.getClass().getClassLoader());
                if (clazz.isInstance(object)) continue;
                throw new IllegalArgumentException("Service " + object.getClass().getName() + " does not implement the interface " + stringArray[i]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Interface " + stringArray[i] + " implemented by service " + object.getClass().getName() + " cannot be located: " + classNotFoundException.getMessage());
            }
        }
    }

    void invalidate() {
        this.service = null;
        this.useCounters.clear();
        this.bundle = null;
        this.registration = null;
        if (this.cachedServices != null) {
            this.cachedServices = null;
        }
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public Object getProperty(String string) {
        Object object = this.properties.get(string);
        if (object != null) {
            return object;
        }
        object = this.properties.get(string.toLowerCase());
        if (object != null) {
            return object;
        }
        for (String string2 : this.properties.keySet()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            object = this.properties.get(string2);
            break;
        }
        return object;
    }

    @Override
    public String[] getPropertyKeys() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle[] getUsingBundles() {
        Map<Bundle, Integer> map = this.useCounters;
        synchronized (map) {
            if (this.useCounters.isEmpty()) {
                return null;
            }
            return this.useCounters.keySet().toArray(new Bundle[this.useCounters.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    S getService(Bundle bundle) {
        if (this.service == null || this.marker) {
            return null;
        }
        Map<Bundle, Integer> map = this.useCounters;
        synchronized (map) {
            if (this.isServiceFactory) {
                S s;
                S s2;
                if (this.cachedServices == null) {
                    this.cachedServices = new HashMap(1);
                }
                if ((s2 = this.cachedServices.get(bundle)) != null) {
                    this.incrementCounter(bundle);
                    return s2;
                }
                ServiceFactory serviceFactory = (ServiceFactory)this.service;
                try {
                    this.incrementCounter(bundle);
                    this.marker = true;
                    s = serviceFactory.getService(bundle, this.registration);
                    this.marker = false;
                    this.checkService(s, (String[])this.properties.get("objectClass"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.decrementCounter(bundle);
                    this.framework.notifyFrameworkListeners(2, this.bundle, new ServiceException("Invalid service object", 2));
                    return null;
                }
                catch (Throwable throwable) {
                    this.decrementCounter(bundle);
                    this.framework.notifyFrameworkListeners(2, this.bundle, new ServiceException("Exception while factoring the service", 3, throwable));
                    return null;
                }
                this.cachedServices.put(bundle, s);
                return s;
            }
            this.incrementCounter(bundle);
            return this.service;
        }
    }

    private void incrementCounter(Bundle bundle) {
        Integer n = this.useCounters.get(bundle);
        n = n == null ? new Integer(1) : new Integer(n + 1);
        this.useCounters.put(bundle, n);
    }

    private void decrementCounter(Bundle bundle) {
        Integer n = this.useCounters.get(bundle);
        int n2 = n - 1;
        n = n2 == 0 ? null : new Integer(n2);
        this.useCounters.put(bundle, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ungetService(Bundle bundle) {
        Map<Bundle, Integer> map = this.useCounters;
        synchronized (map) {
            if (this.service == null) {
                return false;
            }
            Integer n = this.useCounters.get(bundle);
            if (n == null) {
                return false;
            }
            if (n == 1) {
                if (this.isServiceFactory) {
                    try {
                        ((ServiceFactory)this.service).ungetService(bundle, this.registration, this.cachedServices.get(bundle));
                    }
                    catch (Throwable throwable) {
                        this.framework.notifyFrameworkListeners(2, this.bundle, throwable);
                    }
                    this.useCounters.remove(bundle);
                    this.cachedServices.remove(bundle);
                }
                return true;
            }
            n = new Integer(n - 1);
            this.useCounters.put(bundle, n);
            return true;
        }
    }

    public String toString() {
        return "ServiceReference{" + this.service + "}";
    }

    @Override
    public int compareTo(Object object) {
        if (!(object instanceof ServiceReferenceImpl) || ((ServiceReferenceImpl)object).framework != this.framework) {
            throw new IllegalArgumentException("ServiceReference was not created by the same framework instance");
        }
        ServiceReferenceImpl serviceReferenceImpl = (ServiceReferenceImpl)object;
        int n = ((Long)this.properties.get("service.id")).compareTo((Long)serviceReferenceImpl.properties.get("service.id"));
        if (n == 0) {
            return 0;
        }
        int n2 = ((Integer)this.properties.get("service.ranking")).compareTo((Integer)serviceReferenceImpl.properties.get("service.ranking"));
        if (n2 < 0) {
            return -1;
        }
        if (n2 > 0) {
            return 1;
        }
        if (n < 0) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isAssignableTo(Bundle bundle, String string) {
        if (bundle == this.bundle || this.bundle == this.framework || bundle == this.framework) {
            return true;
        }
        BundleImpl bundleImpl = (BundleImpl)bundle;
        BundleImpl bundleImpl2 = (BundleImpl)this.bundle;
        try {
            return bundleImpl.loadClass(string) == bundleImpl2.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
    }

    boolean isAssignableTo(AbstractBundle abstractBundle, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.isAssignableTo((Bundle)abstractBundle, stringArray[i])) continue;
            return false;
        }
        return true;
    }

    static {
        forbidden.add("service.id".toLowerCase());
        forbidden.add("objectClass".toLowerCase());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ServiceRegistrationImpl
    implements ServiceRegistration<S> {
        protected ServiceRegistrationImpl() {
        }

        @Override
        public ServiceReference<S> getReference() {
            if (ServiceReferenceImpl.this.service == null) {
                throw new IllegalStateException("Service has already been uninstalled");
            }
            return ServiceReferenceImpl.this;
        }

        @Override
        public void setProperties(Dictionary<String, ?> dictionary) {
            String string;
            if (ServiceReferenceImpl.this.service == null) {
                throw new IllegalStateException("Service has already been uninstalled");
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(ServiceReferenceImpl.this.properties);
            HashMap<String, String> hashMap2 = new HashMap<String, String>(ServiceReferenceImpl.this.properties.size());
            for (String string2 : ServiceReferenceImpl.this.properties.keySet()) {
                string = string2.toLowerCase();
                if (hashMap2.containsKey(string)) {
                    throw new IllegalArgumentException("Properties contain the same key in different case variants");
                }
                hashMap2.put(string, string2);
            }
            Enumeration<String> enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                String string2;
                string2 = (String)enumeration.nextElement();
                string = dictionary.get(string2);
                String string3 = string2.toLowerCase();
                if (forbidden.contains(string3)) continue;
                Object v = hashMap2.get(string3);
                if (v != null) {
                    if (v.equals(string2)) {
                        ServiceReferenceImpl.this.properties.remove(v);
                    } else {
                        throw new IllegalArgumentException("Properties already exists in a different case variant");
                    }
                }
                ServiceReferenceImpl.this.properties.put(string2, string);
            }
            ServiceReferenceImpl.this.framework.notifyServiceListeners(2, ServiceReferenceImpl.this, hashMap);
        }

        @Override
        public void unregister() {
            if (ServiceReferenceImpl.this.service == null) {
                throw new IllegalStateException("Service has already been uninstalled");
            }
            ServiceReferenceImpl.this.framework.unregisterService(ServiceReferenceImpl.this);
            ServiceReferenceImpl.this.service = null;
        }
    }
}

