/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.concierge.ConciergeCollections;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private static String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Pattern LIST_TYPE_PATTERN = Pattern.compile("List\\s*<\\s*([^\\s]*)\\s*>");
    private static final String SPECIFICATION_VERSION = "specification-version";
    private static final short STRING_TYPE = 0;
    private static final short VERSION_TYPE = 1;
    private static final short LONG_TYPE = 2;
    private static final short DOUBLE_TYPE = 3;

    public static String[] splitString(String string, char c) {
        return Utils.splitString(string, c, Integer.MAX_VALUE);
    }

    static String[] splitString(String string, char c, int n) {
        int n2;
        int n3;
        if (string == null || string.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> arrayList = new ArrayList<String>(string.length() / 10);
        char[] cArray = string.toCharArray();
        int n4 = cArray.length;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (Character.isWhitespace(cArray[n7])) {
            ++n7;
        }
        n6 = n7;
        do {
            if (cArray[n7] == '\\') {
                n7 += 2;
                continue;
            }
            if (cArray[n7] == '\"') {
                n5 = n5 < 0 ? n7 : -1;
                ++n7;
                continue;
            }
            if (cArray[n7] == c && n5 < 0) {
                if (++n8 > n) break;
                for (n3 = n7 - 1; n3 > 0 && Character.isWhitespace(cArray[n3]); --n3) {
                }
                n2 = n3 - n6 + 1;
                if (n2 > 0) {
                    arrayList.add(new String(cArray, n6, n2));
                }
                ++n7;
                while (n7 < n4 && Character.isWhitespace(cArray[n7])) {
                    ++n7;
                }
                n6 = n7;
                continue;
            }
            ++n7;
        } while (n7 < n4);
        if (n5 > -1) {
            throw new IllegalArgumentException("Unmatched quotation mark at position " + n5);
        }
        for (n3 = n4 - 1; n3 > 0 && Character.isWhitespace(cArray[n3]); --n3) {
        }
        n2 = n3 - n6 + 1;
        if (n2 > 0) {
            arrayList.add(new String(cArray, n6, n2));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static ConciergeCollections.ParseResult parseLiterals(String[] stringArray, int n) throws BundleException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        for (int i = n; i < stringArray.length; ++i) {
            String[] stringArray2;
            int n2;
            String[] stringArray3 = Utils.splitString(stringArray[i], '=', 1);
            String string = stringArray3[0].trim();
            if (string.charAt(n2 = string.length() - 1) == ':') {
                stringArray2 = string.substring(0, n2).trim();
                if (hashMap.containsKey(stringArray2)) {
                    throw new BundleException("Duplicate directive '" + (String)stringArray2 + "'");
                }
                hashMap.put((String)stringArray2, Utils.unQuote(stringArray3[1].trim()));
                continue;
            }
            if (hashMap2.containsKey(string)) {
                throw new BundleException("Duplicate attribute " + string);
            }
            stringArray2 = Utils.splitString(string, ':');
            if (stringArray2.length > 1) {
                if (stringArray2.length != 2) {
                    throw new BundleException("Illegal attribute name " + string);
                }
                hashMap2.put(stringArray2[0], Utils.createValue(stringArray2[1].trim(), Utils.unQuote(stringArray3[1])));
                continue;
            }
            if ("version".equals(string) && stringArray3[1].indexOf(44) == -1) {
                hashMap2.put(string, new Version(Utils.unQuote(stringArray3[1].trim())));
                continue;
            }
            hashMap2.put(string, Utils.unQuote(stringArray3[1].trim()));
        }
        return new ConciergeCollections.ParseResult(hashMap, hashMap2);
    }

    private static Object createValue(String string, String string2) throws BundleException {
        Matcher matcher = LIST_TYPE_PATTERN.matcher(string);
        if (matcher.matches() || "List".equals(string)) {
            short s = matcher.matches() ? Utils.getType(matcher.group(1)) : (short)0;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            String[] stringArray = Utils.splitString(string2, ',');
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(Utils.createValue0(s, stringArray[i]));
            }
            return arrayList;
        }
        return Utils.createValue0(Utils.getType(string), string2);
    }

    private static short getType(String string) {
        if ("String".equals(string)) {
            return 0;
        }
        if ("Version".equals(string)) {
            return 1;
        }
        if ("Long".equals(string)) {
            return 2;
        }
        if ("Double".equals(string)) {
            return 3;
        }
        return -1;
    }

    private static Object createValue0(short s, String string) {
        switch (s) {
            case 0: {
                return string;
            }
            case 1: {
                return new Version(string.trim());
            }
            case 2: {
                return new Long(string.trim());
            }
            case 3: {
                return new Double(string.trim());
            }
        }
        throw new IllegalStateException("invalid type " + s);
    }

    public static String unQuote(String string) {
        String string2 = string.trim();
        int n = string2.length();
        int n2 = string2.charAt(0) == '\"' ? 1 : 0;
        int n3 = string2.charAt(string2.length() - 1) == '\"' ? n - 1 : n;
        return n2 == 0 && n3 == n ? string : string2.substring(n2, n3);
    }

    public static String createFilter(String string, String string2, Map<String, Object> map) throws BundleException {
        Object object = map.get("version");
        if ("osgi.wiring.package".equals(string) && object != null && map.containsKey(SPECIFICATION_VERSION)) {
            if (!new Version(Utils.unQuote((String)map.get(SPECIFICATION_VERSION))).equals(object)) {
                throw new BundleException("both version and specification-version are given for the import " + string2);
            }
            map.remove(SPECIFICATION_VERSION);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(string);
        stringBuffer.append('=');
        stringBuffer.append(string2);
        stringBuffer.append(')');
        if (map.size() == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.insert(0, "(&");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string3 = entry.getKey();
            Object object2 = entry.getValue();
            if ("version".equals(string3) || "bundle-version".equals(string3)) {
                if (object2 instanceof String) {
                    VersionRange versionRange = new VersionRange(Utils.unQuote((String)object2));
                    if (versionRange.getRight() == null) {
                        stringBuffer.append('(');
                        stringBuffer.append(string3);
                        stringBuffer.append(">=");
                        stringBuffer.append(versionRange.getLeft());
                        stringBuffer.append(')');
                        continue;
                    }
                    boolean bl = versionRange.getLeftType() == '(';
                    stringBuffer.append(bl ? "(!(" : "(");
                    stringBuffer.append(string3);
                    stringBuffer.append(bl ? "<=" : ">=");
                    stringBuffer.append(versionRange.getLeft());
                    stringBuffer.append(bl ? "))" : ")");
                    bl = versionRange.getRightType() == ')';
                    stringBuffer.append(bl ? "(!(" : "(");
                    stringBuffer.append(string3);
                    stringBuffer.append(bl ? ">=" : "<=");
                    stringBuffer.append(versionRange.getRight());
                    stringBuffer.append(bl ? "))" : ")");
                    continue;
                }
                stringBuffer.append('(');
                stringBuffer.append(string3);
                stringBuffer.append(">=");
                stringBuffer.append(object2);
                stringBuffer.append(')');
                continue;
            }
            stringBuffer.append("(");
            stringBuffer.append(string3);
            stringBuffer.append("=");
            stringBuffer.append(object2);
            stringBuffer.append(")");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

