/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge.compat.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.concierge.BundleImpl;
import org.eclipse.concierge.Concierge;
import org.eclipse.concierge.ConciergeCollections;
import org.eclipse.concierge.Resources;
import org.eclipse.concierge.Utils;
import org.eclipse.concierge.compat.LegacyBundleProcessing;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleManifestTwo
implements LegacyBundleProcessing {
    private static final String SPECIFICATION_VERSION = "specification-version";
    private static final String BUNDLE_REQUIREDEXECUTIONENVIRONMENT = "Bundle-RequiredExecutionEnvironment";
    private static final String FRAMEWORK_EXECUTIONENVIRONMENT = "org.osgi.framework.executionenvironment";
    private static final Pattern PARSE_EE = Pattern.compile("([^-|\\.]*)(?:\\-(\\d\\.\\d))(?:\\/([^\\d|\\.|\\/]*))|([^\\d|\\.|\\/]*)(?:\\/([^-|\\.]*)(?:\\-(\\d\\.\\d)))|([^\\.|\\d]*)");
    private static final Pattern PARSE_EE2 = Pattern.compile("([^-|\\.]*)(?:\\-(\\d\\.\\d))?(?:\\/([^-|\\.]*)(?:\\-(\\d\\.\\d))?)?");

    @Override
    public ConciergeCollections.Tuple<List<BundleCapability>, List<BundleRequirement>> processManifest(BundleImpl.Revision revision, Manifest manifest) throws BundleException {
        Object object;
        Version version;
        Attributes attributes = manifest.getMainAttributes();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        String string = attributes.getValue("Bundle-SymbolicName");
        if (string == null) {
            throw new BundleException("Bundle with Bundle-ManifestVersion=2 must specify Bundle-SymbolicName");
        }
        Object object2 = Utils.splitString(string, ';');
        if (object2[0].contains(";")) {
            throw new IllegalArgumentException(string);
        }
        Object object3 = Utils.parseLiterals((String[])object2, 1);
        HashMap<String, Object> hashMap = object3.getAttributes();
        String string2 = attributes.getValue("Fragment-Host");
        Object object4 = new HashMap<String, Object>(hashMap);
        Object object5 = new HashMap();
        String string3 = object2[0].trim();
        object4.put((String)"osgi.wiring.bundle", (Object)string3);
        try {
            version = Version.parseVersion(attributes.getValue("Bundle-Version"));
            object4.put((String)"bundle-version", (Object)version);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BundleException("Syntactic error in bundle manifest", illegalArgumentException);
        }
        HashMap<String, Object> hashMap2 = object3.getDirectives().get("singleton");
        object5.put("singleton", hashMap2 == null ? "false" : ((String)((Object)hashMap2)).trim());
        Object object6 = object3.getDirectives().get("mandatory");
        if (object6 != null) {
            object5.put("mandatory", object6);
        }
        if (string2 == null) {
            object = new Resources.BundleCapabilityImpl(revision, "osgi.wiring.bundle", (Map<String, String>)object5, (Map<String, Object>)object4, "Bundle " + string3 + ' ' + version);
            arrayList.add(object);
        }
        object = new HashMap<String, Object>((Map<String, Object>)object4);
        Object object7 = new HashMap<String, String>((Map<String, String>)object5);
        object.remove("osgi.wiring.bundle");
        object.put((String)"osgi.identity", (Object)string3);
        object.remove("bundle-version");
        object.put("version", version);
        object.put("type", string2 != null ? "osgi.fragment" : "osgi.bundle");
        this.addAttributeIfPresent((Map<String, Object>)object, "copyright", attributes, "Bundle-Copyright");
        this.addAttributeIfPresent((Map<String, Object>)object, "description", attributes, "Bundle-Description");
        this.addAttributeIfPresent((Map<String, Object>)object, "documentation", attributes, "Bundle-DocURL");
        this.addAttributeIfPresent((Map<String, Object>)object, "license", attributes, "Bundle-License");
        Resources.BundleCapabilityImpl bundleCapabilityImpl = new Resources.BundleCapabilityImpl(revision, "osgi.identity", (Map<String, String>)object7, (Map<String, Object>)object, "Identity " + string3 + ' ' + version);
        arrayList.add(bundleCapabilityImpl);
        if (string2 != null) {
            boolean bl;
            object4 = new HashMap();
            object5 = Utils.splitString(string2, ';');
            if (object5[0].contains(";")) {
                throw new IllegalArgumentException(string2);
            }
            hashMap2 = Utils.parseLiterals((String[])object5, 1);
            if (((ConciergeCollections.ParseResult)((Object)hashMap2)).getDirectives() != null) {
                object4.putAll(((ConciergeCollections.ParseResult)((Object)hashMap2)).getDirectives());
            }
            object4.remove("uses");
            object4.remove("effective");
            object4.put((String)"filter", (Object)Utils.createFilter("osgi.wiring.host", (String)object5[0], ((ConciergeCollections.ParseResult)((Object)hashMap2)).getAttributes()));
            object4.put("cardinality", "multiple");
            object4.put("osgi.wiring.host", object5[0]);
            object6 = (String)((ConciergeCollections.ParseResult)((Object)hashMap2)).getAttributes().get("bundle-version");
            if (object6 != null) {
                object4.put("bundle-version", object6);
            }
            boolean bl2 = bl = ((String)object5[0]).equals("system.bundle") || ((String)object5[0]).equals("org.eclipse.concierge");
            if (!Concierge.SUPPORTS_EXTENSIONS) {
                throw new BundleException("Framework does not support extensions");
            }
            if ("framework".equals(object4.get("extension")) || bl) {
                if (!bl) {
                    throw new BundleException("wrong host " + (String)object5[0] + " for an extension bundle");
                }
                if (attributes.getValue("Import-Package") != null) {
                    throw new BundleException("Framework extension bundle must not declare package imports");
                }
                if (attributes.getValue("Require-Bundle") != null) {
                    throw new BundleException("Framework extension bundle must not declare require bundle");
                }
                if (attributes.getValue("Bundle-NativeCode") != null) {
                    throw new BundleException("Framework extension bundle must not declare native code");
                }
            }
            object7 = new Resources.BundleRequirementImpl(revision, "osgi.wiring.host", (Map<String, String>)object4, null, "Fragment-Host " + (String)object5[0] + ' ' + (String)(object6 == null ? "" : object6));
            arrayList2.add(object7);
        } else if (!"never".equals(object3.getDirectives().get("fragment-attachment"))) {
            object4 = new HashMap();
            object5 = new HashMap();
            if (object3.getDirectives() != null) {
                object5.putAll(object3.getDirectives());
            }
            object4.putAll(hashMap);
            object4.put((String)"osgi.wiring.host", (Object)string3);
            object4.put((String)"bundle-version", (Object)version);
            object5.remove("uses");
            object5.remove("effective");
            hashMap2 = new Resources.BundleCapabilityImpl(revision, "osgi.wiring.host", (Map<String, String>)object5, (Map<String, Object>)object4, "Host " + string3 + ' ' + version);
            arrayList.add(hashMap2);
        }
        string = attributes.getValue(BUNDLE_REQUIREDEXECUTIONENVIRONMENT);
        if (string != null) {
            object2 = string.split(",");
            object3 = new StringBuffer();
            object3.append("osgi.ee; filter:=\"");
            if (((String[])object2).length > 1) {
                object3.append("(|");
            }
            for (int i = 0; i < ((String[])object2).length; ++i) {
                String string4;
                object4 = object2[i].trim();
                object5 = PARSE_EE.matcher((CharSequence)object4);
                if (((Matcher)object5).matches()) {
                    if (((Matcher)object5).group(1) != null) {
                        hashMap2 = ((Matcher)object5).group(1);
                        object6 = ((Matcher)object5).group(3);
                        string4 = ((Matcher)object5).group(2);
                    } else if (((Matcher)object5).group(4) != null) {
                        hashMap2 = ((Matcher)object5).group(4);
                        object6 = ((Matcher)object5).group(5);
                        string4 = ((Matcher)object5).group(6);
                    } else {
                        object7 = ((Matcher)object5).group(7);
                        int n = ((String)object7).indexOf(47);
                        hashMap2 = n > -1 ? ((String)object7).substring(0, n) : object7;
                        object6 = n > -1 ? ((String)object7).substring(n + 1, ((String)object7).length()) : null;
                        string4 = null;
                    }
                } else {
                    object7 = PARSE_EE2.matcher((CharSequence)object4);
                    if (((Matcher)object7).matches()) {
                        if (((Matcher)object7).group(4) == null || ((Matcher)object7).group(2).equals(((Matcher)object7).group(4))) {
                            hashMap2 = ((Matcher)object7).group(1);
                            string4 = ((Matcher)object7).group(2);
                            object6 = ((Matcher)object7).group(3);
                        } else {
                            hashMap2 = ((Matcher)object7).group(1) + "-" + ((Matcher)object7).group(2);
                            object6 = ((Matcher)object7).group(3) + "-" + ((Matcher)object7).group(4);
                            string4 = null;
                        }
                    } else {
                        throw new BundleException("invalid bree string " + (String)object4);
                    }
                }
                if (string4 != null) {
                    object3.append("(&(");
                } else {
                    object3.append('(');
                }
                object3.append("osgi.ee");
                object3.append('=');
                object3.append((String)("J2SE".equals(hashMap2) ? "JavaSE" : hashMap2));
                if (object6 != null) {
                    object3.append('/');
                    object3.append((String)object6);
                }
                if (string4 != null) {
                    object3.append(")(version=");
                    object3.append(string4);
                    object3.append("))");
                    continue;
                }
                object3.append(')');
            }
            if (((String[])object2).length > 1) {
                object3.append(')');
            }
            object3.append('\"');
            arrayList2.add(new Resources.BundleRequirementImpl(revision, object3.toString()));
        }
        object2 = new HashSet();
        object3 = attributes.getValue("Import-Package");
        if (object3 != null) {
            String[] stringArray = Utils.splitString((String)object3, ',');
            for (int i = 0; i < stringArray.length; ++i) {
                object5 = Utils.splitString(stringArray[i], ';');
                if (((String)object5[0]).startsWith("java.")) {
                    throw new BundleException("Explicit import of java.* packages is not permitted", 3);
                }
                if (object2.contains(object5[0])) {
                    throw new BundleException("Duplicate import " + (String)object5[0], 3);
                }
                object2.add(object5[0]);
                hashMap2 = Utils.parseLiterals((String[])object5, 1);
                object6 = ((ConciergeCollections.ParseResult)((Object)hashMap2)).getDirectives();
                ((HashMap)object6).put((String)"filter", (String)Utils.createFilter("osgi.wiring.package", (String)object5[0], ((ConciergeCollections.ParseResult)((Object)hashMap2)).getAttributes()));
                ((HashMap)object6).put("x-int", object5[0]);
                arrayList2.add(new Resources.BundleRequirementImpl(revision, "osgi.wiring.package", (Map<String, String>)object6, null, "Import-Package " + stringArray[i]));
            }
        }
        if ((object2 = attributes.getValue("DynamicImport-Package")) != null) {
            object3 = Utils.splitString((String)object2, ',');
            for (int i = 0; i < ((String[])object3).length; ++i) {
                String[] stringArray = Utils.splitString(object3[i], ';');
                object5 = Utils.parseLiterals(stringArray, 1);
                hashMap2 = ((ConciergeCollections.ParseResult)object5).getDirectives();
                hashMap2.put("filter", Utils.createFilter("osgi.wiring.package", stringArray[0], ((ConciergeCollections.ParseResult)object5).getAttributes()));
                hashMap2.put("resolution", "dynamic");
                hashMap2.put("effective", "active");
                hashMap2.put("x-int", stringArray[0].trim());
                if (stringArray[0].contains("*")) {
                    hashMap2.put("cardinality", "multiple");
                }
                arrayList2.add(new Resources.BundleRequirementImpl(revision, "osgi.wiring.package", (Map<String, String>)hashMap2, null, "DynamicImport-Package " + object3[i]));
            }
        }
        if ((object2 = attributes.getValue("Export-Package")) != null) {
            object3 = Utils.splitString((String)object2, ',');
            for (int i = 0; i < ((String[])object3).length; ++i) {
                String[] stringArray = Utils.splitString(object3[i], ';');
                object5 = Utils.parseLiterals(stringArray, 1);
                hashMap2 = ((ConciergeCollections.ParseResult)object5).getAttributes();
                if (hashMap2.containsKey("bundle-symbolic-name") || hashMap2.containsKey("bundle-version")) {
                    throw new BundleException("Export statement contains illegal attributes");
                }
                object6 = (String)hashMap2.get(SPECIFICATION_VERSION);
                if (object6 != null) {
                    Version version2 = (Version)hashMap2.get("version");
                    object7 = new Version(Utils.unQuote((String)object6));
                    if (version2 != null) {
                        if (!((Version)object7).equals(version2)) {
                            throw new BundleException("Both version and specificationVersion are given but versions are not identical");
                        }
                    } else {
                        hashMap2.put("version", object7);
                    }
                }
                hashMap2.put("osgi.wiring.package", stringArray[0].trim());
                if (stringArray[0].startsWith("java.")) {
                    throw new BundleException("Bundle must not export a java.* package");
                }
                hashMap2.put("bundle-symbolic-name", string3);
                hashMap2.put("bundle-version", version);
                arrayList.add(new Resources.BundleCapabilityImpl(revision, "osgi.wiring.package", ((ConciergeCollections.ParseResult)object5).getDirectives(), (Map<String, Object>)hashMap2, "Export-Package " + object3[i]));
            }
        }
        if ((object2 = attributes.getValue("Require-Bundle")) != null) {
            object3 = Utils.splitString((String)object2, ',');
            for (int i = 0; i < ((String[])object3).length; ++i) {
                String[] stringArray = Utils.splitString(object3[i], ';');
                object5 = stringArray[0].trim();
                hashMap2 = Utils.parseLiterals(stringArray, 1);
                object6 = ((ConciergeCollections.ParseResult)((Object)hashMap2)).getDirectives();
                String string5 = ((ConciergeCollections.ParseResult)((Object)hashMap2)).getDirectives().get("visibility");
                if ("reexport".equals(string5)) {
                    object6.put("visibility", "reexport");
                } else {
                    object6.put("visibility", "private");
                }
                if ("optional".equals(((ConciergeCollections.ParseResult)((Object)hashMap2)).getDirectives().get("resolution"))) {
                    object6.put("resolution", "optional");
                }
                object6.put("filter", Utils.createFilter("osgi.wiring.bundle", (String)object5, ((ConciergeCollections.ParseResult)((Object)hashMap2)).getAttributes()));
                object6.put("x-int", stringArray[0]);
                arrayList2.add(new Resources.BundleRequirementImpl(revision, "osgi.wiring.bundle", (Map<String, String>)object6, null, "Require-Bundle " + object3[i]));
            }
        }
        return new ConciergeCollections.Tuple<List<BundleCapability>, List<BundleRequirement>>(arrayList, arrayList2);
    }

    void addAttributeIfPresent(Map<String, Object> map, String string, Attributes attributes, String string2) {
        String string3 = attributes.getValue(string2);
        if (string3 != null) {
            map.put(string, string3);
        }
    }

    public static String parse(String string) throws BundleException {
        String[] stringArray = string.split(",");
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length > 1) {
            stringBuffer.append("(|");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string2;
            String string3;
            Object object2;
            String string4 = stringArray[i].trim();
            Matcher matcher = PARSE_EE.matcher(string4);
            if (matcher.matches()) {
                if (matcher.group(1) != null) {
                    object2 = matcher.group(1);
                    string3 = matcher.group(3);
                    string2 = matcher.group(2);
                } else if (matcher.group(4) != null) {
                    object2 = matcher.group(4);
                    string3 = matcher.group(5);
                    string2 = matcher.group(6);
                } else {
                    object = matcher.group(7);
                    int n = ((String)object).indexOf(47);
                    object2 = n > -1 ? ((String)object).substring(0, n) : object;
                    string3 = n > -1 ? ((String)object).substring(n + 1, ((String)object).length()) : null;
                    string2 = null;
                }
            } else {
                object = PARSE_EE2.matcher(string4);
                if (((Matcher)object).matches()) {
                    if (((Matcher)object).group(4) == null || ((Matcher)object).group(2).equals(((Matcher)object).group(4))) {
                        object2 = ((Matcher)object).group(1);
                        string2 = ((Matcher)object).group(2);
                        string3 = ((Matcher)object).group(3);
                    } else {
                        object2 = ((Matcher)object).group(1) + "-" + ((Matcher)object).group(2);
                        string3 = ((Matcher)object).group(3) + "-" + ((Matcher)object).group(4);
                        string2 = null;
                    }
                } else {
                    throw new BundleException("invalid bree string " + string4);
                }
            }
            if (string2 != null) {
                stringBuffer.append("(&(");
            } else {
                stringBuffer.append('(');
            }
            stringBuffer.append("osgi.ee");
            stringBuffer.append('=');
            stringBuffer.append((String)("J2SE".equals(object2) ? "JavaSE" : object2));
            if (string3 != null) {
                stringBuffer.append('/');
                stringBuffer.append(string3);
            }
            if (string2 != null) {
                stringBuffer.append(")(version=");
                stringBuffer.append(string2);
                stringBuffer.append("))");
                continue;
            }
            stringBuffer.append(')');
        }
        if (stringArray.length > 1) {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    @Override
    public List<BundleCapability> translateToCapability(Concierge concierge, String string, String string2) {
        if (FRAMEWORK_EXECUTIONENVIRONMENT.equals(string)) {
            String[] stringArray = Utils.splitString(string2, ',');
            ArrayList<BundleCapability> arrayList = new ArrayList<BundleCapability>();
            for (String string3 : stringArray) {
                Object object;
                String string4;
                String string5;
                Object object2;
                String string6 = string3.trim();
                Matcher matcher = PARSE_EE.matcher(string6);
                if (matcher.matches()) {
                    if (matcher.group(1) != null) {
                        object2 = matcher.group(1);
                        string5 = matcher.group(3);
                        string4 = matcher.group(2);
                    } else if (matcher.group(4) != null) {
                        object2 = matcher.group(4);
                        string5 = matcher.group(5);
                        string4 = matcher.group(6);
                    } else {
                        object = matcher.group(7);
                        int n = ((String)object).indexOf(47);
                        object2 = n > -1 ? ((String)object).substring(0, n) : object;
                        string5 = n > -1 ? ((String)object).substring(n + 1, ((String)object).length()) : null;
                        string4 = null;
                    }
                } else {
                    object = PARSE_EE2.matcher(string6);
                    if (((Matcher)object).matches()) {
                        if (((Matcher)object).group(4) == null || ((Matcher)object).group(2).equals(((Matcher)object).group(4))) {
                            object2 = ((Matcher)object).group(1);
                            string4 = ((Matcher)object).group(2);
                            string5 = ((Matcher)object).group(3);
                        } else {
                            object2 = ((Matcher)object).group(1) + "-" + ((Matcher)object).group(2);
                            string5 = ((Matcher)object).group(3) + "-" + ((Matcher)object).group(4);
                            string4 = null;
                        }
                    } else {
                        throw new IllegalStateException("invalid framework execution environment " + string6);
                    }
                }
                object = new HashMap<String, Object>();
                Object object3 = string5 == null ? object2 : (String)object2 + "/" + string5;
                object.put("osgi.ee", object3);
                if (string4 != null) {
                    object.put("version", new Version(string4));
                }
                Resources.BundleCapabilityImpl bundleCapabilityImpl = new Resources.BundleCapabilityImpl(concierge, "osgi.ee", null, (Map<String, Object>)object, "ExecutionEnvironment " + (String)object3 + (string4 == null ? "" : ' ' + string4));
                arrayList.add(bundleCapabilityImpl);
            }
            return arrayList;
        }
        return null;
    }
}

