/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.AdaptPermissionCollection;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.SignerProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AdaptPermission
extends BasicPermission {
    private static final long serialVersionUID = 1L;
    public static final String ADAPT = "adapt";
    private static final int ACTION_ADAPT = 1;
    private static final int ACTION_ALL = 1;
    static final int ACTION_NONE = 0;
    transient int action_mask;
    private volatile String actions = null;
    final transient Bundle bundle;
    transient Filter filter;
    private volatile transient Map<String, Object> properties;

    public AdaptPermission(String string, String string2) {
        this(AdaptPermission.parseFilter(string), AdaptPermission.parseActions(string2));
    }

    public AdaptPermission(String string, Bundle bundle, String string2) {
        super(string);
        this.setTransients(null, AdaptPermission.parseActions(string2));
        this.bundle = bundle;
        if (string == null) {
            throw new NullPointerException("adaptClass must not be null");
        }
        if (bundle == null) {
            throw new NullPointerException("adaptableBundle must not be null");
        }
    }

    AdaptPermission(Filter filter, int n) {
        super(filter == null ? "*" : filter.toString());
        this.setTransients(filter, n);
        this.bundle = null;
    }

    private void setTransients(Filter filter, int n) {
        this.filter = filter;
        if (n == 0 || (n & 1) != n) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
    }

    private static int parseActions(String string) {
        boolean bl = false;
        int n = 0;
        if (string == null) {
            return n;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        if (n2 < 0) {
            return n;
        }
        while (n2 != -1) {
            int n3;
            char c;
            while (n2 != -1 && ((c = cArray[n2]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n2;
            }
            if (!(n2 < 4 || cArray[n2 - 4] != 'a' && cArray[n2 - 4] != 'A' || cArray[n2 - 3] != 'd' && cArray[n2 - 3] != 'D' || cArray[n2 - 2] != 'a' && cArray[n2 - 2] != 'A' || cArray[n2 - 1] != 'p' && cArray[n2 - 1] != 'P' || cArray[n2] != 't' && cArray[n2] != 'T')) {
                n3 = 5;
                n |= 1;
            } else {
                throw new IllegalArgumentException("invalid actions: " + string);
            }
            bl = false;
            while (n2 >= n3 && !bl) {
                switch (cArray[n2 - n3]) {
                    case ',': {
                        bl = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n2;
            }
            n2 -= n3;
        }
        if (bl) {
            throw new IllegalArgumentException("invalid actions: " + string);
        }
        return n;
    }

    private static Filter parseFilter(String string) {
        if ((string = string.trim()).equals("*")) {
            return null;
        }
        try {
            return FrameworkUtil.createFilter(string);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid filter");
            illegalArgumentException.initCause(invalidSyntaxException);
            throw illegalArgumentException;
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof AdaptPermission)) {
            return false;
        }
        AdaptPermission adaptPermission = (AdaptPermission)permission;
        if (this.bundle != null) {
            return false;
        }
        if (adaptPermission.filter != null) {
            return false;
        }
        return this.implies0(adaptPermission, 0);
    }

    boolean implies0(AdaptPermission adaptPermission, int n) {
        int n2 = adaptPermission.action_mask;
        if (((n |= this.action_mask) & n2) != n2) {
            return false;
        }
        Filter filter = this.filter;
        if (filter == null) {
            return true;
        }
        return filter.matches(adaptPermission.getProperties());
    }

    @Override
    public String getActions() {
        String string = this.actions;
        if (string == null) {
            string = ADAPT;
            this.actions = ADAPT;
        }
        return string;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new AdaptPermissionCollection();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AdaptPermission)) {
            return false;
        }
        AdaptPermission adaptPermission = (AdaptPermission)object;
        return this.action_mask == adaptPermission.action_mask && this.getName().equals(adaptPermission.getName()) && (this.bundle == adaptPermission.bundle || this.bundle != null && this.bundle.equals(adaptPermission.bundle));
    }

    @Override
    public int hashCode() {
        int n = 527 + this.getName().hashCode();
        n = 31 * n + this.getActions().hashCode();
        if (this.bundle != null) {
            n = 31 * n + this.bundle.hashCode();
        }
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.bundle != null) {
            throw new NotSerializableException("cannot serialize");
        }
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setTransients(AdaptPermission.parseFilter(this.getName()), AdaptPermission.parseActions(this.actions));
    }

    private Map<String, Object> getProperties() {
        Map<String, Object> map = this.properties;
        if (map != null) {
            return map;
        }
        final HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
        hashMap.put("adaptClass", this.getName());
        if (this.bundle != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    SignerProperty signerProperty;
                    hashMap.put("id", new Long(AdaptPermission.this.bundle.getBundleId()));
                    hashMap.put("location", AdaptPermission.this.bundle.getLocation());
                    String string = AdaptPermission.this.bundle.getSymbolicName();
                    if (string != null) {
                        hashMap.put("name", string);
                    }
                    if ((signerProperty = new SignerProperty(AdaptPermission.this.bundle)).isBundleSigned()) {
                        hashMap.put("signer", signerProperty);
                    }
                    return null;
                }
            });
        }
        this.properties = hashMap;
        return this.properties;
    }
}

