/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.CapabilityPermission;
import org.osgi.framework.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CapabilityPermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = -615322242639008920L;
    private Map<String, CapabilityPermission> permissions = new HashMap<String, CapabilityPermission>();
    private boolean all_allowed = false;
    private Map<String, CapabilityPermission> filterPermissions;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", HashMap.class), new ObjectStreamField("all_allowed", Boolean.TYPE), new ObjectStreamField("filterPermissions", HashMap.class)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof CapabilityPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        CapabilityPermission capabilityPermission = (CapabilityPermission)permission;
        if (capabilityPermission.bundle != null) {
            throw new IllegalArgumentException("cannot add to collection: " + capabilityPermission);
        }
        String string = capabilityPermission.getName();
        Filter filter = capabilityPermission.filter;
        CapabilityPermissionCollection capabilityPermissionCollection = this;
        synchronized (capabilityPermissionCollection) {
            CapabilityPermission capabilityPermission2;
            Map<String, CapabilityPermission> map;
            if (filter != null) {
                map = this.filterPermissions;
                if (map == null) {
                    this.filterPermissions = map = new HashMap<String, CapabilityPermission>();
                }
            } else {
                map = this.permissions;
            }
            if ((capabilityPermission2 = map.get(string)) != null) {
                int n = capabilityPermission2.action_mask;
                int n2 = capabilityPermission.action_mask;
                if (n != n2) {
                    map.put(string, new CapabilityPermission(string, n | n2));
                }
            } else {
                map.put(string, capabilityPermission);
            }
            if (!this.all_allowed && string.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        Collection<CapabilityPermission> collection;
        if (!(permission instanceof CapabilityPermission)) {
            return false;
        }
        CapabilityPermission capabilityPermission = (CapabilityPermission)permission;
        if (capabilityPermission.filter != null) {
            return false;
        }
        String string = capabilityPermission.getName();
        int n = capabilityPermission.action_mask;
        int n2 = 0;
        CapabilityPermissionCollection capabilityPermissionCollection = this;
        synchronized (capabilityPermissionCollection) {
            int n3;
            CapabilityPermission capabilityPermission2;
            Map<String, CapabilityPermission> object = this.permissions;
            if (this.all_allowed && (capabilityPermission2 = object.get("*")) != null && ((n2 |= capabilityPermission2.action_mask) & n) == n) {
                return true;
            }
            capabilityPermission2 = object.get(string);
            if (capabilityPermission2 != null && ((n2 |= capabilityPermission2.action_mask) & n) == n) {
                return true;
            }
            int n4 = string.length() - 1;
            while ((n3 = string.lastIndexOf(".", n4)) != -1) {
                capabilityPermission2 = object.get(string = string.substring(0, n3 + 1) + "*");
                if (capabilityPermission2 != null && ((n2 |= capabilityPermission2.action_mask) & n) == n) {
                    return true;
                }
                n4 = n3 - 1;
            }
            Map<String, CapabilityPermission> map = this.filterPermissions;
            if (map == null) {
                return false;
            }
            collection = map.values();
        }
        for (CapabilityPermission capabilityPermission3 : collection) {
            if (!capabilityPermission3.implies0(capabilityPermission, n2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Enumeration<Permission> elements() {
        ArrayList<CapabilityPermission> arrayList = new ArrayList<CapabilityPermission>(this.permissions.values());
        Map<String, CapabilityPermission> map = this.filterPermissions;
        if (map != null) {
            arrayList.addAll(map.values());
        }
        return Collections.enumeration(arrayList);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("permissions", this.permissions);
        putField.put("all_allowed", this.all_allowed);
        putField.put("filterPermissions", this.filterPermissions);
        objectOutputStream.writeFields();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        HashMap hashMap;
        HashMap hashMap2;
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.permissions = hashMap2 = (HashMap)getField.get("permissions", null);
        this.all_allowed = getField.get("all_allowed", false);
        this.filterPermissions = hashMap = (HashMap)getField.get("filterPermissions", null);
    }
}

