/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.tracker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTracked<S, T, R> {
    static final boolean DEBUG = false;
    private final Map<S, T> tracked = new HashMap<S, T>();
    private int trackingCount = 0;
    private final List<S> adding = new ArrayList<S>(6);
    volatile boolean closed = false;
    private final LinkedList<S> initial = new LinkedList();

    AbstractTracked() {
    }

    void setInitial(S[] SArray) {
        if (SArray == null) {
            return;
        }
        for (S s : SArray) {
            if (s == null) continue;
            this.initial.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trackInitial() {
        while (true) {
            S s;
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.closed || this.initial.size() == 0) {
                    return;
                }
                s = this.initial.removeFirst();
                if (this.tracked.get(s) != null) {
                    continue;
                }
                if (this.adding.contains(s)) {
                    continue;
                }
                this.adding.add(s);
            }
            this.trackAdding(s, null);
        }
    }

    void close() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void track(S s, R r) {
        T t;
        AbstractTracked abstractTracked = this;
        synchronized (abstractTracked) {
            if (this.closed) {
                return;
            }
            t = this.tracked.get(s);
            if (t == null) {
                if (this.adding.contains(s)) {
                    return;
                }
                this.adding.add(s);
            } else {
                this.modified();
            }
        }
        if (t == null) {
            this.trackAdding(s, r);
        } else {
            this.customizerModified(s, r, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackAdding(S s, R r) {
        T t = null;
        boolean bl = false;
        try {
            t = this.customizerAdding(s, r);
        }
        finally {
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.adding.remove(s) && !this.closed) {
                    if (t != null) {
                        this.tracked.put(s, t);
                        this.modified();
                        this.notifyAll();
                    }
                } else {
                    bl = true;
                }
            }
        }
        if (bl && t != null) {
            this.customizerRemoved(s, r, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void untrack(S s, R r) {
        T t;
        AbstractTracked abstractTracked = this;
        synchronized (abstractTracked) {
            if (this.initial.remove(s)) {
                return;
            }
            if (this.adding.remove(s)) {
                return;
            }
            t = this.tracked.remove(s);
            if (t == null) {
                return;
            }
            this.modified();
        }
        this.customizerRemoved(s, r, t);
    }

    int size() {
        return this.tracked.size();
    }

    boolean isEmpty() {
        return this.tracked.isEmpty();
    }

    T getCustomizedObject(S s) {
        return this.tracked.get(s);
    }

    S[] copyKeys(S[] SArray) {
        return this.tracked.keySet().toArray(SArray);
    }

    void modified() {
        ++this.trackingCount;
    }

    int getTrackingCount() {
        return this.trackingCount;
    }

    <M extends Map<? super S, ? super T>> M copyEntries(M m) {
        m.putAll(this.tracked);
        return m;
    }

    abstract T customizerAdding(S var1, R var2);

    abstract void customizerModified(S var1, R var2, T var3);

    abstract void customizerRemoved(S var1, R var2, T var3);
}

