/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge.service.clusterinfo;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.concierge.service.clusterinfo.FrameworkNodeImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.clusterinfo.ClusterTagPermission;
import org.osgi.service.clusterinfo.FrameworkManager;
import org.osgi.service.clusterinfo.FrameworkNodeStatus;
import org.osgi.service.clusterinfo.NodeStatus;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private ServiceRegistration<?> reg;
    private ServiceTracker<?, ?> tracker;
    private Map<ServiceReference<?>, List<String>> tagMap = new HashMap();
    private Dictionary<String, Object> properties = new Hashtable<String, Object>();

    public void start(BundleContext context) throws Exception {
        FrameworkNodeImpl impl = new FrameworkNodeImpl(context);
        this.properties.put("osgi.clusterinfo.id", context.getProperty("org.osgi.framework.uuid").toString());
        String s = context.getProperty("org.eclipse.concierge.clusterinfo.cluster");
        this.properties.put("osgi.clusterinfo.cluster", s == null ? "default" : s);
        s = context.getProperty("org.eclipse.concierge.clusterinfo.endpoint");
        this.properties.put("osgi.clusterinfo.endpoint", s == null ? new String[]{} : s.split(","));
        s = context.getProperty("org.eclipse.concierge.clusterinfo.private.endpoint");
        this.properties.put("osgi.clusterinfo.private.endpoint", s == null ? new String[]{} : s.split(","));
        s = context.getProperty("org.eclipse.concierge.clusterinfo.vendor");
        this.properties.put("osgi.clusterinfo.vendor", s == null ? "Concierge" : s);
        s = context.getProperty("org.eclipse.concierge.clusterinfo.version");
        this.properties.put("osgi.clusterinfo.version", s == null ? "1.0.0" : s);
        s = context.getProperty("org.eclipse.concierge.clusterinfo.country");
        if (s != null) {
            this.properties.put("osgi.clusterinfo.country", s);
        }
        if ((s = context.getProperty("org.eclipse.concierge.clusterinfo.location")) != null) {
            this.properties.put("osgi.clusterinfo.location", s);
        }
        if ((s = context.getProperty("org.eclipse.concierge.clusterinfo.region")) != null) {
            this.properties.put("osgi.clusterinfo.region", s);
        }
        if ((s = context.getProperty("org.eclipse.concierge.clusterinfo.zone")) != null) {
            this.properties.put("osgi.clusterinfo.zone", s);
        }
        if ((s = context.getProperty("org.eclipse.concierge.clusterinfo.tags")) != null) {
            this.properties.put("osgi.clusterinfo.tags", s.split(","));
        }
        this.properties.put("org.osgi.framework.uuid", context.getProperty("org.osgi.framework.uuid").toString());
        this.properties.put("org.osgi.framework.version", context.getProperty("org.osgi.framework.version"));
        this.properties.put("org.osgi.framework.processor", context.getProperty("org.osgi.framework.processor"));
        this.properties.put("org.osgi.framework.os.name", context.getProperty("org.osgi.framework.os.name"));
        this.properties.put("org.osgi.framework.os.version", context.getProperty("org.osgi.framework.os.version"));
        this.properties.put("java.version", System.getProperty("java.version"));
        this.properties.put("java.vm.version", System.getProperty("java.vm.version"));
        this.properties.put("java.specification.version", System.getProperty("java.specification.version"));
        this.properties.put("java.runtime.version", System.getProperty("java.runtime.version"));
        this.properties.put("service.exported.interfaces", "*");
        this.reg = context.registerService(new String[]{FrameworkManager.class.getName(), NodeStatus.class.getName(), FrameworkNodeStatus.class.getName()}, (Object)impl, this.properties);
        if (this.properties.get("osgi.clusterinfo.tags") != null) {
            ArrayList<String> l = new ArrayList<String>();
            for (String t : (String[])this.properties.get("osgi.clusterinfo.tags")) {
                l.add(t);
            }
            this.tagMap.put(this.reg.getReference(), l);
        }
        this.tracker = new ServiceTracker(context, context.createFilter("(&(!(service.imported=*))(org.osgi.service.clusterinfo.tags=*))"), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                Activator.this.addTags(reference);
                Activator.this.updateTags();
                return null;
            }

            public void modifiedService(ServiceReference reference, Object service) {
                Activator.this.addTags(reference);
                Activator.this.updateTags();
            }

            public void removedService(ServiceReference reference, Object service) {
                Activator.this.tagMap.remove(reference);
                Activator.this.updateTags();
            }
        });
        this.tracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.reg != null) {
            this.reg.unregister();
        }
        this.tracker.close();
    }

    private void addTags(ServiceReference reference) {
        ArrayList<String> l = new ArrayList<String>();
        Object o = reference.getProperty("org.osgi.service.clusterinfo.tags");
        if (o instanceof String) {
            String tag = (String)o;
            SecurityManager sm = System.getSecurityManager();
            if (sm == null || reference.getBundle().hasPermission((Object)new ClusterTagPermission(tag, "ADD"))) {
                l.add(tag);
            }
        } else if (o instanceof String[]) {
            String[] tags = (String[])o;
            SecurityManager sm = System.getSecurityManager();
            for (String tag : tags) {
                if (sm != null && !reference.getBundle().hasPermission((Object)new ClusterTagPermission(tag, "ADD"))) continue;
                l.add(tag);
            }
        }
        this.tagMap.put(reference, l);
    }

    private void updateTags() {
        HashSet<String> tags = new HashSet<String>();
        for (List<String> t : this.tagMap.values()) {
            for (String tag : t) {
                tags.add(tag);
            }
        }
        this.properties.put("osgi.clusterinfo.tags", tags.toArray(new String[tags.size()]));
        this.reg.setProperties(this.properties);
    }
}

