/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge.service.clusterinfo;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.concierge.service.clusterinfo.MBeanMonitor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.dto.BundleDTO;
import org.osgi.framework.dto.FrameworkDTO;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.startlevel.dto.BundleStartLevelDTO;
import org.osgi.framework.startlevel.dto.FrameworkStartLevelDTO;
import org.osgi.service.clusterinfo.FrameworkNodeStatus;
import org.osgi.service.clusterinfo.NodeStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkNodeImpl
implements FrameworkNodeStatus {
    private final BundleContext context;
    private final NodeStatus monitor = new MBeanMonitor();

    public FrameworkNodeImpl(BundleContext context) {
        this.context = context;
    }

    @Override
    public Map<String, Object> getMetrics(String ... names) {
        return this.monitor.getMetrics(names);
    }

    @Override
    public BundleDTO getBundle(long id) {
        return (BundleDTO)this.context.getBundle(id).adapt(BundleDTO.class);
    }

    @Override
    public Map<String, String> getBundleHeaders(long id) {
        HashMap<String, String> map = new HashMap<String, String>();
        Dictionary headers = this.context.getBundle(id).getHeaders();
        Enumeration e = headers.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            map.put(key, (String)headers.get(key));
        }
        return map;
    }

    @Override
    public Collection<BundleDTO> getBundles() {
        FrameworkDTO framework = (FrameworkDTO)this.context.getBundle(0L).adapt(FrameworkDTO.class);
        return framework.bundles;
    }

    @Override
    public BundleStartLevelDTO getBundleStartLevel(long id) {
        return (BundleStartLevelDTO)this.context.getBundle(id).adapt(BundleStartLevelDTO.class);
    }

    @Override
    public int getBundleState(long id) {
        return this.context.getBundle(id).getState();
    }

    @Override
    public FrameworkStartLevelDTO getFrameworkStartLevel() {
        return (FrameworkStartLevelDTO)this.context.getBundle(0L).adapt(FrameworkStartLevelDTO.class);
    }

    @Override
    public ServiceReferenceDTO getServiceReference(long id) {
        for (ServiceReferenceDTO r : this.getServiceReferences()) {
            if (r.id != id) continue;
            return r;
        }
        return null;
    }

    @Override
    public Collection<ServiceReferenceDTO> getServiceReferences() {
        FrameworkDTO framework = (FrameworkDTO)this.context.getBundle(0L).adapt(FrameworkDTO.class);
        return framework.services;
    }

    @Override
    public Collection<ServiceReferenceDTO> getServiceReferences(String filter) throws InvalidSyntaxException {
        Filter f = this.context.createFilter(filter);
        ArrayList<ServiceReferenceDTO> filtered = new ArrayList<ServiceReferenceDTO>();
        for (ServiceReferenceDTO r : this.getServiceReferences()) {
            if (!f.matches(r.properties)) continue;
            filtered.add(r);
        }
        return filtered;
    }

    @Override
    public BundleDTO installBundle(String location) throws BundleException {
        Bundle b = this.context.installBundle(location);
        return (BundleDTO)b.adapt(BundleDTO.class);
    }

    @Override
    public void setBundleStartLevel(long id, int startLevel) {
        Bundle b = this.context.getBundle(id);
        if (b == null) {
            return;
        }
        BundleStartLevel bsl = (BundleStartLevel)b.adapt(BundleStartLevel.class);
        bsl.setStartLevel(startLevel);
    }

    @Override
    public void setFrameworkStartLevel(FrameworkStartLevelDTO startLevel) {
        Bundle fw = this.context.getBundle(0L);
        FrameworkStartLevel fwsl = (FrameworkStartLevel)fw.adapt(FrameworkStartLevel.class);
        fwsl.setInitialBundleStartLevel(startLevel.initialBundleStartLevel);
        fwsl.setStartLevel(startLevel.startLevel, new FrameworkListener[0]);
    }

    @Override
    public void startBundle(long id) throws BundleException {
        Bundle b = this.context.getBundle(id);
        if (b == null) {
            return;
        }
        b.start();
    }

    @Override
    public void startBundle(long id, int options) throws BundleException {
        Bundle b = this.context.getBundle(id);
        if (b == null) {
            return;
        }
        b.start(options);
    }

    @Override
    public void stopBundle(long id) throws BundleException {
        Bundle b = this.context.getBundle(id);
        if (b == null) {
            return;
        }
        b.stop();
    }

    @Override
    public void stopBundle(long id, int options) throws BundleException {
        Bundle b = this.context.getBundle(id);
        if (b == null) {
            return;
        }
        b.stop(options);
    }

    @Override
    public BundleDTO uninstallBundle(long id) throws BundleException {
        Bundle b = this.context.getBundle(id);
        if (b == null) {
            return null;
        }
        b.uninstall();
        return (BundleDTO)b.adapt(BundleDTO.class);
    }

    @Override
    public BundleDTO updateBundle(long id) throws BundleException {
        Bundle b = this.context.getBundle(id);
        if (b == null) {
            return null;
        }
        b.update();
        return (BundleDTO)b.adapt(BundleDTO.class);
    }

    @Override
    public BundleDTO updateBundle(long id, String url) throws BundleException, MalformedURLException, IOException {
        Bundle b = this.context.getBundle(id);
        if (b == null) {
            return null;
        }
        URL u = new URL(url);
        b.update(u.openStream());
        return (BundleDTO)b.adapt(BundleDTO.class);
    }
}

