/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge.service.clusterinfo;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.clusterinfo.NodeStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanMonitor
implements NodeStatus {
    private final OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
    private final MemoryMXBean memory = ManagementFactory.getMemoryMXBean();

    @Override
    public Map<String, Object> getMetrics(String ... names) {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        if (this.fill("availableProcessors", names)) {
            metrics.put("availableProcessors", this.os.getAvailableProcessors());
        }
        if (this.fill("systemLoadAverage", names)) {
            metrics.put("systemLoadAverage", this.os.getSystemLoadAverage());
        }
        if (this.fill("heapMemoryUsed", names)) {
            metrics.put("heapMemoryUsed", this.memory.getHeapMemoryUsage().getUsed());
        }
        if (this.fill("heapMemoryMax", names)) {
            metrics.put("heapMemoryMax", this.memory.getHeapMemoryUsage().getMax());
        }
        if (this.fill("nonHeapMemoryUsed", names)) {
            metrics.put("nonHeapMemoryUsed", this.memory.getNonHeapMemoryUsage().getUsed());
        }
        if (this.fill("nonHeapMemoryMax", names)) {
            metrics.put("nonHeapMemoryMax", this.memory.getNonHeapMemoryUsage().getMax());
        }
        return metrics;
    }

    private boolean fill(String key, String ... names) {
        if (names == null || names.length == 0) {
            return true;
        }
        for (String n : names) {
            if (!key.equals(n)) continue;
            return true;
        }
        return false;
    }
}

