/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.clusterinfo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.service.clusterinfo.ClusterTagPermissionCollection;

public final class ClusterTagPermission
extends Permission {
    private static final long serialVersionUID = 1L;
    public static final String ADD = "add";
    private static final int ACTION_ADD = 1;
    private static final int ACTION_ALL = 1;
    static final int ACTION_NONE = 0;
    private transient int action_mask;
    private volatile transient boolean all;
    private volatile String actions = null;

    public ClusterTagPermission(String tag, String actions) {
        this(tag, ClusterTagPermission.parseActions(actions));
    }

    ClusterTagPermission(String name, int mask) {
        super(name);
        this.setTransients(mask);
    }

    private synchronized void setTransients(int mask) {
        String name = this.getName();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("invalid name");
        }
        if (mask == 0 || (mask & 1) != mask) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = mask;
        this.all = name.equals("*");
    }

    synchronized int getActionsMask() {
        return this.action_mask;
    }

    private static int parseActions(String actions) {
        boolean seencomma = false;
        int mask = 0;
        if (actions == null) {
            return mask;
        }
        char[] a = actions.toCharArray();
        int i = a.length - 1;
        if (i < 0) {
            return mask;
        }
        while (i != -1) {
            char c;
            while (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --i;
            }
            if (i < 2 || a[i - 2] != 'a' && a[i - 2] != 'A' || a[i - 1] != 'd' && a[i - 1] != 'D' || a[i] != 'd' && a[i] != 'D') {
                throw new IllegalArgumentException("invalid actions: " + actions);
            }
            int matchlen = 3;
            mask = 1;
            seencomma = false;
            while (i >= matchlen && !seencomma) {
                switch (a[i - matchlen]) {
                    case ',': {
                        seencomma = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid actions: " + actions);
                    }
                }
                --i;
            }
            i -= matchlen;
        }
        if (seencomma) {
            throw new IllegalArgumentException("invalid actions: " + actions);
        }
        return mask;
    }

    public boolean implies(Permission p) {
        if (p instanceof ClusterTagPermission) {
            ClusterTagPermission requested = (ClusterTagPermission)p;
            int requestedMask = requested.getActionsMask();
            if ((this.getActionsMask() & requestedMask) == requestedMask) {
                if (this.all) {
                    return true;
                }
                String requestedName = requested.getName();
                return requestedName.equals(this.getName());
            }
        }
        return false;
    }

    public String getActions() {
        String result = this.actions;
        if (result == null) {
            result = ADD;
            this.actions = ADD;
        }
        return result;
    }

    public PermissionCollection newPermissionCollection() {
        return new ClusterTagPermissionCollection();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ClusterTagPermission)) {
            return false;
        }
        ClusterTagPermission p = (ClusterTagPermission)obj;
        return this.getActionsMask() == p.getActionsMask() && this.getName().equals(p.getName());
    }

    public int hashCode() {
        int h = 527 + this.getName().hashCode();
        h = 31 * h + this.getActions().hashCode();
        return h;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        s.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setTransients(ClusterTagPermission.parseActions(this.actions));
    }
}

