/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.clusterinfo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.clusterinfo.ClusterTagPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClusterTagPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 1L;
    private Map<String, ClusterTagPermission> permissions = new HashMap<String, ClusterTagPermission>();
    private boolean all_allowed = false;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", HashMap.class), new ObjectStreamField("all_allowed", Boolean.TYPE)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof ClusterTagPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        ClusterTagPermission p = (ClusterTagPermission)permission;
        String name = p.getName();
        ClusterTagPermissionCollection clusterTagPermissionCollection = this;
        synchronized (clusterTagPermissionCollection) {
            ClusterTagPermission existing = this.permissions.get(name);
            if (existing != null) {
                int newMask = p.getActionsMask();
                int oldMask = existing.getActionsMask();
                if (oldMask != newMask) {
                    this.permissions.put(name, new ClusterTagPermission(name, oldMask | newMask));
                }
            } else {
                this.permissions.put(name, p);
            }
            if (!this.all_allowed && name.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        ClusterTagPermission x;
        if (!(permission instanceof ClusterTagPermission)) {
            return false;
        }
        ClusterTagPermission requested = (ClusterTagPermission)permission;
        String name = requested.getName();
        int desired = requested.getActionsMask();
        int effective = 0;
        ClusterTagPermissionCollection clusterTagPermissionCollection = this;
        synchronized (clusterTagPermissionCollection) {
            if (this.all_allowed && (x = this.permissions.get("*")) != null && ((effective |= x.getActionsMask()) & desired) == desired) {
                return true;
            }
            x = this.permissions.get(name);
        }
        return x != null && ((effective |= x.getActionsMask()) & desired) == desired;
    }

    @Override
    public synchronized Enumeration<Permission> elements() {
        ArrayList<ClusterTagPermission> all = new ArrayList<ClusterTagPermission>(this.permissions.values());
        return Collections.enumeration(all);
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("permissions", this.permissions);
        pfields.put("all_allowed", this.all_allowed);
        out.writeFields();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        HashMap p;
        ObjectInputStream.GetField gfields = in.readFields();
        this.permissions = p = (HashMap)gfields.get("permissions", null);
        this.all_allowed = gfields.get("all_allowed", false);
    }
}

