/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.concierge.AbstractBundle;
import org.eclipse.concierge.BundleImpl;
import org.eclipse.concierge.ConciergeCollections;
import org.eclipse.concierge.Factory;
import org.eclipse.concierge.RFC1960Filter;
import org.eclipse.concierge.Resources;
import org.eclipse.concierge.ServiceReferenceImpl;
import org.eclipse.concierge.Utils;
import org.eclipse.concierge.compat.LegacyBundleProcessing;
import org.eclipse.concierge.compat.service.XargsFileLauncher;
import org.eclipse.concierge.service.log.LogServiceImpl;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.UnfilteredServiceListener;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.bundle.CollisionHook;
import org.osgi.framework.hooks.bundle.EventHook;
import org.osgi.framework.hooks.bundle.FindHook;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.framework.hooks.weaving.WeavingException;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;
import org.osgi.service.resolver.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Concierge
extends AbstractBundle
implements Framework,
BundleRevision,
FrameworkWiring,
FrameworkStartLevel,
BundleActivator {
    private static final String FRAMEWORK_EXECUTIONENVIRONMENT = "org.osgi.framework.executionenvironment";
    private static final String BUNDLE_REQUIREDEXECUTIONENVIRONMENT = "Bundle-RequiredExecutionEnvironment";
    private static final String BUNDLE_SYMBOLIC_NAME = "org.eclipse.concierge";
    private static final String FRAMEWORK_VERSION = "5.1.0";
    private static Class<?> SERVICE_EVENT_HOOK_CLASS = org.osgi.framework.hooks.service.EventHook.class;
    private static ConciergeURLStreamHandlerFactory conciergeURLStreamHandlerFactory = new ConciergeURLStreamHandlerFactory();
    public static boolean SUPPORTS_EXTENSIONS;
    private String BASEDIR;
    public String BUNDLE_LOCATION = "file:.";
    private int BEGINNING_STARTLEVEL;
    String STORAGE_LOCATION;
    static int CLASSLOADER_BUFFER_SIZE;
    boolean LOG_ENABLED;
    LogService logger;
    int LOG_BUFFER_SIZE;
    boolean LOG_QUIET;
    boolean ALWAYS_DECOMPRESS;
    boolean DECOMPRESS_EMBEDDED;
    int LOG_LEVEL;
    boolean SECURITY_ENABLED;
    boolean DEBUG_BUNDLES;
    boolean DEBUG_PACKAGES;
    boolean DEBUG_CLASSLOADING;
    boolean DEBUG_SERVICES;
    boolean DEBUG_RESOLVER;
    private String PROFILE;
    private final String[] bootdelegationAbs;
    private final String[] bootdelegationPrefix;
    private String[] libraryExtensions;
    private String execPermission;
    private Pattern execPermissionPattern;
    private static final int COLLISION_POLICY_SINGLE = -1;
    private static final int COLLISION_POLICY_NONE = 0;
    private static final int COLLISION_POLICY_MULTIPLE = 1;
    private static final int COLLISION_POLICY_MANAGED = 2;
    int collisionPolicy;
    private Hashtable<String, String> headers;
    private final Version version = new Version("1.5.0");
    static final HashSet<String> SUPPORTED_EE;
    static Comparator<AbstractBundle> VERSION_COMPARATOR;
    protected static final Pattern FILTER_ASSERT_MATCHER;
    List<AbstractBundle> bundles = new ArrayList<AbstractBundle>(2);
    Map<Long, AbstractBundle> bundleID_bundles = new HashMap<Long, AbstractBundle>(2);
    Map<String, AbstractBundle> location_bundles = Collections.synchronizedMap(new HashMap(2));
    ConciergeCollections.MultiMap<String, AbstractBundle> symbolicName_bundles = new ConciergeCollections.MultiMap(2);
    final ConciergeCollections.MultiMap<String, ServiceReference<?>> serviceRegistry = new ConciergeCollections.MultiMap(3);
    final ConciergeCollections.MultiMap<String, ServiceReference<?>> microServices = new ConciergeCollections.MultiMap(3);
    protected final List<BundleListener> bundleListeners = new ArrayList<BundleListener>(1);
    protected final List<SynchronousBundleListener> syncBundleListeners = new ArrayList<SynchronousBundleListener>(1);
    protected final ConciergeCollections.MultiMap<BundleContext, BundleListener> bundleListenerMap = new ConciergeCollections.MultiMap();
    protected final List<ServiceListenerEntry> serviceListeners = new ArrayList<ServiceListenerEntry>(1);
    private final ConciergeCollections.MultiMap<String, BundleImpl.Revision> fragmentIndex = new ConciergeCollections.MultiMap(1);
    private final ArrayList<BundleImpl> extensionBundles = new ArrayList(0);
    protected final List<FrameworkListener> frameworkListeners = new ArrayList<FrameworkListener>(1);
    CapabilityRegistry capabilityRegistry = new CapabilityRegistry();
    Map<Resource, Wiring> wirings = new HashMap<Resource, Wiring>();
    private long nextBundleID = 1L;
    int initStartlevel = 1;
    public boolean restart = false;
    public static final String FRAMEWORK_SYMBOLIC_NAME = "org.eclipse.concierge";
    private final List<BundleCapability> systemBundleCapabilities = new ArrayList<BundleCapability>();
    private static Properties defaultProperties;
    String osname;
    Version osversion;
    String language;
    String processor;
    final Properties properties;
    private final List<ServiceReferenceImpl<CollisionHook>> bundleCollisionHooks = new ArrayList<ServiceReferenceImpl<CollisionHook>>(0);
    private final List<ServiceReferenceImpl<EventHook>> bundleEventHooks = new ArrayList<ServiceReferenceImpl<EventHook>>(0);
    protected final List<ServiceReferenceImpl<FindHook>> bundleFindHooks = new ArrayList<ServiceReferenceImpl<FindHook>>(0);
    protected List<ServiceReferenceImpl<ResolverHookFactory>> resolverHookFactories = new ArrayList<ServiceReferenceImpl<ResolverHookFactory>>(0);
    protected List<ServiceReferenceImpl<org.osgi.framework.hooks.service.EventHook>> serviceEventHooks = new ArrayList<ServiceReferenceImpl<org.osgi.framework.hooks.service.EventHook>>(0);
    protected List<ServiceReferenceImpl<ListenerHook>> serviceListenerHooks = new ArrayList<ServiceReferenceImpl<ListenerHook>>(0);
    protected List<ServiceReferenceImpl<EventListenerHook>> serviceEventListenerHooks = new ArrayList<ServiceReferenceImpl<EventListenerHook>>(0);
    protected List<ServiceReferenceImpl<org.osgi.framework.hooks.service.FindHook>> serviceFindHooks = new ArrayList<ServiceReferenceImpl<org.osgi.framework.hooks.service.FindHook>>(0);
    private final List<ServiceReferenceImpl<WeavingHook>> weavingHooks = new ArrayList<ServiceReferenceImpl<WeavingHook>>(0);
    protected final HashMap<String, List<?>> hooks = new HashMap();
    private FrameworkEvent stopEvent = new FrameworkEvent(64, this, null);
    private final BundleStartLevel systemBundleStartLevel = new SystemBundleStartLevel();
    private final ResolverImpl resolver = new ResolverImpl();
    private final Method addURL;
    final ClassLoader parentClassLoader;
    final ClassLoader systemBundleClassLoader;
    protected static final Comparator<? super Capability> BUNDLE_VERSION;
    protected static final Comparator<? super Capability> EXPORT_ORDER;
    public static final String DIR_INTERNAL = "x-int";
    private static final int MAIN_RC_OK = 0;
    private static final int MAIN_RC_USAGE = 1;
    private boolean firstInit = true;
    private boolean inResolve = false;

    static final Dictionary<String, Object> props2Dict(Properties props) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        for (Object key : Collections.list(props.propertyNames())) {
            String keyStr = (String)key;
            table.put(keyStr, props.getProperty(keyStr));
        }
        return table;
    }

    public static void main(String[] args) throws Exception {
        Concierge framework = Concierge.doMain(args);
        if (framework != null) {
            framework.waitForStop(0L);
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public static Concierge doMain(String[] args) throws Exception {
        Concierge fw;
        XargsFileLauncher xargsLauncher = new XargsFileLauncher(System.err);
        String xargsFile = null;
        StringBuffer argsBuf = new StringBuffer();
        for (int i = 0; args != null && i < args.length; ++i) {
            if ("-help".equalsIgnoreCase(args[i])) {
                System.err.println("Concierge usage: org.eclipse.concierge.Concierge {arguments}\n  {file.xargs}                                 Loads xargs file, must end with .xargs\n  {-install|-start|-istart} {bundle-jar-file}  Install and start one bundle (can be used multiple times, in specified order)\n  {-all} {directory}                           Install and start all bundles from specified directory\n  {-Dprop=value}                               Specify one or more props just for Concierge (can be used multiple times)\nSample: org.eclipse.concierge.Concierge -Dorg.osgi.framework.bootdelegation=sun.*,javax.* -istart mybundle.jar\n");
                return null;
            }
            if (args[i].endsWith(".xargs")) {
                xargsFile = args[i];
                break;
            }
            argsBuf.append(args[i]);
            if (args[i].startsWith("-D")) {
                argsBuf.append('\n');
                continue;
            }
            if (!args[i].equalsIgnoreCase("-profile") && !args[i].equalsIgnoreCase("-install") && !args[i].equalsIgnoreCase("-istart") && !args[i].equalsIgnoreCase("-start") && !args[i].equalsIgnoreCase("-all") || i - 1 >= args.length) continue;
            argsBuf.append(' ');
            argsBuf.append(args[++i]);
            argsBuf.append('\n');
        }
        if (xargsFile == null && argsBuf.length() == 0 && (xargsFile = System.getProperty("org.eclipse.concierge.init.xargs")) == null) {
            xargsFile = "init.xargs";
        }
        if (xargsFile != null) {
            File xargs = new File(xargsFile);
            if (xargs.exists()) {
                fw = xargsLauncher.processXargsFile(xargs);
            } else {
                System.err.println("Concierge: xargs file '" + xargs.toString() + "' not found, starting without arguments");
                fw = (Concierge)new Factory().newFramework(null);
                fw.init();
                fw.start();
            }
        } else {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(argsBuf.toString().getBytes(Charset.forName("UTF-8")));
            Map<String, String> passedProperties = xargsLauncher.getPropertiesFromXargsInputStream(inputStream);
            inputStream = new ByteArrayInputStream(argsBuf.toString().getBytes(Charset.forName("UTF-8")));
            fw = xargsLauncher.processXargsInputStream(passedProperties, inputStream);
        }
        return fw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    Concierge(Map<String, String> passedProperties) {
        void var15_39;
        void var9_13;
        this.hooks.put(CollisionHook.class.getName(), this.bundleCollisionHooks);
        this.hooks.put(FindHook.class.getName(), this.bundleFindHooks);
        this.hooks.put(EventHook.class.getName(), this.bundleEventHooks);
        this.hooks.put(ResolverHookFactory.class.getName(), this.resolverHookFactories);
        this.hooks.put(SERVICE_EVENT_HOOK_CLASS.getName(), this.serviceEventHooks);
        this.hooks.put(EventListenerHook.class.getName(), this.serviceEventListenerHooks);
        this.hooks.put(org.osgi.framework.hooks.service.FindHook.class.getName(), this.serviceFindHooks);
        this.hooks.put(ListenerHook.class.getName(), this.serviceListenerHooks);
        this.hooks.put(WeavingHook.class.getName(), this.weavingHooks);
        defaultProperties = new Properties(System.getProperties());
        defaultProperties.setProperty("org.osgi.framework.bootdelegation", "java.*, sun.*, com.sun.*");
        defaultProperties.setProperty("org.osgi.framework.bundle.parent", "boot");
        defaultProperties.setProperty("org.osgi.framework.startlevel.beginning", "1");
        String feeStr = defaultProperties.getProperty(FRAMEWORK_EXECUTIONENVIRONMENT);
        StringBuffer myEEs = new StringBuffer();
        StringBuffer seVersionList = new StringBuffer();
        StringBuffer compact1VersionList = new StringBuffer();
        StringBuffer compact2VersionList = new StringBuffer();
        StringBuffer compact3VersionList = new StringBuffer();
        StringBuffer minVersionList = new StringBuffer();
        int parsed = 0;
        String specVersion = System.getProperty("java.specification.version");
        if (specVersion.indexOf(46) == -1) {
            try {
                int minor2;
                Object var14_11;
                try {
                    parsed = Integer.parseInt(specVersion);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    var14_11 = null;
                    minor2 = parsed;
                }
                var14_11 = null;
                minor2 = parsed;
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                int minor2 = parsed;
                throw throwable;
            }
        } else {
            try {
                int minor3;
                Object var16_24;
                try {
                    parsed = Integer.parseInt(specVersion.substring(2));
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    var16_24 = null;
                    minor3 = parsed;
                }
                var16_24 = null;
                minor3 = parsed;
            }
            catch (Throwable throwable) {
                Object var16_25 = null;
                int minor3 = parsed;
                throw throwable;
            }
        }
        if (System.getProperty("java.specification.name", "").equals("J2ME Foundation Specification")) {
            switch (var9_13) {
                case 1: {
                    myEEs.append("CDC-1.1/Foundation-1.1,");
                }
                case 0: {
                    myEEs.append("CDC-1.0/Foundation-1.0");
                }
            }
        } else {
            switch (var9_13) {
                case 11: {
                    myEEs.append("JavaSE-11");
                }
                case 9: {
                    myEEs.append("JavaSE-9");
                }
                case 8: {
                    myEEs.append("J2SE-1.8,");
                    myEEs.append("JavaSE-1.8,");
                    try {
                        myEEs.append("JavaSE-1.8/compact1,");
                        compact1VersionList.append("1.8,");
                        Class.forName("org.w3c.dom.Document", false, this.getClass().getClassLoader());
                        myEEs.append("JavaSE-1.8/compact2,");
                        compact2VersionList.append("1.8,");
                        Class.forName("javax.management.Descriptor", false, this.getClass().getClassLoader());
                        myEEs.append("JavaSE-1.8/compact3,");
                        compact3VersionList.append("1.8,");
                        Class.forName("javax.imageio.ImageIO", false, this.getClass().getClassLoader());
                    }
                    catch (ClassNotFoundException nfe) {
                        // empty catch block
                    }
                    seVersionList.append("1.8,");
                }
                case 7: {
                    myEEs.append("J2SE-1.7,");
                    myEEs.append("JavaSE-1.7,");
                    seVersionList.append("1.7,");
                }
                case 6: {
                    myEEs.append("J2SE-1.6,");
                    myEEs.append("JavaSE-1.6,");
                    seVersionList.append("1.6,");
                }
                case 5: {
                    myEEs.append("J2SE-1.5,");
                    seVersionList.append("1.5,");
                }
                case 4: {
                    myEEs.append("J2SE-1.4,");
                    myEEs.append("OSGi/Minimum-1.1,");
                    seVersionList.append("1.4,");
                    minVersionList.append("1.2,1.1,");
                }
                case 3: {
                    myEEs.append("J2SE-1.3,");
                    seVersionList.append("1.3,");
                }
                case 2: {
                    myEEs.append("J2SE-1.2,");
                    myEEs.append("OSGi/Minimum-1.0,");
                    seVersionList.append("1.2,");
                    minVersionList.append("1.0");
                }
                case 1: {
                    myEEs.append("JRE-1.1");
                    seVersionList.append("1.1");
                }
            }
        }
        defaultProperties.setProperty(FRAMEWORK_EXECUTIONENVIRONMENT, myEEs.toString());
        try {
            Object line;
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("META-INF/micro-services");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                try {
                    String[] stringArray = Utils.splitString((String)line, ' ');
                    Hashtable<String, Version> props = new Hashtable<String, Version>();
                    ((Dictionary)props).put("version", Version.parseVersion(stringArray[2]));
                    Class<?> cls = Class.forName(stringArray[1]);
                    Object service = cls.newInstance();
                    ServiceReferenceImpl ref = new ServiceReferenceImpl(this, this, service, props, new String[]{stringArray[0]});
                    this.microServices.insert(stringArray[0], ref);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.serviceRegistry.insertMap(this.microServices);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        try {
            Resources.BundleCapabilityImpl eeCap;
            if (seVersionList.length() > 0) {
                eeCap = new Resources.BundleCapabilityImpl(this, "osgi.ee; osgi.ee=\"JavaSE\"; version:List<Version>=\"" + seVersionList.toString() + "\"");
                this.systemBundleCapabilities.add(eeCap);
            }
            if (compact1VersionList.length() > 0) {
                eeCap = new Resources.BundleCapabilityImpl(this, "osgi.ee; osgi.ee=\"JavaSE/compact1\"; version:List<Version>=\"" + compact1VersionList.toString() + "\"");
                this.systemBundleCapabilities.add(eeCap);
            }
            if (compact2VersionList.length() > 0) {
                eeCap = new Resources.BundleCapabilityImpl(this, "osgi.ee; osgi.ee=\"JavaSE/compact2\"; version:List<Version>=\"" + compact2VersionList.toString() + "\"");
                this.systemBundleCapabilities.add(eeCap);
            }
            if (compact3VersionList.length() > 0) {
                eeCap = new Resources.BundleCapabilityImpl(this, "osgi.ee; osgi.ee=\"JavaSE/compact3\"; version:List<Version>=\"" + compact3VersionList.toString() + "\"");
                this.systemBundleCapabilities.add(eeCap);
            }
            if (minVersionList.length() > 0) {
                eeCap = new Resources.BundleCapabilityImpl(this, "osgi.ee; osgi.ee=\"OSGi/Minimum\"; version:List<Version>=\"" + minVersionList.toString() + "\"");
                this.systemBundleCapabilities.add(eeCap);
            }
        }
        catch (BundleException be) {
            be.printStackTrace();
        }
        if (feeStr != null) {
            LegacyBundleProcessing proc = this.getService(LegacyBundleProcessing.class, LegacyBundleProcessing.VERSION_TWO);
            if (proc == null) {
                this.warning("Framework execution environment is ignored because no bundle manifest version 2 processor is available in this deployment");
            } else {
                List<BundleCapability> feeCaps = proc.translateToCapability(this, FRAMEWORK_EXECUTIONENVIRONMENT, feeStr);
                this.systemBundleCapabilities.addAll(feeCaps);
            }
        }
        defaultProperties.setProperty("org.osgi.framework.system.packages", "org.osgi.framework;version=1.7,org.osgi.framework.hooks.bundle;version=1.1,org.osgi.framework.hooks.resolver;version=1.0,org.osgi.framework.hooks.service;version=1.1,org.osgi.framework.hooks.weaving;version=1.0,org.osgi.framework.launch;version=1.1,org.osgi.framework.namespace;version=1.0,org.osgi.framework.startlevel;version=1.0,org.osgi.framework.wiring;version=1.1,org.osgi.resource;version=1.0,org.osgi.service.log;version=1.3,org.osgi.service.packageadmin;version=1.2,org.osgi.service.startlevel;version=1.1,org.osgi.service.url;version=1.0,org.osgi.service.resolver;version=1.0,org.osgi.util.tracker;version=1.5.1,META-INF.services");
        String obj = System.getProperty("os.name");
        defaultProperties.put("org.osgi.framework.os.name", obj != null ? obj : "undefined");
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            defaultProperties.put("org.osgi.framework.os.name", "MacOSX");
        } else if ("Mac OS".equals(System.getProperty("os.name"))) {
            defaultProperties.put("org.osgi.framework.os.name", "MacOS");
        }
        obj = System.getProperty("os.version");
        defaultProperties.put("org.osgi.framework.os.version", obj != null ? obj : "undefined");
        obj = System.getProperty("os.arch");
        defaultProperties.put("org.osgi.framework.processor", obj != null ? obj : "undefined");
        String lang = Locale.getDefault().getLanguage();
        defaultProperties.setProperty("org.osgi.framework.language", lang != null ? lang : "en");
        defaultProperties.setProperty("org.osgi.framework.startlevel.beginning", "3");
        defaultProperties.setProperty("org.osgi.framework.storage", "storage");
        this.properties = new Properties(defaultProperties){
            private static final long serialVersionUID = -3319768973242656809L;

            public String getProperty(String key) {
                String launchS;
                Object launchO = this.get(key);
                String string = launchS = launchO instanceof String ? (String)launchO : null;
                if (launchS != null) {
                    return launchS;
                }
                String system = System.getProperty(key);
                return system == null ? this.defaults.getProperty(key) : system;
            }
        };
        if (passedProperties != null) {
            for (Map.Entry entry : passedProperties.entrySet()) {
                if (entry.getValue() == null) continue;
                this.properties.put(entry.getKey(), entry.getValue());
            }
        }
        this.systemBundleClassLoader = this.getClass().getClassLoader();
        String p = this.properties.getProperty("org.osgi.framework.bundle.parent");
        if ("app".equals(p)) {
            this.parentClassLoader = ClassLoader.getSystemClassLoader();
        } else if ("framework".equals(p)) {
            this.parentClassLoader = this.systemBundleClassLoader;
        } else if ("ext".equals(p)) {
            void var15_34;
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            while (var15_34.getParent() != null) {
                ClassLoader classLoader2 = var15_34.getParent();
            }
            this.parentClassLoader = var15_34;
        } else {
            this.parentClassLoader = new ClassLoader(Object.class.getClassLoader()){};
        }
        this.properties.setProperty("org.osgi.supports.framework.extension", Boolean.toString(false));
        Object var15_37 = null;
        if (this.getClass().getClassLoader() instanceof URLClassLoader) {
            try {
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                this.properties.setProperty("org.osgi.supports.framework.extension", Boolean.toString(true));
                SUPPORTS_EXTENSIONS = true;
            }
            catch (Exception e) {
                this.logger.log(2, "Could not hijack classloader for framework extensions", e);
            }
        }
        this.addURL = var15_39;
        this.properties.setProperty("org.osgi.framework.version", this.version.toString());
        this.properties.setProperty("org.osgi.framework.vendor", "Eclipse Foundation");
        this.properties.setProperty("org.osgi.supports.bootclasspath.extension", Boolean.toString(false));
        this.properties.setProperty("org.osgi.supports.framework.fragment", Boolean.toString(true));
        this.properties.setProperty("org.osgi.supports.framework.requirebundle", Boolean.toString(true));
        this.PROFILE = this.properties.getProperty("org.eclipse.concierge.profile", "default");
        this.BASEDIR = this.properties.getProperty("org.eclipse.concierge.basedir", ".");
        this.BUNDLE_LOCATION = this.properties.getProperty("org.eclipse.concierge.jars", "file:" + this.BASEDIR);
        CLASSLOADER_BUFFER_SIZE = this.getProperty("org.eclipse.concierge.classloader.buffersize", 2048);
        this.LOG_ENABLED = this.getProperty("org.eclipse.concierge.log.enabled", false);
        this.LOG_QUIET = this.getProperty("org.eclipse.concierge.log.quiet", false);
        this.LOG_BUFFER_SIZE = this.getProperty("org.eclipse.concierge.log.buffersize", 10);
        this.LOG_LEVEL = this.getProperty("org.eclipse.concierge.log.level", 1);
        this.DEBUG_BUNDLES = this.getProperty("org.eclipse.concierge.debug.bundles", false);
        this.DEBUG_PACKAGES = this.getProperty("org.eclipse.concierge.debug.packages", false);
        this.DEBUG_SERVICES = this.getProperty("org.eclipse.concierge.debug.services", false);
        this.DEBUG_RESOLVER = this.getProperty("org.eclipse.concierge.debug.resolver", false);
        this.DEBUG_CLASSLOADING = this.getProperty("org.eclipse.concierge.debug.classloading", false);
        if (this.getProperty("org.eclipse.concierge.debug", false)) {
            System.out.println("SETTING ALL DEBUG FLAGS");
            this.LOG_ENABLED = true;
            this.LOG_LEVEL = 4;
            this.DEBUG_BUNDLES = true;
            this.DEBUG_PACKAGES = true;
            this.DEBUG_SERVICES = true;
            this.DEBUG_CLASSLOADING = true;
            this.DEBUG_RESOLVER = true;
            this.LOG_LEVEL = 4;
        }
        this.ALWAYS_DECOMPRESS = this.getProperty("org.eclipse.concierge.alwaysDecompress", false);
        this.DECOMPRESS_EMBEDDED = this.getProperty("org.eclipse.concierge.decompressEmbedded", true);
        this.SECURITY_ENABLED = this.getProperty("org.eclipse.concierge.security.enabled", false);
        String bsl = this.properties.getProperty("org.osgi.framework.startlevel.beginning");
        try {
            this.BEGINNING_STARTLEVEL = Integer.parseInt(bsl);
        }
        catch (NumberFormatException nfe) {
            this.warning("Invalid initial startlevel " + bsl);
            System.err.println("FALLING BACK TO DEFAULT BEGINNING STARTLEVEL (=1)");
            this.BEGINNING_STARTLEVEL = 1;
        }
        String[] bds = Utils.splitString(this.properties.getProperty("org.osgi.framework.bootdelegation"), ',');
        ArrayList<String> bdsAbs = new ArrayList<String>();
        ArrayList<String> bdsRel = new ArrayList<String>();
        for (int i = 0; i < bds.length; ++i) {
            int pos = bds[i].indexOf(42);
            if (pos < 0) {
                bdsAbs.add(bds[i]);
                continue;
            }
            if (pos < bds[i].length() - 1) {
                throw new IllegalArgumentException("Framework bootdelegation " + bds[i] + " is not supported");
            }
            bdsRel.add(bds[i].substring(0, pos));
        }
        bdsRel.remove("java.");
        this.bootdelegationAbs = bdsAbs.toArray(new String[bdsAbs.size()]);
        this.bootdelegationPrefix = bdsRel.toArray(new String[bdsRel.size()]);
        if (!this.LOG_ENABLED && (this.DEBUG_BUNDLES || this.DEBUG_PACKAGES || this.DEBUG_SERVICES || this.DEBUG_CLASSLOADING)) {
            System.err.println("Logger disabled, ignoring debug flags.");
            this.DEBUG_BUNDLES = false;
            this.DEBUG_PACKAGES = false;
            this.DEBUG_SERVICES = false;
            this.DEBUG_CLASSLOADING = false;
        }
        if (System.getSecurityManager() == null && this.SECURITY_ENABLED) {
            this.warning("No security manager set, ignoring security flag.");
            this.SECURITY_ENABLED = false;
        }
        this.location = "System Bundle";
        this.state = 2;
        this.context = new BundleContextImpl(this);
        this.domain = Concierge.class.getProtectionDomain();
        this.headers = new Hashtable(5);
    }

    private boolean getProperty(String key, boolean defaultVal) {
        String val = this.properties.getProperty(key);
        return val != null ? Boolean.valueOf(val) : defaultVal;
    }

    private int getProperty(String key, int defaultVal) {
        String val = this.properties.getProperty(key);
        return val != null ? Integer.parseInt(val) : defaultVal;
    }

    private void warning(String message) throws RuntimeException {
        if (this.getProperty("org.eclipse.concierge.strictStartup", false)) {
            throw new RuntimeException(message);
        }
        System.err.println("WARNING: " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws BundleException {
        if (this.state == 32 || this.state == 8 || this.state == 16) {
            return;
        }
        StringTokenizer t = new StringTokenizer(this.properties.getProperty(FRAMEWORK_EXECUTIONENVIRONMENT), ",");
        while (t.hasMoreTokens()) {
            SUPPORTED_EE.add(t.nextToken().trim());
        }
        this.STORAGE_LOCATION = this.properties.getProperty("org.eclipse.concierge.storage", this.properties.getProperty("org.osgi.framework.storage", this.BASEDIR + File.separatorChar + "storage")) + File.separatorChar + this.PROFILE + File.separatorChar;
        File storage = new File(this.STORAGE_LOCATION);
        if (storage.exists()) {
            if (this.firstInit && "onFirstInit".equals(this.properties.getProperty("org.osgi.framework.storage.clean"))) {
                Concierge.deleteDirectory(storage);
            } else {
                this.restart = true;
            }
        }
        if (!storage.exists() && !storage.mkdirs()) {
            throw new BundleException("Could not create storage directory " + storage);
        }
        this.firstInit = false;
        this.startlevel = 0;
        String bsnversion = this.properties.getProperty("org.osgi.framework.bsnversion");
        if (bsnversion == null) {
            this.collisionPolicy = 0;
        } else if (bsnversion.equals("single")) {
            this.collisionPolicy = -1;
        } else if (bsnversion.equals("multiple")) {
            this.collisionPolicy = 1;
        } else if (bsnversion.equals("managed")) {
            this.collisionPolicy = 2;
        }
        String os = this.properties.getProperty("org.osgi.framework.os.name");
        this.osversion = new Version(Concierge.sanitizeVersion(this.properties.getProperty("org.osgi.framework.os.version")));
        this.language = new Locale(this.properties.getProperty("org.osgi.framework.language"), "").getLanguage();
        String cpu = this.properties.getProperty("org.osgi.framework.processor").intern();
        this.osname = os.toLowerCase().startsWith("win") ? "Windows" : os;
        this.processor = cpu == "pentium" || cpu == "i386" || cpu == "i486" || cpu == "i586" || cpu == "i686" ? "x86" : (cpu == "amd64" || cpu == "em64t" || cpu == "x86_64" || cpu == "x86-64" ? "x86-64" : cpu);
        String libExtStr = this.properties.getProperty("org.osgi.framework.library.extensions");
        if (libExtStr == null && this.osname.startsWith("MacOS")) {
            libExtStr = "dylib,jnilib";
        }
        if (libExtStr != null) {
            this.libraryExtensions = Utils.splitString(libExtStr, ',');
        }
        this.execPermission = this.properties.getProperty("org.osgi.framework.command.execpermission");
        if (this.execPermission != null) {
            this.execPermissionPattern = Pattern.compile("\\$\\{" + this.properties.getProperty("abspath", "abspath") + "\\}");
        }
        this.headers.put("Bundle-ManifestVersion", "2");
        this.headers.put("Bundle-Name", "org.eclipse.concierge");
        this.headers.put("Bundle-Version", FRAMEWORK_VERSION);
        this.headers.put(BUNDLE_REQUIREDEXECUTIONENVIRONMENT, "OSGi/Minimum-1.1, CDC-1.1/Foundation-1.1");
        this.headers.put("Bundle-SymbolicName", "org.eclipse.concierge");
        String extraPkgs = this.properties.getProperty("org.osgi.framework.system.packages.extra");
        String sysPkgs = extraPkgs == null ? this.properties.getProperty("org.osgi.framework.system.packages") : this.properties.getProperty("org.osgi.framework.system.packages") + "," + extraPkgs;
        String[] framework_pkgs = Utils.splitString(sysPkgs, ',');
        this.exportSystemBundlePackages(framework_pkgs);
        this.headers.put("Export-Package", sysPkgs);
        this.headers.put("Bundle-Vendor", "Eclipse Foundation");
        this.bundleID_bundles.put(new Long(0L), this);
        this.location_bundles.put("System Bundle", this);
        this.symbolicName_bundles.insert("system.bundle", this);
        this.symbolicName_bundles.insert("org.eclipse.concierge", this);
        String extraCaps = this.properties.getProperty("org.osgi.framework.system.capabilities.extra");
        if (extraCaps != null) {
            String[] capStrs;
            for (String capStr : capStrs = Utils.splitString(extraCaps, ',')) {
                try {
                    Resources.BundleCapabilityImpl cap = new Resources.BundleCapabilityImpl(this, capStr);
                    this.systemBundleCapabilities.add(cap);
                }
                catch (BundleException be) {
                    be.printStackTrace();
                }
            }
        }
        Resources.BundleCapabilityImpl sysbundleCap = new Resources.BundleCapabilityImpl(this, "osgi.wiring.bundle; osgi.wiring.bundle=system.bundle");
        this.systemBundleCapabilities.add(sysbundleCap);
        Resources.BundleCapabilityImpl sysbundleDefaultHostCap = new Resources.BundleCapabilityImpl(this, "osgi.wiring.host; osgi.wiring.host=system.bundle");
        this.systemBundleCapabilities.add(sysbundleDefaultHostCap);
        Resources.BundleCapabilityImpl sysbundleHostCap = new Resources.BundleCapabilityImpl(this, "osgi.wiring.host; osgi.wiring.host=org.eclipse.concierge");
        this.systemBundleCapabilities.add(sysbundleHostCap);
        this.publishCapabilities(this.systemBundleCapabilities);
        this.wirings.put(this, new Resources.ConciergeBundleWiring(this, null));
        this.registeredServices = new ArrayList(2);
        if (this.LOG_ENABLED) {
            LogServiceImpl impl = new LogServiceImpl(this.LOG_BUFFER_SIZE, this.LOG_LEVEL, this.LOG_QUIET);
            ServiceReferenceImpl<LogServiceImpl> readerref = new ServiceReferenceImpl<LogServiceImpl>(this, this, impl, null, new String[]{LogReaderService.class.getName()});
            this.logger = impl.factory.getService(null, null);
            ServiceReferenceImpl<ServiceFactory<LogService>> logref = new ServiceReferenceImpl<ServiceFactory<LogService>>(this, this, impl.factory, null, new String[]{LogService.class.getName()});
            ConciergeCollections.MultiMap<String, ServiceReference<?>> multiMap = this.serviceRegistry;
            synchronized (multiMap) {
                this.serviceRegistry.insert(LogReaderService.class.getName(), readerref);
                this.serviceRegistry.insert(LogService.class.getName(), logref);
            }
            this.registeredServices.add(logref);
            this.registeredServices.add(readerref);
            if (this.DEBUG_SERVICES) {
                this.logger.log(4, "Framework has registered LogService and LogReaderService.");
            }
        }
        try {
            conciergeURLStreamHandlerFactory.setConcierge(this);
            URL.setURLStreamHandlerFactory(conciergeURLStreamHandlerFactory);
        }
        catch (Error error) {
            // empty catch block
        }
        this.properties.setProperty("org.osgi.framework.uuid", UUID.randomUUID().toString());
        this.state = 8;
        if (this.restart) {
            this.restoreProfile();
        }
    }

    private void exportSystemBundlePackages(String[] pkgs) throws BundleException {
        for (String pkg : pkgs) {
            String[] literals = Utils.splitString(pkg, ';');
            if (literals.length <= 0) continue;
            ConciergeCollections.ParseResult parseResult = Utils.parseLiterals(literals, 1);
            HashMap<String, Object> attrs = parseResult.getAttributes();
            attrs.put("osgi.wiring.package", literals[0].trim());
            this.systemBundleCapabilities.add(new Resources.BundleCapabilityImpl(this, "osgi.wiring.package", parseResult.getDirectives(), attrs, "Export-Package " + pkg));
        }
    }

    private static String sanitizeVersion(String verStr) {
        int dot = 0;
        int len = verStr.length();
        char[] chars = verStr.toCharArray();
        for (int c = 0; c < len; ++c) {
            if (chars[c] == '.' && dot < 2) {
                ++dot;
                continue;
            }
            if (Character.isDigit(chars[c])) continue;
            return verStr.substring(0, c);
        }
        return verStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized FrameworkEvent waitForStop(long timeout) throws InterruptedException {
        if (this.state == 8 || this.state == 16 || this.state == 32) {
            Concierge concierge = this;
            synchronized (concierge) {
                this.wait(timeout);
            }
            if (this.state != 4 && this.state != 2) {
                return new FrameworkEvent(512, this, null);
            }
        }
        FrameworkEvent event = this.stopEvent;
        this.stopEvent = new FrameworkEvent(64, this, null);
        return event;
    }

    @Override
    public void start() throws BundleException {
        if (this.state != 8) {
            this.init();
        }
        if (this.state == 32) {
            return;
        }
        try {
            System.out.println("---------------------------------------------------------");
            System.out.println("  Concierge OSGi 5.1.0 on " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " starting ... (" + this.PROFILE + ") startlevel=" + this.BEGINNING_STARTLEVEL);
            System.out.println("---------------------------------------------------------");
            long time = System.currentTimeMillis();
            for (BundleImpl ext : this.extensionBundles) {
                ext.state = 4;
            }
            this.start(this.context);
            this.setLevel(this.bundles.toArray(new Bundle[this.bundles.size()]), this.BEGINNING_STARTLEVEL, false);
            if (!this.restart) {
                this.storeProfile();
            }
            float timediff = (float)(System.currentTimeMillis() - time) / 1000.0f;
            System.out.println("---------------------------------------------------------");
            System.out.println("  Framework " + (this.restart ? "restarted" : "started") + " in " + timediff + " seconds.");
            System.out.println("---------------------------------------------------------");
            System.out.flush();
        }
        catch (Exception e) {
            this.notifyFrameworkListeners(2, this, new BundleException("Exception during framework start", 7, e));
        }
        this.state = 32;
        this.notifyFrameworkListeners(1, this, null);
    }

    private void storeProfile() {
        BundleImpl[] bundleArray = this.bundles.toArray(new BundleImpl[this.bundles.size()]);
        for (int i = 0; i < bundleArray.length; ++i) {
            if (bundleArray[i].state == 1) continue;
            bundleArray[i].updateMetadata();
        }
        this.storeMetadata();
    }

    void storeMetadata() {
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(new File(this.STORAGE_LOCATION, "meta")));
            out.writeLong(this.nextBundleID);
            out.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void restoreProfile() {
        try {
            File file;
            if (this.DEBUG_BUNDLES) {
                this.logger.log(4, "restoring profile " + this.PROFILE);
            }
            if (!(file = new File(this.STORAGE_LOCATION, "meta")).exists()) {
                this.warning("Profile " + this.PROFILE + " not found, performing clean start ...");
                this.restart = false;
                return;
            }
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            this.nextBundleID = in.readLong();
            in.close();
            File storageDir = new File(this.STORAGE_LOCATION);
            File[] bundleDirs = storageDir.listFiles();
            for (int i = 0; i < bundleDirs.length; ++i) {
                File meta;
                if (!bundleDirs[i].isDirectory() || !(meta = new File(bundleDirs[i], "meta")).exists()) continue;
                try {
                    BundleImpl bundle = new BundleImpl(this, meta);
                    if (this.DEBUG_BUNDLES) {
                        this.logger.log(4, "RESTORED BUNDLE " + bundle.location);
                    }
                    this.bundles.add(bundle);
                    this.bundleID_bundles.put(new Long(bundle.bundleId), bundle);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    boolean bootdelegation(String pkg) {
        int i;
        for (i = 0; i < this.bootdelegationPrefix.length; ++i) {
            if (!pkg.startsWith(this.bootdelegationPrefix[i])) continue;
            return true;
        }
        for (i = 0; i < this.bootdelegationAbs.length; ++i) {
            if (!pkg.equals(this.bootdelegationAbs[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void start(int options) throws BundleException {
        this.start();
    }

    @Override
    public void stop() throws BundleException {
        new Thread(){

            public void run() {
                Concierge.this.stop0(false);
            }
        }.start();
    }

    @Override
    public void stop(int options) throws BundleException {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop0(boolean update) {
        this.state = 16;
        if (!update) {
            System.out.println("---------------------------------------------------------");
            System.out.println("  Concierge OSGi shutting down ...");
            System.out.println("  Bye !");
            System.out.println("---------------------------------------------------------");
            System.out.flush();
        }
        try {
            this.setLevel(this.bundles.toArray(new Bundle[this.bundles.size()]), 0, true);
            this.state = 4;
            this.stop(this.context);
            for (AbstractBundle bundle : this.bundles) {
                for (BundleRevision rev : bundle.getRevisions()) {
                    ((BundleImpl.Revision)rev).close();
                }
            }
            this.bundles.clear();
            this.bundleID_bundles.clear();
            this.serviceRegistry.clear();
            this.serviceRegistry.insertMap(this.microServices);
            conciergeURLStreamHandlerFactory.setConcierge(null);
            this.stopEvent = new FrameworkEvent(update ? 128 : 64, this, null);
            Concierge concierge = this;
            synchronized (concierge) {
                this.notify();
            }
        }
        catch (Exception e) {
            this.stopEvent = new FrameworkEvent(2, this, new BundleException("Exception during framework start", e));
            this.notify();
        }
    }

    @Override
    public void uninstall() throws BundleException {
        throw new BundleException("System bundle cannot be uninstalled.");
    }

    @Override
    public void update() throws BundleException {
        final int state = this.state;
        new Thread(){

            public void run() {
                Concierge.this.stop0(true);
                try {
                    if (state == 8) {
                        Concierge.this.init();
                    } else if (state == 32) {
                        Concierge.this.start();
                    }
                }
                catch (BundleException be) {
                    be.printStackTrace();
                }
                Concierge.this.state = state;
            }
        }.start();
    }

    @Override
    public void update(InputStream in) throws BundleException {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.update();
    }

    @Override
    public String getSymbolicName() {
        return "org.eclipse.concierge";
    }

    @Override
    public Enumeration<String> getEntryPaths(String path) {
        return null;
    }

    @Override
    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        return null;
    }

    @Override
    public URL getEntry(String path) {
        return null;
    }

    @Override
    public <A> A adapt(Class<A> type) {
        if (type == BundleStartLevel.class) {
            return (A)this.systemBundleStartLevel;
        }
        if (type == BundleWiring.class) {
            return (A)this.wirings.get(this);
        }
        if (type.isInstance(this)) {
            return (A)this;
        }
        return null;
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public ServiceReference<?>[] getServicesInUse() {
        return null;
    }

    @Override
    public URL getResource(String name) {
        return this.systemBundleClassLoader.getResource(name);
    }

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        return this.headers;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.systemBundleClassLoader.loadClass(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.systemBundleClassLoader.getResources(name);
    }

    @Override
    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
        return null;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public String toString() {
        return "Concierge System Bundle";
    }

    @Override
    public int getStartLevel() {
        return this.startlevel;
    }

    @Override
    public void setStartLevel(final int targetLevel, final FrameworkListener ... listeners) {
        if (targetLevel <= 0) {
            throw new IllegalArgumentException("Start level " + targetLevel + " is not a valid level");
        }
        new Thread(){

            public void run() {
                Concierge.this.setLevel(Concierge.this.bundles.toArray(new Bundle[Concierge.this.bundles.size()]), targetLevel, false);
                Concierge.this.notifyFrameworkListeners(8, Concierge.this, null);
                if (listeners != null) {
                    Concierge.this.notifyFrameworkListeners(listeners, 8, Concierge.this, null);
                }
                Concierge.this.storeMetadata();
            }
        }.start();
    }

    @Override
    public int getInitialBundleStartLevel() {
        return this.initStartlevel;
    }

    @Override
    public void setInitialBundleStartLevel(int targetStartLevel) {
        if (targetStartLevel <= 0) {
            throw new IllegalArgumentException("Start level " + targetStartLevel + " is not a valid level");
        }
        this.initStartlevel = targetStartLevel;
    }

    protected void setLevel(Bundle[] bundleArray, int targetLevel, boolean all) {
        int i;
        if (this.startlevel == targetLevel) {
            return;
        }
        boolean up = targetLevel > this.startlevel;
        int levels = up ? targetLevel - this.startlevel : this.startlevel - targetLevel;
        ConciergeCollections.MultiMap<Integer, AbstractBundle> startLevels = new ConciergeCollections.MultiMap<Integer, AbstractBundle>(0);
        for (i = 0; i < bundleArray.length; ++i) {
            int offset;
            AbstractBundle bundle = (AbstractBundle)bundleArray[i];
            if (bundle == this || bundle.state == 1 || up && bundle.autostart == 0 || !up && bundle.state == 4 || (offset = up ? bundle.startlevel - this.startlevel - 1 : this.startlevel - bundle.startlevel) < 0 || offset >= levels) continue;
            startLevels.insert(new Integer(offset), bundle);
        }
        for (i = 0; i < levels; ++i) {
            this.startlevel = up ? ++this.startlevel : --this.startlevel;
            Object list = startLevels.get(new Integer(i));
            if (list == null) continue;
            BundleImpl[] toProcess = list.toArray(new BundleImpl[list.size()]);
            for (int j = 0; j < toProcess.length; ++j) {
                try {
                    if (up) {
                        toProcess[j].activate(toProcess[j].isActivationPolicyUsed() ? 2 : 0);
                        continue;
                    }
                    if (toProcess[toProcess.length - j - 1].getState() == 1) continue;
                    toProcess[toProcess.length - j - 1].stopBundle();
                    continue;
                }
                catch (BundleException be) {
                    if (be.getNestedException() != null) {
                        be.getNestedException().printStackTrace();
                    }
                    be.printStackTrace();
                    this.notifyFrameworkListeners(2, up ? toProcess[j] : toProcess[toProcess.length - j - 1], be);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.notifyFrameworkListeners(2, up ? toProcess[j] : toProcess[toProcess.length - j - 1], t);
                }
            }
        }
        this.startlevel = targetLevel;
    }

    @Override
    public List<BundleCapability> getDeclaredCapabilities(String namespace) {
        ArrayList<BundleCapability> filteredCapabilities = new ArrayList<BundleCapability>();
        if (namespace != null) {
            for (BundleCapability c : this.systemBundleCapabilities) {
                if (!c.getNamespace().equals(namespace)) continue;
                filteredCapabilities.add(c);
            }
        } else {
            filteredCapabilities.addAll(this.systemBundleCapabilities);
        }
        return Collections.unmodifiableList(filteredCapabilities);
    }

    @Override
    public List<BundleRequirement> getDeclaredRequirements(String namespace) {
        return Collections.emptyList();
    }

    @Override
    public int getTypes() {
        return 0;
    }

    @Override
    public BundleWiring getWiring() {
        return (BundleWiring)this.wirings.get(this);
    }

    @Override
    public List<Capability> getCapabilities(String namespace) {
        return Collections.unmodifiableList(new ArrayList<BundleCapability>(this.getDeclaredCapabilities(namespace)));
    }

    @Override
    public List<Requirement> getRequirements(String namespace) {
        return Collections.emptyList();
    }

    @Override
    public void refreshBundles(final Collection<Bundle> bundleCollection, final FrameworkListener ... listeners) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Concierge concierge = Concierge.this;
                    synchronized (concierge) {
                        Bundle[] initial = bundleCollection == null ? Concierge.this.bundles.toArray(new Bundle[Concierge.this.bundles.size()]) : bundleCollection.toArray(new Bundle[bundleCollection.size()]);
                        ArrayList<Bundle> toProcess = new ArrayList<Bundle>();
                        block11: for (int i = 0; i < initial.length; ++i) {
                            if (initial[i] == Concierge.this || initial[i].getState() == 2) continue;
                            BundleImpl theBundle = (BundleImpl)initial[i];
                            if (bundleCollection == null) {
                                if (theBundle.currentRevision == null || theBundle.currentRevision != theBundle.revisions.get(0)) {
                                    toProcess.add(theBundle);
                                    continue;
                                }
                                if (theBundle.currentRevision.fragments == null) continue;
                                for (BundleImpl.Revision fragment : theBundle.currentRevision.fragments) {
                                    if (fragment.getBundle().getState() != 1) continue;
                                    toProcess.add(initial[i]);
                                    continue block11;
                                }
                                continue;
                            }
                            toProcess.add(initial[i]);
                        }
                        if (toProcess.isEmpty()) {
                            this.notifyListeners(4, Concierge.this, null);
                            return;
                        }
                        if (Concierge.this.LOG_ENABLED && Concierge.this.DEBUG_PACKAGES) {
                            Concierge.this.logger.log(4, "REFRESHING PACKAGES FROM BUNDLES " + toProcess);
                        }
                        Collection<Bundle> updateGraph = Concierge.this.getDependencyClosure(toProcess);
                        if (Concierge.this.LOG_ENABLED && Concierge.this.DEBUG_PACKAGES) {
                            Concierge.this.logger.log(4, "UPDATE GRAPH IS " + updateGraph);
                        }
                        ArrayList<Bundle> tmp = new ArrayList<Bundle>(updateGraph);
                        Collections.sort(tmp);
                        Bundle[] refreshArray = tmp.toArray(new Bundle[tmp.size()]);
                        ArrayList<BundleImpl> restartList = new ArrayList<BundleImpl>();
                        for (int i = 0; i < refreshArray.length; ++i) {
                            BundleImpl bundleImpl = (BundleImpl)refreshArray[i];
                            try {
                                if (bundleImpl.state == 32) {
                                    bundleImpl.stop();
                                    restartList.add(0, bundleImpl);
                                }
                                if (bundleImpl.state == 4) {
                                    bundleImpl.state = 2;
                                }
                                bundleImpl.refresh();
                                if (bundleImpl.state == 1) {
                                    Concierge.this.bundles.remove(bundleImpl);
                                    continue;
                                }
                                Concierge.this.notifyBundleListeners(64, bundleImpl);
                                continue;
                            }
                            catch (Exception e) {
                                this.notifyListeners(2, refreshArray[i], e);
                            }
                        }
                        Iterator resolveIter = restartList.iterator();
                        while (resolveIter.hasNext()) {
                            BundleImpl bundleImpl = (BundleImpl)resolveIter.next();
                            try {
                                boolean success;
                                if (bundleImpl.state != 2 || (success = bundleImpl.currentRevision.resolve(false))) continue;
                                resolveIter.remove();
                            }
                            catch (Exception e) {
                                resolveIter.remove();
                                this.notifyListeners(2, bundleImpl, e);
                            }
                        }
                        for (Bundle bundle : restartList) {
                            try {
                                bundle.start();
                            }
                            catch (Exception e) {
                                this.notifyListeners(2, bundle, e);
                            }
                        }
                        this.notifyListeners(4, Concierge.this, null);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }

            private void notifyListeners(int type, Bundle b, Exception e) {
                if (type == 2) {
                    e.printStackTrace();
                }
                Concierge.this.notifyFrameworkListeners(type, b, e);
                if (listeners != null) {
                    Concierge.this.notifyFrameworkListeners(listeners, type, b, e);
                }
            }
        }.start();
    }

    @Override
    public boolean resolveBundles(Collection<Bundle> bundles) {
        ArrayList<BundleRevision> resources = new ArrayList<BundleRevision>();
        boolean resolved = true;
        for (Bundle bundle : bundles == null ? this.bundles : bundles) {
            if (bundle.getState() == 1) {
                resolved = false;
                continue;
            }
            resources.add(bundle.adapt(BundleRevision.class));
        }
        try {
            return resolved &= this.resolve(resources, false);
        }
        catch (BundleException e) {
            return false;
        }
    }

    private HashMap<ResolverHook, ServiceReferenceImpl<ResolverHookFactory>> getResolverHooks(Collection<BundleRevision> bundles) throws Throwable {
        LinkedHashMap<ResolverHook, ServiceReferenceImpl<ResolverHookFactory>> hooks = new LinkedHashMap<ResolverHook, ServiceReferenceImpl<ResolverHookFactory>>();
        ServiceReferenceImpl[] factories = this.resolverHookFactories.toArray(new ServiceReferenceImpl[this.resolverHookFactories.size()]);
        try {
            for (int i = 0; i < factories.length; ++i) {
                ServiceReferenceImpl sref = factories[i];
                ResolverHookFactory factory = (ResolverHookFactory)sref.getService(this);
                if (factory == null) continue;
                ResolverHook hook = factory.begin(Collections.unmodifiableCollection(bundles));
                if (hook != null) {
                    hooks.put(hook, sref);
                }
                sref.ungetService(this);
            }
        }
        catch (Throwable t) {
            for (ResolverHook hook : hooks.keySet()) {
                hook.end();
            }
            throw t;
        }
        return hooks;
    }

    private void endResolverHooks(HashMap<ResolverHook, ServiceReferenceImpl<ResolverHookFactory>> hooks) throws BundleException {
        if (hooks == null) {
            return;
        }
        Throwable error = null;
        for (Map.Entry<ResolverHook, ServiceReferenceImpl<ResolverHookFactory>> entry : hooks.entrySet()) {
            if (entry.getValue().service == null) {
                error = new BundleException("Something unregistered a hook that was in use.", 12);
                continue;
            }
            try {
                entry.getKey().end();
            }
            catch (Throwable t) {
                error = t;
            }
        }
        if (error != null) {
            throw new BundleException("Error", 12, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<BundleCapability> resolveDynamic(BundleRevision trigger, String pkg, String dynImportPackage, BundleRequirement dynImport, boolean multiple) {
        String filterStr;
        List<Capability> candidates;
        block14: {
            candidates = null;
            if (this.resolver.hooks == null) {
                this.resolver.hooks = this.getResolverHooks(Arrays.asList(trigger));
            }
            filterStr = dynImport.getDirectives().get("filter");
            if (multiple) {
                candidates = this.capabilityRegistry.getAll("osgi.wiring.package");
            } else if (filterStr == null) {
                candidates = this.capabilityRegistry.getByValue("osgi.wiring.package", dynImportPackage);
            } else {
                try {
                    candidates = RFC1960Filter.filterWithIndex(dynImport, filterStr, this.capabilityRegistry);
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            }
            if (candidates != null && !candidates.isEmpty()) break block14;
            this.endResolverHooks(this.resolver.hooks);
            List<BundleCapability> e = null;
            Object var13_13 = null;
            this.resolver.hooks = null;
            return e;
        }
        try {
            this.filterCandidates(this.resolver.hooks.keySet(), dynImport, candidates);
            ArrayList<BundleCapability> matches = new ArrayList<BundleCapability>();
            for (Capability cap : candidates) {
                String candidatePackage = (String)cap.getAttributes().get("osgi.wiring.package");
                assert (candidatePackage != null);
                if (multiple && RFC1960Filter.stringCompare(pkg.toCharArray(), 0, candidatePackage.toCharArray(), 0) != 0 || !(cap instanceof BundleCapability) || !Concierge.matches0("osgi.wiring.package", dynImport, cap, filterStr) || ((BundleCapability)cap).getRevision().getBundle().getState() == 2 && !this.resolve(Collections.singletonList(((BundleCapability)cap).getRevision()), false)) continue;
                matches.add((BundleCapability)cap);
            }
            this.endResolverHooks(this.resolver.hooks);
            Collections.sort(matches, EXPORT_ORDER);
            ArrayList<BundleCapability> arrayList = matches;
            Object var13_14 = null;
            this.resolver.hooks = null;
            return arrayList;
        }
        catch (Throwable t) {
            try {
                List<BundleCapability> list = null;
                Object var13_15 = null;
                this.resolver.hooks = null;
                return list;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                this.resolver.hooks = null;
                throw throwable;
            }
        }
    }

    protected void filterCandidates(Collection<ResolverHook> hooks, BundleRequirement requirement, Collection<Capability> candidates) {
        ConciergeCollections.MultiMap<BundleRevision, BundleCapability> mmap = new ConciergeCollections.MultiMap<BundleRevision, BundleCapability>();
        Iterator<Object> iter = candidates.iterator();
        while (iter.hasNext()) {
            Capability cap = iter.next();
            Resource res = cap.getResource();
            if (!(res instanceof BundleRevision)) continue;
            mmap.insert((BundleRevision)cap.getResource(), (BundleCapability)cap);
            iter.remove();
        }
        for (ResolverHook hook : hooks) {
            hook.filterResolvable(mmap.keySet());
        }
        ConciergeCollections.RemoveOnlyList<BundleCapability> filteredCandidates = new ConciergeCollections.RemoveOnlyList<BundleCapability>(mmap.getAllValues());
        for (ResolverHook hook : hooks) {
            hook.filterMatches(requirement, filteredCandidates);
        }
        candidates.addAll(filteredCandidates);
    }

    protected void filterResources(Collection<ResolverHook> hooks, Collection<Resource> resources, Collection<Resource> removed) {
        ArrayList<BundleRevision> revisions = new ArrayList<BundleRevision>();
        removed.addAll(resources);
        Iterator<Resource> iter = resources.iterator();
        while (iter.hasNext()) {
            Resource res = iter.next();
            if (!(res instanceof BundleRevision)) continue;
            revisions.add((BundleRevision)res);
            iter.remove();
        }
        ConciergeCollections.RemoveOnlyList<BundleRevision> filteredResources = new ConciergeCollections.RemoveOnlyList<BundleRevision>(revisions);
        for (ResolverHook hook : this.resolver.hooks.keySet()) {
            hook.filterResolvable(filteredResources);
        }
        resources.addAll(filteredResources);
        removed.removeAll(filteredResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized boolean resolve(final Collection<BundleRevision> bundles, boolean critical) throws BundleException {
        block36: {
            block33: {
                block35: {
                    block32: {
                        if (this.inResolve) {
                            throw new IllegalStateException("nested resolve call");
                        }
                        cleanup = false;
                        try {
                            try {
                                this.inResolve = true;
                                hostedCapabilities = new ConciergeCollections.MultiMap<Resource, V>();
                                if (this.resolver.hooks == null) {
                                    this.resolver.hooks = this.getResolverHooks(bundles);
                                    cleanup = true;
                                }
                                solution = new ConciergeCollections.MultiMap<Resource, Wire>();
                                unresolvedRequirements = new ArrayList<Requirement>();
                                unresolvedResources = new ArrayList<Resource>();
                                this.resolver.resolve0(new ResolveContext(){

                                    @Override
                                    public Collection<Resource> getMandatoryResources() {
                                        return new ArrayList<Resource>(bundles);
                                    }

                                    @Override
                                    public Collection<Resource> getOptionalResources() {
                                        return Collections.emptyList();
                                    }

                                    @Override
                                    public List<Capability> findProviders(Requirement requirement) {
                                        List<Capability> providers;
                                        String filterStr = requirement.getDirectives().get("filter");
                                        if (filterStr == null) {
                                            providers = Concierge.this.capabilityRegistry.getAll(requirement.getNamespace());
                                        } else {
                                            try {
                                                providers = RFC1960Filter.filterWithIndex(requirement, filterStr, Concierge.this.capabilityRegistry);
                                            }
                                            catch (InvalidSyntaxException ise) {
                                                ise.printStackTrace();
                                                return Collections.emptyList();
                                            }
                                        }
                                        this.sortProviders(providers, requirement.getNamespace());
                                        return providers;
                                    }

                                    private void sortProviders(List<Capability> providers, String namespace) {
                                        if (providers.isEmpty()) {
                                            return;
                                        }
                                        if ("osgi.wiring.package".equals(namespace)) {
                                            Collections.sort(providers, EXPORT_ORDER);
                                        }
                                        if ("osgi.wiring.bundle".equals(namespace)) {
                                            Collections.sort(providers, BUNDLE_VERSION);
                                        }
                                    }

                                    @Override
                                    public int insertHostedCapability(List<Capability> capabilities, HostedCapability hostedCapability) {
                                        Concierge.this.publishCapabilities(Collections.singletonList(hostedCapability));
                                        capabilities.add(hostedCapability);
                                        hostedCapabilities.insert(hostedCapability.getResource(), hostedCapability);
                                        if ("osgi.wiring.package".equals(hostedCapability.getNamespace())) {
                                            Collections.sort(capabilities, EXPORT_ORDER);
                                            return capabilities.indexOf(hostedCapability);
                                        }
                                        return capabilities.size();
                                    }

                                    @Override
                                    public boolean isEffective(Requirement requirement) {
                                        String effective = requirement.getDirectives().get("effective");
                                        return effective == null || effective.equals("resolve");
                                    }

                                    @Override
                                    public Map<Resource, Wiring> getWirings() {
                                        return Concierge.this.wirings;
                                    }
                                }, solution, unresolvedRequirements, unresolvedResources, false);
                                if (this.LOG_ENABLED && this.DEBUG_RESOLVER) {
                                    this.logger.log(4, "Solution: " + solution);
                                }
                                for (Resource resource : solution.keySet()) {
                                    wires = solution.get(resource);
                                    if (resource instanceof BundleImpl.Revision) {
                                        revision = (BundleImpl.Revision)resource;
                                        isFragment = revision.isFragment();
                                        if (isFragment) {
                                            attached = false;
                                            iter = wires.iterator();
                                            while (iter.hasNext()) {
                                                wire = (Wire)iter.next();
                                                if (!"osgi.wiring.host".equals(wire.getRequirement().getNamespace())) continue;
                                                if (wire.getProvider() instanceof BundleImpl.Revision) {
                                                    host = (BundleImpl.Revision)wire.getProvider();
                                                    try {
                                                        host.attachFragment(revision);
                                                        attached = true;
                                                    }
                                                    catch (BundleException be) {
                                                        be.printStackTrace();
                                                    }
                                                    continue;
                                                }
                                                if (!this.extensionBundles.contains(revision.getBundle())) continue;
                                                attached = true;
                                            }
                                            if (!attached) continue;
                                            revision.markResolved();
                                        }
                                        if (revision.getWiring() == null) {
                                            wiring = new Resources.ConciergeBundleWiring(revision, (List<Wire>)wires);
                                            revision.setWiring(wiring);
                                        } else {
                                            wiring = revision.addAdditionalWires((List<Wire>)wires);
                                        }
                                        if (!isFragment) {
                                            hostedCaps = hostedCapabilities.lookup(resource);
                                            for (HostedCapability hostedCap : hostedCaps) {
                                                wiring.addCapability(hostedCap);
                                                revision.addHostedCapability(hostedCap);
                                            }
                                        }
                                        this.wirings.put(resource, wiring);
                                        continue;
                                    }
                                    systemBundle = (Concierge)resource;
                                    wiring = (Resources.ConciergeBundleWiring)this.wirings.get(resource);
                                    if (wiring == null) {
                                        wiring = new Resources.ConciergeBundleWiring(systemBundle, (List<Wire>)wires);
                                        this.wirings.put(systemBundle, wiring);
                                        continue;
                                    }
                                    var13_20 = wires.iterator();
                                    while (var13_20.hasNext()) {
                                        wire = (Wire)var13_20.next();
                                        wiring.addWire((BundleWire)wire);
                                    }
                                }
                                if (unresolvedRequirements.isEmpty() && unresolvedResources.isEmpty()) {
                                    var8_11 = true;
                                    var19_25 = null;
                                    break block32;
                                }
                                if (critical) {
                                    throw new BundleException("Resolution failed " + unresolvedRequirements, 4);
                                }
                                if (this.LOG_ENABLED && this.DEBUG_RESOLVER) {
                                    this.logger.log(4, "Unresolved Requirements: " + unresolvedRequirements);
                                }
                                var8_12 = false;
                                break block33;
                            }
                            catch (BundleException be) {
                                throw be;
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                                throw new BundleException("Resolve Error", 12, t);
                            }
                        }
                        catch (Throwable var18_34) {
                            var19_27 = null;
                            try {
                                this.endResolverHooks(this.resolver.hooks);
                                v0 = null;
                            }
                            catch (Throwable var20_30) {
                                v0 = var21_33 = null;
                            }
                            if (cleanup) {
                                this.resolver.hooks = null;
                            }
                            this.inResolve = false;
                            throw var18_34;
                        }
                    }
                    ** try [egrp 3[TRYBLOCK] [8 : 737->754)] { 
lbl103:
                    // 1 sources

                    this.endResolverHooks(this.resolver.hooks);
                    v1 = null;
                    break block35;
lbl106:
                    // 1 sources

                    catch (Throwable var20_28) {
                        v1 = var21_31 = null;
                    }
                }
                if (cleanup) {
                    this.resolver.hooks = null;
                }
                this.inResolve = false;
                return var8_11;
            }
            var19_26 = null;
            ** try [egrp 3[TRYBLOCK] [8 : 737->754)] { 
lbl116:
            // 1 sources

            this.endResolverHooks(this.resolver.hooks);
            v2 = null;
            break block36;
lbl119:
            // 1 sources

            catch (Throwable var20_29) {
                v2 = var21_32 = null;
            }
        }
        if (cleanup) {
            this.resolver.hooks = null;
        }
        this.inResolve = false;
        return var8_12;
    }

    @Override
    public Collection<Bundle> getRemovalPendingBundles() {
        ArrayList<Bundle> removalPending = new ArrayList<Bundle>();
        block0: for (AbstractBundle bundle : this.bundles) {
            if (!(bundle instanceof BundleImpl)) continue;
            List<BundleRevision> revisions = bundle.getRevisions();
            for (BundleRevision rev : revisions) {
                BundleWiring wiring = rev.getWiring();
                if (wiring == null || wiring.isCurrent() || !wiring.isInUse()) continue;
                removalPending.add(bundle);
                continue block0;
            }
        }
        return removalPending;
    }

    @Override
    public Collection<Bundle> getDependencyClosure(Collection<Bundle> bundles) {
        return this.getDependencies(bundles, false);
    }

    private Collection<Bundle> getDependencies(Collection<Bundle> bundles, boolean allRevisions) {
        ArrayList<Bundle> toProcess = new ArrayList<Bundle>(bundles);
        HashSet<Bundle> dependencySet = new HashSet<Bundle>();
        while (!toProcess.isEmpty()) {
            Bundle b = toProcess.remove(0);
            if (b == this) {
                dependencySet.add(b);
                continue;
            }
            if (dependencySet.contains(b)) continue;
            if (!(b instanceof BundleImpl)) {
                throw new IllegalArgumentException("Bundles were not created by this framework instance " + b.getClass().getName());
            }
            dependencySet.add(b);
            BundleImpl bundle = (BundleImpl)b;
            for (BundleRevision brev : bundle.revisions) {
                BundleWiring wiring = brev.getWiring();
                if (wiring == null) continue;
                for (BundleRevision rev : ((Resources.ConciergeBundleWiring)wiring).inUseSet) {
                    toProcess.add(rev.getBundle());
                }
                List<BundleWire> hostWires = wiring.getRequiredWires("osgi.wiring.host");
                if (hostWires == null) continue;
                for (BundleWire hostWire : hostWires) {
                    toProcess.add(hostWire.getProvider().getBundle());
                }
            }
        }
        return dependencySet;
    }

    static boolean matches(Requirement req, Capability cap) {
        String capNamespace;
        String reqNamespace = req.getNamespace();
        if (!reqNamespace.equals(capNamespace = cap.getNamespace())) {
            return false;
        }
        String filter = req.getDirectives().get("filter");
        try {
            if (filter != null && !RFC1960Filter.fromString(filter).matches(cap.getAttributes())) {
                return false;
            }
            return Concierge.matches0(capNamespace, req, cap, filter);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    static boolean matches0(String namespace, Requirement req, Capability cap, String filterStr) {
        if (!namespace.startsWith("osgi.wiring.")) {
            return true;
        }
        String mandatory = cap.getDirectives().get("mandatory");
        if (mandatory == null) {
            return true;
        }
        HashSet<String> mandatoryAttributes = new HashSet<String>(Arrays.asList(Utils.splitString(Utils.unQuote(mandatory).toLowerCase(), ',')));
        Matcher matcher = FILTER_ASSERT_MATCHER.matcher(filterStr == null ? "" : filterStr);
        while (matcher.find()) {
            mandatoryAttributes.remove(matcher.group(1));
        }
        return mandatoryAttributes.isEmpty();
    }

    BundleContextImpl createBundleContext(AbstractBundle bundle) {
        return new BundleContextImpl(bundle);
    }

    List<AbstractBundle> getBundleWithSymbolicName(String symbolicName) {
        List<AbstractBundle> list = this.symbolicName_bundles.lookup(symbolicName);
        return list;
    }

    void addFragment(BundleImpl.Revision fragment) throws BundleException {
        if (fragment.isExtensionBundle()) {
            try {
                this.addURL.invoke((Object)this.systemBundleClassLoader, fragment.createURL("/", null));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.extensionBundles.add((BundleImpl)fragment.getBundle());
        }
        String fragmentHostName = fragment.getFragmentHost();
        this.fragmentIndex.insert(fragmentHostName, fragment);
    }

    void removeFragment(BundleImpl.Revision fragment) {
        this.fragmentIndex.remove(fragment.getFragmentHost(), fragment);
        String fragmentHostName = fragment.getFragmentHost();
        if (fragmentHostName.equals("system.bundle") || fragmentHostName.equals("org.eclipse.concierge")) {
            this.extensionBundles.remove(fragment.getBundle());
        }
    }

    List<BundleImpl.Revision> getFragments(BundleRevision hostBundle) {
        ArrayList<BundleImpl.Revision> candidates = new ArrayList<BundleImpl.Revision>(this.fragmentIndex.lookup(hostBundle.getSymbolicName()));
        if (!candidates.isEmpty()) {
            Capability cap = hostBundle.getCapabilities("osgi.wiring.host").get(0);
            Iterator iter = candidates.iterator();
            while (iter.hasNext()) {
                Requirement req = ((BundleImpl.Revision)iter.next()).getRequirements("osgi.wiring.host").get(0);
                if (Concierge.matches(req, cap)) continue;
                iter.remove();
            }
        }
        return candidates;
    }

    static void deleteDirectory(File path) {
        File[] files = path.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                Concierge.deleteDirectory(files[i]);
                continue;
            }
            files[i].delete();
        }
        path.delete();
    }

    void unregisterService(ServiceReference<?> sref) {
        String[] clazzes = (String[])sref.getProperty("objectClass");
        this.serviceRegistry.removeAll((String[])clazzes, sref);
        boolean isHook = false;
        for (int i = 0; i < clazzes.length; ++i) {
            List<?> hookList = this.hooks.get(clazzes[i]);
            if (hookList == null) continue;
            isHook = true;
            hookList.remove(sref);
        }
        AbstractBundle bundle = (AbstractBundle)sref.getBundle();
        bundle.registeredServices.remove(sref);
        if (bundle.registeredServices.isEmpty()) {
            bundle.registeredServices = null;
        }
        if (!isHook) {
            this.notifyServiceListeners(4, sref, null);
        }
        if (this.LOG_ENABLED && this.DEBUG_SERVICES) {
            this.logger.log(3, "Framework: UNREGISTERED SERVICE " + sref);
        }
    }

    void notifyBundleListeners(int state, Bundle bundle) {
        this.notifyBundleListeners(state, bundle, bundle);
    }

    void notifyBundleListeners(int state, Bundle bundle, Bundle origin) {
        BundleListener[] asyncs;
        SynchronousBundleListener[] syncs;
        if (this.syncBundleListeners.isEmpty() && this.bundleListeners.isEmpty()) {
            return;
        }
        BundleEvent event = new BundleEvent(state, bundle, origin);
        if (!this.bundleEventHooks.isEmpty()) {
            ArrayList<SynchronousBundleListener> syncListeners = new ArrayList<SynchronousBundleListener>(this.syncBundleListeners);
            ArrayList<BundleListener> asyncListeners = new ArrayList<BundleListener>(this.bundleListeners);
            ConciergeCollections.DeltaTrackingRemoveOnlyList<BundleContext> contexts = new ConciergeCollections.DeltaTrackingRemoveOnlyList<BundleContext>((Collection<BundleContext>)this.bundleListenerMap.keySet());
            for (ServiceReferenceImpl<EventHook> sref : this.bundleEventHooks) {
                EventHook eventHook = sref.getService(this);
                if (eventHook != null) {
                    try {
                        eventHook.event(event, contexts);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                sref.ungetService(this);
            }
            for (BundleContext removed : contexts.getRemoved()) {
                Iterator iterator = this.bundleListenerMap.get(removed).iterator();
                while (iterator.hasNext()) {
                    BundleListener listener = (BundleListener)iterator.next();
                    syncListeners.remove(listener);
                    asyncListeners.remove(listener);
                }
            }
            syncs = syncListeners.toArray(new SynchronousBundleListener[syncListeners.size()]);
            asyncs = asyncListeners.toArray(new BundleListener[asyncListeners.size()]);
        } else {
            syncs = this.syncBundleListeners.toArray(new SynchronousBundleListener[this.syncBundleListeners.size()]);
            asyncs = this.bundleListeners.toArray(new BundleListener[this.bundleListeners.size()]);
        }
        for (int i = 0; i < syncs.length; ++i) {
            syncs[i].bundleChanged(event);
        }
        int type = event.getType();
        if (this.bundleListeners.isEmpty() || (type & 0x380) > 0) {
            return;
        }
        for (int i = 0; i < asyncs.length; ++i) {
            asyncs[i].bundleChanged(event);
        }
    }

    void notifyFrameworkListeners(int state, Bundle bundle, Throwable throwable) {
        this.notifyFrameworkListeners(this.frameworkListeners.toArray(new FrameworkListener[this.frameworkListeners.size()]), state, bundle, throwable);
    }

    void publishCapabilities(List<? extends Capability> caps) {
        for (Capability capability : caps) {
            this.capabilityRegistry.add(capability);
        }
    }

    void removeCapabilities(BundleImpl.Revision resource) {
        this.capabilityRegistry.removeAll(resource);
        for (HostedCapability hosted : resource.getHostedCapabilities()) {
            this.capabilityRegistry.remove(hosted);
        }
    }

    void checkForCollision(int operation, Bundle contextOwner, BundleRevision revision) throws BundleException {
        assert (this.context != null);
        if (revision == null) {
            throw new IllegalArgumentException("revision==null");
        }
        if (this.collisionPolicy == 1) {
            return;
        }
        Version version = revision.getVersion();
        ArrayList<AbstractBundle> collisions = new ArrayList<AbstractBundle>();
        Object existing = this.symbolicName_bundles.get(revision.getSymbolicName());
        if (existing == null) {
            return;
        }
        if (version == null) {
            throw new IllegalStateException("version==null");
        }
        Iterator iterator = existing.iterator();
        while (iterator.hasNext()) {
            AbstractBundle b = (AbstractBundle)iterator.next();
            if (!version.equals(b.getVersion())) continue;
            collisions.add(b);
        }
        if (operation == 2) {
            collisions.remove(revision.getBundle());
        }
        if (collisions.isEmpty()) {
            return;
        }
        if (this.collisionPolicy == -1) {
            throw new BundleException("Bundle with same symbolic name and same version is already installed", 9);
        }
        if (this.collisionPolicy == 0) {
            ConciergeCollections.RemoveOnlyList<Bundle> list = new ConciergeCollections.RemoveOnlyList<Bundle>(collisions);
            for (ServiceReferenceImpl<CollisionHook> hookRef : this.bundleCollisionHooks) {
                CollisionHook hook = hookRef.getService(this);
                if (hook != null) {
                    hook.filterCollisions(operation, contextOwner, list);
                }
                hookRef.ungetService(this);
            }
            if (!list.isEmpty()) {
                throw new BundleException("Bundle with same symbolic name and same version is already installed", 9);
            }
        }
    }

    protected void notifyFrameworkListeners(FrameworkListener[] listeners, int state, Bundle bundle, Throwable throwable) {
        if (listeners.length == 0) {
            return;
        }
        final FrameworkEvent event = new FrameworkEvent(state, bundle, throwable);
        for (int i = 0; i < listeners.length; ++i) {
            final FrameworkListener listener = listeners[i];
            if (this.SECURITY_ENABLED) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        listener.frameworkEvent(event);
                        return null;
                    }
                });
                continue;
            }
            listener.frameworkEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void notifyServiceListeners(int state, ServiceReference<?> reference, Map<String, ?> oldProperties) {
        ServiceListenerEntry[] entries;
        ServiceEvent endmatchEvent;
        if (this.serviceListeners.isEmpty()) {
            return;
        }
        final ServiceEvent event = new ServiceEvent(state, reference);
        ServiceEvent serviceEvent = endmatchEvent = state == 2 ? new ServiceEvent(8, reference) : null;
        if (this.serviceEventListenerHooks.isEmpty() && this.serviceEventHooks.isEmpty()) {
            entries = this.serviceListeners.toArray(new ServiceListenerEntry[this.serviceListeners.size()]);
        } else {
            ConciergeCollections.MultiMap<BundleContextImpl, ServiceListenerEntry> mmap = new ConciergeCollections.MultiMap<BundleContextImpl, ServiceListenerEntry>();
            ArrayList<ServiceListenerEntry> serviceListenersCopy = new ArrayList<ServiceListenerEntry>(this.serviceListeners);
            for (ServiceListenerEntry serviceListenerEntry : serviceListenersCopy) {
                mmap.insert(serviceListenerEntry.bundle.context, serviceListenerEntry);
            }
            ConciergeCollections.RemoveOnlyMap<BundleContext, Collection<ListenerHook.ListenerInfo>> map = new ConciergeCollections.RemoveOnlyMap<BundleContext, Collection<ListenerHook.ListenerInfo>>();
            for (Object ctx : mmap.keySet()) {
                ConciergeCollections.RemoveOnlyList removeOnlyList = new ConciergeCollections.RemoveOnlyList(mmap.get(ctx));
                map.put((BundleContext)ctx, removeOnlyList);
            }
            map.seal();
            ArrayList<ServiceReferenceImpl<org.osgi.framework.hooks.service.EventHook>> arrayList = new ArrayList<ServiceReferenceImpl<org.osgi.framework.hooks.service.EventHook>>(this.serviceEventHooks);
            for (ServiceReferenceImpl serviceReferenceImpl : arrayList) {
                Object var15_26;
                try {
                    try {
                        org.osgi.framework.hooks.service.EventHook eventHook = (org.osgi.framework.hooks.service.EventHook)serviceReferenceImpl.getService(this);
                        eventHook.event(event, map.keySet());
                    }
                    catch (Throwable throwable) {
                        this.notifyFrameworkListeners(2, this, throwable);
                        var15_26 = null;
                        serviceReferenceImpl.ungetService(this);
                        continue;
                    }
                    var15_26 = null;
                    serviceReferenceImpl.ungetService(this);
                }
                catch (Throwable throwable) {
                    var15_26 = null;
                    serviceReferenceImpl.ungetService(this);
                    throw throwable;
                }
            }
            ArrayList<ServiceReferenceImpl<EventListenerHook>> serviceEventListenerHooksCopy = new ArrayList<ServiceReferenceImpl<EventListenerHook>>(this.serviceEventListenerHooks);
            for (ServiceReferenceImpl serviceReferenceImpl : serviceEventListenerHooksCopy) {
                Object var17_30;
                try {
                    try {
                        EventListenerHook hook = (EventListenerHook)serviceReferenceImpl.getService(this);
                        hook.event(event, map);
                    }
                    catch (Throwable t) {
                        this.notifyFrameworkListeners(2, this, t);
                        var17_30 = null;
                        serviceReferenceImpl.ungetService(this);
                        continue;
                    }
                    var17_30 = null;
                    serviceReferenceImpl.ungetService(this);
                }
                catch (Throwable throwable) {
                    var17_30 = null;
                    serviceReferenceImpl.ungetService(this);
                    throw throwable;
                }
            }
            ArrayList<ServiceListenerEntry> arrayList2 = new ArrayList<ServiceListenerEntry>();
            for (ServiceListenerEntry entry : serviceListenersCopy) {
                Collection listeners = (Collection)map.get(entry.bundle.context);
                if (listeners == null || !listeners.contains(entry)) continue;
                arrayList2.add(entry);
            }
            entries = arrayList2.toArray(new ServiceListenerEntry[arrayList2.size()]);
        }
        ServiceReferenceImpl ref = (ServiceReferenceImpl)reference;
        int i = 0;
        while (i < entries.length) {
            String[] clazzes;
            if (entries[i].listener instanceof AllServiceListener || ref.isAssignableTo(entries[i].bundle, clazzes = (String[])reference.getProperty("objectClass"))) {
                if (entries[i].listener instanceof UnfilteredServiceListener || entries[i].filter == null || entries[i].filter.matches(ref.properties)) {
                    final ServiceListener listener = entries[i].listener;
                    if (this.SECURITY_ENABLED) {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                listener.serviceChanged(event);
                                return null;
                            }
                        });
                    } else {
                        listener.serviceChanged(event);
                    }
                } else if (state == 2 && entries[i].filter.matches(oldProperties)) {
                    entries[i].listener.serviceChanged(endmatchEvent);
                }
            }
            ++i;
        }
        return;
    }

    void clearBundleTrace(AbstractBundle bundle) {
        ServiceReference<?>[] refs;
        ServiceReference<?>[] regs;
        Object bundleListeners;
        if (bundle.registeredFrameworkListeners != null) {
            this.frameworkListeners.removeAll(bundle.registeredFrameworkListeners);
            bundle.registeredFrameworkListeners = null;
        }
        if (bundle.registeredServiceListeners != null) {
            this.serviceListeners.removeAll(bundle.registeredServiceListeners);
            bundle.registeredServiceListeners = null;
        }
        if ((bundleListeners = this.bundleListenerMap.get(bundle.context)) != null) {
            bundleListeners.removeAll((Collection<?>)bundleListeners);
            this.syncBundleListeners.removeAll((Collection<?>)bundleListeners);
            this.bundleListenerMap.remove(bundle.context);
        }
        if ((regs = bundle.getRegisteredServices()) != null) {
            for (int i = 0; i < regs.length; ++i) {
                this.unregisterService(regs[i]);
                ((ServiceReferenceImpl)regs[i]).invalidate();
            }
            bundle.registeredServices = null;
        }
        if ((refs = bundle.getServicesInUse()) != null) {
            for (int i = 0; i < refs.length; ++i) {
                ((ServiceReferenceImpl)refs[i]).ungetService(bundle);
            }
        }
    }

    BundleImpl installNewBundle(BundleContext context, String location) throws BundleException {
        try {
            String location2 = location.indexOf(":") > -1 ? location : this.BUNDLE_LOCATION + File.separatorChar + location;
            return this.installNewBundle(context, location2, new URL(location2).openConnection().getInputStream());
        }
        catch (IOException e) {
            throw new BundleException("Cannot retrieve bundle from " + location, 11, e);
        }
    }

    synchronized BundleImpl installNewBundle(BundleContext context, String location, InputStream in) throws BundleException {
        AbstractBundle cached = this.location_bundles.get(location);
        if (cached != null) {
            Bundle[] test;
            if (!this.bundleFindHooks.isEmpty() && (test = this.filterWithBundleHooks(context, Arrays.asList(cached))).length == 0) {
                throw new BundleException("Existing bundle rejected by find hooks", 12);
            }
            return (BundleImpl)cached;
        }
        BundleImpl bundle = new BundleImpl(this, context, location, this.nextBundleID++, in);
        bundle.install();
        this.notifyBundleListeners(1, bundle, context.getBundle());
        this.storeMetadata();
        return bundle;
    }

    protected Bundle[] filterWithBundleHooks(BundleContext context, Collection<Bundle> bundles) {
        ConciergeCollections.RemoveOnlyList<Bundle> list = new ConciergeCollections.RemoveOnlyList<Bundle>(bundles);
        for (ServiceReferenceImpl<FindHook> sref : this.bundleFindHooks) {
            FindHook findHook = sref.getService(this);
            if (findHook != null) {
                try {
                    findHook.find(context, list);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            sref.ungetService(this);
        }
        return list.toArray(new Bundle[list.size()]);
    }

    protected <T> T getService(Class<T> cls, Version version) {
        List<ServiceReference<?>> refs = this.serviceRegistry.lookup(cls.getName());
        for (ServiceReference<?> ref : refs) {
            Version other = (Version)ref.getProperty("version");
            if (other == null || other.compareTo(version) != 0) continue;
            return (T)((ServiceReferenceImpl)ref).service;
        }
        return null;
    }

    @Override
    protected final boolean isSecurityEnabled() {
        return this.SECURITY_ENABLED;
    }

    boolean hasWeavingHooks() {
        return !this.weavingHooks.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void callWeavingHooks(BundleImpl.Revision.WovenClassImpl wovenClass) {
        Collections.sort(this.weavingHooks, Collections.reverseOrder());
        ArrayList<ServiceReferenceImpl<WeavingHook>> wHooks = new ArrayList<ServiceReferenceImpl<WeavingHook>>();
        wHooks.addAll(this.weavingHooks);
        Iterator iterator = wHooks.iterator();
        while (true) {
            Object var9_6;
            if (!iterator.hasNext()) {
                wovenClass.setComplete();
                return;
            }
            ServiceReferenceImpl serviceReferenceImpl = (ServiceReferenceImpl)iterator.next();
            WeavingHook hook = (WeavingHook)serviceReferenceImpl.getService(this);
            try {
                try {
                    hook.weave(wovenClass);
                }
                catch (Throwable t) {
                    if (!(t instanceof WeavingException)) {
                        this.weavingHooks.remove(serviceReferenceImpl);
                    }
                    this.notifyFrameworkListeners(2, serviceReferenceImpl.bundle, t);
                    wovenClass.setComplete();
                    ClassFormatError err = new ClassFormatError("Error while invoking weaving hook");
                    err.initCause(t);
                    throw err;
                }
                var9_6 = null;
                serviceReferenceImpl.ungetService(this);
            }
            catch (Throwable throwable) {
                var9_6 = null;
                serviceReferenceImpl.ungetService(this);
                throw throwable;
            }
        }
    }

    @Override
    public void start(BundleContext context) throws Exception {
        context.registerService(Resolver.class, this.resolver, null);
    }

    @Override
    public void stop(BundleContext context) throws Exception {
    }

    String[] getLibraryName(String libname) {
        if (this.libraryExtensions == null) {
            return new String[]{System.mapLibraryName(libname)};
        }
        String[] result = new String[this.libraryExtensions.length + 1];
        result[0] = System.mapLibraryName(libname);
        for (int i = 0; i < this.libraryExtensions.length; ++i) {
            result[i + 1] = result[0].substring(0, result[0].lastIndexOf(".") + 1) + this.libraryExtensions[i];
        }
        return result;
    }

    void execPermission(File libfile) {
        if (this.execPermission == null) {
            return;
        }
        String cmd = this.execPermissionPattern.matcher(this.execPermission).replaceAll(Matcher.quoteReplacement(libfile.getAbsolutePath()));
        try {
            Runtime.getRuntime().exec(cmd).waitFor();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static {
        SUPPORTED_EE = new HashSet();
        VERSION_COMPARATOR = new Comparator<AbstractBundle>(){

            @Override
            public int compare(AbstractBundle b1, AbstractBundle b2) {
                return b2.getVersion().compareTo(b1.getVersion());
            }
        };
        FILTER_ASSERT_MATCHER = Pattern.compile("\\(([^&\\!|=<>~\\(\\)]*)[=|<=|>=|~=]");
        BUNDLE_VERSION = new Comparator<Capability>(){

            @Override
            public int compare(Capability cap1, Capability cap2) {
                Version cap1Version = (Version)cap1.getAttributes().get("bundle-version");
                Version cap2Version = (Version)cap2.getAttributes().get("bundle-version");
                return cap2Version.compareTo(cap1Version);
            }
        };
        EXPORT_ORDER = new Comparator<Capability>(){

            @Override
            public int compare(Capability c1, Capability c2) {
                if (!(c1 instanceof BundleCapability) || !(c2 instanceof BundleCapability)) {
                    return 0;
                }
                BundleCapability cap1 = (BundleCapability)c1;
                BundleCapability cap2 = (BundleCapability)c2;
                int cap1Resolved = cap1.getResource().getWiring() == null ? 0 : 1;
                int cap2Resolved = cap2.getResource().getWiring() == null ? 0 : 1;
                int score = cap2Resolved - cap1Resolved;
                if (score != 0) {
                    return score;
                }
                Version cap1Version = (Version)cap1.getAttributes().get("version");
                Version cap2Version = (Version)cap2.getAttributes().get("version");
                score = cap2Version.compareTo(cap1Version);
                if (score != 0) {
                    return score;
                }
                long cap1BundleId = cap1.getRevision().getBundle().getBundleId();
                long cap2BundleId = cap2.getRevision().getBundle().getBundleId();
                return (int)(cap1BundleId - cap2BundleId);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CapabilityRegistry {
        private final ConciergeCollections.MultiMap<String, Capability> capabilities = new ConciergeCollections.MultiMap();
        private final HashMap<String, ConciergeCollections.MultiMap<String, Capability>> defaultAttributeIndex = new HashMap();

        CapabilityRegistry() {
        }

        void add(Capability cap) {
            String namespace = cap.getNamespace();
            this.capabilities.insert(namespace, cap);
            Object defaultAttribute = cap.getAttributes().get(namespace);
            if (defaultAttribute instanceof String) {
                ConciergeCollections.MultiMap<String, Capability> attributeIndex = this.defaultAttributeIndex.get(namespace);
                if (attributeIndex == null) {
                    attributeIndex = new ConciergeCollections.MultiMap();
                    this.defaultAttributeIndex.put(namespace, attributeIndex);
                }
                attributeIndex.insert((String)defaultAttribute, cap);
            }
        }

        void addAll(Resource res) {
            for (Capability cap : res.getCapabilities(null)) {
                this.add(cap);
            }
        }

        boolean remove(Capability cap) {
            String namespace = cap.getNamespace();
            this.capabilities.remove(namespace, cap);
            Object defaultAttribute = cap.getAttributes().get(namespace);
            ConciergeCollections.MultiMap<String, Capability> attributeIndex = this.defaultAttributeIndex.get(namespace);
            if (attributeIndex == null) {
                return false;
            }
            if (defaultAttribute != null && defaultAttribute instanceof String) {
                boolean success = attributeIndex.remove(defaultAttribute, cap);
                if (success && attributeIndex.isEmpty()) {
                    this.defaultAttributeIndex.remove(namespace);
                }
                return success;
            }
            return false;
        }

        void removeAll(Resource res) {
            for (Capability cap : res.getCapabilities(null)) {
                this.remove(cap);
            }
        }

        public List<Capability> getByValue(String namespace, String value) {
            ConciergeCollections.MultiMap<String, Capability> attributeIndex = this.defaultAttributeIndex.get(namespace);
            Object result = attributeIndex == null ? null : attributeIndex.get(value);
            return result == null ? Collections.emptyList() : new ArrayList(result);
        }

        public List<Capability> getByKey(String namespace, String value) {
            ConciergeCollections.MultiMap<String, Capability> caps = this.defaultAttributeIndex.get(namespace);
            return caps == null ? Collections.emptyList() : caps.get(value);
        }

        public List<Capability> getAll(String namespace) {
            Object result = this.capabilities.get(namespace);
            return result == null ? Collections.emptyList() : new ArrayList(result);
        }

        public String toString() {
            return this.capabilities.toString();
        }
    }

    static final class ServiceListenerEntry
    implements EventListener,
    ListenerHook.ListenerInfo {
        final AbstractBundle bundle;
        final ServiceListener listener;
        final Filter filter;
        boolean removed;

        protected ServiceListenerEntry(AbstractBundle bundle, ServiceListener listener, String filter) throws InvalidSyntaxException {
            this.bundle = bundle;
            this.listener = listener;
            this.removed = false;
            this.filter = filter == null ? null : RFC1960Filter.fromString(filter);
        }

        public boolean equals(Object other) {
            if (other instanceof ServiceListenerEntry) {
                ServiceListenerEntry entry = (ServiceListenerEntry)other;
                return this.bundle == entry.bundle && this.listener.equals(entry.listener);
            }
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode() + (this.filter != null ? this.filter.hashCode() >> 8 : 0);
        }

        public String toString() {
            return this.listener + " " + this.filter;
        }

        public BundleContext getBundleContext() {
            return this.bundle.context;
        }

        public String getFilter() {
            return this.filter == null ? null : this.filter.toString();
        }

        public boolean isRemoved() {
            return this.removed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class BundleContextImpl
    implements BundleContext {
        boolean isValid = true;
        final AbstractBundle bundle;

        protected BundleContextImpl(AbstractBundle bundle) {
            this.bundle = bundle;
        }

        private void checkValid() {
            if (!this.isValid) {
                throw new IllegalStateException("BundleContext of bundle " + this.bundle + " used after bundle has been stopped or uninstalled.");
            }
        }

        @Override
        public void addBundleListener(BundleListener listener) {
            this.checkValid();
            Object registered = Concierge.this.bundleListenerMap.get(this);
            if (registered == null || !registered.contains(listener)) {
                if (listener instanceof SynchronousBundleListener) {
                    Concierge.this.syncBundleListeners.add((SynchronousBundleListener)listener);
                } else {
                    Concierge.this.bundleListeners.add(listener);
                }
                Concierge.this.bundleListenerMap.insert(this, listener);
            }
        }

        @Override
        public void addFrameworkListener(FrameworkListener listener) {
            this.checkValid();
            if (this.bundle.registeredFrameworkListeners == null) {
                this.bundle.registeredFrameworkListeners = new ArrayList<FrameworkListener>(1);
            }
            if (!this.bundle.registeredFrameworkListeners.contains(listener)) {
                Concierge.this.frameworkListeners.add(listener);
                this.bundle.registeredFrameworkListeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addServiceListener(ServiceListener listener, String filterExpr) throws InvalidSyntaxException {
            this.checkValid();
            ServiceListenerEntry entry = new ServiceListenerEntry(this.bundle, listener, filterExpr);
            if (this.bundle.registeredServiceListeners == null) {
                this.bundle.registeredServiceListeners = new ArrayList<ServiceListenerEntry>(1);
            }
            List<ServiceListenerEntry> list = this.bundle.registeredServiceListeners;
            synchronized (list) {
                ServiceListenerEntry existing = this.getRegisteredServiceListener(listener);
                if (existing != null) {
                    this.removeServiceListener(listener);
                }
                this.bundle.registeredServiceListeners.add(entry);
                Concierge.this.serviceListeners.add(entry);
            }
            this.informListenerHooks(Concierge.this.serviceListenerHooks, new ServiceListenerEntry[]{entry}, true);
        }

        private void informListenerHooks(Collection<ServiceReferenceImpl<ListenerHook>> hooks, ServiceListenerEntry[] entries, boolean added) {
            if (hooks == null || hooks.isEmpty()) {
                return;
            }
            if (!added) {
                for (ServiceListenerEntry entry : entries) {
                    entry.removed = true;
                }
            }
            ConciergeCollections.RemoveOnlyList<ListenerHook.ListenerInfo> c = new ConciergeCollections.RemoveOnlyList<ListenerHook.ListenerInfo>(Arrays.asList(entries));
            for (ServiceReferenceImpl<ListenerHook> hookRef : hooks) {
                ListenerHook hook = this.getService(hookRef);
                try {
                    if (added) {
                        hook.added(c);
                    } else {
                        hook.removed(c);
                    }
                }
                catch (Throwable t) {
                    Concierge.this.notifyFrameworkListeners(2, Concierge.this, t);
                }
                this.ungetService(hookRef);
            }
        }

        private ServiceListenerEntry getRegisteredServiceListener(ServiceListener listener) {
            ServiceListenerEntry[] listeners = this.bundle.registeredServiceListeners.toArray(new ServiceListenerEntry[this.bundle.registeredServiceListeners.size()]);
            for (int i = 0; i < listeners.length; ++i) {
                if (listeners[i].bundle != this.bundle || listeners[i].listener != listener) continue;
                return listeners[i];
            }
            return null;
        }

        @Override
        public void addServiceListener(ServiceListener listener) {
            this.checkValid();
            try {
                this.addServiceListener(listener, null);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }

        @Override
        public Filter createFilter(String filter) throws InvalidSyntaxException {
            if (filter == null) {
                throw new NullPointerException();
            }
            return RFC1960Filter.fromString(filter);
        }

        @Override
        public Bundle getBundle() {
            return this.bundle;
        }

        @Override
        public Bundle getBundle(long id) {
            this.checkValid();
            Bundle bundle = Concierge.this.bundleID_bundles.get(new Long(id));
            if (bundle == null || Concierge.this.bundleFindHooks.isEmpty()) {
                return bundle;
            }
            Bundle[] bundles = Concierge.this.filterWithBundleHooks(this, Arrays.asList(bundle));
            return bundles.length == 0 ? null : bundles[0];
        }

        @Override
        public Bundle[] getBundles() {
            this.checkValid();
            ArrayList<Bundle> bundleList = new ArrayList<Bundle>(Concierge.this.bundles);
            bundleList.add(0, Concierge.this);
            if (Concierge.this.bundleFindHooks.isEmpty()) {
                return bundleList.toArray(new Bundle[bundleList.size()]);
            }
            return Concierge.this.filterWithBundleHooks(this, bundleList);
        }

        @Override
        public File getDataFile(String filename) {
            this.checkValid();
            String path = this.bundle == Concierge.this ? Concierge.this.STORAGE_LOCATION : this.bundle.storageLocation;
            try {
                File file = new File(path + "/data", filename);
                if (filename.isEmpty()) {
                    file.mkdirs();
                } else {
                    file.getParentFile().mkdirs();
                }
                return file;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public String getProperty(String key) {
            return Concierge.this.properties.getProperty(key);
        }

        @Override
        public <S> S getService(ServiceReference<S> reference) {
            this.checkValid();
            if (reference == null) {
                throw new NullPointerException("Null service reference.");
            }
            if (Concierge.this.SECURITY_ENABLED) {
                String[] clazzes = (String[])reference.getProperty("objectClass");
                for (int i = 0; i < clazzes.length; ++i) {
                    try {
                        AccessController.checkPermission(new ServicePermission(clazzes[i], "get"));
                        return ((ServiceReferenceImpl)reference).getService(this.bundle);
                    }
                    catch (SecurityException se) {
                        continue;
                    }
                }
                throw new SecurityException("Caller does not have permissions for getting service from " + reference);
            }
            return ((ServiceReferenceImpl)reference).getService(this.bundle);
        }

        @Override
        public ServiceReference<?>[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
            return this.getServiceReferences(clazz, filter, true);
        }

        @Override
        public ServiceReference<?>[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
            return this.getServiceReferences(clazz, filter, false);
        }

        private final ServiceReference<?>[] getServiceReferences(String clazz, String filter, boolean all) throws InvalidSyntaxException {
            this.checkValid();
            Filter theFilter = RFC1960Filter.fromString(filter);
            Object references = clazz == null ? Concierge.this.serviceRegistry.getAllValues() : Concierge.this.serviceRegistry.get(clazz);
            ArrayList<ServiceReferenceImpl> result = new ArrayList<ServiceReferenceImpl>();
            if (references != null) {
                ServiceReferenceImpl[] refs = references.toArray(new ServiceReferenceImpl[references.size()]);
                for (int i = 0; i < refs.length; ++i) {
                    if (!theFilter.match(refs[i]) || !all && !refs[i].isAssignableTo(this.bundle, (String[])refs[i].getProperty("objectClass"))) continue;
                    result.add(refs[i]);
                }
            }
            if (!Concierge.this.serviceFindHooks.isEmpty()) {
                ConciergeCollections.RemoveOnlyList c = new ConciergeCollections.RemoveOnlyList(result);
                for (ServiceReferenceImpl<org.osgi.framework.hooks.service.FindHook> hookRef : Concierge.this.serviceFindHooks) {
                    org.osgi.framework.hooks.service.FindHook hook = this.getService(hookRef);
                    try {
                        hook.find(this, clazz, filter, all, c);
                    }
                    catch (Throwable t) {
                        Concierge.this.notifyFrameworkListeners(2, Concierge.this, t);
                    }
                    this.ungetService(hookRef);
                }
                return c.size() == 0 ? null : c.toArray(new ServiceReference[c.size()]);
            }
            if (Concierge.this.LOG_ENABLED && Concierge.this.DEBUG_SERVICES) {
                Concierge.this.logger.log(3, "Framework: REQUESTED SERVICES " + (clazz == null ? "(no class)" : clazz) + " " + (filter == null ? "(no filter)" : "filter=" + filter));
                Concierge.this.logger.log(3, "\tRETURNED " + result);
            }
            return result.size() == 0 ? null : result.toArray(new ServiceReference[result.size()]);
        }

        @Override
        public ServiceReference<?> getServiceReference(String clazz) {
            this.checkValid();
            ServiceReference<?> winner = null;
            int maxRanking = -1;
            long lastServiceID = Long.MAX_VALUE;
            ServiceReference<?>[] list = null;
            try {
                list = this.getServiceReferences(clazz, null, true);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
            if (list == null) {
                return null;
            }
            ServiceReference<?>[] candidates = list;
            for (int i = 0; i < candidates.length; ++i) {
                Integer rankProp = (Integer)candidates[i].getProperty("service.ranking");
                int ranking = rankProp != null ? rankProp : 0;
                long serviceID = (Long)candidates[i].getProperty("service.id");
                if (ranking <= maxRanking && (ranking != maxRanking || serviceID >= lastServiceID)) continue;
                winner = candidates[i];
                maxRanking = ranking;
                lastServiceID = serviceID;
            }
            if (Concierge.this.LOG_ENABLED && Concierge.this.DEBUG_SERVICES) {
                Concierge.this.logger.log(3, "Framework: REQUESTED SERVICE " + clazz);
                Concierge.this.logger.log(3, "\tRETURNED " + winner);
            }
            return winner;
        }

        @Override
        public Bundle installBundle(String location) throws BundleException {
            if (location == null) {
                throw new IllegalArgumentException("Location must not be null");
            }
            this.checkValid();
            return Concierge.this.installNewBundle(this, location);
        }

        @Override
        public Bundle installBundle(String location, InputStream in) throws BundleException {
            if (location == null) {
                throw new IllegalArgumentException("Location must not be null");
            }
            this.checkValid();
            if (in == null) {
                return Concierge.this.installNewBundle(this, location);
            }
            return Concierge.this.installNewBundle(this, location, in);
        }

        @Override
        public ServiceRegistration<?> registerService(String[] clazzes, Object service, Dictionary<String, ?> serviceProperties) {
            this.checkValid();
            if (service == null) {
                throw new IllegalArgumentException("Cannot register a null service");
            }
            if (Concierge.this.SECURITY_ENABLED) {
                for (int i = 0; i < clazzes.length; ++i) {
                    AccessController.checkPermission(new ServicePermission(clazzes[i], "register"));
                }
            }
            ServiceReferenceImpl<Object> sref = new ServiceReferenceImpl<Object>(Concierge.this, this.bundle, service, serviceProperties, clazzes);
            if (this.bundle.registeredServices == null) {
                this.bundle.registeredServices = new ArrayList(1);
            }
            this.bundle.registeredServices.add(sref);
            boolean isHook = false;
            for (int counter = 0; counter < clazzes.length; ++counter) {
                String clazz = clazzes[counter];
                isHook = this.checkHook(clazz, sref, true);
                Concierge.this.serviceRegistry.insert(clazz, sref);
            }
            if (Concierge.this.LOG_ENABLED && Concierge.this.DEBUG_SERVICES) {
                Concierge.this.logger.log(3, "Framework: REGISTERED SERVICE " + clazzes[0]);
            }
            if (!isHook) {
                Concierge.this.notifyServiceListeners(1, sref, null);
            }
            return sref.registration;
        }

        private boolean checkHook(String clazz, ServiceReference<?> sref, boolean add) {
            List<?> hookList = Concierge.this.hooks.get(clazz);
            if (hookList == null) {
                return false;
            }
            if (add) {
                hookList.add(sref);
                Collections.sort(hookList, Collections.reverseOrder());
            }
            if (add && hookList == Concierge.this.serviceListenerHooks) {
                ServiceReferenceImpl hookRef = (ServiceReferenceImpl)sref;
                if (Concierge.this.serviceListeners != null) {
                    try {
                        this.informListenerHooks(Collections.singletonList(hookRef), Concierge.this.serviceListeners.toArray(new ServiceListenerEntry[Concierge.this.serviceListeners.size()]), true);
                    }
                    catch (Throwable t) {
                        Concierge.this.notifyFrameworkListeners(2, sref.getBundle(), t);
                    }
                }
            }
            return true;
        }

        @Override
        public ServiceRegistration<?> registerService(String clazz, Object service, Dictionary<String, ?> properties) {
            return this.registerService(new String[]{clazz}, service, properties);
        }

        @Override
        public void removeBundleListener(BundleListener listener) {
            this.checkValid();
            if (this.bundle == Concierge.this) {
                return;
            }
            (listener instanceof SynchronousBundleListener ? Concierge.this.syncBundleListeners : Concierge.this.bundleListeners).remove(listener);
            Concierge.this.bundleListenerMap.remove(this, listener);
        }

        @Override
        public void removeFrameworkListener(FrameworkListener listener) {
            this.checkValid();
            if (this.bundle == Concierge.this) {
                return;
            }
            AbstractBundle b = this.bundle;
            Concierge.this.frameworkListeners.remove(listener);
            if (b.registeredFrameworkListeners != null) {
                b.registeredFrameworkListeners.remove(listener);
                if (b.registeredFrameworkListeners.isEmpty()) {
                    b.registeredFrameworkListeners = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeServiceListener(ServiceListener listener) {
            ServiceListenerEntry entry;
            this.checkValid();
            List<ServiceListenerEntry> list = this.bundle.registeredServiceListeners;
            synchronized (list) {
                entry = this.getRegisteredServiceListener(listener);
                if (entry == null) {
                    return;
                }
                entry.removed = true;
                Concierge.this.serviceListeners.remove(entry);
                this.bundle.registeredServiceListeners.remove(entry);
                if (this.bundle.registeredServiceListeners.isEmpty()) {
                    this.bundle.registeredServiceListeners = null;
                }
            }
            this.informListenerHooks(Concierge.this.serviceListenerHooks, new ServiceListenerEntry[]{entry}, false);
        }

        @Override
        public synchronized boolean ungetService(ServiceReference<?> reference) {
            this.checkValid();
            return ((ServiceReferenceImpl)reference).ungetService(this.bundle);
        }

        @Override
        public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
            return this.registerService(clazz.getName(), service, properties);
        }

        @Override
        public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
            return this.getServiceReference(clazz == null ? null : clazz.getName());
        }

        @Override
        public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) throws InvalidSyntaxException {
            ServiceReference<?>[] refs = this.getServiceReferences(clazz.getName(), filter);
            if (refs == null) {
                return Collections.EMPTY_LIST;
            }
            return Arrays.asList(refs);
        }

        @Override
        public Bundle getBundle(String location) {
            return Concierge.this.location_bundles.get(location);
        }
    }

    protected static class ConciergeURLStreamHandlerFactory
    implements URLStreamHandlerFactory {
        Concierge frameworkInstance = null;

        protected ConciergeURLStreamHandlerFactory() {
        }

        public void setConcierge(Concierge concierge) {
            this.frameworkInstance = concierge;
        }

        public URLStreamHandler createURLStreamHandler(String protocol) {
            if ("bundle".equals(protocol)) {
                return new URLStreamHandler(){

                    protected URLConnection openConnection(final URL u) throws IOException {
                        try {
                            String host = u.getHost();
                            String[] s = Utils.splitString(host, '.');
                            Long bundleId = Long.parseLong(s[0]);
                            final int rev = Integer.parseInt(s[1]);
                            if (ConciergeURLStreamHandlerFactory.this.frameworkInstance == null) {
                                throw new IllegalStateException("ConciergeURLStreamHandlerFactory is not linked to a Concierge framework");
                            }
                            final BundleImpl bundle = (BundleImpl)ConciergeURLStreamHandlerFactory.this.frameworkInstance.bundleID_bundles.get(bundleId);
                            if (bundle == null) {
                                throw new IllegalStateException("Bundle for URL " + u + " can not be found");
                            }
                            return new URLConnection(u){
                                private InputStream inputStream;
                                private boolean isConnected;

                                public void connect() throws IOException {
                                    this.inputStream = bundle.getURLResource(u, rev);
                                    this.isConnected = true;
                                }

                                public int getContentLength() {
                                    return (int)bundle.getResourceLength(u, rev);
                                }

                                public InputStream getInputStream() throws IOException {
                                    if (!this.isConnected) {
                                        this.connect();
                                    }
                                    return this.inputStream;
                                }
                            };
                        }
                        catch (NumberFormatException nfe) {
                            throw new IOException("Malformed host " + u.getHost());
                        }
                    }
                };
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ResolverImpl
    implements Resolver {
        protected HashMap<ResolverHook, ServiceReferenceImpl<ResolverHookFactory>> hooks;

        @Override
        public synchronized Map<Resource, List<Wire>> resolve(ResolveContext context) throws ResolutionException {
            if (context == null) {
                throw new IllegalArgumentException("context is null");
            }
            ConciergeCollections.MultiMap<Resource, Wire> solution = new ConciergeCollections.MultiMap<Resource, Wire>();
            ArrayList<Requirement> unresolvedRequirements = new ArrayList<Requirement>();
            ArrayList<Resource> unresolvedResources = new ArrayList<Resource>();
            this.resolve0(context, solution, unresolvedRequirements, unresolvedResources, true);
            if (!unresolvedRequirements.isEmpty() || !unresolvedResources.isEmpty()) {
                throw new ResolutionException("Could not resolve.", null, unresolvedRequirements);
            }
            return solution.getFlatMap();
        }

        protected void resolve0(ResolveContext context, ConciergeCollections.MultiMap<Resource, Wire> solution, ArrayList<Requirement> unresolvedRequirements, ArrayList<Resource> unresolvedResources, boolean standalone) {
            Collection<Resource> mandatory = context.getMandatoryResources();
            Collection<Resource> optional = context.getOptionalResources();
            if (this.hooks != null && !this.hooks.isEmpty()) {
                Concierge.this.filterResources(this.hooks.keySet(), mandatory, unresolvedResources);
            }
            if (!mandatory.isEmpty() || !optional.isEmpty()) {
                Map<Resource, Wiring> existingWirings = context.getWirings();
                for (Resource resource : mandatory) {
                    if (resource == null) continue;
                    try {
                        if (resource instanceof BundleImpl.Revision && !((BundleImpl.Revision)resource).resolveMetadata(false)) {
                            unresolvedResources.add(resource);
                            continue;
                        }
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                    }
                    if (resource instanceof BundleRevision && !this.checkSingleton((BundleRevision)resource)) {
                        unresolvedResources.add(resource);
                        continue;
                    }
                    Collection<Requirement> unres = this.resolveResource(context, resource, existingWirings, solution, new HashSet<Resource>(), standalone);
                    unresolvedRequirements.addAll(unres);
                }
                if (!unresolvedRequirements.isEmpty() || !unresolvedResources.isEmpty()) {
                    return;
                }
                for (Resource resource : optional) {
                    this.resolveResource(context, resource, existingWirings, solution, new HashSet<Resource>(), standalone);
                }
            }
        }

        private boolean checkSingleton(BundleRevision resource) {
            try {
                List<Capability> identities = resource.getCapabilities("osgi.identity");
                if (identities == null || identities.isEmpty()) {
                    return true;
                }
                BundleCapability identity = (BundleCapability)identities.get(0);
                if (!"true".equals(identity.getDirectives().get("singleton"))) {
                    return true;
                }
                ArrayList<BundleCapability> col = new ArrayList<BundleCapability>();
                if (Concierge.this.DEBUG_BUNDLES) {
                    Concierge.this.logger.log(4, "RESOLVING " + resource.getSymbolicName() + " - " + resource.getVersion() + " /.//" + resource);
                }
                ArrayList<AbstractBundle> existing = new ArrayList<AbstractBundle>(Concierge.this.getBundleWithSymbolicName(resource.getSymbolicName()));
                existing.remove(resource.getBundle());
                if (existing.isEmpty()) {
                    return true;
                }
                for (AbstractBundle bundle : existing) {
                    BundleCapability existingIdentity;
                    if (bundle.state == 2 || !"true".equals((existingIdentity = (BundleCapability)bundle.currentRevision.getCapabilities("osgi.identity").get(0)).getDirectives().get("singleton"))) continue;
                    col.add(existingIdentity);
                }
                if (this.hooks != null && this.hooks.isEmpty()) {
                    return col.isEmpty();
                }
                ConciergeCollections.RemoveOnlyList<BundleCapability> collisions = new ConciergeCollections.RemoveOnlyList<BundleCapability>(col);
                for (ResolverHook hook : this.hooks.keySet()) {
                    hook.filterSingletonCollisions(identity, collisions);
                }
                if (!collisions.isEmpty()) {
                    return false;
                }
                for (BundleCapability cap : col) {
                    ConciergeCollections.RemoveOnlyList<BundleCapability> identityList = new ConciergeCollections.RemoveOnlyList<BundleCapability>(Collections.singletonList(identity));
                    for (ResolverHook hook : this.hooks.keySet()) {
                        hook.filterSingletonCollisions(cap, identityList);
                    }
                    if (identityList.isEmpty()) continue;
                    return false;
                }
                return true;
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new RuntimeException(t.getMessage());
            }
        }

        private final Collection<Requirement> resolveResource(ResolveContext context, Resource resource, Map<Resource, Wiring> existingWirings, ConciergeCollections.MultiMap<Resource, Wire> solution, HashSet<Resource> inResolution, boolean standalone) {
            inResolution.add(resource);
            if (solution.containsKey(resource)) {
                return Collections.emptyList();
            }
            ArrayList<Requirement> unresolvedRequirements = new ArrayList<Requirement>();
            ConciergeCollections.MultiMap<Resource, Wire> newWires = new ConciergeCollections.MultiMap<Resource, Wire>();
            boolean isFragment = false;
            if (resource instanceof BundleImpl.Revision) {
                BundleImpl.Revision revision = (BundleImpl.Revision)resource;
                isFragment = revision.isFragment();
                if (!isFragment && revision.allowsFragmentAttachment()) {
                    for (BundleImpl.Revision frag : Concierge.this.getFragments(revision)) {
                        ArrayList<Capability> capList = new ArrayList<Capability>();
                        capList.add(revision.getCapabilities("osgi.wiring.host").get(0));
                        if (this.hooks != null && !this.hooks.isEmpty()) {
                            Concierge.this.filterCandidates(this.hooks.keySet(), (BundleRequirement)frag.getRequirements("osgi.wiring.host").get(0), capList);
                        }
                        if (capList.isEmpty()) continue;
                        try {
                            if (!revision.attachFragment(frag)) continue;
                            this.hostFragment(context, frag, revision, solution);
                        }
                        catch (BundleException e) {
                            if (!Concierge.this.LOG_ENABLED) continue;
                            Concierge.this.logger.log(1, "Unsuccessfully attempted to attach " + frag + " to " + revision, e);
                        }
                    }
                }
            } else {
                isFragment = !resource.getRequirements("osgi.wiring.host").isEmpty();
            }
            List<Requirement> requirements = resource.getRequirements(null);
            HashSet<Requirement> skip = new HashSet<Requirement>();
            for (Requirement requirement : requirements) {
                if (skip.contains(requirement) || !context.isEffective(requirement) || isFragment && !"osgi.wiring.host".equals(requirement.getNamespace())) continue;
                List<Capability> candidates = context.findProviders(requirement);
                if (this.hooks != null && !this.hooks.isEmpty() && requirement instanceof BundleRequirement) {
                    Concierge.this.filterCandidates(this.hooks.keySet(), (BundleRequirement)requirement, candidates);
                }
                boolean resolved = false;
                boolean multiple = "multiple".equals(requirement.getDirectives().get("cardinality"));
                for (Capability capability : candidates) {
                    Wire wire;
                    if (isFragment) {
                        BundleImpl.Revision revision = (BundleImpl.Revision)resource;
                        if (capability.getResource() instanceof BundleImpl.Revision) {
                            BundleImpl.Revision host = (BundleImpl.Revision)capability.getResource();
                            try {
                                if (!host.attachFragment(revision)) {
                                    resolved = true;
                                }
                            }
                            catch (BundleException be) {}
                            continue;
                        }
                        resolved = true;
                        this.hostFragment(context, revision, (BundleRevision)capability.getResource(), solution);
                        continue;
                    }
                    if (capability instanceof BundleCapability) {
                        ArrayList<BundleCapability> caps = new ArrayList<BundleCapability>();
                        if ("osgi.wiring.bundle".equals(capability.getNamespace())) {
                            caps.addAll(((BundleCapability)capability).getResource().getDeclaredCapabilities("osgi.wiring.package"));
                        } else {
                            caps.add((BundleCapability)capability);
                        }
                        ArrayList<BundleCapability> impliedConstraints = new ArrayList<BundleCapability>();
                        HashSet<BundleCapability> seen = new HashSet<BundleCapability>();
                        while (!caps.isEmpty()) {
                            BundleCapability cap = (BundleCapability)caps.remove(0);
                            if (seen.contains(cap)) continue;
                            seen.add(cap);
                            String usesStr = cap.getDirectives().get("uses");
                            if (usesStr == null) continue;
                            String[] usesConstraints = Utils.splitString(usesStr, ',');
                            HashSet<String> usesSet = new HashSet<String>();
                            usesSet.addAll(Arrays.asList(usesConstraints));
                            BundleWiring wiring = cap.getResource().getWiring();
                            if (wiring == null || !wiring.isInUse()) continue;
                            List<BundleWire> wires = wiring.getRequiredWires("osgi.wiring.package");
                            HashSet<Object> requireSet = new HashSet<Object>();
                            for (BundleWire wire2 : wires) {
                                Object object = wire2.getCapability().getAttributes().get("osgi.wiring.package");
                                if (!usesSet.contains(object)) continue;
                                impliedConstraints.add(wire2.getCapability());
                                caps.add(wire2.getCapability());
                                requireSet.add(object);
                            }
                            List<BundleCapability> caps2 = wiring.getCapabilities("osgi.wiring.package");
                            for (Capability capability2 : caps2) {
                                Object pkg = capability2.getAttributes().get("osgi.wiring.package");
                                if (!usesSet.contains(pkg) || requireSet.contains(pkg)) continue;
                                impliedConstraints.add((BundleCapability)capability2);
                                caps.add((BundleCapability)capability2);
                            }
                        }
                        if (!impliedConstraints.isEmpty()) {
                            for (BundleCapability implied : impliedConstraints) {
                                for (Requirement req : requirements) {
                                    if (!Concierge.matches(req, implied)) continue;
                                    for (Map.Entry entry : newWires.entrySet()) {
                                        Iterator iter = entry.getValue().iterator();
                                        while (iter.hasNext()) {
                                            Wire wire3 = (Wire)iter.next();
                                            if (wire3.getRequirement() != req) continue;
                                            iter.remove();
                                        }
                                    }
                                    skip.add(req);
                                    Wire wire4 = Resources.createWire(implied, req);
                                    newWires.insert(resource, wire4);
                                }
                            }
                        }
                    }
                    if (existingWirings.get(capability.getResource()) != null) {
                        wire = Resources.createWire(capability, requirement);
                        newWires.insert(resource, wire);
                        newWires.insertUnique(capability.getResource(), wire);
                        resolved = true;
                        if (multiple) continue;
                        break;
                    }
                    try {
                        if (!inResolution.contains(capability.getResource()) && (capability.getResource() instanceof BundleImpl.Revision && !((BundleImpl.Revision)capability.getResource()).resolveMetadata(false) || !this.resolveResource(context, capability.getResource(), existingWirings, solution, inResolution, standalone).isEmpty())) continue;
                        wire = Resources.createWire(capability, requirement);
                        newWires.insert(resource, wire);
                        if (!standalone) {
                            newWires.insertUnique(capability.getResource(), wire);
                        }
                        resolved = true;
                        if (multiple) continue;
                        break;
                    }
                    catch (BundleException bundleException) {
                    }
                }
                if (resolved || "optional".equals(requirement.getDirectives().get("resolution"))) continue;
                unresolvedRequirements.add(requirement);
            }
            if (unresolvedRequirements.isEmpty()) {
                if (newWires.isEmpty()) {
                    solution.insertEmpty(resource);
                } else {
                    solution.insertMap(newWires);
                }
                if (resource instanceof BundleImpl.Revision) {
                    ((BundleImpl.Revision)resource).markResolved();
                }
            }
            return unresolvedRequirements;
        }

        private void hostFragment(ResolveContext context, BundleRevision fragment, BundleRevision host, ConciergeCollections.MultiMap<Resource, Wire> solution) {
            for (Capability cap : fragment.getCapabilities(null)) {
                if ("osgi.identity".equals(cap.getNamespace())) continue;
                Resources.HostedBundleCapability hostedCap = new Resources.HostedBundleCapability(host, cap);
                context.insertHostedCapability(new ArrayList<Capability>(host.getCapabilities("osgi.wiring.package")), hostedCap);
            }
            Capability hostCapability = host.getCapabilities("osgi.wiring.host").get(0);
            Requirement hostRequirement = fragment.getRequirements("osgi.wiring.host").get(0);
            Wire wire = Resources.createWire(hostCapability, hostRequirement);
            solution.insert(fragment, wire);
            solution.insert(host, wire);
        }
    }

    final class SystemBundleStartLevel
    implements BundleStartLevel {
        SystemBundleStartLevel() {
        }

        public Bundle getBundle() {
            return Concierge.this;
        }

        public int getStartLevel() {
            return 0;
        }

        public void setStartLevel(int startlevel) {
            throw new IllegalArgumentException();
        }

        public boolean isPersistentlyStarted() {
            return true;
        }

        public boolean isActivationPolicyUsed() {
            return true;
        }
    }
}

