/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import org.eclipse.concierge.Concierge;
import org.eclipse.concierge.ServiceReferenceImpl;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RFC1960Filter
implements Filter {
    private static final int AND_OPERATOR = 1;
    private static final int OR_OPERATOR = 2;
    private static final int NOT_OPERATOR = 3;
    private static final int EQUALS = 0;
    private static final int PRESENT = 1;
    private static final int APPROX = 2;
    private static final int GREATER = 3;
    private static final int LESS = 4;
    private static final int SUBSTRING = 5;
    protected static final String[] OP = new String[]{"=", "=*", "~=", ">=", "<=", "="};
    private static final Filter NULL_FILTER = new Filter(){

        @Override
        public final boolean match(ServiceReference<?> reference) {
            return true;
        }

        @Override
        public final boolean match(Dictionary<String, ?> dictionary) {
            return true;
        }

        @Override
        public final boolean matchCase(Dictionary<String, ?> dictionary) {
            return true;
        }

        @Override
        public boolean matches(Map<String, ?> map) {
            return true;
        }
    };
    private final List<Filter> operands = new ArrayList<Filter>(1);
    private final int operator;
    private static WeakHashMap<String, Filter> filterCache = new WeakHashMap();
    private static short INSUFFICIENT = 0;
    private static short NECESSARY = 1;
    private static short REQUIRED = (short)3;

    private RFC1960Filter(int operator) {
        this.operator = operator;
    }

    public static Filter fromString(String str) throws InvalidSyntaxException {
        if (str == null) {
            return NULL_FILTER;
        }
        Filter cached = filterCache.get(str);
        if (cached != null) {
            return cached;
        }
        String filterString = str.trim();
        if (filterString.length() == 1) {
            throw new InvalidSyntaxException("Malformed filter", filterString);
        }
        Stack<RFC1960Filter> stack = new Stack<RFC1960Filter>();
        try {
            int len = filterString.length();
            int last = -1;
            int oper = 0;
            String id = null;
            int comparator = -1;
            char[] chars = filterString.toCharArray();
            BitSet esc = new BitSet(chars.length);
            block12: for (int i = 0; i < chars.length; ++i) {
                switch (chars[i]) {
                    case '\\': {
                        if (i < chars.length && (chars[i + 1] == '(' || chars[i + 1] == ')' || chars[i + 1] == '\\' || chars[i + 1] == '*')) {
                            esc.set(i);
                        }
                        ++i;
                        continue block12;
                    }
                    case '(': {
                        char nextChar = chars[i + 1];
                        while (Character.isWhitespace(nextChar)) {
                            nextChar = chars[++i + 1];
                        }
                        if (nextChar == ')') {
                            throw new InvalidSyntaxException("Empty filter", filterString);
                        }
                        int x = i;
                        char nextnextChar = chars[x + 2];
                        while (Character.isWhitespace(nextnextChar)) {
                            nextnextChar = chars[++x + 2];
                        }
                        if (nextChar == '&' && nextnextChar == '(') {
                            stack.push(new RFC1960Filter(1));
                            continue block12;
                        }
                        if (nextChar == '|' && nextnextChar == '(') {
                            stack.push(new RFC1960Filter(2));
                            continue block12;
                        }
                        if (nextChar == '!' && nextnextChar == '(') {
                            stack.push(new RFC1960Filter(3));
                            continue block12;
                        }
                        if (last == -1) {
                            last = i;
                            continue block12;
                        }
                        throw new InvalidSyntaxException("Surplus left paranthesis at: " + filterString.substring(i), filterString);
                    }
                    case ')': {
                        String value;
                        if (last == -1) {
                            RFC1960Filter filter = (RFC1960Filter)stack.pop();
                            if (stack.isEmpty()) {
                                filterCache.put(str, filter);
                                return filter;
                            }
                            RFC1960Filter parent = (RFC1960Filter)stack.peek();
                            if (parent.operator == 3 && !parent.operands.isEmpty()) {
                                throw new InvalidSyntaxException("Unexpected literal: " + filterString.substring(i), filterString);
                            }
                            parent.operands.add(filter);
                            if (i != len - 1) continue block12;
                            throw new InvalidSyntaxException("Missing right paranthesis at the end.", filterString);
                        }
                        if (oper == 0) {
                            throw new InvalidSyntaxException("Missing operator.", filterString);
                        }
                        if (stack.isEmpty()) {
                            if (i == len - 1) {
                                String value2;
                                if ((value2 = RFC1960Filter.value(filterString, ++oper, len - 1, esc)).equals("*") && comparator == 5) {
                                    comparator = 1;
                                    value2 = null;
                                }
                                RFC1960SimpleFilter filter = new RFC1960SimpleFilter(id, comparator, value2);
                                filterCache.put(str, filter);
                                return filter;
                            }
                            throw new InvalidSyntaxException("Unexpected literal: " + filterString.substring(i), filterString);
                        }
                        RFC1960Filter parent = (RFC1960Filter)stack.peek();
                        if ((value = RFC1960Filter.value(filterString, ++oper, i, esc)).equals("*") && comparator == 5) {
                            comparator = 1;
                            value = null;
                        }
                        parent.operands.add(new RFC1960SimpleFilter(id, comparator, value));
                        oper = 0;
                        last = -1;
                        id = null;
                        comparator = -1;
                        continue block12;
                    }
                    case '~': {
                        if (oper == 0 && chars[i + 1] == '=') {
                            id = filterString.substring(last + 1, i).trim();
                            comparator = 2;
                            oper = ++i;
                            continue block12;
                        }
                        throw new InvalidSyntaxException("Unexpected character " + chars[i + 1], filterString);
                    }
                    case '>': {
                        if (oper == 0 && chars[i + 1] == '=') {
                            id = filterString.substring(last + 1, i).trim();
                            comparator = 3;
                            oper = ++i;
                            continue block12;
                        }
                        throw new InvalidSyntaxException("Unexpected character " + chars[i + 1], filterString);
                    }
                    case '<': {
                        if (oper == 0 && chars[i + 1] == '=') {
                            id = filterString.substring(last + 1, i).trim();
                            comparator = 4;
                            oper = ++i;
                            continue block12;
                        }
                        throw new InvalidSyntaxException("Unexpected character " + chars[i + 1], filterString);
                    }
                    case '=': {
                        if (oper != 0) continue block12;
                        if (last + 1 == i) {
                            throw new InvalidSyntaxException("Missing identifier", filterString);
                        }
                        id = filterString.substring(last + 1, i).trim();
                        comparator = 0;
                        oper = i;
                        continue block12;
                    }
                    case '*': {
                        if (comparator != 0) continue block12;
                        comparator = 5;
                        continue block12;
                    }
                }
            }
            Filter filter = (Filter)stack.pop();
            filterCache.put(str, filter);
            return filter;
        }
        catch (EmptyStackException e) {
            throw new InvalidSyntaxException("Filter expression not well-formed.", filterString);
        }
    }

    private static final String value(String str, int start, int end, BitSet esc) {
        int j;
        if (esc.isEmpty()) {
            return str.substring(start, end);
        }
        StringBuilder b = new StringBuilder();
        int i = start;
        while ((j = esc.nextSetBit(i)) > -1) {
            b.append(str.substring(i, j));
            i = j + 1;
        }
        b.append(str.substring(i, end));
        return b.toString();
    }

    protected static final Map<String, ?> dict2map(Dictionary<String, ?> dict) {
        if (dict == null) {
            return null;
        }
        if (dict instanceof Hashtable) {
            return (Hashtable)dict;
        }
        HashMap map = new HashMap();
        Enumeration<String> e = dict.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            map.put(key, dict.get(key));
        }
        return map;
    }

    @Override
    public boolean match(ServiceReference<?> reference) {
        try {
            return this.matches(((ServiceReferenceImpl)reference).properties);
        }
        catch (ClassCastException ce) {
            HashMap<String, Object> dict = new HashMap<String, Object>();
            String[] keys = reference.getPropertyKeys();
            for (int i = 0; i < keys.length; ++i) {
                dict.put(keys[i], reference.getProperty(keys[i]));
            }
            return this.matches(dict);
        }
    }

    @Override
    public boolean match(Dictionary<String, ?> values) {
        return this.matches(RFC1960Filter.dict2map(values));
    }

    @Override
    public boolean matches(Map<String, ?> map) {
        if (this.operator == 1) {
            Filter[] operandArray = this.operands.toArray(new Filter[this.operands.size()]);
            for (int i = 0; i < operandArray.length; ++i) {
                if (operandArray[i].matches(map)) continue;
                return false;
            }
            return true;
        }
        if (this.operator == 2) {
            Filter[] operandArray = this.operands.toArray(new Filter[this.operands.size()]);
            for (int i = 0; i < operandArray.length; ++i) {
                if (!operandArray[i].matches(map)) continue;
                return true;
            }
            return false;
        }
        if (this.operator == 3) {
            return !this.operands.get(0).matches(map);
        }
        throw new IllegalStateException("PARSER ERROR");
    }

    @Override
    public boolean matchCase(Dictionary<String, ?> values) {
        if (this.operator == 1) {
            Filter[] operandArray = this.operands.toArray(new Filter[this.operands.size()]);
            for (int i = 0; i < operandArray.length; ++i) {
                if (operandArray[i].matchCase(values)) continue;
                return false;
            }
            return true;
        }
        if (this.operator == 2) {
            Filter[] operandArray = this.operands.toArray(new Filter[this.operands.size()]);
            for (int i = 0; i < operandArray.length; ++i) {
                if (!operandArray[i].matchCase(values)) continue;
                return true;
            }
            return false;
        }
        if (this.operator == 3) {
            return !this.operands.get(0).matchCase(values);
        }
        throw new IllegalStateException("PARSER ERROR");
    }

    @Override
    public String toString() {
        if (this.operator == 3) {
            return "(!" + this.operands.get(0) + ")";
        }
        StringBuffer buffer = new StringBuffer(this.operator == 1 ? "(&" : "(|");
        Filter[] operandArray = this.operands.toArray(new Filter[this.operands.size()]);
        for (int i = 0; i < operandArray.length; ++i) {
            buffer.append(operandArray[i]);
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RFC1960Filter) {
            RFC1960Filter filter = (RFC1960Filter)obj;
            if (this.operands.size() != filter.operands.size()) {
                return false;
            }
            Filter[] operandArray = this.operands.toArray(new Filter[this.operands.size()]);
            Filter[] operandArray2 = filter.operands.toArray(new Filter[this.operands.size()]);
            for (int i = 0; i < operandArray.length; ++i) {
                if (operandArray[i].equals(operandArray2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    static int stringCompare(char[] c1, int p1, char[] c2, int p2) {
        if (p1 == c1.length) {
            return 0;
        }
        int l1 = c1.length;
        int l2 = c2.length;
        while (p1 < l1 && p2 < l2) {
            boolean escaped = false;
            if (c1[p1] == c2[p2]) {
                ++p1;
                ++p2;
                continue;
            }
            if (c1[p1] == '\\') {
                ++p1;
                escaped = true;
            }
            if (c1[p1] == '*' && !escaped) {
                ++p1;
                do {
                    if (RFC1960Filter.stringCompare(c1, p1, c2, p2) != 0) continue;
                    return 0;
                } while (l2 - ++p2 > -1);
                return 1;
            }
            if (c1[p1] < c2[p2]) {
                return -1;
            }
            if (c1[p1] <= c2[p2]) continue;
            return 1;
        }
        if (p2 == l2 && c1[p1 - 1] == c2[p2 - 1] && (p1 == l1 || p1 == l1 - 1 && c1[p1] == '*')) {
            return 0;
        }
        if (p1 > 0 && c1[p1 - 1] == '*' && p1 == l1 && p2 == l2) {
            return 0;
        }
        int min = l1 < l2 ? l1 : l2;
        return l1 == min ? -1 : 1;
    }

    static List<Capability> filterWithIndex(Requirement requirement, String filterStr, Concierge.CapabilityRegistry capabilityIndex) throws InvalidSyntaxException {
        Filter filter;
        HashSet<String> values = new HashSet<String>();
        String namespace = requirement.getNamespace();
        int prefilterResult = RFC1960Filter.prefilter(namespace, filter = RFC1960Filter.fromString(filterStr), capabilityIndex, INSUFFICIENT, false, values);
        if (prefilterResult == REQUIRED) {
            if (values.size() != 1) {
                return Collections.emptyList();
            }
            return capabilityIndex.getByValue(namespace, (String)values.iterator().next());
        }
        List<Capability> candidates = prefilterResult == NECESSARY ? (values.size() != 1 ? capabilityIndex.getAll(namespace) : capabilityIndex.getByKey(namespace, (String)values.iterator().next())) : capabilityIndex.getAll(namespace);
        if (candidates == null) {
            return Collections.emptyList();
        }
        ArrayList<Capability> matches = new ArrayList<Capability>();
        for (Capability cap : candidates) {
            if (!filter.matches(cap.getAttributes()) || !Concierge.matches0(namespace, requirement, cap, filterStr)) continue;
            matches.add(cap);
        }
        return matches;
    }

    private static int prefilter(String namespace, Filter filter, Concierge.CapabilityRegistry capabilities, int state, boolean inNegation, Set<String> values) {
        int newState = state;
        if (filter instanceof RFC1960Filter) {
            RFC1960Filter f = (RFC1960Filter)filter;
            int operator = f.operator;
            if (f.operands.size() == 1) {
                return RFC1960Filter.prefilter(namespace, f.operands.get(0), capabilities, state, operator == 3 ? !inNegation : inNegation, values);
            }
            for (Filter next : f.operands) {
                int childState = RFC1960Filter.prefilter(namespace, next, capabilities, state, inNegation, values);
                newState = f.operator == 1 ? (newState |= childState) : (newState &= childState);
                if (newState == INSUFFICIENT) {
                    return INSUFFICIENT;
                }
                newState ^= 2;
            }
            return newState == 3 ? NECESSARY : newState;
        }
        if (filter instanceof RFC1960SimpleFilter) {
            RFC1960SimpleFilter f = (RFC1960SimpleFilter)filter;
            if (namespace.equals(f.id)) {
                if (f.comparator == 0) {
                    values.add(f.value);
                    return REQUIRED;
                }
                if (f.comparator == 1 && inNegation) {
                    return INSUFFICIENT;
                }
                return NECESSARY;
            }
            return INSUFFICIENT;
        }
        return INSUFFICIENT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RFC1960SimpleFilter
    implements Filter {
        protected final String id;
        protected final int comparator;
        protected final String value;

        protected RFC1960SimpleFilter(String id, int comparator, String value) {
            this.id = id;
            this.comparator = comparator;
            this.value = value;
        }

        @Override
        public boolean match(ServiceReference<?> reference) {
            try {
                return this.matches(((ServiceReferenceImpl)reference).properties);
            }
            catch (ClassCastException e) {
                HashMap<String, Object> dict = new HashMap<String, Object>();
                String[] keys = reference.getPropertyKeys();
                for (int i = 0; i < keys.length; ++i) {
                    dict.put(keys[i], reference.getProperty(keys[i]));
                }
                return this.matches(dict);
            }
        }

        @Override
        public boolean match(Dictionary<String, ?> dict) {
            return this.matches(RFC1960Filter.dict2map(dict), false);
        }

        @Override
        public boolean matchCase(Dictionary<String, ?> dict) {
            return this.matches(RFC1960Filter.dict2map(dict), true);
        }

        @Override
        public boolean matches(Map<String, ?> map) {
            return this.matches(map, false);
        }

        private boolean matches(Map<String, ?> map, boolean caseSensitive) {
            if (map == null) {
                return false;
            }
            Object temp = null;
            temp = map.get(this.id);
            if (temp == null) {
                if (caseSensitive) {
                    return false;
                }
                temp = map.get(this.id.toLowerCase());
            }
            if (temp == null) {
                for (String key : map.keySet()) {
                    if (!key.equalsIgnoreCase(this.id)) continue;
                    temp = map.get(key);
                    break;
                }
            }
            if (temp == null) {
                return false;
            }
            if (this.comparator == 1) {
                return true;
            }
            Object attr = temp;
            try {
                if (attr instanceof String) {
                    return RFC1960SimpleFilter.compareString(this.value, this.comparator, (String)attr);
                }
                if (attr instanceof Number) {
                    return RFC1960SimpleFilter.compareNumber(this.value.trim(), this.comparator, (Number)attr);
                }
                if (attr instanceof String[]) {
                    String[] array = (String[])attr;
                    if (array.length == 0) {
                        return false;
                    }
                    String val = this.comparator == 2 ? RFC1960SimpleFilter.stripWhitespaces(this.value) : this.value;
                    for (int i = 0; i < array.length; ++i) {
                        if (!RFC1960SimpleFilter.compareString(val, this.comparator, array[i])) continue;
                        return true;
                    }
                    return false;
                }
                if (attr instanceof Boolean) {
                    return (this.comparator == 0 || this.comparator == 2) && ((Boolean)attr).equals(Boolean.valueOf(this.value.trim()));
                }
                if (attr instanceof Character) {
                    String trimmed = this.value.trim();
                    return trimmed.length() == 1 ? RFC1960SimpleFilter.compareTyped(new Character(trimmed.charAt(0)), this.comparator, (Character)attr) : trimmed.length() == 0 && Character.isWhitespace(((Character)attr).charValue());
                }
                if (attr instanceof Collection) {
                    Collection col = (Collection)attr;
                    Object[] obj = col.toArray();
                    return RFC1960SimpleFilter.compareArray(this.value, this.comparator, obj);
                }
                if (attr instanceof Object[]) {
                    return RFC1960SimpleFilter.compareArray(this.value, this.comparator, (Object[])attr);
                }
                if (attr.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(attr); ++i) {
                        Object obj = Array.get(attr, i);
                        if (!(obj instanceof Number && RFC1960SimpleFilter.compareNumber(this.value.trim(), this.comparator, (Number)obj) || obj instanceof Character && RFC1960SimpleFilter.compareTyped(new Character(this.value.trim().charAt(0)), this.comparator, (Character)obj)) && !RFC1960SimpleFilter.compareReflective(this.value, this.comparator, obj)) continue;
                        return true;
                    }
                    return false;
                }
                return RFC1960SimpleFilter.compareReflective(this.value, this.comparator, attr);
            }
            catch (Throwable t) {
                return false;
            }
        }

        private static boolean compareString(String val, int comparator, String attr) {
            String value = comparator == 2 ? RFC1960SimpleFilter.stripWhitespaces(val).toLowerCase() : val;
            String attribute = comparator == 2 ? RFC1960SimpleFilter.stripWhitespaces(attr).toLowerCase() : attr;
            switch (comparator) {
                case 0: 
                case 2: 
                case 5: {
                    return RFC1960Filter.stringCompare(value.toCharArray(), 0, attribute.toCharArray(), 0) == 0;
                }
                case 3: {
                    return RFC1960Filter.stringCompare(value.toCharArray(), 0, attribute.toCharArray(), 0) <= 0;
                }
                case 4: {
                    return RFC1960Filter.stringCompare(value.toCharArray(), 0, attribute.toCharArray(), 0) >= 0;
                }
            }
            throw new IllegalStateException("Found illegal comparator.");
        }

        private static boolean compareNumber(String value, int comparator, Number attr) {
            if (attr instanceof Integer) {
                int intAttr = (Integer)attr;
                int intValue = Integer.parseInt(value);
                switch (comparator) {
                    case 3: {
                        return intAttr >= intValue;
                    }
                    case 4: {
                        return intAttr <= intValue;
                    }
                }
                return intAttr == intValue;
            }
            if (attr instanceof Long) {
                long longAttr = (Long)attr;
                long longValue = Long.parseLong(value);
                switch (comparator) {
                    case 3: {
                        return longAttr >= longValue;
                    }
                    case 4: {
                        return longAttr <= longValue;
                    }
                }
                return longAttr == longValue;
            }
            if (attr instanceof Byte) {
                byte byteAttr = (Byte)attr;
                int intVal = Integer.parseInt(value);
                if (intVal < -128 || intVal > 127) {
                    throw new NumberFormatException("Value out of range. Value:\"" + value);
                }
                switch (comparator) {
                    case 3: {
                        return byteAttr >= (byte)intVal;
                    }
                    case 4: {
                        return byteAttr <= (byte)intVal;
                    }
                }
                return byteAttr == (byte)intVal;
            }
            if (attr instanceof Short) {
                short shortAttr = (Short)attr;
                int intVal = Integer.parseInt(value);
                if (intVal < Short.MIN_VALUE || intVal > Short.MAX_VALUE) {
                    throw new NumberFormatException("Value out of range. Value:\"" + value);
                }
                switch (comparator) {
                    case 3: {
                        return shortAttr >= (short)intVal;
                    }
                    case 4: {
                        return shortAttr <= (short)intVal;
                    }
                }
                return shortAttr == (short)intVal;
            }
            if (attr instanceof Double) {
                double doubleAttr = (Double)attr;
                double doubleValue = Double.parseDouble(value);
                switch (comparator) {
                    case 3: {
                        return doubleAttr >= doubleValue;
                    }
                    case 4: {
                        return doubleAttr <= doubleValue;
                    }
                }
                return doubleAttr == doubleValue;
            }
            if (attr instanceof Float) {
                float floatAttr = ((Float)attr).floatValue();
                float floatValue = Float.parseFloat(value);
                switch (comparator) {
                    case 3: {
                        return floatAttr >= floatValue;
                    }
                    case 4: {
                        return floatAttr <= floatValue;
                    }
                }
                return floatAttr == floatValue;
            }
            return RFC1960SimpleFilter.compareReflective(value, comparator, attr);
        }

        private static boolean compareTyped(Object typedVal, int comparator, Comparable attr) {
            switch (comparator) {
                case 2: {
                    if (typedVal instanceof Character) {
                        return RFC1960SimpleFilter.compareString(String.valueOf(((Character)typedVal).toString()), comparator, ((Character)attr).toString());
                    }
                }
                case 0: {
                    return attr.compareTo(typedVal) == 0;
                }
                case 3: {
                    return attr.compareTo(typedVal) >= 0;
                }
                case 4: {
                    return attr.compareTo(typedVal) <= 0;
                }
            }
            throw new IllegalStateException("Found illegal comparator.");
        }

        private static boolean compareArray(String value, int comparator, Object[] array) {
            for (int i = 0; i < array.length; ++i) {
                Object obj = array[i];
                if (!(obj instanceof String ? RFC1960SimpleFilter.compareString(value.trim(), comparator, ((String)obj).trim()) : (obj instanceof Number ? RFC1960SimpleFilter.compareNumber(value.trim(), comparator, (Number)obj) : RFC1960SimpleFilter.compareReflective(value, comparator, obj)))) continue;
                return true;
            }
            return false;
        }

        private static boolean compareReflective(String val, int comparator, Object attr) {
            if (comparator == 5) {
                return false;
            }
            Object typedVal = null;
            try {
                Method m = attr.getClass().getDeclaredMethod("valueOf", String.class);
                if (Modifier.isStatic(m.getModifiers()) && attr.getClass().isAssignableFrom(m.getReturnType())) {
                    if (!m.isAccessible()) {
                        m.setAccessible(true);
                    }
                    typedVal = m.invoke(null, val);
                }
            }
            catch (Exception m) {
                // empty catch block
            }
            try {
                if (typedVal == null) {
                    Constructor<?> constr = attr.getClass().getConstructor(String.class);
                    if (!constr.isAccessible()) {
                        constr.setAccessible(true);
                    }
                    typedVal = constr.newInstance(val);
                }
                return attr instanceof Comparable ? RFC1960SimpleFilter.compareTyped(typedVal, comparator, (Comparable)attr) : typedVal.equals(attr);
            }
            catch (Exception didNotWork) {
                return false;
            }
        }

        private static String stripWhitespaces(String s) {
            return s.replaceAll(" ", "");
        }

        @Override
        public String toString() {
            return "(" + this.id + OP[this.comparator] + (this.value == null ? "" : RFC1960SimpleFilter.escape(this.value)) + ")";
        }

        private static final String escape(String s) {
            StringBuilder b = new StringBuilder();
            char[] chars = s.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                switch (chars[i]) {
                    case '(': 
                    case ')': 
                    case '\\': {
                        b.append('\\');
                    }
                }
                b.append(chars[i]);
            }
            return b.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof RFC1960SimpleFilter) {
                RFC1960SimpleFilter filter = (RFC1960SimpleFilter)obj;
                return this.comparator == filter.comparator && this.id.equals(filter.id) && this.value.equals(filter.value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

