/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge.compat.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.concierge.BundleImpl;
import org.eclipse.concierge.Concierge;
import org.eclipse.concierge.ConciergeCollections;
import org.eclipse.concierge.Resources;
import org.eclipse.concierge.Utils;
import org.eclipse.concierge.compat.LegacyBundleProcessing;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleManifestOne
implements LegacyBundleProcessing {
    private static final String SPLIT_AT_COMMA = ",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)";
    private static final String SPLIT_AT_SEMICOLON = ";(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)";
    private static final Map<String, Object> NO_ATTRS = new HashMap<String, Object>();

    @Override
    public ConciergeCollections.Tuple<List<BundleCapability>, List<BundleRequirement>> processManifest(BundleImpl.Revision revision, Manifest manifest) throws BundleException {
        String exportStr;
        HashMap<String, String> dirs;
        ConciergeCollections.ParseResult parseResult;
        String[] literals;
        int i;
        Attributes mfAttrs = manifest.getMainAttributes();
        ArrayList<Resources.BundleCapabilityImpl> caps = new ArrayList<Resources.BundleCapabilityImpl>();
        ArrayList<Resources.BundleRequirementImpl> reqs = new ArrayList<Resources.BundleRequirementImpl>();
        String importStr = mfAttrs.getValue("Import-Package");
        if (importStr != null) {
            String[] imports = importStr.split(SPLIT_AT_COMMA);
            for (i = 0; i < imports.length; ++i) {
                literals = imports[i].split(SPLIT_AT_SEMICOLON);
                parseResult = Utils.parseLiterals(literals, 1);
                dirs = parseResult.getDirectives();
                dirs.put("filter", Utils.createFilter("osgi.wiring.package", literals[0], parseResult.getAttributes()));
                dirs.put("x-int", literals[0].trim());
                reqs.add(new Resources.BundleRequirementImpl(revision, "osgi.wiring.package", dirs, null, "Import-Package " + imports[i]));
            }
        }
        HashMap<String, String> dirs2 = new HashMap<String, String>();
        dirs2.put("filter", Utils.createFilter("osgi.wiring.package", "org.osgi.framework", NO_ATTRS));
        reqs.add(new Resources.BundleRequirementImpl(revision, "osgi.wiring.package", dirs2, null, "Import-Package org.osgi.framework"));
        String dynImportStr = mfAttrs.getValue("DynamicImport-Package");
        if (dynImportStr != null) {
            String[] dynImports = dynImportStr.split(SPLIT_AT_COMMA);
            for (i = 0; i < dynImports.length; ++i) {
                literals = dynImports[i].split(SPLIT_AT_SEMICOLON);
                parseResult = Utils.parseLiterals(literals, 1);
                dirs = parseResult.getDirectives();
                HashMap<String, Object> attrs = parseResult.getAttributes();
                dirs.put("resolution", "dynamic");
                dirs.put("x-int", literals[0].trim());
                if (literals[0].contains("*")) {
                    dirs.put("cardinality", "multiple");
                }
                reqs.add(new Resources.BundleRequirementImpl(revision, "osgi.wiring.package", dirs, attrs, "DynamicImport-Package " + dynImports[i]));
            }
        }
        if ((exportStr = mfAttrs.getValue("Export-Package")) != null) {
            String[] exports = exportStr.split(SPLIT_AT_COMMA);
            for (i = 0; i < exports.length; ++i) {
                literals = exports[i].split(SPLIT_AT_SEMICOLON);
                parseResult = Utils.parseLiterals(literals, 1);
                HashMap<String, Object> attrs = parseResult.getAttributes();
                attrs.put("osgi.wiring.package", literals[0].trim());
                caps.add(new Resources.BundleCapabilityImpl(revision, "osgi.wiring.package", parseResult.getDirectives(), attrs, "Export-Package " + exports[i]));
            }
        }
        return new ConciergeCollections.Tuple<List<BundleCapability>, List<BundleRequirement>>(caps, reqs);
    }

    @Override
    public List<BundleCapability> translateToCapability(Concierge concierge, String attributeName, String valueStr) {
        throw new UnsupportedOperationException();
    }
}

