/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge.compat.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.concierge.BundleImpl;
import org.eclipse.concierge.Concierge;
import org.eclipse.concierge.Factory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XargsFileLauncher {
    protected static final boolean WIN = System.getProperty("os.name").toLowerCase().startsWith("win");
    private PrintStream streamErr;
    static final String regex = "\\$\\{([^}]*)\\}";
    static final Pattern pattern = Pattern.compile("\\$\\{([^}]*)\\}");

    public XargsFileLauncher() {
        this(System.err);
    }

    public XargsFileLauncher(PrintStream err) {
        this.streamErr = err;
    }

    public Concierge processXargsFile(File file) throws BundleException, FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(file);
        Map<String, String> passedProperties = this.getPropertiesFromXargsInputStream(inputStream);
        inputStream = new FileInputStream(file);
        return this.processXargsInputStream(passedProperties, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Concierge processXargsInputStream(Map<String, String> passedProperties, InputStream inputStream) throws BundleException, FileNotFoundException {
        Concierge concierge;
        block19: {
            String token;
            concierge = (Concierge)new Factory().newFramework(passedProperties);
            concierge.init();
            concierge.start();
            if (concierge.restart) {
                return concierge;
            }
            BundleContext context = concierge.getBundleContext();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            HashMap<String, Bundle> memory = new HashMap<String, Bundle>(0);
            int initLevel = 1;
            boolean skipProcessing = false;
            while (!skipProcessing && (token = reader.readLine()) != null) {
                BundleStartLevel bundleStartLevel;
                Bundle bundle;
                String bundleLocation;
                if ((token = token.trim()).equals("") || token.charAt(0) == '#') continue;
                if (token.startsWith("-initlevel")) {
                    token = XargsFileLauncher.getArg(token, 10);
                    initLevel = Integer.parseInt(token);
                    continue;
                }
                if (token.startsWith("-all")) {
                    File jardir = (token = XargsFileLauncher.getArg(token, 4)).isEmpty() ? new File(new URL(concierge.BUNDLE_LOCATION).getFile()) : new File(token);
                    File[] files = jardir.listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.toLowerCase().endsWith(".jar") || name.toLowerCase().endsWith(".zip");
                        }
                    });
                    if (files == null) {
                        this.printErr("NO FILES FOUND IN " + jardir.getPath());
                        break;
                    }
                    ArrayList<Bundle> bundlesToStart = new ArrayList<Bundle>();
                    for (int i = 0; i < files.length; ++i) {
                        if (files[i].isDirectory()) continue;
                        Bundle b = context.installBundle(files[i].getPath());
                        BundleStartLevel bundleStartLevel2 = b.adapt(BundleStartLevel.class);
                        bundleStartLevel2.setStartLevel(initLevel);
                        bundlesToStart.add(b);
                    }
                    for (Bundle b : bundlesToStart) {
                        BundleImpl.Revision rev = (BundleImpl.Revision)b.adapt(BundleRevision.class);
                        if (rev.isFragment()) continue;
                        b.start();
                    }
                    continue;
                }
                if (token.startsWith("-istart")) {
                    bundleLocation = XargsFileLauncher.getArg(token, 7);
                    bundleLocation = this.replaceVariable(bundleLocation, passedProperties);
                    bundleLocation = this.resolveWildcardName(bundleLocation);
                    bundle = context.installBundle(bundleLocation);
                    bundleStartLevel = bundle.adapt(BundleStartLevel.class);
                    bundleStartLevel.setStartLevel(initLevel);
                    bundle.start();
                    continue;
                }
                if (token.startsWith("-install")) {
                    bundleLocation = XargsFileLauncher.getArg(token, 8);
                    bundleLocation = this.replaceVariable(bundleLocation, passedProperties);
                    bundleLocation = this.resolveWildcardName(bundleLocation);
                    bundle = context.installBundle(bundleLocation);
                    bundleStartLevel = bundle.adapt(BundleStartLevel.class);
                    bundleStartLevel.setStartLevel(initLevel);
                    memory.put(bundleLocation, bundle);
                    continue;
                }
                if (token.startsWith("-start")) {
                    bundleLocation = XargsFileLauncher.getArg(token, 6);
                    bundleLocation = this.replaceVariable(bundleLocation, passedProperties);
                    bundle = (Bundle)memory.remove(bundleLocation = this.resolveWildcardName(bundleLocation));
                    if (bundle == null) {
                        this.printErr("Bundle " + bundleLocation + " is marked to be started but has not been installed before. Ignoring the command !");
                        continue;
                    }
                    bundleStartLevel = bundle.adapt(BundleStartLevel.class);
                    bundleStartLevel.setStartLevel(initLevel);
                    bundle.start();
                    continue;
                }
                if (!token.startsWith("-skip")) continue;
                skipProcessing = true;
            }
            Object var17_18 = null;
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            break block19;
            {
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    Object var17_19 = null;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return concierge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map<String, String> getPropertiesFromXargsInputStream(InputStream inputStream) {
        HashMap<String, String> properties;
        block17: {
            String line;
            properties = new HashMap<String, String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                String token = line.trim();
                if (token.equals("") || token.charAt(0) == '#') continue;
                if (token.startsWith("-D")) {
                    int pos = (token = XargsFileLauncher.getArg(token, 2)).indexOf("=");
                    if (pos < 0) {
                        this.printErr("WRONG PROPERTY DEFINITION: EQUALS for -Dname=value IS MISSING, IGNORE '" + line + "'");
                        continue;
                    }
                    if (pos == 0) {
                        this.printErr("WRONG PROPERTY DEFINITION: NAME for -Dname=value IS MISSING, IGNORE '" + line + "'");
                        continue;
                    }
                    if (pos <= 0) continue;
                    boolean doAdd = token.charAt(pos - 1) == '+';
                    String key = token.substring(0, doAdd ? pos - 1 : pos);
                    if (key.length() == 0) {
                        this.printErr("WRONG PROPERTY DEFINITION: NAME for -Dname+=value IS MISSING, IGNORE '" + line + "'");
                        continue;
                    }
                    String value = token.substring(pos + 1);
                    while (value.endsWith("\\")) {
                        token = reader.readLine();
                        token = XargsFileLauncher.getArg(token, 0);
                        value = value.substring(0, value.length() - 1).trim() + token.trim();
                    }
                    value = this.replaceVariable(value, properties);
                    if (doAdd) {
                        String oldValue = (String)properties.get(key);
                        properties.put(key, (oldValue == null ? "" : oldValue) + value);
                        continue;
                    }
                    properties.put(key, value);
                    continue;
                }
                if (token.startsWith("-profile")) {
                    token = XargsFileLauncher.getArg(token, 8);
                    properties.put("ch.ethz.systems.concierge.profile", token);
                    continue;
                }
                if (token.equals("-init")) {
                    properties.put("org.osgi.framework.storage.clean", "onFirstInit");
                    continue;
                }
                if (!token.startsWith("-startlevel")) continue;
                token = XargsFileLauncher.getArg(token, 11);
                properties.put("org.osgi.framework.startlevel.beginning", token);
            }
            Object var12_12 = null;
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            break block17;
            {
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    Object var12_13 = null;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return properties;
    }

    private static String getArg(String entry, int cmdLength) {
        String str = entry.substring(cmdLength);
        int pos = str.indexOf("#");
        return pos > -1 ? str.substring(0, pos).trim() : str.trim();
    }

    String replaceVariable(String line, Map<String, String> properties) {
        Matcher matcher = pattern.matcher(line);
        String replacedLine = line;
        int pos = 0;
        while (matcher.find(pos)) {
            pos = matcher.end();
            String variable = matcher.group();
            String propertyName = variable.substring(2, variable.length() - 1);
            String propertyValue = properties.get(propertyName);
            if (propertyValue == null) continue;
            replacedLine = replacedLine.replace(variable, propertyValue);
        }
        return replacedLine;
    }

    String resolveWildcardName(final String bundleName) {
        FileFilter filter;
        if (!bundleName.contains("*")) {
            return bundleName;
        }
        File dir = new File(bundleName.substring(0, bundleName.lastIndexOf("/")));
        File[] foundFiles = dir.listFiles(filter = new FileFilter(){

            public boolean accept(File pathname) {
                String preStar = bundleName.substring(0, bundleName.lastIndexOf("*"));
                String postStar = bundleName.substring(bundleName.lastIndexOf("*") + 1);
                String path = WIN ? pathname.getPath().replace('\\', '/') : pathname.getPath();
                return path.startsWith(preStar) && path.endsWith(postStar);
            }
        });
        if (foundFiles == null || foundFiles.length == 0) {
            return bundleName;
        }
        if (foundFiles.length == 1) {
            return foundFiles[0].getPath();
        }
        if (foundFiles.length > 1) {
            ArrayList<String> sortedFiles = new ArrayList<String>();
            for (int i = 0; i < foundFiles.length; ++i) {
                sortedFiles.add(foundFiles[i].getPath());
            }
            Collections.sort(sortedFiles, Collections.reverseOrder());
            return (String)sortedFiles.get(0);
        }
        return bundleName;
    }

    private void printErr(String msg) {
        this.streamErr.println("[XargsFileLauncher] " + msg);
    }
}

