/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.service.rest;

import java.io.StringWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.json.JSONObject;
import org.osgi.impl.service.rest.pojos.BundleExceptionPojo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoReflector<B> {
    private static HashMap<Class<?>, PojoReflector<?>> reflectorCache = new HashMap();
    private final Class<B> clazz;
    private final HashMap<String, Method> setterMethodTable;
    private final HashMap<String, Method> getterMethodTable;
    private static final DocumentBuilderFactory factory;
    private static final Map<Class<?>, String> typeCache;
    private static final String SCHEMA_LOCATION = "http://www.osgi.org/xmlns/rest/v1.0.0 rest.xsd";
    private static final String REST_NS = "rest";

    public static <T> PojoReflector<T> getReflector(Class<T> clazz) {
        PojoReflector<Object> r = reflectorCache.get(clazz);
        if (r == null) {
            r = new PojoReflector<T>(clazz);
            reflectorCache.put(clazz, r);
        }
        return r;
    }

    private PojoReflector(Class<B> clazz) {
        this.clazz = clazz;
        Field[] fields = clazz.getDeclaredFields();
        this.setterMethodTable = new HashMap(fields.length);
        this.getterMethodTable = new HashMap(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String fieldName = field.getName();
            try {
                Method setter = clazz.getMethod(PojoReflector.getSetterName(fieldName), field.getType());
                this.setterMethodTable.put(fieldName, setter);
                Method getter = clazz.getMethod(PojoReflector.getGetterName(fieldName), new Class[0]);
                this.getterMethodTable.put(fieldName, getter);
                continue;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getSetterName(String fieldName) {
        return "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }

    private static String getGetterName(String fieldName) {
        return "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }

    public B beanFromJSONObject(JSONObject obj) throws Exception {
        String[] names = JSONObject.getNames((JSONObject)obj);
        B instance = this.clazz.newInstance();
        for (int i = 0; i < names.length; ++i) {
            Object o;
            String key = names[i];
            Method setter = this.setterMethodTable.get(key);
            if (setter == null || (o = obj.get(key)) instanceof JSONObject) continue;
            setter.invoke(instance, o);
        }
        return instance;
    }

    public B beanFromXml(Document doc) throws Exception {
        B instance = this.clazz.newInstance();
        Node rootNode = doc.getFirstChild();
        NodeList elems = rootNode.getChildNodes();
        for (int i = 0; i < elems.getLength(); ++i) {
            String key = elems.item(i).getNodeName();
            Method setter = this.setterMethodTable.get(key);
            if (setter == null) {
                System.err.println("Warning: unknown value " + key);
                continue;
            }
            String value = elems.item(i).getTextContent();
            Class<?> type = setter.getParameterTypes()[0];
            Object o = Integer.TYPE == type ? Integer.valueOf(value) : (Long.TYPE == type ? Long.valueOf(value) : (Boolean.TYPE == type ? Boolean.valueOf(value) : value));
            setter.invoke(instance, o);
        }
        return instance;
    }

    public Document xmlFromBean(B bean) throws Exception {
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element rootNode = this.xmlFromBean(bean, doc);
        rootNode.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", SCHEMA_LOCATION);
        doc.appendChild(rootNode);
        return doc;
    }

    public Element xmlFromBean(Object bean, Document doc) throws Exception {
        Element rootNode = doc.createElementNS(REST_NS, bean.getClass().getAnnotation(RootNode.class).name());
        if (bean instanceof Collection) {
            String elemName = null;
            boolean complex = false;
            ElementNode a = bean.getClass().getAnnotation(ElementNode.class);
            if (a != null) {
                elemName = a.name();
            }
            for (Object o : (Collection)bean) {
                if (elemName == null) {
                    elemName = o.getClass().getAnnotation(RootNode.class).name();
                    complex = true;
                }
                if (complex) {
                    rootNode.appendChild(PojoReflector.getReflector(o.getClass()).xmlFromBean(o, doc));
                    continue;
                }
                rootNode.appendChild(PojoReflector.toXml(o, elemName, doc));
            }
        } else if (bean instanceof BundleExceptionPojo) {
            BundleExceptionPojo p = (BundleExceptionPojo)bean;
            Element tc = doc.createElementNS(REST_NS, "typecode");
            tc.setTextContent(Integer.toString(p.getTypecode()));
            rootNode.appendChild(tc);
            Element msg = doc.createElementNS(REST_NS, "message");
            msg.setTextContent(p.getMessage());
            rootNode.appendChild(msg);
        } else {
            for (Map.Entry<String, Method> entry : this.getterMethodTable.entrySet()) {
                String field = entry.getKey();
                Object o = entry.getValue().invoke(bean, new Object[0]);
                rootNode.appendChild(PojoReflector.toXml(o, field, doc));
            }
        }
        return rootNode;
    }

    private final String printDoc(Document doc) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        return writer.getBuffer().toString();
    }

    private static Element toXml(Object o, String name, Document doc) {
        Element e = doc.createElementNS(REST_NS, name);
        if ("usingBundles".equals(name)) {
            for (String bundle : (String[])o) {
                e.appendChild(PojoReflector.toXml(bundle, "bundle", doc));
            }
        } else if (o instanceof Map) {
            Map map = (Map)o;
            for (Map.Entry entry : map.entrySet()) {
                String type;
                Element elem = doc.createElementNS(REST_NS, "property");
                elem.setAttribute("name", entry.getKey().toString());
                Object val = entry.getValue();
                if (val.getClass().isArray()) {
                    type = PojoReflector.getType(o.getClass().getComponentType());
                    if (type != null) {
                        e.setAttribute("type", type);
                    }
                    int len = Array.getLength(val);
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < len; ++i) {
                        sb.append(Array.get(val, i).toString());
                        if (i >= len) continue;
                        sb.append('\n');
                    }
                    elem.setTextContent(sb.toString());
                } else {
                    type = PojoReflector.getType(val.getClass());
                    if (type != null) {
                        elem.setAttribute("type", type);
                    }
                    elem.setAttribute("value", val.toString());
                }
                e.appendChild(elem);
            }
        } else {
            e.setTextContent(o.toString());
        }
        return e;
    }

    private static String getType(Class<? extends Object> cls) {
        return typeCache.get(cls);
    }

    public static Document mapToXml(Map<String, String> map) throws Exception {
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element rootNode = doc.createElementNS(REST_NS, "bundleHeader");
        doc.appendChild(rootNode);
        for (String key : map.keySet()) {
            Element entry = doc.createElementNS(REST_NS, "entry");
            entry.setAttribute("key", key);
            entry.setAttribute("value", map.get(key));
            rootNode.appendChild(entry);
        }
        return doc;
    }

    static {
        typeCache = new HashMap();
        SchemaFactory sfact = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setSchema(sfact.newSchema(new StreamSource(PojoReflector.class.getResourceAsStream("/rest.xsd"))));
            factory.setNamespaceAware(true);
            factory.setValidating(true);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        typeCache.put(String.class, "String");
        typeCache.put(Long.class, "Long");
        typeCache.put(Double.class, "Double");
        typeCache.put(Float.class, "Float");
        typeCache.put(Integer.class, "Integer");
        typeCache.put(Byte.class, "Byte");
        typeCache.put(Character.class, "Character");
        typeCache.put(Boolean.class, "Boolean");
        typeCache.put(Short.class, "Short");
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ElementNode {
        public String name();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RootNode {
        public String name();
    }
}

