/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.service.rest;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.impl.service.rest.resources.BundleHeaderResource;
import org.osgi.impl.service.rest.resources.BundleRepresentationsResource;
import org.osgi.impl.service.rest.resources.BundleResource;
import org.osgi.impl.service.rest.resources.BundleStartLevelResource;
import org.osgi.impl.service.rest.resources.BundleStateResource;
import org.osgi.impl.service.rest.resources.BundlesResource;
import org.osgi.impl.service.rest.resources.ExtensionsResource;
import org.osgi.impl.service.rest.resources.FrameworkStartLevelResource;
import org.osgi.impl.service.rest.resources.ServiceListResource;
import org.osgi.impl.service.rest.resources.ServiceRepresentationsResource;
import org.osgi.impl.service.rest.resources.ServiceResource;
import org.osgi.service.rest.RestApiExtension;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.restlet.Application;
import org.restlet.Restlet;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Router;

public class RestService
extends Application {
    public static final String BUNDLE_CONTEXT_ATTR = "context";
    public static final String TRACKER_ATTR = "tracker";
    public static final String SERVICE_ID_KEY = "serviceId";
    public static final String FILTER_ID_KEY = "filter";
    public static final String BUNDLE_ID_KEY = "bundleId";
    private final BundleContext context;
    private ServiceTracker<RestApiExtension, Class<? extends ServerResource>> tracker;

    RestService(BundleContext context) {
        this.context = context;
    }

    public synchronized Restlet createInboundRoot() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(BUNDLE_CONTEXT_ATTR, this.context);
        Router root = new Router(this.getContext());
        Router framework = new Router(this.getContext());
        root.attach("/framework", (Restlet)framework);
        framework.attach("/startlevel", FrameworkStartLevelResource.class);
        framework.attach("/bundles", BundlesResource.class);
        framework.attach("/bundles/representations", BundleRepresentationsResource.class);
        framework.attach("/bundle/{bundleId}", BundleResource.class);
        framework.attach("/bundle/{bundleId}/state", BundleStateResource.class);
        framework.attach("/bundle/{bundleId}/startlevel", BundleStartLevelResource.class);
        framework.attach("/bundle/{bundleId}/header", BundleHeaderResource.class);
        framework.attach("/services", ServiceListResource.class);
        framework.attach("/services/representations", ServiceRepresentationsResource.class);
        framework.attach("/service/{serviceId}", ServiceResource.class);
        Router extensions = new Router(this.getContext());
        root.attach("/extensions", (Restlet)extensions);
        this.getTunnelService().setExtensionsTunnel(true);
        this.tracker = new ServiceTracker(this.context, RestApiExtension.class, (ServiceTrackerCustomizer)new ExtensionsTrackerCustomizer(extensions));
        this.tracker.open();
        attributes.put(TRACKER_ATTR, this.tracker);
        this.getContext().setAttributes(attributes);
        extensions.attach("", ExtensionsResource.class);
        return root;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ExtensionsTrackerCustomizer
    implements ServiceTrackerCustomizer<RestApiExtension, Class<? extends ServerResource>> {
        private final Router router;

        public ExtensionsTrackerCustomizer(Router router) {
            this.router = router;
        }

        public Class<? extends ServerResource> addingService(ServiceReference<RestApiExtension> reference) {
            String uri_path = (String)reference.getProperty("org.osgi.rest.uri.path");
            Class proprietary_extension_unit = (Class)reference.getProperty("restlet");
            try {
                URI uri = new URI("/" + uri_path);
                this.router.attach(uri.toString(), proprietary_extension_unit);
                return proprietary_extension_unit;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return null;
            }
        }

        public void modifiedService(ServiceReference<RestApiExtension> reference, Class<? extends ServerResource> service) {
            this.removedService(reference, service);
            this.addingService((ServiceReference)reference);
        }

        public void removedService(ServiceReference<RestApiExtension> reference, Class<? extends ServerResource> service) {
            this.router.detach(service);
        }
    }
}

