/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.service.rest.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.impl.service.rest.PojoReflector;
import org.osgi.impl.service.rest.pojos.BundleExceptionPojo;
import org.osgi.impl.service.rest.pojos.ServicePojo;
import org.osgi.resource.Capability;
import org.osgi.service.rest.RestApiExtension;
import org.osgi.util.tracker.ServiceTracker;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractOSGiResource<T>
extends ServerResource {
    private static final String number = "([0-9]*)";
    private static final String MT_JSON = "+json";
    private static final String MT_XML = "+xml";
    private static final String MT_BE = "application/org.osgi.bundleexception";
    private static final MediaType MT_BE_JSON = new MediaType("application/org.osgi.bundleexception+json");
    private static final MediaType MT_BE_XML = new MediaType("application/org.osgi.bundleexception+xml");
    protected static final Representation SUCCESS = null;
    private static final Representation ERROR = null;
    private final PojoReflector<T> reflector;
    private final MediaType xmlMediaType;
    private final MediaType jsonMediaType;

    protected AbstractOSGiResource(PojoReflector<T> reflector, MediaType mediaType) {
        this.reflector = reflector;
        this.xmlMediaType = new MediaType(mediaType.toString() + MT_XML);
        this.jsonMediaType = new MediaType(mediaType.toString() + MT_JSON);
        this.setNegotiated(true);
        this.getVariants().add(new Variant(this.jsonMediaType));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.getVariants().add(new Variant(this.xmlMediaType));
        this.getVariants().add(new Variant(MediaType.APPLICATION_XML));
        this.getVariants().add(new Variant(MediaType.TEXT_XML));
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
    }

    protected BundleContext getBundleContext() {
        return (BundleContext)this.getContext().getAttributes().get("context");
    }

    protected ServiceTracker<RestApiExtension, Class<? extends ServerResource>> getTracker() {
        return (ServiceTracker)this.getContext().getAttributes().get("tracker");
    }

    protected FrameworkStartLevel getFrameworkStartLevel() {
        return (FrameworkStartLevel)this.getBundleContext().getBundle(0L).adapt(FrameworkStartLevel.class);
    }

    protected Bundle getBundleFromKeys(String bundleIdKey) {
        String id = (String)this.getRequest().getAttributes().get(bundleIdKey);
        if (id != null) {
            return this.getBundleContext().getBundle(Long.parseLong(id));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected Bundle[] getBundles() throws InvalidSyntaxException {
        BundleContext context = this.getBundleContext();
        if (this.getQuery().isEmpty()) {
            return context.getBundles();
        }
        Map filterMap = this.getQuery().getValuesMap();
        Bundle[] bundles = context.getBundles();
        ArrayList<Object> workingSet = new ArrayList<Object>();
        for (Bundle bundle : bundles) {
            workingSet.add(bundle.adapt(BundleRevision.class));
        }
        for (Map.Entry entry : filterMap.entrySet()) {
            String namespace;
            if (entry.getValue() == null) {
                namespace = "osgi.identity";
                Filter filter = FrameworkUtil.createFilter((String)((String)entry.getKey()));
            } else {
                namespace = (String)entry.getKey();
                Filter filter = FrameworkUtil.createFilter((String)((String)entry.getValue()));
            }
            Iterator iter = workingSet.iterator();
            block2: while (iter.hasNext()) {
                BundleRevision rev = (BundleRevision)iter.next();
                List caps = rev.getCapabilities(namespace);
                for (Capability cap : caps) {
                    void var8_17;
                    if (!var8_17.matches(cap.getAttributes())) continue;
                    continue block2;
                }
                iter.remove();
            }
        }
        if (workingSet.isEmpty()) {
            return new Bundle[0];
        }
        Bundle[] result = new Bundle[workingSet.size()];
        int n = -1;
        for (BundleRevision bundleRevision : workingSet) {
            result[++var6_9] = bundleRevision.getBundle();
        }
        return result;
    }

    protected Bundle[] getBundleVersionsBySymbolicName(String key) {
        String symbolicName = (String)this.getRequest().getAttributes().get(key);
        if (symbolicName == null) {
            return null;
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (Bundle bundle : this.getBundleContext().getBundles()) {
            if (!bundle.getSymbolicName().equals(symbolicName)) continue;
            bundles.add(bundle);
        }
        return bundles.toArray(new Bundle[bundles.size()]);
    }

    protected ServiceReference<?> getServiceReferenceFromKey(String key) {
        String id = (String)this.getRequest().getAttributes().get(key);
        if (id == null) {
            return null;
        }
        if (!id.matches(number)) {
            throw new IllegalArgumentException("Invalid service id " + id);
        }
        try {
            ServiceReference[] srefs = this.getBundleContext().getServiceReferences((String)null, "(service.id=" + id + ")");
            return srefs != null ? srefs[0] : null;
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Representation getRepresentation(Object bean, Variant variant) throws Exception {
        Representation rep;
        MediaType mt;
        if (this.xmlMediaType.includes((Metadata)variant.getMediaType()) || MediaType.APPLICATION_XML.includes((Metadata)variant.getMediaType()) || MediaType.TEXT_XML.includes((Metadata)variant.getMediaType())) {
            mt = this.xmlMediaType;
            rep = bean instanceof Map ? this.toRepresentation(PojoReflector.mapToXml((Map)bean), new Variant(MediaType.APPLICATION_ALL_XML)) : this.toRepresentation(this.reflector.xmlFromBean(bean), new Variant(MediaType.APPLICATION_ALL_XML));
        } else if (this.jsonMediaType.includes((Metadata)variant.getMediaType()) || MediaType.APPLICATION_JSON.includes((Metadata)variant.getMediaType()) || MediaType.TEXT_PLAIN.includes((Metadata)variant.getMediaType())) {
            mt = this.jsonMediaType;
            if (bean instanceof Collection) {
                ArrayList reprList = new ArrayList();
                for (Object o : (Collection)bean) {
                    if (o instanceof String) {
                        reprList.add(o);
                        continue;
                    }
                    reprList.add(this.jsonObject(o));
                }
                JSONArray arr = new JSONArray(reprList);
                rep = this.toRepresentation(arr, variant);
            } else {
                rep = bean instanceof Map ? this.toRepresentation(new JSONObject((Map)bean), variant) : this.toRepresentation(this.jsonObject(bean), variant);
            }
        } else {
            throw new UnsupportedOperationException(variant.getMediaType().toString());
        }
        rep.setMediaType(mt);
        return rep;
    }

    private JSONObject jsonObject(Object bean) {
        if (bean instanceof ServicePojo) {
            JSONObject json = new JSONObject(bean);
            try {
                json.put("properties", (Object)new JSONObject(((ServicePojo)bean).getProperties()));
                json.put("usingBundles", (Object)new JSONArray((Object)((ServicePojo)bean).getUsingBundles()));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return json;
        }
        return new JSONObject(bean);
    }

    protected T fromRepresentation(Representation r, MediaType mediaType) throws Exception {
        if (this.xmlMediaType.includes((Metadata)mediaType) || MediaType.APPLICATION_XML.includes((Metadata)mediaType) || MediaType.TEXT_XML.includes((Metadata)mediaType)) {
            return this.reflector.beanFromXml((Document)this.toObject(r, Document.class));
        }
        if (this.jsonMediaType.includes((Metadata)mediaType) || MediaType.APPLICATION_JSON.includes((Metadata)mediaType) || MediaType.TEXT_PLAIN.includes((Metadata)mediaType)) {
            return this.reflector.beanFromJSONObject((JSONObject)this.toObject(r, JSONObject.class));
        }
        throw new UnsupportedOperationException(mediaType.toString());
    }

    protected Map<String, String> mapFromDict(Dictionary<String, String> headers) {
        HashMap<String, String> map = new HashMap<String, String>(headers.size());
        Enumeration<String> keyE = headers.keys();
        while (keyE.hasMoreElements()) {
            String key = keyE.nextElement();
            map.put(key, headers.get(key));
        }
        return map;
    }

    protected Representation ERROR(Throwable t, Variant variant) {
        t.printStackTrace();
        if (t instanceof BundleException) {
            try {
                Representation rep;
                MediaType mt;
                if (MediaType.APPLICATION_ALL_XML.includes((Metadata)variant.getMediaType())) {
                    mt = MT_BE_XML;
                    rep = this.getRepresentation(new BundleExceptionPojo((BundleException)t), new Variant(MediaType.TEXT_XML));
                } else {
                    mt = MT_BE_JSON;
                    rep = this.getRepresentation(new BundleExceptionPojo((BundleException)t), new Variant(MediaType.APPLICATION_JSON));
                }
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                rep.setMediaType(mt);
                return rep;
            }
            catch (Exception exception) {}
        } else {
            if (t instanceof IllegalArgumentException) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return ERROR;
            }
            if (t instanceof InvalidSyntaxException) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return ERROR;
            }
        }
        this.setStatus(Status.SERVER_ERROR_INTERNAL, t);
        return ERROR;
    }

    protected Representation SUCCESS(Status status) {
        this.setStatus(status);
        return SUCCESS;
    }

    protected Representation ERROR(Status status) {
        this.setStatus(status);
        return ERROR;
    }

    protected Representation ERROR(Status status, Exception e) {
        this.setStatus(status, e);
        return ERROR;
    }

    protected Representation ERROR(Status status, String s) {
        this.setStatus(status, s);
        return ERROR;
    }
}

