/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.service.rest.resources;

import java.net.MalformedURLException;
import java.net.URL;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.impl.service.rest.PojoReflector;
import org.osgi.impl.service.rest.pojos.BundlePojo;
import org.osgi.impl.service.rest.resources.AbstractOSGiResource;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleResource
extends AbstractOSGiResource<BundlePojo> {
    private static final MediaType MEDIA_TYPE = MediaType.valueOf((String)"application/org.osgi.bundle");

    public BundleResource() {
        super(PojoReflector.getReflector(BundlePojo.class), MEDIA_TYPE);
    }

    public Representation get(Variant variant) {
        try {
            Bundle bundle = this.getBundleFromKeys("bundleId");
            if (bundle == null) {
                return this.ERROR(Status.CLIENT_ERROR_NOT_FOUND);
            }
            return this.getRepresentation(new BundlePojo(bundle), variant);
        }
        catch (Exception e) {
            return this.ERROR(e, variant);
        }
    }

    public Representation delete(Variant variant) {
        try {
            Bundle bundle = this.getBundleFromKeys("bundleId");
            if (bundle == null) {
                return this.ERROR(Status.CLIENT_ERROR_NOT_FOUND);
            }
            bundle.uninstall();
        }
        catch (Exception e) {
            return this.ERROR(e, variant);
        }
        return this.SUCCESS(Status.SUCCESS_NO_CONTENT);
    }

    public Representation put(Representation content, Variant variant) {
        try {
            if (MediaType.TEXT_PLAIN.equals((Object)content.getMediaType())) {
                Bundle bundle = this.getBundleFromKeys("bundleId");
                if (bundle == null) {
                    return this.ERROR(Status.CLIENT_ERROR_NOT_FOUND);
                }
                String location = content.getText();
                if (location == null) {
                    bundle.update();
                } else {
                    bundle.update(new URL(location).openStream());
                }
                return this.SUCCESS(Status.SUCCESS_NO_CONTENT);
            }
            Bundle bundle = this.getBundleFromKeys("bundleId");
            if (bundle == null) {
                return this.ERROR(Status.CLIENT_ERROR_NOT_FOUND);
            }
            bundle.update(content.getStream());
            return this.SUCCESS(Status.SUCCESS_NO_CONTENT);
        }
        catch (MalformedURLException e) {
            return this.ERROR((Throwable)new BundleException("Malformed update URL", 11, (Throwable)e), variant);
        }
        catch (Exception e) {
            return this.ERROR(e, variant);
        }
    }
}

