/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.service.rest.resources;

import org.osgi.framework.Bundle;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.impl.service.rest.PojoReflector;
import org.osgi.impl.service.rest.pojos.BundleStartLevelPojo;
import org.osgi.impl.service.rest.resources.AbstractOSGiResource;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleStartLevelResource
extends AbstractOSGiResource<BundleStartLevelPojo> {
    private static final MediaType MEDIA_TYPE = MediaType.valueOf((String)"application/org.osgi.bundlestartlevel");

    public BundleStartLevelResource() {
        super(PojoReflector.getReflector(BundleStartLevelPojo.class), MEDIA_TYPE);
    }

    public Representation get(Variant variant) {
        try {
            Bundle bundle = this.getBundleFromKeys("bundleId");
            if (bundle == null) {
                return this.ERROR(Status.CLIENT_ERROR_NOT_FOUND);
            }
            BundleStartLevel bsl = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
            BundleStartLevelPojo sl = new BundleStartLevelPojo(bsl);
            return this.getRepresentation(sl, variant);
        }
        catch (Exception e) {
            return this.ERROR(e, variant);
        }
    }

    public Representation put(Representation value, Variant variant) {
        try {
            Bundle bundle = this.getBundleFromKeys("bundleId");
            if (bundle == null) {
                return this.ERROR(Status.CLIENT_ERROR_NOT_FOUND);
            }
            BundleStartLevelPojo sl = (BundleStartLevelPojo)this.fromRepresentation(value, value.getMediaType());
            BundleStartLevel bsl = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
            bsl.setStartLevel(sl.getStartLevel());
            return this.getRepresentation(new BundleStartLevelPojo(bsl), variant);
        }
        catch (Exception e) {
            return this.ERROR(e, variant);
        }
    }
}

