/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.service.rest.resources;

import org.osgi.framework.Bundle;
import org.osgi.impl.service.rest.PojoReflector;
import org.osgi.impl.service.rest.pojos.BundleStatePojo;
import org.osgi.impl.service.rest.resources.AbstractOSGiResource;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleStateResource
extends AbstractOSGiResource<BundleStatePojo> {
    private static final MediaType MEDIA_TYPE = MediaType.valueOf((String)"application/org.osgi.bundlestate");

    public BundleStateResource() {
        super(PojoReflector.getReflector(BundleStatePojo.class), MEDIA_TYPE);
    }

    public Representation get(Variant variant) {
        try {
            Bundle bundle = this.getBundleFromKeys("bundleId");
            if (bundle == null) {
                this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                return null;
            }
            return this.getRepresentation(new BundleStatePojo(bundle.getState()), variant);
        }
        catch (Exception e) {
            return this.ERROR(e, variant);
        }
    }

    public Representation put(Representation value, Variant variant) {
        try {
            Bundle bundle = this.getBundleFromKeys("bundleId");
            if (bundle == null) {
                this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                return null;
            }
            BundleStatePojo targetState = (BundleStatePojo)this.fromRepresentation(value, value.getMediaType());
            if (bundle.getState() == 1) {
                return this.ERROR(Status.CLIENT_ERROR_PRECONDITION_FAILED, "target state " + targetState.getState() + " not reachable from the current state");
            }
            if (targetState.getState() == 32) {
                bundle.start(targetState.getOptions());
                return this.getRepresentation(new BundleStatePojo(bundle.getState()), variant);
            }
            if (targetState.getState() == 4) {
                bundle.stop(targetState.getOptions());
                return this.getRepresentation(new BundleStatePojo(bundle.getState()), variant);
            }
            return this.ERROR(Status.CLIENT_ERROR_BAD_REQUEST, "target state " + targetState.getState() + " not supported");
        }
        catch (Exception e) {
            return this.ERROR(e, variant);
        }
    }
}

