/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.service.rest.resources;

import java.util.UUID;
import org.osgi.framework.Bundle;
import org.osgi.impl.service.rest.PojoReflector;
import org.osgi.impl.service.rest.pojos.BundlePojoList;
import org.osgi.impl.service.rest.resources.AbstractOSGiResource;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundlesResource
extends AbstractOSGiResource<BundlePojoList> {
    private static final MediaType MEDIA_TYPE = MediaType.valueOf((String)"application/org.osgi.bundles");

    public BundlesResource() {
        super(PojoReflector.getReflector(BundlePojoList.class), MEDIA_TYPE);
    }

    public Representation get(Variant variant) {
        try {
            Representation rep = this.getRepresentation(new BundlePojoList(this.getBundles()), variant);
            return rep;
        }
        catch (Exception e) {
            return this.ERROR(e, variant);
        }
    }

    public Representation post(Representation content, Variant variant) {
        try {
            if (MediaType.TEXT_PLAIN.equals((Object)content.getMediaType())) {
                String uri = content.getText();
                if (this.getBundleContext().getBundle(uri) != null) {
                    this.ERROR(Status.CLIENT_ERROR_CONFLICT);
                }
                Bundle bundle = this.getBundleContext().installBundle(uri);
                return new StringRepresentation((CharSequence)("framework/bundle/" + bundle.getBundleId()));
            }
            Form headers = (Form)this.getRequestAttributes().get("org.restlet.http.headers");
            String location = headers.getFirstValue("Content-Location");
            if (location != null) {
                if (this.getBundleContext().getBundle(location) != null) {
                    return this.ERROR(Status.CLIENT_ERROR_CONFLICT);
                }
            } else {
                location = UUID.randomUUID().toString();
            }
            Bundle bundle = this.getBundleContext().installBundle(location, content.getStream());
            return new StringRepresentation((CharSequence)("framework/bundle/" + bundle.getBundleId()));
        }
        catch (Exception e) {
            return this.ERROR(e, variant);
        }
    }
}

