/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.service.rest.client;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.dto.DTO;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DTOReflector {
    private static final MediaType XML_BASED = MediaType.valueOf((String)"application/*+xml");
    private static final MediaType JSON_BASED = MediaType.valueOf((String)"application/*+json");
    private static final Pattern p = Pattern.compile("\\/(\\d+)\\/*");

    public static <T extends DTO> T getDTO(Class<T> clazz, Representation repr) throws Exception {
        if (JSON_BASED.includes((Metadata)repr.getMediaType())) {
            JSONObject data = new JsonRepresentation(repr).getJsonObject();
            return DTOReflector.getDTOfromJson(clazz, data, repr.getLocationRef().getPath());
        }
        if (XML_BASED.includes((Metadata)repr.getMediaType())) {
            Document doc = new DomRepresentation(repr).getDocument();
            return DTOReflector.getDTOfromXml(clazz, (Element)doc.getFirstChild(), repr.getLocationRef().getPath());
        }
        throw new UnsupportedOperationException(repr.getMediaType().toString());
    }

    public static <T extends DTO> Collection<T> getDTOs(Class<T> clazz, Representation repr) throws Exception {
        if (JSON_BASED.includes((Metadata)repr.getMediaType())) {
            return DTOReflector.getDTOsFromJson(clazz, new JsonRepresentation(repr).getJsonArray());
        }
        if (XML_BASED.includes((Metadata)repr.getMediaType())) {
            System.out.println("content: " + repr.getText());
            return DTOReflector.getDTOsFromXml(clazz, new DomRepresentation(repr).getDocument());
        }
        throw new UnsupportedOperationException(repr.getMediaType().toString());
    }

    public static Map<String, String> getMap(Representation repr) throws Exception {
        if (JSON_BASED.includes((Metadata)repr.getMediaType())) {
            JSONObject data = new JsonRepresentation(repr).getJsonObject();
            return DTOReflector.getMapfromJsonObject(data);
        }
        throw new UnsupportedOperationException(repr.getMediaType().toString());
    }

    public static Collection<String> getStrings(Representation repr) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        if (JSON_BASED.includes((Metadata)repr.getMediaType())) {
            JSONArray array = new JsonRepresentation(repr).getJsonArray();
            for (int i = 0; i < array.length(); ++i) {
                result.add(array.getString(i));
            }
        } else if (XML_BASED.includes((Metadata)repr.getMediaType())) {
            Document doc = new DomRepresentation(repr).getDocument();
            Node rootNode = doc.getFirstChild();
            NodeList nodes = rootNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                result.add(nodes.item(i).getTextContent());
            }
        } else {
            throw new UnsupportedOperationException(repr.getMediaType().toString());
        }
        return result;
    }

    private static <T extends DTO> T getDTOfromJson(Class<T> clazz, JSONObject data, String path) throws Exception {
        Field[] fields = clazz.getFields();
        DTO dto = (DTO)clazz.newInstance();
        for (Field field : fields) {
            if ("bundle".equals(field.getName())) {
                if (data.has("bundle")) {
                    field.set(dto, new Long(DTOReflector.getBundleIdFromPath(data.getString("bundle"))));
                    continue;
                }
                field.set(dto, new Long(DTOReflector.getBundleIdFromPath(path)));
                continue;
            }
            if ("usingBundles".equals(field.getName())) {
                field.set(dto, DTOReflector.getBundleIdsFromPaths(data.getJSONArray("usingBundles")));
                continue;
            }
            if (field.getType().equals(Map.class)) {
                field.set(dto, DTOReflector.getMapfromJsonObject(data.getJSONObject(field.getName())));
                continue;
            }
            field.set(dto, data.get(field.getName()));
        }
        return (T)dto;
    }

    private static <T extends DTO> T getDTOfromXml(Class<T> clazz, Element elem, String path) throws Exception {
        Field[] fields = clazz.getFields();
        DTO dto = (DTO)clazz.newInstance();
        for (Field field : fields) {
            int i;
            if ("bundle".equals(field.getName())) {
                if (elem.getElementsByTagName("bundle") != null) {
                    field.set(dto, new Long(DTOReflector.getBundleIdFromPath(elem.getElementsByTagName("bundle").item(0).getTextContent())));
                    continue;
                }
                field.set(dto, new Long(DTOReflector.getBundleIdFromPath(path)));
                continue;
            }
            if ("usingBundles".equals(field.getName())) {
                Node node = elem.getElementsByTagName("usingBundles").item(0);
                NodeList nodes = node.getChildNodes();
                if (nodes.getLength() <= 0) continue;
                long[] using = new long[nodes.getLength()];
                for (i = 0; i < nodes.getLength(); ++i) {
                    using[i] = DTOReflector.getBundleIdFromPath(nodes.item(i).getTextContent());
                    field.set(dto, using);
                }
                continue;
            }
            if ("id".equals(field.getName()) || "lastModified".equals(field.getName())) {
                field.set(dto, Long.valueOf(elem.getElementsByTagName(field.getName()).item(0).getTextContent()));
                continue;
            }
            if ("state".equals(field.getName())) {
                field.set(dto, Integer.valueOf(elem.getElementsByTagName(field.getName()).item(0).getTextContent()));
                continue;
            }
            if (field.getType().equals(Map.class)) {
                Node props = elem.getElementsByTagName("properties").item(0);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                NodeList prop = props.getChildNodes();
                for (i = 0; i < prop.getLength(); ++i) {
                    DTOReflector.propertyFromXml(properties, prop.item(i));
                }
                field.set(dto, properties);
                continue;
            }
            field.set(dto, elem.getElementsByTagName(field.getName()).item(0).getTextContent());
        }
        return (T)dto;
    }

    private static void propertyFromXml(Map<String, Object> map, Node node) {
        Object value;
        String name = node.getAttributes().getNamedItem("name").getTextContent();
        Node tNode = node.getAttributes().getNamedItem("type");
        String type = tNode == null ? null : tNode.getTextContent();
        Node vNode = node.getAttributes().getNamedItem("value");
        if (vNode != null) {
            value = DTOReflector.fromXml(type, vNode.getTextContent());
        } else {
            String[] vals = node.getTextContent().split("\n");
            int len = vals.length;
            value = DTOReflector.getArray(type, len);
            for (int i = 0; i < len; ++i) {
                Array.set(value, i, DTOReflector.fromXml(type, vals[i]));
            }
        }
        map.put(name, value);
    }

    private static Object fromXml(String type, String value) {
        if (type == null || "String".equals(type)) {
            return value;
        }
        if ("Long".equals(type)) {
            return Long.valueOf(value);
        }
        if ("Double".equals(type)) {
            return Double.valueOf(value);
        }
        if ("Float".equals(type)) {
            return Float.valueOf(value);
        }
        if ("Integer".equals(type)) {
            return Integer.valueOf(value);
        }
        if ("Byte".equals(type)) {
            return Byte.valueOf(value);
        }
        if ("Character".equals(type)) {
            return new Character(value.trim().charAt(0));
        }
        if ("Boolean".equals(type)) {
            return Boolean.valueOf(value);
        }
        if ("Short".equals(type)) {
            return Short.valueOf(value);
        }
        return value;
    }

    private static Object getArray(String type, int len) {
        if (type == null || "String".equals(type)) {
            return new String[len];
        }
        if ("Long".equals(type)) {
            return new long[len];
        }
        if ("Double".equals(type)) {
            return new double[len];
        }
        if ("Float".equals(type)) {
            return new float[len];
        }
        if ("Integer".equals(type)) {
            return new int[len];
        }
        if ("Byte".equals(type)) {
            return new byte[len];
        }
        if ("Character".equals(type)) {
            return new char[len];
        }
        if ("Boolean".equals(type)) {
            return new boolean[len];
        }
        if ("Short".equals(type)) {
            return new short[len];
        }
        return new Object[len];
    }

    private static long getBundleIdFromPath(String path) {
        Matcher m = p.matcher(path);
        if (m.find()) {
            String s = m.group(1);
            return Long.parseLong(s);
        }
        throw new IllegalArgumentException(path);
    }

    private static long[] getBundleIdsFromPaths(JSONArray array) throws JSONException {
        if (array.length() == 0) {
            return null;
        }
        long[] result = new long[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            result[i] = DTOReflector.getBundleIdFromPath(array.getString(i));
        }
        return result;
    }

    private static <K, V> Map<K, V> getMapfromJsonObject(JSONObject obj) throws JSONException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] keys = JSONObject.getNames((JSONObject)obj);
        for (int i = 0; i < keys.length; ++i) {
            Long o;
            Long l = o = keys[i].equals("service.id") || keys[i].equals("service.bundleid") ? new Long(obj.getLong(keys[i])) : obj.get(keys[i]);
            if (o instanceof JSONArray) {
                result.put(keys[i], DTOReflector.getStringArrayFromJSONArray((JSONArray)o));
                continue;
            }
            result.put(keys[i], o);
        }
        return result;
    }

    private static String[] getStringArrayFromJSONArray(JSONArray a) throws JSONException {
        String[] result = new String[a.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = a.getString(i);
        }
        return result;
    }

    private static <T extends DTO> Collection<T> getDTOsFromJson(Class<T> clazz, JSONArray array) throws Exception {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < array.length(); ++i) {
            result.add(DTOReflector.getDTOfromJson(clazz, array.getJSONObject(i), null));
        }
        return result;
    }

    private static <T extends DTO> Collection<T> getDTOsFromXml(Class<T> clazz, Node rootNode) throws Exception {
        ArrayList<T> result = new ArrayList<T>();
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            result.add(DTOReflector.getDTOfromXml(clazz, (Element)nodes.item(i), null));
        }
        return result;
    }

    public static <T extends DTO> JSONObject getJson(Class<T> clazz, T dto) throws Exception {
        Field[] fields = clazz.getFields();
        JSONObject obj = new JSONObject();
        for (Field field : fields) {
            if (field.getName().equals("bundle")) {
                obj.put("bundle", (Object)DTOReflector.getBundlePathFromId((Long)field.get(dto)));
                continue;
            }
            obj.put(field.getName(), field.get(dto));
        }
        return obj;
    }

    private static String getBundlePathFromId(Long id) {
        return "framework/bundle/" + id.toString();
    }
}

