/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.service.rest.client;

import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.json.JSONObject;
import org.osgi.framework.dto.BundleDTO;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.framework.startlevel.dto.BundleStartLevelDTO;
import org.osgi.framework.startlevel.dto.FrameworkStartLevelDTO;
import org.osgi.impl.service.rest.client.DTOReflector;
import org.osgi.service.rest.client.RestClient;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestClientImpl
implements RestClient {
    private static final String MT_FRAMEWORK_STARTLEVEL = "application/org.osgi.framework.startlevel";
    private static final String MT_BUNDLE = "application/org.osgi.bundle";
    private static final String MT_BUNDLES = "application/org.osgi.bundles";
    private static final String MT_BUNDLES_REPRESENTATIONS = "application/org.osgi.bundles.representations";
    private static final String MT_BUNDLE_STATE = "application/org.osgi.bundle.state";
    private static final String MT_BUNDLE_HEADER = "application/org.osgi.bundle.header";
    private static final String MT_BUNDLE_STARTLEVEL = "application/org.osgi.bundle.startlevel";
    private static final String MT_SERVICE = "application/org.osgi.service";
    private static final String MT_SERVICES = "application/org.osgi.services";
    private static final String MT_SERVICES_REPRESENTATIONS = "application/org.osgi.services.representations";
    private static final String MT_JSON_EXT = "+json";
    private static final String MT_XML_EXT = "+xml";
    private final MediaType FRAMEWORK_STARTLEVEL;
    private final MediaType BUNDLE;
    private final MediaType BUNDLES;
    private final MediaType BUNDLES_REPRESENTATIONS;
    private final MediaType BUNDLE_STATE;
    private final MediaType BUNDLE_HEADER;
    private final MediaType BUNDLE_STARTLEVEL;
    private final MediaType SERVICE;
    private final MediaType SERVICES;
    private final MediaType SERVICES_REPRESENTATIONS;
    private final URI baseUri;

    protected RestClientImpl(URI uri, boolean useXml) {
        this.baseUri = uri.normalize().resolve("/");
        String ext = useXml ? MT_XML_EXT : MT_JSON_EXT;
        this.FRAMEWORK_STARTLEVEL = new MediaType(MT_FRAMEWORK_STARTLEVEL + ext);
        this.BUNDLE = new MediaType(MT_BUNDLE + ext);
        this.BUNDLES = new MediaType(MT_BUNDLES + ext);
        this.BUNDLES_REPRESENTATIONS = new MediaType(MT_BUNDLES_REPRESENTATIONS + ext);
        this.BUNDLE_STATE = new MediaType(MT_BUNDLE_STATE + ext);
        this.BUNDLE_HEADER = new MediaType(MT_BUNDLE_HEADER + ext);
        this.BUNDLE_STARTLEVEL = new MediaType(MT_BUNDLE_STARTLEVEL + ext);
        this.SERVICE = new MediaType(MT_SERVICE + ext);
        this.SERVICES = new MediaType(MT_SERVICES + ext);
        this.SERVICES_REPRESENTATIONS = new MediaType(MT_SERVICES_REPRESENTATIONS + ext);
    }

    @Override
    public FrameworkStartLevelDTO getFrameworkStartLevel() throws Exception {
        Representation repr = new ClientResource(Method.GET, this.baseUri.resolve("framework/startlevel")).get(this.FRAMEWORK_STARTLEVEL);
        return DTOReflector.getDTO(FrameworkStartLevelDTO.class, repr);
    }

    @Override
    public void setFrameworkStartLevel(FrameworkStartLevelDTO startLevel) throws Exception {
        new ClientResource(Method.PUT, this.baseUri.resolve("framework/startlevel")).put((Object)DTOReflector.getJson(FrameworkStartLevelDTO.class, startLevel), this.FRAMEWORK_STARTLEVEL);
    }

    @Override
    public Collection<String> getBundlePaths() throws Exception {
        ClientResource res = new ClientResource(Method.GET, this.baseUri.resolve("framework/bundles"));
        Representation repr = res.get(this.BUNDLES);
        return DTOReflector.getStrings(repr);
    }

    @Override
    public Collection<BundleDTO> getBundles() throws Exception {
        try {
            Representation repr = new ClientResource(Method.GET, this.baseUri.resolve("framework/bundles/representations")).get(this.BUNDLES_REPRESENTATIONS);
            return DTOReflector.getDTOs(BundleDTO.class, repr);
        }
        catch (ResourceException e) {
            if (Status.CLIENT_ERROR_NOT_FOUND.equals((Object)e.getStatus())) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public BundleDTO getBundle(long id) throws Exception {
        return this.getBundle("framework/bundle/" + id);
    }

    @Override
    public BundleDTO getBundle(String bundlePath) throws Exception {
        try {
            Representation repr = new ClientResource(Method.GET, this.baseUri.resolve(bundlePath)).get(this.BUNDLE);
            return DTOReflector.getDTO(BundleDTO.class, repr);
        }
        catch (ResourceException e) {
            if (Status.CLIENT_ERROR_NOT_FOUND.equals((Object)e.getStatus())) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public int getBundleState(long id) throws Exception {
        return this.getBundleState("framework/bundle/" + id);
    }

    @Override
    public int getBundleState(String bundlePath) throws Exception {
        Representation repr = new ClientResource(Method.GET, this.baseUri.resolve(bundlePath + "/state")).get(this.BUNDLE_STATE);
        JSONObject obj = new JsonRepresentation(repr).getJsonObject();
        return obj.getInt("state");
    }

    @Override
    public void startBundle(long id) throws Exception {
        this.startBundle("framework/bundle/" + id, 0);
    }

    @Override
    public void startBundle(long id, int options) throws Exception {
        this.startBundle("framework/bundle/" + id, options);
    }

    @Override
    public void startBundle(String bundlePath) throws Exception {
        this.startBundle(bundlePath, 0);
    }

    @Override
    public void startBundle(String bundlePath, int options) throws Exception {
        JSONObject state = new JSONObject();
        state.put("state", 32);
        state.put("options", options);
        new ClientResource(Method.PUT, this.baseUri.resolve(bundlePath + "/state")).put((Object)state, this.BUNDLE_STATE);
    }

    @Override
    public void stopBundle(long id) throws Exception {
        this.stopBundle("framework/bundle/" + id, 0);
    }

    @Override
    public void stopBundle(long id, int options) throws Exception {
        this.stopBundle("framework/bundle/" + id, options);
    }

    @Override
    public void stopBundle(String bundlePath) throws Exception {
        this.stopBundle(bundlePath, 0);
    }

    @Override
    public void stopBundle(String bundlePath, int options) throws Exception {
        JSONObject state = new JSONObject();
        state.put("state", 4);
        state.put("options", options);
        new ClientResource(Method.PUT, this.baseUri.resolve(bundlePath + "/state")).put((Object)state, this.BUNDLE_STATE);
    }

    @Override
    public Map<String, String> getBundleHeaders(long id) throws Exception {
        return this.getBundleHeaders("framework/bundle/" + id);
    }

    @Override
    public Map<String, String> getBundleHeaders(String bundlePath) throws Exception {
        Representation repr = new ClientResource(Method.GET, this.baseUri.resolve(bundlePath + "/header")).get(this.BUNDLE_HEADER);
        return DTOReflector.getMap(repr);
    }

    @Override
    public BundleStartLevelDTO getBundleStartLevel(long id) throws Exception {
        return this.getBundleStartLevel("framework/bundle/" + id);
    }

    @Override
    public BundleStartLevelDTO getBundleStartLevel(String bundlePath) throws Exception {
        Representation repr = new ClientResource(Method.GET, this.baseUri.resolve(bundlePath + "/startlevel")).get(this.BUNDLE_STARTLEVEL);
        return DTOReflector.getDTO(BundleStartLevelDTO.class, repr);
    }

    @Override
    public void setBundleStartLevel(long id, int startLevel) throws Exception {
        this.setBundleStartLevel("framework/bundle/" + id, startLevel);
    }

    @Override
    public void setBundleStartLevel(String bundlePath, int startLevel) throws Exception {
        BundleStartLevelDTO bsl = new BundleStartLevelDTO();
        bsl.startLevel = startLevel;
        new ClientResource(Method.PUT, this.baseUri.resolve(bundlePath + "/startlevel")).put((Object)DTOReflector.getJson(BundleStartLevelDTO.class, bsl), this.BUNDLE_STARTLEVEL);
    }

    @Override
    public BundleDTO installBundle(String url) throws Exception {
        ClientResource res = new ClientResource(Method.POST, this.baseUri.resolve("framework/bundles"));
        Representation repr = res.post((Object)url, MediaType.TEXT_PLAIN);
        return this.getBundle(repr.getText());
    }

    @Override
    public BundleDTO installBundle(String location, InputStream in) throws Exception {
        ClientResource res = new ClientResource(Method.POST, this.baseUri.resolve("framework/bundles"));
        Form responseHeaders = (Form)res.getRequestAttributes().get("org.restlet.http.headers");
        if (responseHeaders == null) {
            responseHeaders = new Form();
            res.getRequestAttributes().put("org.restlet.http.headers", responseHeaders);
        }
        responseHeaders.add("Content-Location", location);
        Representation repr = res.post((Object)in);
        return this.getBundle(repr.getText());
    }

    @Override
    public BundleDTO updateBundle(long id) throws Exception {
        new ClientResource(Method.PUT, this.baseUri.resolve("framework/bundle/" + id)).put((Object)"", MediaType.TEXT_PLAIN);
        return this.getBundle(id);
    }

    @Override
    public BundleDTO updateBundle(long id, String url) throws Exception {
        new ClientResource(Method.PUT, this.baseUri.resolve("framework/bundle/" + id)).put((Object)url, MediaType.TEXT_PLAIN);
        return this.getBundle(id);
    }

    @Override
    public BundleDTO updateBundle(long id, InputStream in) throws Exception {
        new ClientResource(Method.PUT, this.baseUri.resolve("framework/bundle/" + id)).put((Object)in);
        return this.getBundle(id);
    }

    @Override
    public BundleDTO uninstallBundle(long id) throws Exception {
        return this.uninstallBundle("framework/bundle/" + id);
    }

    @Override
    public BundleDTO uninstallBundle(String bundlePath) throws Exception {
        BundleDTO bundle = this.getBundle(bundlePath);
        ClientResource res = new ClientResource(Method.DELETE, this.baseUri.resolve(bundlePath));
        res.delete();
        return bundle;
    }

    @Override
    public Collection<String> getServicePaths() throws Exception {
        return this.getServicePaths(null);
    }

    @Override
    public Collection<String> getServicePaths(String filter) throws Exception {
        ClientResource res = new ClientResource(Method.GET, this.baseUri.resolve("framework/services"));
        if (filter != null) {
            res.getQuery().add("filter", filter);
        }
        Representation repr = res.get(this.SERVICES);
        return DTOReflector.getStrings(repr);
    }

    @Override
    public Collection<ServiceReferenceDTO> getServiceReferences() throws Exception {
        return this.getServiceReferences(null);
    }

    @Override
    public Collection<ServiceReferenceDTO> getServiceReferences(String filter) throws Exception {
        ClientResource res = new ClientResource(Method.GET, this.baseUri.resolve("framework/services/representations"));
        if (filter != null) {
            res.getQuery().add("filter", filter);
        }
        Representation repr = res.get(this.SERVICES_REPRESENTATIONS);
        return DTOReflector.getDTOs(ServiceReferenceDTO.class, repr);
    }

    @Override
    public ServiceReferenceDTO getServiceReference(long id) throws Exception {
        return this.getServiceReference("framework/service/" + id);
    }

    @Override
    public ServiceReferenceDTO getServiceReference(String servicePath) throws Exception {
        Representation repr = new ClientResource(Method.GET, this.baseUri.resolve(servicePath)).get(this.SERVICE);
        return DTOReflector.getDTO(ServiceReferenceDTO.class, repr);
    }
}

