/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge.service.eventadmin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.concierge.service.eventadmin.EventAdminActivator;
import org.eclipse.concierge.service.eventadmin.Subscription;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.osgi.service.event.TopicPermission;

final class EventAdminImpl
implements FrameworkListener,
BundleListener,
ServiceListener,
EventAdmin {
    private static final String[] FRAMEWORK_EVENT = new String[]{"STARTED", "ERROR", "PACKAGES_REFRESHED", "STARTLEVEL_CHANGED", "WARNING"};
    private static final String[] BUNDLE_EVENT = new String[]{"INSTALLED", "STARTED", "STOPPED", "UPDATED", "UNINSTALLED", "RESOLVED", "UNRESOLVED"};
    private static final String[] SERVICE_EVENT = new String[]{"REGISTERED", "MODIFIED", "UNREGISTERING"};
    private List eventQueue = new ArrayList(2);
    private HashMap eventHandlerSubscriptions = new HashMap(2);
    static SecurityManager security;
    boolean running = true;

    public EventAdminImpl() {
        security = System.getSecurityManager();
        ServiceReference[] refs = null;
        try {
            refs = EventAdminActivator.context.getServiceReferences(EventHandler.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                try {
                    Object handler = EventAdminActivator.context.getService(refs[i]);
                    if (handler == this) continue;
                    String[] topics = (String[])refs[i].getProperty("event.topics");
                    String filter = (String)refs[i].getProperty("event.filter");
                    Filter filterObj = filter != null ? EventAdminActivator.context.createFilter(filter) : null;
                    this.eventHandlerSubscriptions.put(refs[i].getProperty("service.id"), new Subscription((EventHandler)handler, topics, filterObj));
                    continue;
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
        new EventDispatchingThread().start();
    }

    public void frameworkEvent(FrameworkEvent fEvent) {
        int t;
        Throwable throwable;
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("event", fEvent);
        ((Dictionary)props).put("timestamp", new Long(System.currentTimeMillis()));
        Bundle bundle = fEvent.getBundle();
        if (bundle != null) {
            ((Dictionary)props).put("bundle.id", new Long(bundle.getBundleId()));
            ((Dictionary)props).put("bundle.symbolicName", "null");
            ((Dictionary)props).put("bundle", bundle);
        }
        if ((throwable = fEvent.getThrowable()) != null) {
            ((Dictionary)props).put("exception.class", throwable.getClass().getName());
            ((Dictionary)props).put("exception.message", throwable.getMessage());
            ((Dictionary)props).put("exception", throwable);
        }
        String type = (t = EventAdminImpl.log2(fEvent.getType())) < 5 ? FRAMEWORK_EVENT[t] : "UNDEFINED";
        Event event = new Event("org/osgi/framework/FrameworkEvent/" + type, (Dictionary<String, ?>)props);
        this.postEvent(event);
    }

    public void bundleChanged(BundleEvent bEvent) {
        Hashtable<String, Long> props = new Hashtable<String, Long>();
        ((Dictionary)props).put("timestamp", new Long(System.currentTimeMillis()));
        Bundle bundle = bEvent.getBundle();
        ((Dictionary)props).put("event", (Long)bEvent);
        ((Dictionary)props).put("bundle.id", new Long(bundle.getBundleId()));
        ((Dictionary)props).put("bundle", (Long)bundle);
        int t = EventAdminImpl.log2(bEvent.getType());
        String type = t < 7 ? BUNDLE_EVENT[t] : "UNDEFINED";
        Event event = new Event("org/osgi/framework/BundleEvent/" + type, (Dictionary<String, ?>)props);
        this.postEvent(event);
    }

    public void serviceChanged(ServiceEvent sEvent) {
        try {
            ServiceReference ref = sEvent.getServiceReference();
            List<String> objClasses = Arrays.asList((String[])ref.getProperty("objectClass"));
            if (objClasses.contains("org.osgi.service.event.EventHandler")) {
                Long serviceID = (Long)ref.getProperty("service.id");
                Object handler = EventAdminActivator.context.getService(ref);
                switch (sEvent.getType()) {
                    case 1: {
                        String[] topics = (String[])ref.getProperty("event.topics");
                        String filter = (String)ref.getProperty("event.filter");
                        Filter filterObj = filter != null ? EventAdminActivator.context.createFilter(filter) : null;
                        Subscription ehandler = new Subscription((EventHandler)handler, topics, filterObj);
                        this.eventHandlerSubscriptions.put(serviceID, ehandler);
                        break;
                    }
                    case 4: {
                        this.eventHandlerSubscriptions.remove(serviceID);
                        EventAdminActivator.context.ungetService(ref);
                        break;
                    }
                    case 2: {
                        Subscription subscr = (Subscription)this.eventHandlerSubscriptions.get(serviceID);
                        if (subscr == null) break;
                        String[] topics = (String[])ref.getProperty("event.topics");
                        String filter = (String)ref.getProperty("event.filter");
                        Filter filterObj = filter != null ? EventAdminActivator.context.createFilter(filter) : null;
                        subscr.update(topics, filterObj);
                    }
                }
            }
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("event", sEvent);
            ((Dictionary)props).put("timestamp", new Long(System.currentTimeMillis()));
            ((Dictionary)props).put("service", sEvent.getServiceReference());
            int t = EventAdminImpl.log2(sEvent.getType());
            String type = t < 4 ? SERVICE_EVENT[t] : "UNDEFINED";
            Event event = new Event("org/osgi/framework/ServiceEvent/" + type, (Dictionary<String, ?>)props);
            this.postEvent(event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postEvent(Event event) {
        if (security != null) {
            security.checkPermission(new TopicPermission(event.getTopic(), "publish"));
        }
        Subscription[] subscriptions = this.eventHandlerSubscriptions.values().toArray(new Subscription[this.eventHandlerSubscriptions.size()]);
        ArrayList<EventHandler> handlers = new ArrayList<EventHandler>(subscriptions.length);
        for (int i = 0; i < subscriptions.length; ++i) {
            if (!subscriptions[i].matches(event)) continue;
            handlers.add(subscriptions[i].getHandler());
        }
        List list = this.eventQueue;
        synchronized (list) {
            this.eventQueue.add(new QueueElement(event, handlers.toArray(new EventHandler[handlers.size()])));
            this.eventQueue.notifyAll();
        }
    }

    public void sendEvent(Event event) {
        if (security != null) {
            security.checkPermission(new TopicPermission(event.getTopic(), "publish"));
        }
        Subscription[] subscriptions = this.eventHandlerSubscriptions.values().toArray(new Subscription[this.eventHandlerSubscriptions.size()]);
        for (int i = 0; i < subscriptions.length; ++i) {
            if (!subscriptions[i].matches(event)) continue;
            subscriptions[i].sendEvent(event);
        }
    }

    private static int log2(int num) {
        int i = num;
        int j = -1;
        while (i > 0) {
            i >>= 1;
            ++j;
        }
        return j;
    }

    private static final class QueueElement {
        final Event event;
        final EventHandler[] handlers;

        private QueueElement(Event event, EventHandler[] handlers) {
            this.event = event;
            this.handlers = handlers;
        }
    }

    private final class EventDispatchingThread
    extends Thread {
        private EventDispatchingThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (EventAdminImpl.this.running) {
                    List list = EventAdminImpl.this.eventQueue;
                    synchronized (list) {
                        if (EventAdminImpl.this.eventQueue.isEmpty()) {
                            EventAdminImpl.this.eventQueue.wait();
                        }
                        QueueElement element = (QueueElement)EventAdminImpl.this.eventQueue.remove(0);
                        EventHandler[] handlers = element.handlers;
                        Event event = element.event;
                        try {
                            for (int i = 0; i < handlers.length; ++i) {
                                handlers[i].handleEvent(event);
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
                return;
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }
}

