/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge.service.eventadmin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.eclipse.concierge.service.eventadmin.EventAdminImpl;
import org.osgi.framework.Filter;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.event.TopicPermission;

final class Subscription {
    private EventHandler handler;
    private String[] topics;
    private Filter filter;

    private Subscription() {
    }

    Subscription(EventHandler eventHandler, String[] topics, Filter filter) {
        if (EventAdminImpl.security != null) {
            ArrayList<String> checkedTopics = new ArrayList<String>(topics.length);
            for (int i = 0; i < topics.length; ++i) {
                try {
                    EventAdminImpl.security.checkPermission(new TopicPermission(topics[i], "subscribe"));
                    checkedTopics.add(topics[i]);
                    continue;
                }
                catch (SecurityException se) {
                    System.err.println("Bundle does not have permission for subscribing to " + topics[i]);
                }
            }
            this.topics = checkedTopics.toArray(new String[checkedTopics.size()]);
        } else {
            this.topics = topics;
        }
        this.handler = eventHandler;
        this.filter = filter;
    }

    void sendEvent(Event event) {
        try {
            this.handler.handleEvent(event);
        }
        catch (Exception shield) {
            shield.printStackTrace();
        }
    }

    EventHandler getHandler() {
        return this.handler;
    }

    boolean matches(Event event) {
        if (this.topics != null && !Subscription.stringMatch(this.topics, event.getTopic())) {
            return false;
        }
        return this.filter == null || !event.matches(this.filter);
    }

    private static boolean stringMatch(String pattern, String topic) {
        StringTokenizer strTokens = new StringTokenizer(pattern, "/");
        StringTokenizer topicTokens = new StringTokenizer(topic, "/");
        while (strTokens.hasMoreTokens()) {
            String current = strTokens.nextToken();
            if (!topicTokens.hasMoreTokens()) {
                return false;
            }
            if (current.equals("*") && !strTokens.hasMoreTokens()) {
                return true;
            }
            if (current.equals(topicTokens.nextToken())) continue;
            return false;
        }
        return !topicTokens.hasMoreTokens();
    }

    private static boolean stringMatch(String[] patterns, String topic) {
        for (int i = 0; i < patterns.length; ++i) {
            if (!Subscription.stringMatch(patterns[i], topic)) continue;
            return true;
        }
        return false;
    }

    void update(String[] topics, Filter filter) {
        this.topics = topics;
        this.filter = filter;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[EventHandlerSubscription] ");
        buffer.append(this.handler.getClass().getName());
        buffer.append(", topics ");
        if (this.topics != null) {
            buffer.append(Arrays.asList(this.topics));
        } else {
            buffer.append("*");
        }
        if (this.filter != null) {
            buffer.append(", filter '");
            buffer.append(this.filter);
            buffer.append("'");
        }
        return buffer.toString();
    }
}

