/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ConciergeCollections {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeltaTrackingRemoveOnlyList<E>
    extends RemoveOnlyList<E> {
        private final ArrayList<E> removed = new ArrayList();
        private static final long serialVersionUID = 2467542232248099702L;

        public DeltaTrackingRemoveOnlyList(Collection<E> collection) {
            super(collection);
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = super.remove(object);
            if (bl) {
                this.removed.add(object);
            }
            return bl;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl = false;
            for (Object obj : collection) {
                bl |= this.remove(obj);
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            for (Object e : this) {
                if (collection.contains(e)) continue;
                this.remove(e);
                bl = true;
            }
            return bl;
        }

        public List<E> getRemoved() {
            return this.removed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultiMap<K, V>
    implements Map<K, List<V>> {
        protected final HashMap<K, List<V>> map;
        protected final LinkedHashSet<V> allValues = new LinkedHashSet();
        private final Comparator<V> comp;
        boolean dirty = false;

        public MultiMap() {
            this.map = new HashMap();
            this.comp = null;
        }

        public MultiMap(int n) {
            this.map = new HashMap(n);
            this.comp = null;
        }

        public MultiMap(MultiMap<K, ? extends V> multiMap) {
            this();
            this.insertMap(multiMap);
        }

        public MultiMap(Comparator<V> comparator) {
            this.map = new HashMap();
            this.comp = comparator;
        }

        HashMap<K, List<V>> getFlatMap() {
            return this.map;
        }

        public void insert(K k, V v) {
            List<V> list = this.map.get(k);
            if (list == null) {
                list = new ArrayList<V>();
                this.map.put(k, list);
            }
            list.add(v);
            if (this.comp != null) {
                Collections.sort(list, this.comp);
            }
            if (!this.dirty) {
                this.allValues.add(v);
            }
        }

        public void insertEmpty(K k) {
            List<V> list = this.map.get(k);
            if (list == null) {
                list = new ArrayList<V>();
                this.map.put(k, list);
            }
        }

        public void insertUnique(K k, V v) {
            List<V> list = this.map.get(k);
            if (list == null) {
                list = new ArrayList<V>();
                this.map.put(k, list);
            }
            if (!list.contains(v)) {
                list.add(v);
                if (this.comp != null) {
                    Collections.sort(list, this.comp);
                }
                if (!this.dirty) {
                    this.allValues.add(v);
                }
            }
        }

        public void insertAll(K k, Collection<? extends V> collection) {
            List<V> list = this.map.get(k);
            if (list == null) {
                list = new ArrayList<V>();
                this.map.put(k, list);
            }
            list.addAll(collection);
            if (this.comp != null) {
                Collections.sort(list, this.comp);
            }
            if (!this.dirty) {
                this.allValues.addAll(collection);
            }
        }

        public void insertMap(MultiMap<K, ? extends V> multiMap) {
            for (K k : multiMap.keySet()) {
                Object object = multiMap.get(k);
                this.insertAll(k, (Collection<? extends V>)object);
            }
        }

        @Override
        public List<V> get(Object object) {
            return this.map.get(object);
        }

        public int indexOf(K k, V v) {
            Object object = this.get(k);
            return object == null ? -1 : object.indexOf(v);
        }

        @Override
        public boolean remove(Object object, Object object2) {
            Object object3 = this.get(object);
            if (object3 != null) {
                boolean bl = object3.remove(object2);
                if (bl) {
                    this.dirty = true;
                }
                return bl;
            }
            return false;
        }

        @Override
        public List<V> remove(Object object) {
            List<V> list = this.map.remove(object);
            if (list == null) {
                return null;
            }
            this.dirty = true;
            return list;
        }

        public List<V> lookup(K k) {
            Object object = this.get(k);
            return object == null ? Collections.emptyList() : object;
        }

        protected void redoAllValues() {
            this.allValues.clear();
            for (List<V> list : this.values()) {
                this.allValues.addAll(list);
            }
            this.dirty = false;
        }

        public List<V> getAllValues() {
            if (this.dirty) {
                this.redoAllValues();
            }
            return new ArrayList<V>(this.allValues);
        }

        public void removeAll(K[] KArray, V v) {
            for (int i = 0; i < KArray.length; ++i) {
                Object object = this.get(KArray[i]);
                if (object == null) continue;
                object.remove(v);
            }
            this.dirty = true;
        }

        @Override
        public Set<K> keySet() {
            return new KeySet();
        }

        public String toString() {
            return "MultiMap " + this.map.toString();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            if (this.dirty) {
                this.redoAllValues();
            }
            return this.allValues.contains(object);
        }

        @Override
        public List<V> put(K k, List<V> list) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public void putAll(Map<? extends K, ? extends List<V>> map) {
            throw new UnsupportedOperationException("putAll");
        }

        @Override
        public void clear() {
            this.map.clear();
            this.allValues.clear();
            this.dirty = false;
        }

        @Override
        public Collection<List<V>> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<K, List<V>>> entrySet() {
            return this.map.entrySet();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class KeySet
        extends AbstractSet<K> {
            private final Set<K> keySet;

            protected KeySet() {
                this.keySet = MultiMap.this.map.keySet();
            }

            @Override
            public Iterator<K> iterator() {
                final Iterator iterator = this.keySet.iterator();
                return new Iterator<K>(){
                    private K element;

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public K next() {
                        this.element = iterator.next();
                        return this.element;
                    }

                    @Override
                    public void remove() {
                        MultiMap.this.remove(this.element);
                    }
                };
            }

            @Override
            public int size() {
                return MultiMap.this.map.size();
            }

            @Override
            public boolean contains(Object object) {
                return MultiMap.this.containsKey(object);
            }

            @Override
            public boolean remove(Object object) {
                boolean bl;
                boolean bl2 = bl = MultiMap.this.remove(object) != null;
                if (bl) {
                    MultiMap.this.dirty = true;
                }
                return bl;
            }

            @Override
            public void clear() {
                MultiMap.this.clear();
                MultiMap.this.allValues.clear();
                MultiMap.this.dirty = false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParseResult
    extends Tuple<HashMap<String, String>, HashMap<String, Object>> {
        public ParseResult(HashMap<String, String> hashMap, HashMap<String, Object> hashMap2) {
            super(hashMap, hashMap2);
        }

        public HashMap<String, String> getDirectives() {
            return (HashMap)this.getFormer();
        }

        public HashMap<String, Object> getAttributes() {
            return (HashMap)this.getLatter();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveOnlyList<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = -2126964539821583131L;

        public RemoveOnlyList(Collection<? extends E> collection) {
            super(collection);
        }

        @Override
        public boolean add(Object object) {
            throw new UnsupportedOperationException("add");
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException("addAll");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveOnlyMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = -3743325895136799794L;
        private boolean sealed;

        @Override
        public V put(K k, V v) {
            if (this.sealed) {
                throw new UnsupportedOperationException("put");
            }
            return super.put(k, v);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            throw new UnsupportedOperationException("putAll");
        }

        void seal() {
            this.sealed = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tuple<T1, T2> {
        private final T1 former;
        private final T2 latter;

        public Tuple(T1 T1, T2 T2) {
            this.former = T1;
            this.latter = T2;
        }

        public T1 getFormer() {
            return this.former;
        }

        public T2 getLatter() {
            return this.latter;
        }

        public String toString() {
            return "<" + this.former + ", " + this.latter + ">";
        }
    }
}

