/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import org.eclipse.concierge.Concierge;
import org.eclipse.concierge.ServiceReferenceImpl;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RFC1960Filter
implements Filter {
    private static final int AND_OPERATOR = 1;
    private static final int OR_OPERATOR = 2;
    private static final int NOT_OPERATOR = 3;
    private static final int EQUALS = 0;
    private static final int PRESENT = 1;
    private static final int APPROX = 2;
    private static final int GREATER = 3;
    private static final int LESS = 4;
    private static final int SUBSTRING = 5;
    protected static final String[] OP = new String[]{"=", "=*", "~=", ">=", "<=", "="};
    private static final Filter NULL_FILTER = new Filter(){

        @Override
        public final boolean match(ServiceReference<?> serviceReference) {
            return true;
        }

        @Override
        public final boolean match(Dictionary<String, ?> dictionary) {
            return true;
        }

        @Override
        public final boolean matchCase(Dictionary<String, ?> dictionary) {
            return true;
        }

        @Override
        public boolean matches(Map<String, ?> map) {
            return true;
        }
    };
    private final List<Filter> operands = new ArrayList<Filter>(1);
    private final int operator;
    private static WeakHashMap<String, Filter> filterCache = new WeakHashMap();
    private static short INSUFFICIENT = 0;
    private static short NECESSARY = 1;
    private static short REQUIRED = (short)3;

    private RFC1960Filter(int n) {
        this.operator = n;
    }

    public static Filter fromString(String string) throws InvalidSyntaxException {
        if (string == null) {
            return NULL_FILTER;
        }
        Filter filter = filterCache.get(string);
        if (filter != null) {
            return filter;
        }
        String string2 = string.trim();
        if (string2.length() == 1) {
            throw new InvalidSyntaxException("Malformed filter", string2);
        }
        Stack<RFC1960Filter> stack = new Stack<RFC1960Filter>();
        try {
            int n = string2.length();
            int n2 = -1;
            int n3 = 0;
            String string3 = null;
            int n4 = -1;
            char[] cArray = string2.toCharArray();
            BitSet bitSet = new BitSet(cArray.length);
            block12: for (int i = 0; i < cArray.length; ++i) {
                switch (cArray[i]) {
                    case '\\': {
                        if (i < cArray.length && (cArray[i + 1] == '(' || cArray[i + 1] == ')' || cArray[i + 1] == '\\' || cArray[i + 1] == '*')) {
                            bitSet.set(i);
                        }
                        ++i;
                        continue block12;
                    }
                    case '(': {
                        char c = cArray[i + 1];
                        while (Character.isWhitespace(c)) {
                            c = cArray[++i + 1];
                        }
                        if (c == ')') {
                            throw new InvalidSyntaxException("Empty filter", string2);
                        }
                        int n5 = i;
                        char c2 = cArray[n5 + 2];
                        while (Character.isWhitespace(c2)) {
                            c2 = cArray[++n5 + 2];
                        }
                        if (c == '&' && c2 == '(') {
                            stack.push(new RFC1960Filter(1));
                            continue block12;
                        }
                        if (c == '|' && c2 == '(') {
                            stack.push(new RFC1960Filter(2));
                            continue block12;
                        }
                        if (c == '!' && c2 == '(') {
                            stack.push(new RFC1960Filter(3));
                            continue block12;
                        }
                        if (n2 == -1) {
                            n2 = i;
                            continue block12;
                        }
                        throw new InvalidSyntaxException("Surplus left paranthesis at: " + string2.substring(i), string2);
                    }
                    case ')': {
                        Object object;
                        Object object2;
                        if (n2 == -1) {
                            object2 = (RFC1960Filter)stack.pop();
                            if (stack.isEmpty()) {
                                filterCache.put(string, (Filter)object2);
                                return object2;
                            }
                            object = (RFC1960Filter)stack.peek();
                            if (((RFC1960Filter)object).operator == 3 && !((RFC1960Filter)object).operands.isEmpty()) {
                                throw new InvalidSyntaxException("Unexpected literal: " + string2.substring(i), string2);
                            }
                            ((RFC1960Filter)object).operands.add((Filter)object2);
                            if (i != n - 1) continue block12;
                            throw new InvalidSyntaxException("Missing right paranthesis at the end.", string2);
                        }
                        if (n3 == 0) {
                            throw new InvalidSyntaxException("Missing operator.", string2);
                        }
                        if (stack.isEmpty()) {
                            if (i == n - 1) {
                                if (((String)(object2 = RFC1960Filter.value(string2, ++n3, n - 1, bitSet))).equals("*") && n4 == 5) {
                                    n4 = 1;
                                    object2 = null;
                                }
                                object = new RFC1960SimpleFilter(string3, n4, (String)object2);
                                filterCache.put(string, (Filter)object);
                                return object;
                            }
                            throw new InvalidSyntaxException("Unexpected literal: " + string2.substring(i), string2);
                        }
                        object2 = (RFC1960Filter)stack.peek();
                        if (((String)(object = RFC1960Filter.value(string2, ++n3, i, bitSet))).equals("*") && n4 == 5) {
                            n4 = 1;
                            object = null;
                        }
                        ((RFC1960Filter)object2).operands.add(new RFC1960SimpleFilter(string3, n4, (String)object));
                        n3 = 0;
                        n2 = -1;
                        string3 = null;
                        n4 = -1;
                        continue block12;
                    }
                    case '~': {
                        if (n3 == 0 && cArray[i + 1] == '=') {
                            string3 = string2.substring(n2 + 1, i).trim();
                            n4 = 2;
                            n3 = ++i;
                            continue block12;
                        }
                        throw new InvalidSyntaxException("Unexpected character " + cArray[i + 1], string2);
                    }
                    case '>': {
                        if (n3 == 0 && cArray[i + 1] == '=') {
                            string3 = string2.substring(n2 + 1, i).trim();
                            n4 = 3;
                            n3 = ++i;
                            continue block12;
                        }
                        throw new InvalidSyntaxException("Unexpected character " + cArray[i + 1], string2);
                    }
                    case '<': {
                        if (n3 == 0 && cArray[i + 1] == '=') {
                            string3 = string2.substring(n2 + 1, i).trim();
                            n4 = 4;
                            n3 = ++i;
                            continue block12;
                        }
                        throw new InvalidSyntaxException("Unexpected character " + cArray[i + 1], string2);
                    }
                    case '=': {
                        if (n3 != 0) continue block12;
                        if (n2 + 1 == i) {
                            throw new InvalidSyntaxException("Missing identifier", string2);
                        }
                        string3 = string2.substring(n2 + 1, i).trim();
                        n4 = 0;
                        n3 = i;
                        continue block12;
                    }
                    case '*': {
                        if (n4 != 0) continue block12;
                        n4 = 5;
                        continue block12;
                    }
                }
            }
            Filter filter2 = (Filter)stack.pop();
            filterCache.put(string, filter2);
            return filter2;
        }
        catch (EmptyStackException emptyStackException) {
            throw new InvalidSyntaxException("Filter expression not well-formed.", string2);
        }
    }

    private static final String value(String string, int n, int n2, BitSet bitSet) {
        int n3;
        if (bitSet.isEmpty()) {
            return string.substring(n, n2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = n;
        while ((n3 = bitSet.nextSetBit(n4)) > -1) {
            stringBuilder.append(string.substring(n4, n3));
            n4 = n3 + 1;
        }
        stringBuilder.append(string.substring(n4, n2));
        return stringBuilder.toString();
    }

    protected static final Map<String, ?> dict2map(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            return null;
        }
        if (dictionary instanceof Hashtable) {
            return (Hashtable)dictionary;
        }
        HashMap hashMap = new HashMap();
        Enumeration<String> enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            hashMap.put(string, dictionary.get(string));
        }
        return hashMap;
    }

    @Override
    public boolean match(ServiceReference<?> serviceReference) {
        try {
            return this.matches(((ServiceReferenceImpl)serviceReference).properties);
        }
        catch (ClassCastException classCastException) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            String[] stringArray = serviceReference.getPropertyKeys();
            for (int i = 0; i < stringArray.length; ++i) {
                hashMap.put(stringArray[i], serviceReference.getProperty(stringArray[i]));
            }
            return this.matches(hashMap);
        }
    }

    @Override
    public boolean match(Dictionary<String, ?> dictionary) {
        return this.matches(RFC1960Filter.dict2map(dictionary));
    }

    @Override
    public boolean matches(Map<String, ?> map) {
        if (this.operator == 1) {
            Filter[] filterArray = this.operands.toArray(new Filter[this.operands.size()]);
            for (int i = 0; i < filterArray.length; ++i) {
                if (filterArray[i].matches(map)) continue;
                return false;
            }
            return true;
        }
        if (this.operator == 2) {
            Filter[] filterArray = this.operands.toArray(new Filter[this.operands.size()]);
            for (int i = 0; i < filterArray.length; ++i) {
                if (!filterArray[i].matches(map)) continue;
                return true;
            }
            return false;
        }
        if (this.operator == 3) {
            return !this.operands.get(0).matches(map);
        }
        throw new IllegalStateException("PARSER ERROR");
    }

    @Override
    public boolean matchCase(Dictionary<String, ?> dictionary) {
        if (this.operator == 1) {
            Filter[] filterArray = this.operands.toArray(new Filter[this.operands.size()]);
            for (int i = 0; i < filterArray.length; ++i) {
                if (filterArray[i].matchCase(dictionary)) continue;
                return false;
            }
            return true;
        }
        if (this.operator == 2) {
            Filter[] filterArray = this.operands.toArray(new Filter[this.operands.size()]);
            for (int i = 0; i < filterArray.length; ++i) {
                if (!filterArray[i].matchCase(dictionary)) continue;
                return true;
            }
            return false;
        }
        if (this.operator == 3) {
            return !this.operands.get(0).matchCase(dictionary);
        }
        throw new IllegalStateException("PARSER ERROR");
    }

    @Override
    public String toString() {
        if (this.operator == 3) {
            return "(!" + this.operands.get(0) + ")";
        }
        StringBuffer stringBuffer = new StringBuffer(this.operator == 1 ? "(&" : "(|");
        Filter[] filterArray = this.operands.toArray(new Filter[this.operands.size()]);
        for (int i = 0; i < filterArray.length; ++i) {
            stringBuffer.append(filterArray[i]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof RFC1960Filter) {
            RFC1960Filter rFC1960Filter = (RFC1960Filter)object;
            if (this.operands.size() != rFC1960Filter.operands.size()) {
                return false;
            }
            Filter[] filterArray = this.operands.toArray(new Filter[this.operands.size()]);
            Filter[] filterArray2 = rFC1960Filter.operands.toArray(new Filter[this.operands.size()]);
            for (int i = 0; i < filterArray.length; ++i) {
                if (filterArray[i].equals(filterArray2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    static int stringCompare(char[] cArray, int n, char[] cArray2, int n2) {
        int n3;
        if (n == cArray.length) {
            return 0;
        }
        int n4 = cArray.length;
        int n5 = cArray2.length;
        while (n < n4 && n2 < n5) {
            n3 = 0;
            if (cArray[n] == cArray2[n2]) {
                ++n;
                ++n2;
                continue;
            }
            if (cArray[n] == '\\') {
                ++n;
                n3 = 1;
            }
            if (cArray[n] == '*' && n3 == 0) {
                ++n;
                do {
                    if (RFC1960Filter.stringCompare(cArray, n, cArray2, n2) != 0) continue;
                    return 0;
                } while (n5 - ++n2 > -1);
                return 1;
            }
            if (cArray[n] < cArray2[n2]) {
                return -1;
            }
            if (cArray[n] <= cArray2[n2]) continue;
            return 1;
        }
        if (n2 == n5 && cArray[n - 1] == cArray2[n2 - 1] && (n == n4 || n == n4 - 1 && cArray[n] == '*')) {
            return 0;
        }
        if (n > 0 && cArray[n - 1] == '*' && n == n4 && n2 == n5) {
            return 0;
        }
        n3 = n4 < n5 ? n4 : n5;
        return n4 == n3 ? -1 : 1;
    }

    static List<Capability> filterWithIndex(Requirement requirement, String string, Concierge.CapabilityRegistry capabilityRegistry) throws InvalidSyntaxException {
        Filter filter;
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = requirement.getNamespace();
        int n = RFC1960Filter.prefilter(string2, filter = RFC1960Filter.fromString(string), capabilityRegistry, INSUFFICIENT, false, hashSet);
        if (n == REQUIRED) {
            if (hashSet.size() != 1) {
                return Collections.emptyList();
            }
            return capabilityRegistry.getByValue(string2, (String)hashSet.iterator().next());
        }
        List<Capability> list = n == NECESSARY ? (hashSet.size() != 1 ? capabilityRegistry.getAll(string2) : capabilityRegistry.getByKey(string2, (String)hashSet.iterator().next())) : capabilityRegistry.getAll(string2);
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<Capability> arrayList = new ArrayList<Capability>();
        for (Capability capability : list) {
            if (!filter.matches(capability.getAttributes()) || !Concierge.matches0(string2, requirement, capability, string)) continue;
            arrayList.add(capability);
        }
        return arrayList;
    }

    private static int prefilter(String string, Filter filter, Concierge.CapabilityRegistry capabilityRegistry, int n, boolean bl, Set<String> set) {
        int n2 = n;
        if (filter instanceof RFC1960Filter) {
            RFC1960Filter rFC1960Filter = (RFC1960Filter)filter;
            int n3 = rFC1960Filter.operator;
            if (rFC1960Filter.operands.size() == 1) {
                return RFC1960Filter.prefilter(string, rFC1960Filter.operands.get(0), capabilityRegistry, n, n3 == 3 ? !bl : bl, set);
            }
            for (Filter filter2 : rFC1960Filter.operands) {
                int n4 = RFC1960Filter.prefilter(string, filter2, capabilityRegistry, n, bl, set);
                n2 = rFC1960Filter.operator == 1 ? (n2 |= n4) : (n2 &= n4);
                if (n2 == INSUFFICIENT) {
                    return INSUFFICIENT;
                }
                n2 ^= 2;
            }
            return n2 == 3 ? NECESSARY : n2;
        }
        if (filter instanceof RFC1960SimpleFilter) {
            RFC1960SimpleFilter rFC1960SimpleFilter = (RFC1960SimpleFilter)filter;
            if (string.equals(rFC1960SimpleFilter.id)) {
                if (rFC1960SimpleFilter.comparator == 0) {
                    set.add(rFC1960SimpleFilter.value);
                    return REQUIRED;
                }
                if (rFC1960SimpleFilter.comparator == 1 && bl) {
                    return INSUFFICIENT;
                }
                return NECESSARY;
            }
            return INSUFFICIENT;
        }
        return INSUFFICIENT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RFC1960SimpleFilter
    implements Filter {
        protected final String id;
        protected final int comparator;
        protected final String value;

        protected RFC1960SimpleFilter(String string, int n, String string2) {
            this.id = string;
            this.comparator = n;
            this.value = string2;
        }

        @Override
        public boolean match(ServiceReference<?> serviceReference) {
            try {
                return this.matches(((ServiceReferenceImpl)serviceReference).properties);
            }
            catch (ClassCastException classCastException) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                String[] stringArray = serviceReference.getPropertyKeys();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashMap.put(stringArray[i], serviceReference.getProperty(stringArray[i]));
                }
                return this.matches(hashMap);
            }
        }

        @Override
        public boolean match(Dictionary<String, ?> dictionary) {
            return this.matches(RFC1960Filter.dict2map(dictionary), false);
        }

        @Override
        public boolean matchCase(Dictionary<String, ?> dictionary) {
            return this.matches(RFC1960Filter.dict2map(dictionary), true);
        }

        @Override
        public boolean matches(Map<String, ?> map) {
            return this.matches(map, false);
        }

        /*
         * WARNING - void declaration
         */
        private boolean matches(Map<String, ?> map, boolean bl) {
            if (map == null) {
                return false;
            }
            Object var3_3 = null;
            var3_3 = map.get(this.id);
            if (var3_3 == null) {
                if (bl) {
                    return false;
                }
                var3_3 = map.get(this.id.toLowerCase());
            }
            if (var3_3 == null) {
                for (String object : map.keySet()) {
                    if (!object.equalsIgnoreCase(this.id)) continue;
                    var3_3 = map.get(object);
                    break;
                }
            }
            if (var3_3 == null) {
                return false;
            }
            if (this.comparator == 1) {
                return true;
            }
            Iterator<String> iterator = var3_3;
            try {
                if (iterator instanceof String) {
                    return RFC1960SimpleFilter.compareString(this.value, this.comparator, (String)((Object)iterator));
                }
                if (iterator instanceof Number) {
                    return RFC1960SimpleFilter.compareNumber(this.value.trim(), this.comparator, (Number)((Object)iterator));
                }
                if (iterator instanceof String[]) {
                    String[] i = (String[])iterator;
                    if (i.length == 0) {
                        return false;
                    }
                    String string = this.comparator == 2 ? RFC1960SimpleFilter.stripWhitespaces(this.value) : this.value;
                    for (int j = 0; j < i.length; ++j) {
                        if (!RFC1960SimpleFilter.compareString(string, this.comparator, i[j])) continue;
                        return true;
                    }
                    return false;
                }
                if (iterator instanceof Boolean) {
                    return (this.comparator == 0 || this.comparator == 2) && ((Boolean)((Object)iterator)).equals(Boolean.valueOf(this.value.trim()));
                }
                if (iterator instanceof Character) {
                    String throwable = this.value.trim();
                    return throwable.length() == 1 ? RFC1960SimpleFilter.compareTyped(new Character(throwable.charAt(0)), this.comparator, (Character)((Object)iterator)) : throwable.length() == 0 && Character.isWhitespace(((Character)((Object)iterator)).charValue());
                }
                if (iterator instanceof Collection) {
                    Collection collection = (Collection)((Object)iterator);
                    Object[] objectArray = collection.toArray();
                    return RFC1960SimpleFilter.compareArray(this.value, this.comparator, objectArray);
                }
                if (iterator instanceof Object[]) {
                    return RFC1960SimpleFilter.compareArray(this.value, this.comparator, (Object[])iterator);
                }
                if (iterator.getClass().isArray()) {
                    void var5_10;
                    boolean bl2 = false;
                    while (var5_10 < Array.getLength(iterator)) {
                        Object object = Array.get(iterator, (int)var5_10);
                        if (object instanceof Number && RFC1960SimpleFilter.compareNumber(this.value.trim(), this.comparator, (Number)object) || object instanceof Character && RFC1960SimpleFilter.compareTyped(new Character(this.value.trim().charAt(0)), this.comparator, (Character)object) || RFC1960SimpleFilter.compareReflective(this.value, this.comparator, object)) {
                            return true;
                        }
                        ++var5_10;
                    }
                    return false;
                }
                return RFC1960SimpleFilter.compareReflective(this.value, this.comparator, iterator);
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        private static boolean compareString(String string, int n, String string2) {
            String string3 = n == 2 ? RFC1960SimpleFilter.stripWhitespaces(string).toLowerCase() : string;
            String string4 = n == 2 ? RFC1960SimpleFilter.stripWhitespaces(string2).toLowerCase() : string2;
            switch (n) {
                case 0: 
                case 2: 
                case 5: {
                    return RFC1960Filter.stringCompare(string3.toCharArray(), 0, string4.toCharArray(), 0) == 0;
                }
                case 3: {
                    return RFC1960Filter.stringCompare(string3.toCharArray(), 0, string4.toCharArray(), 0) <= 0;
                }
                case 4: {
                    return RFC1960Filter.stringCompare(string3.toCharArray(), 0, string4.toCharArray(), 0) >= 0;
                }
            }
            throw new IllegalStateException("Found illegal comparator.");
        }

        private static boolean compareNumber(String string, int n, Number number) {
            if (number instanceof Integer) {
                int n2 = (Integer)number;
                int n3 = Integer.parseInt(string);
                switch (n) {
                    case 3: {
                        return n2 >= n3;
                    }
                    case 4: {
                        return n2 <= n3;
                    }
                }
                return n2 == n3;
            }
            if (number instanceof Long) {
                long l = (Long)number;
                long l2 = Long.parseLong(string);
                switch (n) {
                    case 3: {
                        return l >= l2;
                    }
                    case 4: {
                        return l <= l2;
                    }
                }
                return l == l2;
            }
            if (number instanceof Byte) {
                byte by = (Byte)number;
                int n4 = Integer.parseInt(string);
                if (n4 < -128 || n4 > 127) {
                    throw new NumberFormatException("Value out of range. Value:\"" + string);
                }
                switch (n) {
                    case 3: {
                        return by >= (byte)n4;
                    }
                    case 4: {
                        return by <= (byte)n4;
                    }
                }
                return by == (byte)n4;
            }
            if (number instanceof Short) {
                short s = (Short)number;
                int n5 = Integer.parseInt(string);
                if (n5 < Short.MIN_VALUE || n5 > Short.MAX_VALUE) {
                    throw new NumberFormatException("Value out of range. Value:\"" + string);
                }
                switch (n) {
                    case 3: {
                        return s >= (short)n5;
                    }
                    case 4: {
                        return s <= (short)n5;
                    }
                }
                return s == (short)n5;
            }
            if (number instanceof Double) {
                double d = (Double)number;
                double d2 = Double.parseDouble(string);
                switch (n) {
                    case 3: {
                        return d >= d2;
                    }
                    case 4: {
                        return d <= d2;
                    }
                }
                return d == d2;
            }
            if (number instanceof Float) {
                float f = ((Float)number).floatValue();
                float f2 = Float.parseFloat(string);
                switch (n) {
                    case 3: {
                        return f >= f2;
                    }
                    case 4: {
                        return f <= f2;
                    }
                }
                return f == f2;
            }
            return RFC1960SimpleFilter.compareReflective(string, n, number);
        }

        private static boolean compareTyped(Object object, int n, Comparable comparable) {
            switch (n) {
                case 2: {
                    if (object instanceof Character) {
                        return RFC1960SimpleFilter.compareString(String.valueOf(((Character)object).toString()), n, ((Character)comparable).toString());
                    }
                }
                case 0: {
                    return comparable.compareTo(object) == 0;
                }
                case 3: {
                    return comparable.compareTo(object) >= 0;
                }
                case 4: {
                    return comparable.compareTo(object) <= 0;
                }
            }
            throw new IllegalStateException("Found illegal comparator.");
        }

        private static boolean compareArray(String string, int n, Object[] objectArray) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof String ? RFC1960SimpleFilter.compareString(string.trim(), n, ((String)object).trim()) : (object instanceof Number ? RFC1960SimpleFilter.compareNumber(string.trim(), n, (Number)object) : RFC1960SimpleFilter.compareReflective(string, n, object)))) continue;
                return true;
            }
            return false;
        }

        private static boolean compareReflective(String string, int n, Object object) {
            Executable executable;
            if (n == 5) {
                return false;
            }
            Object object2 = null;
            try {
                executable = object.getClass().getDeclaredMethod("valueOf", String.class);
                if (Modifier.isStatic(((Method)executable).getModifiers()) && object.getClass().isAssignableFrom(((Method)executable).getReturnType())) {
                    if (!executable.isAccessible()) {
                        ((Method)executable).setAccessible(true);
                    }
                    object2 = ((Method)executable).invoke(null, string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (object2 == null) {
                    executable = object.getClass().getConstructor(String.class);
                    if (!executable.isAccessible()) {
                        ((Constructor)executable).setAccessible(true);
                    }
                    object2 = ((Constructor)executable).newInstance(string);
                }
                return object instanceof Comparable ? RFC1960SimpleFilter.compareTyped(object2, n, (Comparable)object) : object2.equals(object);
            }
            catch (Exception exception) {
                return false;
            }
        }

        private static String stripWhitespaces(String string) {
            return string.replaceAll(" ", "");
        }

        @Override
        public String toString() {
            return "(" + this.id + OP[this.comparator] + (this.value == null ? "" : RFC1960SimpleFilter.escape(this.value)) + ")";
        }

        private static final String escape(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                switch (cArray[i]) {
                    case '(': 
                    case ')': 
                    case '\\': {
                        stringBuilder.append('\\');
                    }
                }
                stringBuilder.append(cArray[i]);
            }
            return stringBuilder.toString();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof RFC1960SimpleFilter) {
                RFC1960SimpleFilter rFC1960SimpleFilter = (RFC1960SimpleFilter)object;
                return this.comparator == rFC1960SimpleFilter.comparator && this.id.equals(rFC1960SimpleFilter.id) && this.value.equals(rFC1960SimpleFilter.value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

