/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge.compat.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.concierge.BundleImpl;
import org.eclipse.concierge.Concierge;
import org.eclipse.concierge.ConciergeCollections;
import org.eclipse.concierge.Resources;
import org.eclipse.concierge.Utils;
import org.eclipse.concierge.compat.LegacyBundleProcessing;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleManifestOne
implements LegacyBundleProcessing {
    private static final String SPLIT_AT_COMMA = ",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)";
    private static final String SPLIT_AT_SEMICOLON = ";(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)";
    private static final Map<String, Object> NO_ATTRS = new HashMap<String, Object>();

    @Override
    public ConciergeCollections.Tuple<List<BundleCapability>, List<BundleRequirement>> processManifest(BundleImpl.Revision revision, Manifest manifest) throws BundleException {
        HashMap<String, Object> hashMap;
        ConciergeCollections.ParseResult parseResult;
        String[] stringArray;
        int n;
        Object object;
        Attributes attributes = manifest.getMainAttributes();
        ArrayList<Resources.BundleCapabilityImpl> arrayList = new ArrayList<Resources.BundleCapabilityImpl>();
        ArrayList<Resources.BundleRequirementImpl> arrayList2 = new ArrayList<Resources.BundleRequirementImpl>();
        String string = attributes.getValue("Import-Package");
        if (string != null) {
            object = string.split(SPLIT_AT_COMMA);
            for (n = 0; n < ((String[])object).length; ++n) {
                stringArray = ((String)object[n]).split(SPLIT_AT_SEMICOLON);
                parseResult = Utils.parseLiterals(stringArray, 1);
                hashMap = parseResult.getDirectives();
                hashMap.put("filter", Utils.createFilter("osgi.wiring.package", stringArray[0], parseResult.getAttributes()));
                hashMap.put("x-int", stringArray[0].trim());
                arrayList2.add(new Resources.BundleRequirementImpl(revision, "osgi.wiring.package", hashMap, null, "Import-Package " + (String)object[n]));
            }
        }
        object = new HashMap();
        ((HashMap)object).put("filter", Utils.createFilter("osgi.wiring.package", "org.osgi.framework", NO_ATTRS));
        arrayList2.add(new Resources.BundleRequirementImpl(revision, "osgi.wiring.package", (Map<String, String>)object, null, "Import-Package org.osgi.framework"));
        string = attributes.getValue("DynamicImport-Package");
        if (string != null) {
            object = string.split(SPLIT_AT_COMMA);
            for (n = 0; n < ((Object)object).length; ++n) {
                stringArray = ((String)object[n]).split(SPLIT_AT_SEMICOLON);
                parseResult = Utils.parseLiterals(stringArray, 1);
                hashMap = parseResult.getDirectives();
                HashMap<String, Object> hashMap2 = parseResult.getAttributes();
                hashMap.put("resolution", "dynamic");
                hashMap.put("x-int", stringArray[0].trim());
                if (stringArray[0].contains("*")) {
                    hashMap.put("cardinality", "multiple");
                }
                arrayList2.add(new Resources.BundleRequirementImpl(revision, "osgi.wiring.package", hashMap, hashMap2, "DynamicImport-Package " + (String)object[n]));
            }
        }
        if ((string = attributes.getValue("Export-Package")) != null) {
            object = string.split(SPLIT_AT_COMMA);
            for (n = 0; n < ((Object)object).length; ++n) {
                stringArray = ((String)object[n]).split(SPLIT_AT_SEMICOLON);
                parseResult = Utils.parseLiterals(stringArray, 1);
                hashMap = parseResult.getAttributes();
                hashMap.put("osgi.wiring.package", stringArray[0].trim());
                arrayList.add(new Resources.BundleCapabilityImpl(revision, "osgi.wiring.package", parseResult.getDirectives(), hashMap, "Export-Package " + (String)object[n]));
            }
        }
        return new ConciergeCollections.Tuple<List<BundleCapability>, List<BundleRequirement>>(arrayList, arrayList2);
    }

    @Override
    public List<BundleCapability> translateToCapability(Concierge concierge, String string, String string2) {
        throw new UnsupportedOperationException();
    }
}

