/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge.compat.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.concierge.BundleImpl;
import org.eclipse.concierge.Concierge;
import org.eclipse.concierge.Factory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XargsFileLauncher {
    protected static final boolean WIN = System.getProperty("os.name").toLowerCase().startsWith("win");
    private PrintStream streamErr;
    static final String regex = "\\$\\{([^}]*)\\}";
    static final Pattern pattern = Pattern.compile("\\$\\{([^}]*)\\}");

    public XargsFileLauncher() {
        this(System.err);
    }

    public XargsFileLauncher(PrintStream printStream) {
        this.streamErr = printStream;
    }

    public Concierge processXargsFile(File file) throws BundleException, FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        Map<String, String> map = this.getPropertiesFromXargsInputStream(fileInputStream);
        fileInputStream = new FileInputStream(file);
        return this.processXargsInputStream(map, fileInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Concierge processXargsInputStream(Map<String, String> map, InputStream inputStream) throws BundleException, FileNotFoundException {
        Concierge concierge;
        block19: {
            String string;
            concierge = (Concierge)new Factory().newFramework(map);
            concierge.init();
            concierge.start();
            if (concierge.restart) {
                return concierge;
            }
            BundleContext bundleContext = concierge.getBundleContext();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>(0);
            int n = 1;
            boolean bl = false;
            while (!bl && (string = bufferedReader.readLine()) != null) {
                Object object;
                Object object2;
                Object object3;
                if ((string = string.trim()).equals("") || string.charAt(0) == '#') continue;
                if (string.startsWith("-initlevel")) {
                    string = XargsFileLauncher.getArg(string, 10);
                    n = Integer.parseInt(string);
                    continue;
                }
                if (string.startsWith("-all")) {
                    BundleReference bundleReference;
                    Bundle bundle;
                    object3 = (string = XargsFileLauncher.getArg(string, 4)).isEmpty() ? new File(new URL(concierge.BUNDLE_LOCATION).getFile()) : new File(string);
                    object2 = ((File)object3).listFiles(new FilenameFilter(){

                        public boolean accept(File file, String string) {
                            return string.toLowerCase().endsWith(".jar") || string.toLowerCase().endsWith(".zip");
                        }
                    });
                    if (object2 == null) {
                        this.printErr("NO FILES FOUND IN " + ((File)object3).getPath());
                        break;
                    }
                    object = new ArrayList();
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        if (((File)object2[i]).isDirectory()) continue;
                        bundle = bundleContext.installBundle(((File)object2[i]).getPath());
                        bundleReference = bundle.adapt(BundleStartLevel.class);
                        bundleReference.setStartLevel(n);
                        object.add(bundle);
                    }
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        bundle = (Bundle)iterator.next();
                        bundleReference = (BundleImpl.Revision)bundle.adapt(BundleRevision.class);
                        if (((BundleImpl.Revision)bundleReference).isFragment()) continue;
                        bundle.start();
                    }
                    continue;
                }
                if (string.startsWith("-istart")) {
                    object3 = XargsFileLauncher.getArg(string, 7);
                    object3 = this.replaceVariable((String)object3, map);
                    object3 = this.resolveWildcardName((String)object3);
                    object2 = bundleContext.installBundle((String)object3);
                    object = object2.adapt(BundleStartLevel.class);
                    object.setStartLevel(n);
                    object2.start();
                    continue;
                }
                if (string.startsWith("-install")) {
                    object3 = XargsFileLauncher.getArg(string, 8);
                    object3 = this.replaceVariable((String)object3, map);
                    object3 = this.resolveWildcardName((String)object3);
                    object2 = bundleContext.installBundle((String)object3);
                    object = object2.adapt(BundleStartLevel.class);
                    object.setStartLevel(n);
                    hashMap.put(object3, object2);
                    continue;
                }
                if (string.startsWith("-start")) {
                    object3 = XargsFileLauncher.getArg(string, 6);
                    object3 = this.replaceVariable((String)object3, map);
                    object2 = (Bundle)hashMap.remove(object3 = this.resolveWildcardName((String)object3));
                    if (object2 == null) {
                        this.printErr("Bundle " + (String)object3 + " is marked to be started but has not been installed before. Ignoring the command !");
                        continue;
                    }
                    object = object2.adapt(BundleStartLevel.class);
                    object.setStartLevel(n);
                    object2.start();
                    continue;
                }
                if (!string.startsWith("-skip")) continue;
                bl = true;
            }
            Object var17_18 = null;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            break block19;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var17_19 = null;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return concierge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map<String, String> getPropertiesFromXargsInputStream(InputStream inputStream) {
        HashMap<String, String> hashMap;
        block17: {
            String string;
            hashMap = new HashMap<String, String>();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                String string2 = string.trim();
                if (string2.equals("") || string2.charAt(0) == '#') continue;
                if (string2.startsWith("-D")) {
                    int n = (string2 = XargsFileLauncher.getArg(string2, 2)).indexOf("=");
                    if (n < 0) {
                        this.printErr("WRONG PROPERTY DEFINITION: EQUALS for -Dname=value IS MISSING, IGNORE '" + string + "'");
                        continue;
                    }
                    if (n == 0) {
                        this.printErr("WRONG PROPERTY DEFINITION: NAME for -Dname=value IS MISSING, IGNORE '" + string + "'");
                        continue;
                    }
                    if (n <= 0) continue;
                    boolean bl = string2.charAt(n - 1) == '+';
                    String string3 = string2.substring(0, bl ? n - 1 : n);
                    if (string3.length() == 0) {
                        this.printErr("WRONG PROPERTY DEFINITION: NAME for -Dname+=value IS MISSING, IGNORE '" + string + "'");
                        continue;
                    }
                    String string4 = string2.substring(n + 1);
                    while (string4.endsWith("\\")) {
                        string2 = bufferedReader.readLine();
                        string2 = XargsFileLauncher.getArg(string2, 0);
                        string4 = string4.substring(0, string4.length() - 1).trim() + string2.trim();
                    }
                    string4 = this.replaceVariable(string4, hashMap);
                    if (bl) {
                        String string5 = (String)hashMap.get(string3);
                        hashMap.put(string3, (string5 == null ? "" : string5) + string4);
                        continue;
                    }
                    hashMap.put(string3, string4);
                    continue;
                }
                if (string2.startsWith("-profile")) {
                    string2 = XargsFileLauncher.getArg(string2, 8);
                    hashMap.put("ch.ethz.systems.concierge.profile", string2);
                    continue;
                }
                if (string2.equals("-init")) {
                    hashMap.put("org.osgi.framework.storage.clean", "onFirstInit");
                    continue;
                }
                if (!string2.startsWith("-startlevel")) continue;
                string2 = XargsFileLauncher.getArg(string2, 11);
                hashMap.put("org.osgi.framework.startlevel.beginning", string2);
            }
            Object var12_12 = null;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            break block17;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var12_13 = null;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return hashMap;
    }

    private static String getArg(String string, int n) {
        String string2 = string.substring(n);
        int n2 = string2.indexOf("#");
        return n2 > -1 ? string2.substring(0, n2).trim() : string2.trim();
    }

    String replaceVariable(String string, Map<String, String> map) {
        Matcher matcher = pattern.matcher(string);
        String string2 = string;
        int n = 0;
        while (matcher.find(n)) {
            n = matcher.end();
            String string3 = matcher.group();
            String string4 = string3.substring(2, string3.length() - 1);
            String string5 = map.get(string4);
            if (string5 == null) continue;
            string2 = string2.replace(string3, string5);
        }
        return string2;
    }

    String resolveWildcardName(final String string) {
        FileFilter fileFilter;
        if (!string.contains("*")) {
            return string;
        }
        File file = new File(string.substring(0, string.lastIndexOf("/")));
        File[] fileArray = file.listFiles(fileFilter = new FileFilter(){

            public boolean accept(File file) {
                String string4 = string.substring(0, string.lastIndexOf("*"));
                String string2 = string.substring(string.lastIndexOf("*") + 1);
                String string3 = WIN ? file.getPath().replace('\\', '/') : file.getPath();
                return string3.startsWith(string4) && string3.endsWith(string2);
            }
        });
        if (fileArray == null || fileArray.length == 0) {
            return string;
        }
        if (fileArray.length == 1) {
            return fileArray[0].getPath();
        }
        if (fileArray.length > 1) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < fileArray.length; ++i) {
                arrayList.add(fileArray[i].getPath());
            }
            Collections.sort(arrayList, Collections.reverseOrder());
            return (String)arrayList.get(0);
        }
        return string;
    }

    private void printErr(String string) {
        this.streamErr.println("[XargsFileLauncher] " + string);
    }
}

