/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge.service.log;

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogServiceImpl
implements LogReaderService {
    private final Vector<LogEntryImpl> logBuffer;
    private final List<LogListener> logListeners = new ArrayList<LogListener>(0);
    private final int LOG_BUFFER_SIZE;
    private final int LOG_LEVEL;
    private final boolean QUIET;
    protected static final String[] LEVELS = new String[]{"NULL", "ERROR", "WARNING", "INFO", "DEBUG"};
    public final ServiceFactory<LogService> factory = new LogServiceFactory();

    protected static final String getLevelString(int n) {
        if (n < 0 || n > 4) {
            return Integer.toString(n);
        }
        return LEVELS[n];
    }

    public LogServiceImpl(int n, int n2, boolean bl) {
        this.LOG_BUFFER_SIZE = n;
        this.LOG_LEVEL = n2 < 0 ? 0 : (n2 > 4 ? 4 : n2);
        this.QUIET = bl;
        this.logBuffer = new Vector(this.LOG_BUFFER_SIZE);
        if (!this.QUIET) {
            System.out.println("Logger initialized, loglevel is " + LEVELS[this.LOG_LEVEL]);
        }
    }

    protected void log(int n, String string, Throwable throwable, ServiceReference<?> serviceReference, Bundle bundle) {
        if (n <= this.LOG_LEVEL) {
            LogEntryImpl logEntryImpl = LogEntryImpl.getEntry(n, string, throwable, serviceReference, bundle);
            this.logBuffer.add(logEntryImpl);
            if (this.logBuffer.size() > this.LOG_BUFFER_SIZE) {
                LogEntryImpl.releaseEntry(this.logBuffer.remove(0));
            }
            Iterator<LogListener> iterator = this.logListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().logged(logEntryImpl);
            }
            if (!this.QUIET) {
                System.out.println(logEntryImpl);
            }
        }
    }

    @Override
    public void addLogListener(LogListener logListener) {
        this.logListeners.add(logListener);
    }

    @Override
    public void removeLogListener(LogListener logListener) {
        this.logListeners.remove(logListener);
    }

    @Override
    public Enumeration<? extends LogEntry> getLog() {
        return this.logBuffer.elements();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LogEntryImpl
    implements LogEntry {
        private int level;
        private String message;
        private ServiceReference<?> sref;
        private Throwable exception;
        private Bundle bundle;
        private long time;
        private static final List<LogEntryImpl> entryRecyclingList = new ArrayList<LogEntryImpl>(5);
        private static final int THRESHOLD = 5;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static LogEntryImpl getEntry(int n, String string, Throwable throwable, ServiceReference<?> serviceReference, Bundle bundle) {
            List<LogEntryImpl> list = entryRecyclingList;
            synchronized (list) {
                LogEntryImpl logEntryImpl = entryRecyclingList.isEmpty() ? new LogEntryImpl() : entryRecyclingList.remove(0);
                logEntryImpl.log(n, string, throwable, serviceReference, bundle);
                return logEntryImpl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static void releaseEntry(LogEntryImpl logEntryImpl) {
            List<LogEntryImpl> list = entryRecyclingList;
            synchronized (list) {
                if (entryRecyclingList.size() < 5) {
                    logEntryImpl.log(0, null, null, null, null);
                    entryRecyclingList.add(logEntryImpl);
                }
            }
        }

        private LogEntryImpl() {
        }

        private void log(int n, String string, Throwable throwable, ServiceReference<?> serviceReference, Bundle bundle) {
            this.level = n;
            this.message = string;
            this.exception = throwable;
            this.sref = serviceReference;
            this.bundle = bundle;
            this.time = System.currentTimeMillis();
        }

        @Override
        public Bundle getBundle() {
            return this.bundle;
        }

        @Override
        public ServiceReference<?> getServiceReference() {
            return this.sref;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public Throwable getException() {
            return this.exception;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[").append(new Date(this.time)).append("] [").append(LogServiceImpl.getLevelString(this.level)).append("] ");
            if (this.sref != null) {
                stringBuffer.append("Bundle: ");
                stringBuffer.append(this.sref.getBundle());
                stringBuffer.append(" ");
                stringBuffer.append("ServiceReference: ");
                stringBuffer.append(this.sref);
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.message);
            if (this.exception != null) {
                stringBuffer.append("\n\tException: ");
                stringBuffer.append(this.exception.getMessage());
            }
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class LogServiceFactory
    implements ServiceFactory<LogService> {
        LogServiceFactory() {
        }

        @Override
        public LogService getService(Bundle bundle, ServiceRegistration<LogService> serviceRegistration) {
            return new LogServiceInstance(bundle);
        }

        @Override
        public void ungetService(Bundle bundle, ServiceRegistration<LogService> serviceRegistration, LogService logService) {
        }
    }

    private final class LogServiceInstance
    implements LogService {
        private final Bundle bundle;

        protected LogServiceInstance(Bundle bundle) {
            this.bundle = bundle;
        }

        public void log(int n, String string) {
            LogServiceImpl.this.log(n, string, null, null, this.bundle);
        }

        public void log(int n, String string, Throwable throwable) {
            LogServiceImpl.this.log(n, string, throwable, null, this.bundle);
        }

        public void log(ServiceReference serviceReference, int n, String string) {
            LogServiceImpl.this.log(n, string, null, serviceReference, this.bundle);
        }

        public void log(ServiceReference serviceReference, int n, String string, Throwable throwable) {
            LogServiceImpl.this.log(n, string, throwable, serviceReference, this.bundle);
        }
    }
}

