/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.PackagePermissionCollection;
import org.osgi.framework.SignerProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PackagePermission
extends BasicPermission {
    static final long serialVersionUID = -5107705877071099135L;
    public static final String EXPORT = "export";
    public static final String EXPORTONLY = "exportonly";
    public static final String IMPORT = "import";
    private static final int ACTION_EXPORT = 1;
    private static final int ACTION_IMPORT = 2;
    private static final int ACTION_ALL = 3;
    static final int ACTION_NONE = 0;
    transient int action_mask;
    private volatile String actions = null;
    final transient Bundle bundle;
    transient Filter filter;
    private volatile transient Map<String, Object> properties;

    public PackagePermission(String string, String string2) {
        this(string, PackagePermission.parseActions(string2));
        if (this.filter != null && (this.action_mask & 3) != 2) {
            throw new IllegalArgumentException("invalid action string for filter expression");
        }
    }

    public PackagePermission(String string, Bundle bundle, String string2) {
        super(string);
        this.setTransients(string, PackagePermission.parseActions(string2));
        this.bundle = bundle;
        if (bundle == null) {
            throw new IllegalArgumentException("bundle must not be null");
        }
        if (this.filter != null) {
            throw new IllegalArgumentException("invalid name");
        }
        if ((this.action_mask & 3) != 2) {
            throw new IllegalArgumentException("invalid action string");
        }
    }

    PackagePermission(String string, int n) {
        super(string);
        this.setTransients(string, n);
        this.bundle = null;
    }

    private void setTransients(String string, int n) {
        if (n == 0 || (n & 3) != n) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
        this.filter = PackagePermission.parseFilter(string);
    }

    private static int parseActions(String string) {
        boolean bl = false;
        int n = 0;
        if (string == null) {
            return n;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        if (n2 < 0) {
            return n;
        }
        while (n2 != -1) {
            int n3;
            char c;
            while (n2 != -1 && ((c = cArray[n2]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n2;
            }
            if (!(n2 < 5 || cArray[n2 - 5] != 'i' && cArray[n2 - 5] != 'I' || cArray[n2 - 4] != 'm' && cArray[n2 - 4] != 'M' || cArray[n2 - 3] != 'p' && cArray[n2 - 3] != 'P' || cArray[n2 - 2] != 'o' && cArray[n2 - 2] != 'O' || cArray[n2 - 1] != 'r' && cArray[n2 - 1] != 'R' || cArray[n2] != 't' && cArray[n2] != 'T')) {
                n3 = 6;
                n |= 2;
            } else if (!(n2 < 5 || cArray[n2 - 5] != 'e' && cArray[n2 - 5] != 'E' || cArray[n2 - 4] != 'x' && cArray[n2 - 4] != 'X' || cArray[n2 - 3] != 'p' && cArray[n2 - 3] != 'P' || cArray[n2 - 2] != 'o' && cArray[n2 - 2] != 'O' || cArray[n2 - 1] != 'r' && cArray[n2 - 1] != 'R' || cArray[n2] != 't' && cArray[n2] != 'T')) {
                n3 = 6;
                n |= 3;
            } else if (!(n2 < 9 || cArray[n2 - 9] != 'e' && cArray[n2 - 9] != 'E' || cArray[n2 - 8] != 'x' && cArray[n2 - 8] != 'X' || cArray[n2 - 7] != 'p' && cArray[n2 - 7] != 'P' || cArray[n2 - 6] != 'o' && cArray[n2 - 6] != 'O' || cArray[n2 - 5] != 'r' && cArray[n2 - 5] != 'R' || cArray[n2 - 4] != 't' && cArray[n2 - 4] != 'T' || cArray[n2 - 3] != 'o' && cArray[n2 - 3] != 'O' || cArray[n2 - 2] != 'n' && cArray[n2 - 2] != 'N' || cArray[n2 - 1] != 'l' && cArray[n2 - 1] != 'L' || cArray[n2] != 'y' && cArray[n2] != 'Y')) {
                n3 = 10;
                n |= 1;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            bl = false;
            while (n2 >= n3 && !bl) {
                switch (cArray[n2 - n3]) {
                    case ',': {
                        bl = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n2;
            }
            n2 -= n3;
        }
        if (bl) {
            throw new IllegalArgumentException("invalid permission: " + string);
        }
        return n;
    }

    private static Filter parseFilter(String string) {
        if ((string = string.trim()).charAt(0) != '(') {
            return null;
        }
        try {
            return FrameworkUtil.createFilter(string);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid filter");
            illegalArgumentException.initCause(invalidSyntaxException);
            throw illegalArgumentException;
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof PackagePermission)) {
            return false;
        }
        PackagePermission packagePermission = (PackagePermission)permission;
        if (this.bundle != null) {
            return false;
        }
        if (packagePermission.filter != null) {
            return false;
        }
        return this.implies0(packagePermission, 0);
    }

    boolean implies0(PackagePermission packagePermission, int n) {
        int n2 = packagePermission.action_mask;
        if (((n |= this.action_mask) & n2) != n2) {
            return false;
        }
        Filter filter = this.filter;
        if (filter == null) {
            return super.implies(packagePermission);
        }
        return filter.matches(packagePermission.getProperties());
    }

    @Override
    public String getActions() {
        String string = this.actions;
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n = this.action_mask;
            if ((n & 1) == 1) {
                stringBuffer.append(EXPORTONLY);
                bl = true;
            }
            if ((n & 2) == 2) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(IMPORT);
            }
            this.actions = string = stringBuffer.toString();
        }
        return string;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new PackagePermissionCollection();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PackagePermission)) {
            return false;
        }
        PackagePermission packagePermission = (PackagePermission)object;
        return this.action_mask == packagePermission.action_mask && this.getName().equals(packagePermission.getName()) && (this.bundle == packagePermission.bundle || this.bundle != null && this.bundle.equals(packagePermission.bundle));
    }

    @Override
    public int hashCode() {
        int n = 527 + this.getName().hashCode();
        n = 31 * n + this.getActions().hashCode();
        if (this.bundle != null) {
            n = 31 * n + this.bundle.hashCode();
        }
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.bundle != null) {
            throw new NotSerializableException("cannot serialize");
        }
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setTransients(this.getName(), PackagePermission.parseActions(this.actions));
    }

    private Map<String, Object> getProperties() {
        Map<String, Object> map = this.properties;
        if (map != null) {
            return map;
        }
        final HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
        hashMap.put("package.name", this.getName());
        if (this.bundle != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    SignerProperty signerProperty;
                    hashMap.put("id", new Long(PackagePermission.this.bundle.getBundleId()));
                    hashMap.put("location", PackagePermission.this.bundle.getLocation());
                    String string = PackagePermission.this.bundle.getSymbolicName();
                    if (string != null) {
                        hashMap.put("name", string);
                    }
                    if ((signerProperty = new SignerProperty(PackagePermission.this.bundle)).isBundleSigned()) {
                        hashMap.put("signer", signerProperty);
                    }
                    return null;
                }
            });
        }
        this.properties = hashMap;
        return this.properties;
    }
}

