/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.osgi.framework.Version;

public class VersionRange {
    public static final char LEFT_OPEN = '(';
    public static final char LEFT_CLOSED = '[';
    public static final char RIGHT_OPEN = ')';
    public static final char RIGHT_CLOSED = ']';
    private final boolean leftClosed;
    private final Version left;
    private final Version right;
    private final boolean rightClosed;
    private final boolean empty;
    private transient String versionRangeString;
    private transient int hash;
    private static final String LEFT_OPEN_DELIMITER = "(";
    private static final String LEFT_CLOSED_DELIMITER = "[";
    private static final String LEFT_DELIMITERS = "[(";
    private static final String RIGHT_OPEN_DELIMITER = ")";
    private static final String RIGHT_CLOSED_DELIMITER = "]";
    private static final String RIGHT_DELIMITERS = ")]";
    private static final String ENDPOINT_DELIMITER = ",";

    public VersionRange(char c, Version version, Version version2, char c2) {
        if (c != '[' && c != '(') {
            throw new IllegalArgumentException("invalid leftType \"" + c + "\"");
        }
        if (c2 != ')' && c2 != ']') {
            throw new IllegalArgumentException("invalid rightType \"" + c2 + "\"");
        }
        if (version == null) {
            throw new IllegalArgumentException("null leftEndpoint argument");
        }
        this.leftClosed = c == '[';
        this.rightClosed = c2 == ']';
        this.left = version;
        this.right = version2;
        this.empty = this.isEmpty0();
    }

    public VersionRange(String string) {
        Version version;
        boolean bl;
        Version version2;
        boolean bl2;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, LEFT_DELIMITERS, true);
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() == 0) {
                string2 = stringTokenizer.nextToken();
            }
            if (!(bl2 = LEFT_CLOSED_DELIMITER.equals(string2)) && !LEFT_OPEN_DELIMITER.equals(string2)) {
                if (stringTokenizer.hasMoreTokens()) {
                    throw new IllegalArgumentException("invalid range \"" + string + "\": invalid format");
                }
                this.leftClosed = true;
                this.rightClosed = false;
                this.left = VersionRange.parseVersion(string2, string);
                this.right = null;
                this.empty = false;
                return;
            }
            String string3 = stringTokenizer.nextToken(ENDPOINT_DELIMITER);
            version2 = VersionRange.parseVersion(string3, string);
            string2 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken(RIGHT_DELIMITERS);
            string2 = stringTokenizer.nextToken();
            bl = RIGHT_CLOSED_DELIMITER.equals(string2);
            if (!bl && !RIGHT_OPEN_DELIMITER.equals(string2)) {
                throw new IllegalArgumentException("invalid range \"" + string + "\": invalid format");
            }
            version = VersionRange.parseVersion(string3, string);
            if (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken("").trim()).length() != 0) {
                throw new IllegalArgumentException("invalid range \"" + string + "\": invalid format");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid range \"" + string + "\": invalid format");
            illegalArgumentException.initCause(noSuchElementException);
            throw illegalArgumentException;
        }
        this.leftClosed = bl2;
        this.rightClosed = bl;
        this.left = version2;
        this.right = version;
        this.empty = this.isEmpty0();
    }

    private static Version parseVersion(String string, String string2) {
        try {
            return Version.parseVersion(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IllegalArgumentException illegalArgumentException2 = new IllegalArgumentException("invalid range \"" + string2 + "\": " + illegalArgumentException.getMessage());
            illegalArgumentException2.initCause(illegalArgumentException);
            throw illegalArgumentException2;
        }
    }

    public Version getLeft() {
        return this.left;
    }

    public Version getRight() {
        return this.right;
    }

    public char getLeftType() {
        return this.leftClosed ? (char)'[' : '(';
    }

    public char getRightType() {
        return this.rightClosed ? (char)']' : ')';
    }

    public boolean includes(Version version) {
        if (this.empty) {
            return false;
        }
        if (this.left.compareTo(version) >= (this.leftClosed ? 1 : 0)) {
            return false;
        }
        if (this.right == null) {
            return true;
        }
        return this.right.compareTo(version) >= (this.rightClosed ? 0 : 1);
    }

    public VersionRange intersection(VersionRange ... versionRangeArray) {
        if (versionRangeArray == null || versionRangeArray.length == 0) {
            return this;
        }
        boolean bl = this.leftClosed;
        boolean bl2 = this.rightClosed;
        Version version = this.left;
        Version version2 = this.right;
        for (VersionRange versionRange : versionRangeArray) {
            int n = version.compareTo(versionRange.left);
            if (n == 0) {
                bl = bl && versionRange.leftClosed;
            } else if (n < 0) {
                version = versionRange.left;
                bl = versionRange.leftClosed;
            }
            if (versionRange.right == null) continue;
            if (version2 == null) {
                version2 = versionRange.right;
                bl2 = versionRange.rightClosed;
                continue;
            }
            n = version2.compareTo(versionRange.right);
            if (n == 0) {
                bl2 = bl2 && versionRange.rightClosed;
                continue;
            }
            if (n <= 0) continue;
            version2 = versionRange.right;
            bl2 = versionRange.rightClosed;
        }
        return new VersionRange(bl ? (char)'[' : '(', version, version2, bl2 ? (char)']' : ')');
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private boolean isEmpty0() {
        if (this.right == null) {
            return false;
        }
        int n = this.left.compareTo(this.right);
        if (n == 0) {
            return !this.leftClosed || !this.rightClosed;
        }
        return n > 0;
    }

    public boolean isExact() {
        if (this.empty || this.right == null) {
            return false;
        }
        if (this.leftClosed) {
            if (this.rightClosed) {
                return this.left.equals(this.right);
            }
            Version version = new Version(this.left.getMajor(), this.left.getMinor(), this.left.getMicro(), this.left.getQualifier() + "-");
            return version.compareTo(this.right) >= 0;
        }
        if (this.rightClosed) {
            Version version = new Version(this.left.getMajor(), this.left.getMinor(), this.left.getMicro(), this.left.getQualifier() + "-");
            return version.equals(this.right);
        }
        Version version = new Version(this.left.getMajor(), this.left.getMinor(), this.left.getMicro(), this.left.getQualifier() + "--");
        return version.compareTo(this.right) >= 0;
    }

    public String toString() {
        if (this.versionRangeString != null) {
            return this.versionRangeString;
        }
        String string = this.left.toString();
        if (this.right == null) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 1);
            stringBuffer.append(this.left.toString0());
            this.versionRangeString = stringBuffer.toString();
            return this.versionRangeString;
        }
        String string2 = this.right.toString();
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length() + 5);
        stringBuffer.append(this.leftClosed ? (char)'[' : '(');
        stringBuffer.append(this.left.toString0());
        stringBuffer.append(ENDPOINT_DELIMITER);
        stringBuffer.append(this.right.toString0());
        stringBuffer.append(this.rightClosed ? (char)']' : ')');
        this.versionRangeString = stringBuffer.toString();
        return this.versionRangeString;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        if (this.empty) {
            this.hash = 31;
            return 31;
        }
        int n = 31 + (this.leftClosed ? 7 : 5);
        n = 31 * n + this.left.hashCode();
        if (this.right != null) {
            n = 31 * n + this.right.hashCode();
            n = 31 * n + (this.rightClosed ? 7 : 5);
        }
        this.hash = n;
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VersionRange)) {
            return false;
        }
        VersionRange versionRange = (VersionRange)object;
        if (this.empty && versionRange.empty) {
            return true;
        }
        if (this.right == null) {
            return this.leftClosed == versionRange.leftClosed && versionRange.right == null && this.left.equals(versionRange.left);
        }
        return this.leftClosed == versionRange.leftClosed && this.rightClosed == versionRange.rightClosed && this.left.equals(versionRange.left) && this.right.equals(versionRange.right);
    }

    public String toFilterString(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException("invalid attributeName \"" + string + "\"");
        }
        for (char c : string.toCharArray()) {
            if (c != '=' && c != '>' && c != '<' && c != '~' && c != '(' && c != ')') continue;
            throw new IllegalArgumentException("invalid attributeName \"" + string + "\"");
        }
        Object object = new StringBuffer(128);
        if (this.right != null) {
            ((StringBuffer)object).append("(&");
        }
        if (this.leftClosed) {
            ((StringBuffer)object).append('(');
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append(">=");
            ((StringBuffer)object).append(this.left.toString0());
            ((StringBuffer)object).append(')');
        } else {
            ((StringBuffer)object).append("(!(");
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append("<=");
            ((StringBuffer)object).append(this.left.toString0());
            ((StringBuffer)object).append("))");
        }
        if (this.right != null) {
            if (this.rightClosed) {
                ((StringBuffer)object).append('(');
                ((StringBuffer)object).append(string);
                ((StringBuffer)object).append("<=");
                ((StringBuffer)object).append(this.right.toString0());
                ((StringBuffer)object).append(')');
            } else {
                ((StringBuffer)object).append("(!(");
                ((StringBuffer)object).append(string);
                ((StringBuffer)object).append(">=");
                ((StringBuffer)object).append(this.right.toString0());
                ((StringBuffer)object).append("))");
            }
            ((StringBuffer)object).append(')');
        }
        return ((StringBuffer)object).toString();
    }
}

