/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.generic.gdiffdata.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.generic.Messages;
import org.eclipse.emf.diffmerge.generic.api.IComparison;
import org.eclipse.emf.diffmerge.generic.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMergePolicy;
import org.eclipse.emf.diffmerge.generic.api.IMergeSelector;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GComparison;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GMapping;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GdiffdataPackage;
import org.eclipse.emf.diffmerge.generic.gdiffdata.impl.GIdentifiedImpl;
import org.eclipse.emf.diffmerge.generic.impl.helpers.DiffOperation;
import org.eclipse.emf.diffmerge.generic.impl.helpers.MatchOperation;
import org.eclipse.emf.diffmerge.generic.impl.helpers.MergeOperation;
import org.eclipse.emf.diffmerge.generic.impl.policies.ConfigurableMatchPolicy;
import org.eclipse.emf.diffmerge.generic.impl.policies.DefaultDiffPolicy;
import org.eclipse.emf.diffmerge.generic.impl.policies.DefaultMergePolicy;
import org.eclipse.emf.diffmerge.generic.util.IExpensiveOperation;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public abstract class GComparisonImpl<E, A, R>
extends GIdentifiedImpl
implements GComparison<E, A, R> {
    protected IEditableTreeDataScope<E> ancestorScope;
    protected IEditableTreeDataScope<E> referenceScope;
    protected IEditableTreeDataScope<E> targetScope;
    protected IMatchPolicy<E> lastMatchPolicy;
    protected IDiffPolicy<E> lastDiffPolicy;
    protected IMergePolicy<E> lastMergePolicy;
    protected GMapping<E, A, R> mapping;
    private final Map<Role, Set<Object>> _duplicateIDs;

    protected GComparisonImpl() {
        HashMap duplicateIDs = new HashMap(3);
        Role[] roleArray = Role.values();
        int n = roleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            duplicateIDs.put(role, new HashSet(0));
            ++n2;
        }
        this._duplicateIDs = Collections.unmodifiableMap(duplicateIDs);
    }

    public GComparisonImpl(IEditableTreeDataScope<E> targetScope_p, IEditableTreeDataScope<E> referenceScope_p) {
        this(targetScope_p, referenceScope_p, null);
    }

    public GComparisonImpl(IEditableTreeDataScope<E> targetScope_p, IEditableTreeDataScope<E> referenceScope_p, IEditableTreeDataScope<E> ancestorScope_p) {
        this();
        this.setTargetScope(targetScope_p);
        this.setReferenceScope(referenceScope_p);
        this.setAncestorScope(ancestorScope_p);
        this.setMapping(this.newMapping());
    }

    @Override
    protected EClass eStaticClass() {
        return GdiffdataPackage.Literals.GCOMPARISON;
    }

    @Override
    public IEditableTreeDataScope<E> getAncestorScope() {
        return this.ancestorScope;
    }

    @Override
    public void setAncestorScope(IEditableTreeDataScope<E> newAncestorScope) {
        IEditableTreeDataScope<E> oldAncestorScope = this.ancestorScope;
        this.ancestorScope = newAncestorScope;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldAncestorScope, this.ancestorScope));
        }
    }

    @Override
    public IEditableTreeDataScope<E> getReferenceScope() {
        return this.referenceScope;
    }

    @Override
    public void setReferenceScope(IEditableTreeDataScope<E> newReferenceScope) {
        IEditableTreeDataScope<E> oldReferenceScope = this.referenceScope;
        this.referenceScope = newReferenceScope;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldReferenceScope, this.referenceScope));
        }
    }

    @Override
    public IEditableTreeDataScope<E> getTargetScope() {
        return this.targetScope;
    }

    @Override
    public void setTargetScope(IEditableTreeDataScope<E> newTargetScope) {
        IEditableTreeDataScope<E> oldTargetScope = this.targetScope;
        this.targetScope = newTargetScope;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldTargetScope, this.targetScope));
        }
    }

    @Override
    public IMatchPolicy<E> getLastMatchPolicy() {
        return this.lastMatchPolicy;
    }

    @Override
    public void setLastMatchPolicy(IMatchPolicy<E> newLastMatchPolicy) {
        IMatchPolicy<E> oldLastMatchPolicy = this.lastMatchPolicy;
        this.lastMatchPolicy = newLastMatchPolicy;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldLastMatchPolicy, this.lastMatchPolicy));
        }
    }

    @Override
    public IDiffPolicy<E> getLastDiffPolicy() {
        return this.lastDiffPolicy;
    }

    @Override
    public void setLastDiffPolicy(IDiffPolicy<E> newLastDiffPolicy) {
        IDiffPolicy<E> oldLastDiffPolicy = this.lastDiffPolicy;
        this.lastDiffPolicy = newLastDiffPolicy;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldLastDiffPolicy, this.lastDiffPolicy));
        }
    }

    @Override
    public IMergePolicy<E> getLastMergePolicy() {
        return this.lastMergePolicy;
    }

    @Override
    public void setLastMergePolicy(IMergePolicy<E> newLastMergePolicy) {
        IMergePolicy<E> oldLastMergePolicy = this.lastMergePolicy;
        this.lastMergePolicy = newLastMergePolicy;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldLastMergePolicy, this.lastMergePolicy));
        }
    }

    @Override
    public GMapping<E, A, R> getMapping() {
        return this.mapping;
    }

    public NotificationChain basicSetMapping(GMapping<E, A, R> newMapping, NotificationChain msgs) {
        NotificationChain result = msgs;
        GMapping<E, A, R> oldMapping = this.mapping;
        this.mapping = newMapping;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 7, oldMapping, newMapping);
            if (result == null) {
                result = notification;
            } else {
                result.add((Notification)notification);
            }
        }
        return result;
    }

    @Override
    public void setMapping(GMapping<E, A, R> newMapping) {
        if (newMapping != this.mapping) {
            NotificationChain msgs = null;
            if (this.mapping != null) {
                msgs = ((InternalEObject)this.mapping).eInverseRemove((InternalEObject)this, -8, null, msgs);
            }
            if (newMapping != null) {
                msgs = ((InternalEObject)newMapping).eInverseAdd((InternalEObject)this, -8, null, msgs);
            }
            if ((msgs = this.basicSetMapping(newMapping, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, newMapping, newMapping));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return this.basicSetMapping(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getAncestorScope();
            }
            case 2: {
                return this.getReferenceScope();
            }
            case 3: {
                return this.getTargetScope();
            }
            case 4: {
                return this.getLastMatchPolicy();
            }
            case 5: {
                return this.getLastDiffPolicy();
            }
            case 6: {
                return this.getLastMergePolicy();
            }
            case 7: {
                return this.getMapping();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setAncestorScope((IEditableTreeDataScope)newValue);
                return;
            }
            case 2: {
                this.setReferenceScope((IEditableTreeDataScope)newValue);
                return;
            }
            case 3: {
                this.setTargetScope((IEditableTreeDataScope)newValue);
                return;
            }
            case 4: {
                this.setLastMatchPolicy((IMatchPolicy)newValue);
                return;
            }
            case 5: {
                this.setLastDiffPolicy((IDiffPolicy)newValue);
                return;
            }
            case 6: {
                this.setLastMergePolicy((IMergePolicy)newValue);
                return;
            }
            case 7: {
                this.setMapping((GMapping)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setAncestorScope(null);
                return;
            }
            case 2: {
                this.setReferenceScope(null);
                return;
            }
            case 3: {
                this.setTargetScope(null);
                return;
            }
            case 4: {
                this.setLastMatchPolicy(null);
                return;
            }
            case 5: {
                this.setLastDiffPolicy(null);
                return;
            }
            case 6: {
                this.setLastMergePolicy(null);
                return;
            }
            case 7: {
                this.setMapping(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.ancestorScope != null;
            }
            case 2: {
                return this.referenceScope != null;
            }
            case 3: {
                return this.targetScope != null;
            }
            case 4: {
                return this.lastMatchPolicy != null;
            }
            case 5: {
                return this.lastDiffPolicy != null;
            }
            case 6: {
                return this.lastMergePolicy != null;
            }
            case 7: {
                return this.mapping != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (ancestorScope: ");
        result.append(this.ancestorScope);
        result.append(", referenceScope: ");
        result.append(this.referenceScope);
        result.append(", targetScope: ");
        result.append(this.targetScope);
        result.append(", lastMatchPolicy: ");
        result.append(this.lastMatchPolicy);
        result.append(", lastDiffPolicy: ");
        result.append(this.lastDiffPolicy);
        result.append(", lastMergePolicy: ");
        result.append(this.lastMergePolicy);
        result.append(')');
        return result.toString();
    }

    @Override
    public void clear() {
        this.getMapping().clear();
        this.setLastMatchPolicy(null);
        this.setLastDiffPolicy(null);
        this.setLastMergePolicy(null);
        Role[] roleArray = Role.values();
        int n = roleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            this._duplicateIDs.get((Object)role).clear();
            ++n2;
        }
    }

    @Override
    public IStatus compute(IMatchPolicy<E> matchPolicy_p, IDiffPolicy<E> diffPolicy_p, IMergePolicy<E> mergePolicy_p, IProgressMonitor monitor_p) {
        IProgressMonitor nonNullMonitor = monitor_p != null ? monitor_p : new NullProgressMonitor();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)nonNullMonitor, (String)Messages.Comparison_Task_Main, (int)2);
        this.setLastMatchPolicy(matchPolicy_p != null ? matchPolicy_p : this.getDefaultMatchPolicy());
        this.setLastDiffPolicy(diffPolicy_p != null ? diffPolicy_p : this.getDefaultDiffPolicy());
        this.setLastMergePolicy(mergePolicy_p != null ? mergePolicy_p : this.getDefaultMergePolicy());
        IStatus result = this.computeMatch(this.getLastMatchPolicy(), (IProgressMonitor)subMonitor.newChild(1));
        if (result.isOK()) {
            result = this.computeDiff(this.getLastDiffPolicy(), this.getLastMergePolicy(), (IProgressMonitor)subMonitor.newChild(1));
        }
        return result;
    }

    protected IStatus computeMatch(IMatchPolicy<E> matchPolicy_p, IProgressMonitor monitor_p) {
        IExpensiveOperation matchOperation = this.getMatchOperation(matchPolicy_p, this._duplicateIDs);
        IStatus result = matchOperation.run(monitor_p);
        return result;
    }

    protected IStatus computeDiff(IDiffPolicy<E> diffPolicy_p, IMergePolicy<E> mergePolicy_p, IProgressMonitor monitor_p) {
        IExpensiveOperation diffOperation = this.getDiffOperation(diffPolicy_p, mergePolicy_p);
        IStatus result = diffOperation.run(monitor_p);
        return result;
    }

    @Override
    public TreeIterator<IMatch<E>> getAllContents(final Role role_p) {
        return new AbstractTreeIterator<IMatch<E>>(this, false){

            protected Iterator<? extends IMatch<E>> getChildren(Object object_p) {
                Iterator<IMatch<Object>> result = object_p instanceof IComparison ? ((IComparison)object_p).getContents(role_p).iterator() : GComparisonImpl.this.getContentsOf((IMatch)object_p, role_p).iterator();
                return result;
            }
        };
    }

    @Override
    public IMatch<E> getContainerOf(IMatch<E> match_p, Role role_p) {
        ITreeDataScope scope;
        Object container;
        IMatch result = null;
        Object child = match_p.get(role_p);
        if (child != null && (container = (scope = this.getScope(role_p)).getContainer(child)) != null) {
            result = this.getMapping().getMatchFor(container, role_p);
        }
        return result;
    }

    @Override
    public List<IMatch<E>> getContents() {
        List<IMatch<E>> targetMatches = this.getContents(Role.TARGET);
        List<IMatch<E>> referenceMatches = this.getContents(Role.REFERENCE);
        FArrayList result = new FArrayList(referenceMatches, null);
        for (IMatch<E> targetMatch : targetMatches) {
            if (result.contains(targetMatch)) continue;
            result.add(targetMatch);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<IMatch<E>> getContents(Role role_p) {
        FArrayList result = new FArrayList();
        List contents = this.getScope(role_p).getRoots();
        for (Object child : contents) {
            IMatch childMatch = this.getMapping().getMatchFor(child, role_p);
            if (childMatch == null) continue;
            result.add(childMatch);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<IMatch<E>> getContentsOf(IMatch<E> match_p) {
        List<IMatch<E>> targetMatches = this.getContentsOf(match_p, Role.TARGET);
        List<IMatch<E>> referenceMatches = this.getContentsOf(match_p, Role.REFERENCE);
        FOrderedSet result = new FOrderedSet(referenceMatches, null);
        for (IMatch<E> targetMatch : targetMatches) {
            result.add(targetMatch);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<IMatch<E>> getContentsOf(IMatch<E> match_p, Role role_p) {
        FArrayList result = new FArrayList();
        List contents = null;
        Object container = match_p.get(role_p);
        if (container != null) {
            ITreeDataScope scope = this.getScope(role_p);
            contents = scope.getContents(container);
        }
        if (contents != null) {
            for (Object child : contents) {
                IMatch childMatch = this.getMapping().getMatchFor(child, role_p);
                if (childMatch == null) continue;
                result.add(childMatch);
            }
        }
        return Collections.unmodifiableList(result);
    }

    protected IDiffPolicy<E> getDefaultDiffPolicy() {
        return new DefaultDiffPolicy();
    }

    protected IMatchPolicy<E> getDefaultMatchPolicy() {
        return new ConfigurableMatchPolicy();
    }

    protected IMergePolicy<E> getDefaultMergePolicy() {
        return new DefaultMergePolicy();
    }

    @Override
    public Collection<IDifference<E>> getDifferences(Role role_p) {
        FHashSet result = new FHashSet(IEqualityTester.BY_EQUALS);
        for (IMatch match : this.getMapping().getContents()) {
            result.addAll(match.getPresenceDifferencesIn(role_p));
        }
        return Collections.unmodifiableCollection(result);
    }

    protected IExpensiveOperation getDiffOperation(IDiffPolicy<E> diffPolicy_p, IMergePolicy<E> mergePolicy_p) {
        return new DiffOperation<E>(this, diffPolicy_p, mergePolicy_p);
    }

    @Override
    public Collection<Object> getDuplicateMatchIDs(Role role_p) {
        return this._duplicateIDs.get((Object)role_p);
    }

    protected IExpensiveOperation getMatchOperation(IMatchPolicy<E> policy_p, Map<Role, Set<Object>> duplicateIDs_p) {
        return new MatchOperation<E>(this, policy_p, duplicateIDs_p);
    }

    @Override
    public int getNbDifferences() {
        int result = 0;
        for (IMatch match : this.getMapping().getContents()) {
            result += match.getRelatedDifferences().size();
        }
        return result;
    }

    @Override
    public int getNbNoContainmentDifferences() {
        int result = 0;
        for (IMatch match : this.getMapping().getContents()) {
            result += match.getNbNoContainmentDifferences();
        }
        return result;
    }

    @Override
    public Collection<IDifference<E>> getRemainingDifferences() {
        FHashSet result = new FHashSet(IEqualityTester.BY_EQUALS);
        for (IMatch match : this.getMapping().getContents()) {
            for (IDifference difference : match.getAllDifferences()) {
                if (difference.isMerged()) continue;
                result.add(difference);
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public IEditableTreeDataScope<E> getScope(Role role) {
        IEditableTreeDataScope<E> result;
        switch (role) {
            case TARGET: {
                result = this.getTargetScope();
                break;
            }
            case REFERENCE: {
                result = this.getReferenceScope();
                break;
            }
            default: {
                result = this.getAncestorScope();
            }
        }
        return result;
    }

    @Override
    public boolean hasRemainingDifferences() {
        for (IMatch match : this.getMapping().getContents()) {
            for (IDifference difference : match.getAllDifferences()) {
                if (difference.isMerged()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConsistent() {
        Role[] roleArray = Role.values();
        int n = roleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            if (!this.getDuplicateMatchIDs(role).isEmpty()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isThreeWay() {
        return this.getAncestorScope() != null;
    }

    @Override
    public Collection<IDifference<E>> merge(final Role destination_p, boolean updateReferences_p, IProgressMonitor monitor_p) {
        Collection<IDifference<E>> result = this.merge(new IMergeSelector<E>(){

            @Override
            public Role getMergeDirection(IDifference<E> difference_p) {
                return destination_p;
            }
        }, updateReferences_p, monitor_p);
        return result;
    }

    @Override
    public Collection<IDifference<E>> merge(Collection<? extends IDifference<E>> differences_p, Role destination_p, boolean updateReferences_p, IProgressMonitor monitor_p) {
        MergeOperation operation = new MergeOperation(this, differences_p, destination_p, updateReferences_p);
        operation.run(monitor_p);
        return operation.getOutput();
    }

    @Override
    public Collection<IDifference<E>> merge(IMergeSelector<E> merger_p, boolean updateReferences_p, IProgressMonitor monitor_p) {
        MergeOperation<E> operation = new MergeOperation<E>(this, merger_p, updateReferences_p);
        operation.run(monitor_p);
        return operation.getOutput();
    }

    protected abstract GMapping<E, A, R> newMapping();

    @Override
    public boolean swapScopes() {
        boolean isEmpty = this.getMapping().isEmpty();
        if (isEmpty) {
            IEditableTreeDataScope<E> formerTarget = this.targetScope;
            this.targetScope = this.referenceScope;
            this.referenceScope = formerTarget;
        }
        return isEmpty;
    }
}

