/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.compare.INavigatable;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Logger;
import org.eclipse.emf.diffmerge.generic.api.IComparison;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.diffmerge.generic.api.diff.IPresenceDifference;
import org.eclipse.emf.diffmerge.generic.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.generic.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.diffuidata.ComparisonSelection;
import org.eclipse.emf.diffmerge.ui.diffuidata.MatchAndFeature;
import org.eclipse.emf.diffmerge.ui.diffuidata.impl.ComparisonSelectionImpl;
import org.eclipse.emf.diffmerge.ui.log.CompareLogEvent;
import org.eclipse.emf.diffmerge.ui.log.DiffMergeLogger;
import org.eclipse.emf.diffmerge.ui.log.MergeLogEvent;
import org.eclipse.emf.diffmerge.ui.setup.ComparisonSetupManager;
import org.eclipse.emf.diffmerge.ui.setup.EMFDiffMergeEditorInput;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethod;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.util.DelegatingLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.DiffDecoratingLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.DifferenceKind;
import org.eclipse.emf.diffmerge.ui.util.IDiffLabelDecorator;
import org.eclipse.emf.diffmerge.ui.util.InconsistencyDialog;
import org.eclipse.emf.diffmerge.ui.util.SymmetricMatchComparer;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.AbstractComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.CategoryDialog;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonSideViewer;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonTreeViewer;
import org.eclipse.emf.diffmerge.ui.viewers.DefaultUserProperties;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.EnhancedComparisonSideViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EnhancedComparisonTreeViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EnhancedFeaturesViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EnhancedValuesViewer;
import org.eclipse.emf.diffmerge.ui.viewers.FeaturesViewer;
import org.eclipse.emf.diffmerge.ui.viewers.HeaderViewer;
import org.eclipse.emf.diffmerge.ui.viewers.IgnoreChoiceData;
import org.eclipse.emf.diffmerge.ui.viewers.IgnoreChoicesDialog;
import org.eclipse.emf.diffmerge.ui.viewers.MergeChoiceData;
import org.eclipse.emf.diffmerge.ui.viewers.MergeChoicesDialog;
import org.eclipse.emf.diffmerge.ui.viewers.MergeImpactMessageDialog;
import org.eclipse.emf.diffmerge.ui.viewers.MergeImpactViewer;
import org.eclipse.emf.diffmerge.ui.viewers.SelectionBridge;
import org.eclipse.emf.diffmerge.ui.viewers.TextCompareContent;
import org.eclipse.emf.diffmerge.ui.viewers.TextMergerDialog;
import org.eclipse.emf.diffmerge.ui.viewers.ValuesViewer;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.progress.IProgressService;

public class ComparisonViewer
extends AbstractComparisonViewer {
    public static final String LOCATION_TOOLBAR_SYNTHESIS = "toolbar:org.eclipse.emf.diffmerge.ui.toolbars.synthesis";
    public static final String LOCATION_TOOLBAR_DETAILS = "toolbar:org.eclipse.emf.diffmerge.ui.toolbars.details";
    public static final String LOCATION_TOOLBAR_GROUP_CONSISTENCY = "consistencyGroup";
    public static final String LOCATION_TOOLBAR_GROUP_NAVIGATION = "navigationGroup";
    public static final String LOCATION_TOOLBAR_GROUP_EXPANSION = "expansionGroup";
    public static final String LOCATION_TOOLBAR_GROUP_FILTERING = "filteringGroup";
    public static final String LOCATION_TOOLBAR_GROUP_MENU = "menuGroup";
    public static final String PROPERTY_FILTERING = "PROPERTY_FILTERING";
    public static final String PROPERTY_ACTIVATION_DELETE_LEFT = "PROPERTY_ACTIVATION_DELETE_LEFT";
    public static final String PROPERTY_ACTIVATION_DELETE_RIGHT = "PROPERTY_ACTIVATION_DELETE_RIGHT";
    public static final String PROPERTY_ACTIVATION_MERGE_TO_LEFT = "PROPERTY_ACTIVATION_MERGE_TO_LEFT";
    public static final String PROPERTY_ACTIVATION_MERGE_TO_RIGHT = "PROPERTY_ACTIVATION_MERGE_TO_RIGHT";
    public static final String PROPERTY_ACTIVATION_IGNORE_LEFT = "PROPERTY_ACTIVATION_IGNORE_LEFT";
    public static final String PROPERTY_ACTIVATION_IGNORE_RIGHT = "PROPERTY_ACTIVATION_IGNORE_RIGHT";
    public static final String PROPERTY_ACTIVATION_OPEN_DEDICATED = "PROPERTY_ACTIVATION_OPEN_DEDICATED";
    protected static final ISelectionProvider UNKNOWN_SELECTION_PROVIDER = new ISelectionProvider(){

        public void setSelection(ISelection selection_p) {
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener_p) {
        }

        public ISelection getSelection() {
            return null;
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener_p) {
        }
    };
    protected EnhancedComparisonTreeViewer _viewerSynthesisMain;
    protected EnhancedComparisonSideViewer _viewerSynthesisLeft;
    protected EnhancedComparisonSideViewer _viewerSynthesisRight;
    protected EnhancedFeaturesViewer _viewerFeatures;
    protected EnhancedValuesViewer _viewerValuesLeft;
    protected EnhancedValuesViewer _viewerValuesRight;
    protected ViewerFilter _filterMoveOrigins;
    protected ViewerFilter _filterUnchangedElements;
    protected ViewerComparator _sorterSynthesis;
    private ComparisonSelection _lastUserSelection;
    protected SelectionBridge.SingleSource _multiViewerSelectionProvider;
    protected FilterSelectionListener _filterSelectionListener;

    public ComparisonViewer(Composite parent_p) {
        this(parent_p, null);
    }

    public ComparisonViewer(Composite parent_p, IActionBars actionBars_p) {
        super(parent_p, actionBars_p);
    }

    protected boolean acceptContextMenuAdditions(Viewer viewer_p) {
        return true;
    }

    protected boolean acceptToolBarAdditions(Viewer viewer_p) {
        return true;
    }

    protected void addDifferencesToMerge(List<IDifference<?>> toMerge_p, IMatch<?> match_p, Role destination_p, boolean incrementalMode_p) {
        for (IDifference difference : match_p.getAllDifferences()) {
            if (this.getInput().getCategoryManager().isFiltered(difference) || incrementalMode_p && (!(difference instanceof IPresenceDifference) || ((IPresenceDifference)difference).getPresenceRole() == destination_p)) continue;
            toMerge_p.add(difference);
        }
    }

    protected void addDifferencesToMergeRec(List<IDifference<?>> toMerge_p, IMatch<?> match_p, Role destination_p, boolean incrementalMode_p) {
        this.addDifferencesToMerge(toMerge_p, match_p, destination_p, incrementalMode_p);
        for (IMatch<?> child : this.getInput().getCategoryManager().getChildrenForMerge(match_p)) {
            this.addDifferencesToMergeRec(toMerge_p, child, destination_p, incrementalMode_p);
        }
    }

    protected ComparisonSelection asComparisonSelection(IStructuredSelection selection_p) {
        EMFDiffNode input = this.getInput();
        List<Object> matches = input != null ? ComparisonSelectionImpl.selectionToMatches(selection_p, input) : Collections.emptyList();
        ComparisonSelectionImpl result = new ComparisonSelectionImpl(matches, null, input);
        return result;
    }

    protected boolean canAddToTheLeft(DifferenceKind originKind_p) {
        List<DifferenceKind> allowed = Arrays.asList(DifferenceKind.CONFLICT, DifferenceKind.MODIFIED, DifferenceKind.FROM_BOTH, DifferenceKind.FROM_RIGHT, DifferenceKind.FROM_RIGHT_ADD, DifferenceKind.FROM_LEFT_DEL);
        return allowed.contains((Object)originKind_p);
    }

    protected boolean canAddToTheRight(DifferenceKind originKind_p) {
        List<DifferenceKind> allowed = Arrays.asList(DifferenceKind.CONFLICT, DifferenceKind.MODIFIED, DifferenceKind.FROM_BOTH, DifferenceKind.FROM_LEFT, DifferenceKind.FROM_LEFT_ADD, DifferenceKind.FROM_RIGHT_DEL);
        return allowed.contains((Object)originKind_p);
    }

    protected DirectedAction createActionAccept() {
        final DirectedAction result = new DirectedAction(this){

            public ImageDescriptor getImageDescriptor() {
                return this.isLeftToRight() ? EMFDiffMergeUIPlugin.getDefault().getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.CHECKIN_ACTION) : EMFDiffMergeUIPlugin.getDefault().getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.CHECKOUT_ACTION);
            }

            public void run() {
                this.merge(!this.isLeftToRight(), true);
            }
        };
        result.setText(Messages.ComparisonViewer_AcceptAction_Text);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                Object newValue;
                boolean leftToRight = result.isLeftToRight();
                if ((!leftToRight && ComparisonViewer.PROPERTY_ACTIVATION_MERGE_TO_LEFT.equals(event_p.getProperty()) || leftToRight && ComparisonViewer.PROPERTY_ACTIVATION_MERGE_TO_RIGHT.equals(event_p.getProperty())) && (newValue = event_p.getNewValue()) instanceof Boolean) {
                    result.setEnabled((Boolean)newValue);
                }
            }
        });
        return result;
    }

    protected DirectedAction createActionAcceptDeletion() {
        final DirectedAction result = new DirectedAction(this){

            public void run() {
                this.merge(!this.isLeftToRight(), false);
            }
        };
        result.setText(Messages.ComparisonViewer_DeleteAction_Text);
        result.setImageDescriptor(EMFDiffMergeUIPlugin.getDefault().getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.DELETE));
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                Object newValue;
                boolean leftToRight = result.isLeftToRight();
                if ((!leftToRight && ComparisonViewer.PROPERTY_ACTIVATION_DELETE_LEFT.equals(event_p.getProperty()) || leftToRight && ComparisonViewer.PROPERTY_ACTIVATION_DELETE_RIGHT.equals(event_p.getProperty())) && (newValue = event_p.getNewValue()) instanceof Boolean) {
                    result.setEnabled((Boolean)newValue);
                }
            }
        });
        return result;
    }

    protected DirectedAction createActionIgnore() {
        final IgnoreAction result = new IgnoreAction();
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                Object newValue = event_p.getNewValue();
                if (newValue instanceof Boolean) {
                    boolean boolValue = (Boolean)newValue;
                    String property = event_p.getProperty();
                    if (ComparisonViewer.PROPERTY_ACTIVATION_IGNORE_LEFT.equals(property)) {
                        result.setActiveLeft(boolValue);
                    } else if (ComparisonViewer.PROPERTY_ACTIVATION_IGNORE_RIGHT.equals(property)) {
                        result.setActiveRight(boolValue);
                    }
                }
            }
        });
        return result;
    }

    @Override
    protected Composite createControls(Composite parent_p) {
        this.initialize();
        SashForm result = new SashForm(parent_p, 512);
        SashForm upperPart = this.createRowUpper((Composite)result);
        SashForm lowerPart = this.createRowLower((Composite)result);
        this.setupColumns(upperPart, lowerPart);
        result.setWeights(this.getDefaultRowWeights());
        this.setupToolBars();
        return result;
    }

    protected ActionContributionItem createItemCollapse(IContributionManager context_p) {
        Action action = new Action(){

            public void run() {
                BusyIndicator.showWhile((Display)ComparisonViewer.this.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((ComparisonTreeViewer)((Object)(this).ComparisonViewer.this._viewerSynthesisMain.getInnerViewer())).collapseAll();
                    }
                });
            }
        };
        action.setImageDescriptor(this.getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.COLLAPSEALL));
        action.setToolTipText(Messages.ComparisonViewer_CollapseTooltip);
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemDelete(IContributionManager context_p, final boolean onLeft_p) {
        Action action = new Action(){

            public void run() {
                ComparisonViewer.this.merge(onLeft_p, false);
            }
        };
        action.setImageDescriptor(this.getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.DELETE));
        action.setToolTipText(onLeft_p ? Messages.ComparisonViewer_DeleteLeftTooltip : Messages.ComparisonViewer_DeleteRightTooltip);
        action.setEnabled(false);
        this.addPropertyChangeListener(new IPropertyChangeListener((IAction)action){
            private final /* synthetic */ IAction val$action;
            {
                this.val$action = iAction;
            }

            public void propertyChange(PropertyChangeEvent event_p) {
                Object newValue;
                if ((onLeft_p && ComparisonViewer.PROPERTY_ACTIVATION_DELETE_LEFT.equals(event_p.getProperty()) || !onLeft_p && ComparisonViewer.PROPERTY_ACTIVATION_DELETE_RIGHT.equals(event_p.getProperty())) && (newValue = event_p.getNewValue()) instanceof Boolean) {
                    this.val$action.setEnabled(((Boolean)newValue).booleanValue());
                }
            }
        });
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemExpand(IContributionManager context_p) {
        Action action = new Action(){

            public void run() {
                BusyIndicator.showWhile((Display)ComparisonViewer.this.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ComparisonTreeViewer synthesisViewer = (ComparisonTreeViewer)((Object)(this).ComparisonViewer.this._viewerSynthesisMain.getInnerViewer());
                        try {
                            synthesisViewer.getControl().setRedraw(false);
                            synthesisViewer.expandAll();
                        }
                        finally {
                            synthesisViewer.getControl().setRedraw(true);
                        }
                    }
                });
            }
        };
        action.setImageDescriptor(this.getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.EXPANDALL));
        action.setToolTipText(Messages.ComparisonViewer_ExpandTooltip);
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemFilter(IContributionManager context_p) {
        Action action = new Action(null, 2){

            public void runWithEvent(Event event_p) {
                ComparisonViewer.this._filterSelectionListener.runWithEvent(event_p);
            }
        };
        String text = context_p instanceof ToolBar ? Messages.ComparisonViewer_FilterToolTip : Messages.ComparisonViewer_FilterText;
        action.setText(text);
        action.setToolTipText(Messages.ComparisonViewer_EnhancedFilterToolTip);
        action.setImageDescriptor(this.getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.FILTER));
        action.setChecked(false);
        if (this._filterSelectionListener == null) {
            this._filterSelectionListener = new FilterSelectionListener();
        }
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        this._filterSelectionListener.addItem(result);
        return result;
    }

    protected ActionContributionItem createItemIgnore(IContributionManager context_p, final boolean onLeft_p) {
        Action action = new Action(){

            public void run() {
                ComparisonViewer.this.ignore(onLeft_p);
            }
        };
        action.setImageDescriptor(this.getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.CHECKED));
        action.setToolTipText(onLeft_p ? Messages.ComparisonViewer_IgnoreLeftTooltip : Messages.ComparisonViewer_IgnoreRightTooltip);
        action.setEnabled(false);
        this.addPropertyChangeListener(new IPropertyChangeListener((IAction)action){
            private final /* synthetic */ IAction val$action;
            {
                this.val$action = iAction;
            }

            public void propertyChange(PropertyChangeEvent event_p) {
                Object newValue;
                if ((onLeft_p && ComparisonViewer.PROPERTY_ACTIVATION_IGNORE_LEFT.equals(event_p.getProperty()) || !onLeft_p && ComparisonViewer.PROPERTY_ACTIVATION_IGNORE_RIGHT.equals(event_p.getProperty())) && (newValue = event_p.getNewValue()) instanceof Boolean) {
                    this.val$action.setEnabled(((Boolean)newValue).booleanValue());
                }
            }
        });
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemInconsistency(IContributionManager context_p) {
        final Action action = new Action(){

            public void run() {
                final Shell shell = ComparisonViewer.this.getShell();
                final IComparison<?> comparison = ComparisonViewer.this.getComparison();
                if (shell != null && comparison != null) {
                    shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            InconsistencyDialog dialog = new InconsistencyDialog(shell, comparison);
                            dialog.open();
                        }
                    });
                }
            }
        };
        action.setImageDescriptor(this.getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.WARNING));
        action.setDisabledImageDescriptor(this.getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.EMPTY));
        action.setEnabled(false);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty())) {
                    IComparison<?> comparison = ComparisonViewer.this.getComparison();
                    boolean enabled = comparison != null && !comparison.isConsistent();
                    action.setEnabled(enabled);
                    action.setToolTipText(enabled ? Messages.ComparisonViewer_InconsistencyTooltip : null);
                }
            }
        });
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemLock(IContributionManager context_p, final boolean onLeft_p) {
        final ImageDescriptor openLockImage = this.getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.LOCK_OPEN);
        final ImageDescriptor closedLockImage = this.getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.LOCK_CLOSED);
        final String lockedTooltip = Messages.ComparisonViewer_LockTooltip_Locked;
        final String unlockedTooltip = Messages.ComparisonViewer_LockTooltip_Unlocked;
        Action action = new Action(null, 2){

            public void run() {
                boolean editable = !this.isChecked();
                ComparisonViewer.this.getInput().setEditable(editable, onLeft_p);
                this.setImageDescriptor(editable ? openLockImage : closedLockImage);
                this.setToolTipText(editable ? unlockedTooltip : lockedTooltip);
                ComparisonViewer.this.refreshTools();
            }
        };
        action.setToolTipText(unlockedTooltip);
        action.setImageDescriptor(openLockImage);
        this.addPropertyChangeListener(new IPropertyChangeListener((IAction)action, openLockImage, closedLockImage, unlockedTooltip, lockedTooltip){
            private final /* synthetic */ IAction val$action;
            private final /* synthetic */ ImageDescriptor val$openLockImage;
            private final /* synthetic */ ImageDescriptor val$closedLockImage;
            private final /* synthetic */ String val$unlockedTooltip;
            private final /* synthetic */ String val$lockedTooltip;
            {
                this.val$action = iAction;
                this.val$openLockImage = imageDescriptor;
                this.val$closedLockImage = imageDescriptor2;
                this.val$unlockedTooltip = string;
                this.val$lockedTooltip = string2;
            }

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null) {
                    boolean editable = input.isEditable(onLeft_p);
                    this.val$action.setChecked(!editable);
                    this.val$action.setImageDescriptor(editable ? this.val$openLockImage : this.val$closedLockImage);
                    this.val$action.setToolTipText(editable ? this.val$unlockedTooltip : this.val$lockedTooltip);
                    this.val$action.setEnabled(input.isEditionPossible(onLeft_p));
                }
            }
        });
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemLogEvents(IContributionManager context_p) {
        Action action = new Action(Messages.ComparisonViewer_LogEventsMenuItem, 2){

            public void run() {
                boolean logEvents = this.isChecked();
                EMFDiffNode input = ComparisonViewer.this.getInput();
                if (input != null) {
                    input.setUserPropertyValue(DefaultUserProperties.P_LOG_EVENTS, logEvents);
                    if (logEvents) {
                        ComparisonViewer.this.getLogger().log((Object)new CompareLogEvent(ComparisonViewer.this.getEditingDomain(), input));
                    }
                }
            }
        };
        String tooltip = Messages.ComparisonViewer_LogTooltipNoFile;
        Logger logger = this.getLogger();
        if (logger instanceof DiffMergeLogger) {
            IPath logFile = ((DiffMergeLogger)logger).getLogFile();
            tooltip = String.format(Messages.ComparisonViewer_LogTooltipFile, logFile.toOSString());
        }
        action.setToolTipText(tooltip);
        this.addPropertyChangeListener(new IPropertyChangeListener((IAction)action){
            private final /* synthetic */ IAction val$action;
            {
                this.val$action = iAction;
            }

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null) {
                    this.val$action.setChecked(input.isUserPropertyTrue(DefaultUserProperties.P_LOG_EVENTS));
                }
            }
        });
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemMerge(IContributionManager context_p, final boolean toLeft_p) {
        Action action = new Action(){

            public void run() {
                ComparisonViewer.this.merge(toLeft_p, true);
            }
        };
        EMFDiffMergeUIPlugin.ImageID imageID = toLeft_p ? EMFDiffMergeUIPlugin.ImageID.CHECKOUT_ACTION : EMFDiffMergeUIPlugin.ImageID.CHECKIN_ACTION;
        action.setImageDescriptor(this.getImageDescriptor(imageID));
        action.setToolTipText(toLeft_p ? Messages.ComparisonViewer_MergeLeftTooltip : Messages.ComparisonViewer_MergeRightTooltip);
        action.setEnabled(false);
        this.addPropertyChangeListener(new IPropertyChangeListener((IAction)action){
            private final /* synthetic */ IAction val$action;
            {
                this.val$action = iAction;
            }

            public void propertyChange(PropertyChangeEvent event_p) {
                Object newValue;
                if ((toLeft_p && ComparisonViewer.PROPERTY_ACTIVATION_MERGE_TO_LEFT.equals(event_p.getProperty()) || !toLeft_p && ComparisonViewer.PROPERTY_ACTIVATION_MERGE_TO_RIGHT.equals(event_p.getProperty())) && (newValue = event_p.getNewValue()) instanceof Boolean) {
                    this.val$action.setEnabled(((Boolean)newValue).booleanValue());
                }
            }
        });
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemNavigationNext(IContributionManager context_p) {
        Action action = new Action(){

            public void run() {
                ComparisonViewer.this.navigate(true);
            }
        };
        action.setImageDescriptor(this.getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.NEXT_DIFF_NAV));
        action.setToolTipText(Messages.ComparisonViewer_NextTooltip);
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemNavigationPrevious(IContributionManager context_p) {
        Action action = new Action(){

            public void run() {
                ComparisonViewer.this.navigate(false);
            }
        };
        action.setImageDescriptor(this.getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.PREV_DIFF_NAV));
        action.setToolTipText(Messages.ComparisonViewer_PreviousTooltip);
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemOpenDedicated(IContributionManager context_p) {
        Action action = new Action(){

            public void run() {
                ComparisonSelection selection;
                EMFDiffNode input = ComparisonViewer.this.getInput();
                if (ComparisonViewer.this.isDedicatedViewerApplicable(input, selection = ComparisonViewer.this.getSelection())) {
                    ComparisonViewer.this.openDedicatedViewer(ComparisonViewer.this.getInput(), ComparisonViewer.this.getSelection().asMatch(), selection.asFeature());
                }
            }
        };
        action.setImageDescriptor(this.getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.COMPARE));
        action.setToolTipText(Messages.ComparisonViewer_OpenDedicated_ToolTip);
        action.setEnabled(false);
        this.addPropertyChangeListener(new IPropertyChangeListener((IAction)action){
            private final /* synthetic */ IAction val$action;
            {
                this.val$action = iAction;
            }

            public void propertyChange(PropertyChangeEvent event) {
                if (ComparisonViewer.PROPERTY_ACTIVATION_OPEN_DEDICATED.equals(event.getProperty())) {
                    boolean newEnabled = (Boolean)event.getNewValue();
                    this.val$action.setEnabled(newEnabled);
                }
            }
        });
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemRestart(IContributionManager context_p) {
        Action action = new Action(){

            public void run() {
                ComparisonViewer.this.restart();
            }
        };
        action.setText(Messages.ComparisonViewer_ToolUpdate);
        action.setToolTipText(Messages.ComparisonViewer_ToolUpdate_Tooltip);
        action.setImageDescriptor(this.getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.UPDATE));
        this.addPropertyChangeListener(new IPropertyChangeListener((IAction)action){
            private final /* synthetic */ IAction val$action;
            {
                this.val$action = iAction;
            }

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty())) {
                    boolean enable = false;
                    EMFDiffNode input = ComparisonViewer.this.getInput();
                    if (input != null) {
                        enable = input.getEditorInput() != null;
                    }
                    this.val$action.setEnabled(enable);
                }
            }
        });
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemShowAllFeatures(IContributionManager context_p) {
        Action action = new Action(Messages.ComparisonViewer_ShowAllFeatures, 8){

            public void run() {
                ((FeaturesViewer)ComparisonViewer.this._viewerFeatures.getInnerViewer()).setDifferenceAgnostic(true);
                ((ValuesViewer)ComparisonViewer.this._viewerValuesLeft.getInnerViewer()).setDifferenceAgnostic(true);
                ((ValuesViewer)ComparisonViewer.this._viewerValuesRight.getInnerViewer()).setDifferenceAgnostic(true);
            }
        };
        action.setToolTipText(Messages.ComparisonViewer_ShowAllFeaturesTooltip);
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemShowAllValues(IContributionManager context_p) {
        Action action = new Action(Messages.ComparisonViewer_ShowAllValues, 8){

            public void run() {
                ((FeaturesViewer)ComparisonViewer.this._viewerFeatures.getInnerViewer()).setDifferenceAgnostic(false);
                ((ValuesViewer)ComparisonViewer.this._viewerValuesLeft.getInnerViewer()).setDifferenceAgnostic(true);
                ((ValuesViewer)ComparisonViewer.this._viewerValuesRight.getInnerViewer()).setDifferenceAgnostic(true);
            }
        };
        action.setToolTipText(Messages.ComparisonViewer_ShowAllValuesTooltip);
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemShowDifferenceNumbers(IContributionManager context_p) {
        Action action = new Action(Messages.ComparisonViewer_ShowDifferenceNumbersMenuItem, 2){

            public void run() {
                EMFDiffNode input = ComparisonViewer.this.getInput();
                if (input != null) {
                    input.setUserPropertyValue(DefaultUserProperties.P_SHOW_DIFFERENCE_NUMBERS, this.isChecked());
                    ComparisonViewer.this.refresh();
                }
            }
        };
        action.setToolTipText(Messages.ComparisonViewer_ShowDifferenceNumbersTooltip);
        this.addPropertyChangeListener(new IPropertyChangeListener((IAction)action){
            private final /* synthetic */ IAction val$action;
            {
                this.val$action = iAction;
            }

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty())) {
                    this.val$action.setChecked(ComparisonViewer.this.isUserPropertyTrue(DefaultUserProperties.P_SHOW_DIFFERENCE_NUMBERS));
                }
            }
        });
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemShowDiffValues(IContributionManager context_p) {
        Action action = new Action(Messages.ComparisonViewer_ShowValueDiffs, 8){

            public void run() {
                ((FeaturesViewer)ComparisonViewer.this._viewerFeatures.getInnerViewer()).setDifferenceAgnostic(false);
                ((ValuesViewer)ComparisonViewer.this._viewerValuesLeft.getInnerViewer()).setDifferenceAgnostic(false);
                ((ValuesViewer)ComparisonViewer.this._viewerValuesRight.getInnerViewer()).setDifferenceAgnostic(false);
            }
        };
        action.setToolTipText(Messages.ComparisonViewer_ShowValueDiffsTooltip);
        action.setChecked(true);
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemShowImpact(IContributionManager context_p) {
        Action action = new Action(Messages.ComparisonViewer_ImpactMenuItem, 2){

            public void run() {
                boolean showImpact = this.isChecked();
                EMFDiffNode input = ComparisonViewer.this.getInput();
                if (input != null) {
                    input.setUserPropertyValue(DefaultUserProperties.P_SHOW_MERGE_IMPACT, showImpact);
                    input.setUserPropertyValue(DefaultUserProperties.P_DEFAULT_SHOW_MERGE_IMPACT, showImpact);
                }
            }
        };
        action.setToolTipText(Messages.ComparisonViewer_ImpactMenuItemTooltip);
        this.addPropertyChangeListener(new IPropertyChangeListener((IAction)action){
            private final /* synthetic */ IAction val$action;
            {
                this.val$action = iAction;
            }

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty())) {
                    this.val$action.setChecked(ComparisonViewer.this.isUserPropertyTrue(DefaultUserProperties.P_SHOW_MERGE_IMPACT));
                }
            }
        });
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemShowSides(IContributionManager context_p) {
        Action action = new Action(Messages.ComparisonViewer_ShowSidesMenuItem, 2){

            public void run() {
                ComparisonViewer.this.showSides(this.isChecked());
            }
        };
        action.setToolTipText(Messages.ComparisonViewer_ShowSidesMenuItemTooltip);
        this.addPropertyChangeListener(new IPropertyChangeListener((IAction)action){
            private final /* synthetic */ IAction val$action;
            {
                this.val$action = iAction;
            }

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty())) {
                    boolean isShowSidesPossible = ComparisonViewer.this.isUserPropertyTrue(DefaultUserProperties.P_SHOW_SIDES_POSSIBLE);
                    this.val$action.setChecked(isShowSidesPossible);
                    this.val$action.setEnabled(isShowSidesPossible);
                    ComparisonViewer.this.showSides(isShowSidesPossible);
                }
            }
        });
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemShowUncounted(IContributionManager context_p) {
        Action action = new Action(Messages.ComparisonViewer_ShowUncountedMenuItem, 2){

            public void run() {
                if (this.isChecked()) {
                    ((ComparisonTreeViewer)((Object)ComparisonViewer.this._viewerSynthesisMain.getInnerViewer())).removeFilter(ComparisonViewer.this._filterUnchangedElements);
                } else {
                    ((ComparisonTreeViewer)((Object)ComparisonViewer.this._viewerSynthesisMain.getInnerViewer())).addFilter(ComparisonViewer.this._filterUnchangedElements);
                }
            }
        };
        action.setChecked(false);
        action.setToolTipText(Messages.ComparisonViewer_ShowUncountedMenuItemTooltip);
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemSupportUndoRedo(IContributionManager context_p) {
        Action action = new Action(Messages.ComparisonViewer_SupportUndoRedoMenuItem, 2){

            public void run() {
                EMFDiffNode input = ComparisonViewer.this.getInput();
                if (input != null) {
                    input.setUserPropertyValue(DefaultUserProperties.P_SUPPORT_UNDO_REDO, this.isChecked());
                }
            }
        };
        action.setToolTipText(Messages.ComparisonViewer_SupportUndoRedoMenuItemTooltip);
        this.addPropertyChangeListener(new IPropertyChangeListener((IAction)action){
            private final /* synthetic */ IAction val$action;
            {
                this.val$action = iAction;
            }

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null) {
                    this.val$action.setChecked(input.isUndoRedoSupported());
                    this.val$action.setEnabled(input.getEditingDomain() != null && !ComparisonViewer.this.isUserPropertyFalse(DefaultUserProperties.P_SUPPORT_UNDO_REDO_OPTIONAL));
                }
            }
        });
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemSort(IContributionManager context_p) {
        Action action = new Action(Messages.ComparisonViewer_SortTooltip, 2){

            public void run() {
                if (this.isChecked()) {
                    ((ComparisonTreeViewer)((Object)ComparisonViewer.this._viewerSynthesisMain.getInnerViewer())).setComparator(ComparisonViewer.this._sorterSynthesis);
                } else {
                    ((ComparisonTreeViewer)((Object)ComparisonViewer.this._viewerSynthesisMain.getInnerViewer())).setComparator(null);
                }
            }
        };
        action.setChecked(false);
        action.setImageDescriptor(this.getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.SORT));
        action.setToolTipText(Messages.ComparisonViewer_EnhancedSortTooltip);
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemSync(IContributionManager context_p) {
        UIUtil.MenuDropDownAction action = new UIUtil.MenuDropDownAction();
        action.setText(Messages.ComparisonViewer_LinkViews);
        action.setImageDescriptor(this.getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.SYNCED));
        this.createItemSyncInternal((IContributionManager)action.getMenuManager());
        this.createItemSyncExternal((IContributionManager)action.getMenuManager());
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemSyncExternal(IContributionManager context_p) {
        Action action = new Action(Messages.ComparisonViewer_LinkViewsExternal, 2){

            public void run() {
                ComparisonViewer.this._isExternallySynced = this.isChecked();
            }
        };
        action.setToolTipText(Messages.ComparisonViewer_LinkViewsExternalToolTip);
        boolean isInWorkbenchWindow = this.isInWorkbenchWindow();
        action.setChecked(this._isExternallySynced && isInWorkbenchWindow);
        action.setEnabled(isInWorkbenchWindow);
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemSyncInternal(IContributionManager context_p) {
        Action action = new Action(Messages.ComparisonViewer_LinkViewsInternal, 2){

            public void run() {
                boolean synced = this.isChecked();
                EMFDiffNode input = ComparisonViewer.this.getInput();
                if (input != null) {
                    input.setUserPropertyValue(DefaultUserProperties.P_SYNC_SYNTHESIS_AND_SIDES, synced);
                    if (ComparisonViewer.this.isLeftRightSynced()) {
                        BusyIndicator.showWhile((Display)ComparisonViewer.this.getDisplay(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ITreeSelection selection = (this).ComparisonViewer.this._viewerSynthesisMain.getSelection();
                                (this).ComparisonViewer.this._viewerSynthesisLeft.setSelection((ISelection)ComparisonViewer.this.getSelectionAsSide((IStructuredSelection)selection, true), true);
                                (this).ComparisonViewer.this._viewerSynthesisRight.setSelection((ISelection)ComparisonViewer.this.getSelectionAsSide((IStructuredSelection)selection, false), true);
                            }
                        });
                    }
                }
            }
        };
        action.setToolTipText(Messages.ComparisonViewer_LinkViewsInternalTooltip);
        this.addPropertyChangeListener(new IPropertyChangeListener((IAction)action){
            private final /* synthetic */ IAction val$action;
            {
                this.val$action = iAction;
            }

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty())) {
                    this.val$action.setChecked(ComparisonViewer.this.isUserPropertyTrue(DefaultUserProperties.P_SYNC_SYNTHESIS_AND_SIDES));
                    this.val$action.setEnabled(ComparisonViewer.this.isUserPropertyTrue(DefaultUserProperties.P_SHOW_SIDES_POSSIBLE));
                }
            }
        });
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemUseCustomIcons(IContributionManager context_p) {
        Action action = new Action(Messages.ComparisonViewer_IconsMenuItem, 2){

            public void run() {
                EMFDiffNode input = ComparisonViewer.this.getInput();
                if (input != null) {
                    input.setUserPropertyValue(DefaultUserProperties.P_CUSTOM_ICONS, this.isChecked());
                    ComparisonViewer.this._viewerSynthesisMain.refresh();
                    ComparisonViewer.this._viewerFeatures.refresh();
                    ComparisonViewer.this._viewerValuesLeft.refresh();
                    ComparisonViewer.this._viewerValuesRight.refresh();
                }
            }
        };
        action.setToolTipText(Messages.ComparisonViewer_IconsMenuItemTooltip);
        this.addPropertyChangeListener(new IPropertyChangeListener((IAction)action){
            private final /* synthetic */ IAction val$action;
            {
                this.val$action = iAction;
            }

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty())) {
                    this.val$action.setChecked(ComparisonViewer.this.isUserPropertyTrue(DefaultUserProperties.P_CUSTOM_ICONS));
                }
            }
        });
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemUseCustomLabels(IContributionManager context_p) {
        Action action = new Action(Messages.ComparisonViewer_LabelsMenuItem, 2){

            public void run() {
                EMFDiffNode input = ComparisonViewer.this.getInput();
                if (input != null) {
                    input.setUserPropertyValue(DefaultUserProperties.P_CUSTOM_LABELS, this.isChecked());
                    ComparisonViewer.this._viewerSynthesisMain.refresh();
                    ComparisonViewer.this._viewerFeatures.refresh();
                    ComparisonViewer.this._viewerValuesLeft.refresh();
                    ComparisonViewer.this._viewerValuesRight.refresh();
                }
            }
        };
        action.setToolTipText(Messages.ComparisonViewer_LabelsMenuItemTooltip);
        this.addPropertyChangeListener(new IPropertyChangeListener((IAction)action){
            private final /* synthetic */ IAction val$action;
            {
                this.val$action = iAction;
            }

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty())) {
                    this.val$action.setChecked(ComparisonViewer.this.isUserPropertyTrue(DefaultUserProperties.P_CUSTOM_LABELS));
                }
            }
        });
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemUseTechnicalRepresentation(IContributionManager context_p) {
        Action action = new Action(Messages.ComparisonViewer_UseTechnicalRepresentation, 2){

            public void run() {
                EMFDiffNode node = ComparisonViewer.this.getInput();
                if (node != null) {
                    node.setUserPropertyValue(DefaultUserProperties.P_TECHNICAL_LABELS, this.isChecked());
                }
            }
        };
        action.setToolTipText(Messages.ComparisonViewer_UseTechnicalRepresentationTooltip);
        this.addPropertyChangeListener(new IPropertyChangeListener((IAction)action){
            private final /* synthetic */ IAction val$action;
            {
                this.val$action = iAction;
            }

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty())) {
                    this.val$action.setChecked(ComparisonViewer.this.isUserPropertyTrue(DefaultUserProperties.P_TECHNICAL_LABELS));
                }
            }
        });
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context_p.add((IContributionItem)result);
        return result;
    }

    @Override
    protected INavigatable createNavigatable() {
        INavigatable result = new INavigatable(){

            public Object getInput() {
                return ComparisonViewer.this.getInput();
            }

            public boolean hasChange(int changeFlag_p) {
                return true;
            }

            public boolean openSelectedChange() {
                return false;
            }

            public boolean selectChange(int changeFlag_p) {
                boolean innerResult = false;
                switch (changeFlag_p) {
                    case 1: {
                        innerResult = ComparisonViewer.this.navigate(true);
                        break;
                    }
                    case 2: {
                        innerResult = ComparisonViewer.this.navigate(false);
                    }
                }
                return innerResult;
            }
        };
        return result;
    }

    protected SashForm createRowLower(Composite parent_p) {
        SashForm result = new SashForm(parent_p, 256);
        this._viewerFeatures = this.createViewerFeatures((Composite)result);
        this._viewerValuesLeft = this.createViewerValues((Composite)result, true);
        this._viewerValuesRight = this.createViewerValues((Composite)result, false);
        return result;
    }

    protected SashForm createRowUpper(Composite parent_p) {
        SashForm result = new SashForm(parent_p, 256);
        this._viewerSynthesisMain = this.createViewerSynthesis((Composite)result);
        this._viewerSynthesisLeft = this.createViewerSynthesisSide((Composite)result, true);
        this._viewerSynthesisRight = this.createViewerSynthesisSide((Composite)result, false);
        return result;
    }

    protected MenuManager createViewerContextMenus(HeaderViewer<?> viewer_p, boolean useLocalSelectionProvider_p) {
        IWorkbenchPartSite site;
        MenuManager result = new MenuManager();
        result.setRemoveAllWhenShown(true);
        Control control = viewer_p.getInnerViewer().getControl();
        Menu contextMenu = result.createContextMenu(control);
        control.setMenu(contextMenu);
        Object selectionProvider = useLocalSelectionProvider_p ? viewer_p.getInnerViewer() : this.getMultiViewerSelectionProvider();
        this.populateContextMenu(result, viewer_p, (ISelectionProvider)selectionProvider);
        if (this.acceptContextMenuAdditions(viewer_p) && (site = this.getSite()) != null) {
            result.add((IContributionItem)new GroupMarker("additions"));
            site.registerContextMenu(result, selectionProvider);
        }
        return result;
    }

    protected EnhancedFeaturesViewer createViewerFeatures(Composite parent_p) {
        final EnhancedFeaturesViewer result = this.doCreateViewerFeatures(parent_p);
        result.addSWTSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                IStructuredSelection selection = result.getSelection();
                if (selection.size() == 1) {
                    MatchAndFeature maf = (MatchAndFeature)selection.getFirstElement();
                    ComparisonViewer.this.setSelection((ISelection)new ComparisonSelectionImpl(maf, ComparisonViewer.this.getTargetRole(), ComparisonViewer.this.getInput()), true, (ISelectionProvider)result.getInnerViewer());
                }
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ISelection rawSelection = event_p.getSelection();
                Object source = event_p.getSource();
                if (rawSelection instanceof ComparisonSelection && source != result.getInnerViewer()) {
                    ComparisonSelection selection = (ComparisonSelection)rawSelection;
                    if (selection.getSelectedMatches().size() <= 1) {
                        IMatch<?> match = selection.asMatch();
                        if (match != null) {
                            MatchAndFeature firstMAF;
                            MatchAndFeature maf;
                            boolean changeInput;
                            FeaturesViewer.FeaturesInput newInput = new FeaturesViewer.FeaturesInput(ComparisonViewer.this.getInput(), match);
                            boolean bl = changeInput = !newInput.equals(result.getInput());
                            if (changeInput) {
                                result.setInput(newInput);
                            }
                            if ((maf = selection.asMatchAndFeature()) != null) {
                                StructuredSelection newSelection = new StructuredSelection((Object)maf);
                                result.setSelection((ISelection)newSelection, true);
                            } else if (changeInput && (firstMAF = ComparisonViewer.this.getDefaultFeatureSelection(newInput, (FeaturesViewer)result.getInnerViewer())) != null) {
                                result.setSelection((ISelection)new StructuredSelection((Object)firstMAF));
                            }
                        } else {
                            result.setInput(null);
                        }
                    } else {
                        result.setInput(null);
                    }
                }
            }
        });
        ((FeaturesViewer)result.getInnerViewer()).addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MatchAndFeature maf;
                Object first;
                ISelection selection = event.getViewer().getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof MatchAndFeature && TextMergerDialog.isApplicableTo((maf = (MatchAndFeature)first).getFeature())) {
                    ComparisonViewer.this.openDedicatedViewer(ComparisonViewer.this.getInput(), maf.getMatch(), maf.getFeature());
                }
            }
        });
        return result;
    }

    protected EnhancedComparisonTreeViewer createViewerSynthesis(Composite parent_p) {
        final EnhancedComparisonTreeViewer result = this.doCreateViewerSynthesis(parent_p);
        ((ComparisonTreeViewer)((Object)result.getInnerViewer())).addFilter(this._filterUnchangedElements);
        ((ComparisonTreeViewer)((Object)result.getInnerViewer())).addFilter(this._filterMoveOrigins);
        ((ComparisonTreeViewer)((Object)result.getInnerViewer())).setComparer(new SymmetricMatchComparer());
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                Boolean filtered;
                if (ComparisonViewer.PROPERTY_FILTERING.equals(event_p.getProperty()) && (filtered = (Boolean)event_p.getNewValue()) != null) {
                    String newHeader = String.valueOf(result.getDefaultHeaderText()) + (filtered != false ? Messages.ComparisonViewer_Filtered : "");
                    result.setHeaderText(newHeader);
                }
            }
        });
        result.addSWTSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ITreeSelection selection = result.getSelection();
                if (!selection.isEmpty()) {
                    ComparisonViewer.this.setSelection((ISelection)new ComparisonSelectionImpl(selection.toList(), ComparisonViewer.this.getTargetRole(), ComparisonViewer.this.getInput()), true, (ISelectionProvider)result.getInnerViewer());
                }
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ISelection rawSelection = event_p.getSelection();
                Object source = event_p.getSource();
                if (rawSelection instanceof ComparisonSelection && source != result.getInnerViewer()) {
                    ComparisonSelection selection = (ComparisonSelection)rawSelection;
                    StructuredSelection newSelection = StructuredSelection.EMPTY;
                    int matchesSize = selection.getSelectedMatches().size();
                    if (matchesSize > 1) {
                        newSelection = new StructuredSelection(selection.getSelectedMatches());
                    } else {
                        TreePath path = selection.asMatchPath();
                        if (path != null) {
                            newSelection = new TreeSelection(path);
                        } else {
                            IMatch<?> match = selection.asMatch();
                            if (match != null) {
                                newSelection = new StructuredSelection(match);
                            }
                        }
                    }
                    result.setSelection((ISelection)newSelection, true);
                }
            }
        });
        this.createViewerContextMenus(result, false);
        return result;
    }

    protected EnhancedComparisonSideViewer createViewerSynthesisSide(Composite parent_p, final boolean isLeftSide_p) {
        final EnhancedComparisonSideViewer result = this.doCreateViewerSynthesisSide(parent_p, isLeftSide_p);
        result.addSWTSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                if (ComparisonViewer.this.isLeftRightSynced() && ComparisonViewer.this.getInput() != null) {
                    Role sideRole;
                    EMFDiffNode input = ComparisonViewer.this.getInput();
                    ITreeSelection selection = result.getSelection();
                    List<IMatch<?>> synthesisSelection = ComparisonSelectionImpl.selectionToMatches((IStructuredSelection)selection, input, sideRole = ComparisonViewer.this.getInput().getRoleForSide(isLeftSide_p));
                    if (!synthesisSelection.isEmpty()) {
                        ComparisonViewer.this.setSelection((ISelection)new ComparisonSelectionImpl(synthesisSelection, sideRole, ComparisonViewer.this.getInput()), true, (ISelectionProvider)result.getInnerViewer());
                    }
                }
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ISelection rawSelection = event_p.getSelection();
                Object source = event_p.getSource();
                if (rawSelection instanceof ComparisonSelection && source != result.getInnerViewer() && (source != ComparisonViewer.this._viewerSynthesisMain.getInnerViewer() || ComparisonViewer.this.isLeftRightSynced())) {
                    ComparisonSelection selection = (ComparisonSelection)rawSelection;
                    StructuredSelection newSelection = StructuredSelection.EMPTY;
                    int matchesSize = selection.getSelectedMatches().size();
                    if (matchesSize > 1) {
                        newSelection = new StructuredSelection(selection.getSelectedMatches());
                    } else {
                        TreePath path = selection.asMatchPath();
                        if (path != null) {
                            newSelection = new TreeSelection(path);
                        } else {
                            IMatch<?> match = selection.asMatch();
                            if (match != null) {
                                newSelection = new StructuredSelection(match);
                            }
                        }
                    }
                    result.setSelection((ISelection)ComparisonViewer.this.getSelectionAsSide((IStructuredSelection)newSelection, isLeftSide_p), true);
                }
            }
        });
        ((ComparisonSideViewer)result.getInnerViewer()).getControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e_p) {
                ComparisonViewer.this._multiViewerSelectionProvider.setSource((ISelectionProvider)result.getInnerViewer());
            }

            public void focusLost(FocusEvent e_p) {
                ComparisonViewer.this._multiViewerSelectionProvider.setSource((ISelectionProvider)ComparisonViewer.this);
            }
        });
        this.createViewerContextMenus(result, true);
        return result;
    }

    protected EnhancedValuesViewer createViewerValues(Composite parent_p, final boolean isLeftSide_p) {
        final EnhancedValuesViewer result = this.doCreateViewerValues(parent_p, isLeftSide_p);
        result.addSWTSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                IStructuredSelection selection = result.getSelection();
                if (!selection.isEmpty()) {
                    IReferenceValuePresence rvp;
                    boolean containment;
                    Object selectedElement;
                    Object match;
                    ComparisonViewer.this.setSelection((ISelection)new ComparisonSelectionImpl(selection.toList(), ComparisonViewer.this.getInput().getRoleForSide(isLeftSide_p), ComparisonViewer.this.getInput()), true, (ISelectionProvider)result.getInnerViewer());
                    if (selection.size() == 1 && (match = (selectedElement = selection.getFirstElement()) instanceof IMatch ? (IMatch)selectedElement : (selectedElement instanceof IReferenceValuePresence ? ((containment = (rvp = (IReferenceValuePresence)selectedElement).isContainment()) ? rvp.getElementMatch() : rvp.getValueMatch()) : null)) != null) {
                        ComparisonViewer.this.getModelScopeViewer(isLeftSide_p).setSelection((ISelection)new StructuredSelection(match.get(ComparisonViewer.this.getInput().getRoleForSide(isLeftSide_p))));
                    }
                }
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ISelection rawSelection = event_p.getSelection();
                Object source = event_p.getSource();
                if (rawSelection instanceof ComparisonSelection && source != result.getInnerViewer()) {
                    ComparisonSelection selection = (ComparisonSelection)rawSelection;
                    MatchAndFeature maf = selection.asMatchAndFeature();
                    if (maf != null) {
                        ValuesViewer.ValuesInput newInput = new ValuesViewer.ValuesInput(ComparisonViewer.this.getInput(), maf);
                        if (!newInput.equals(result.getInput())) {
                            result.setInput(newInput);
                        }
                        EList<IValuePresence<?>> values = selection.getSelectedValuePresences();
                        result.setSelection((ISelection)new StructuredSelection(values), true);
                    } else {
                        IMatch<?> newMatch;
                        ValuesViewer.ValuesInput newInput = null;
                        if (selection.getSelectedMatches().size() <= 1 && ComparisonViewer.this.getInput() != null && (newMatch = selection.asMatch()) != null) {
                            IMatch<?> currentMatch = null;
                            ValuesViewer.ValuesInput currentInput = result.getInput();
                            if (currentInput != null && currentInput.getMatchAndFeature() != null) {
                                currentMatch = currentInput.getMatchAndFeature().getMatch();
                            }
                            if (newMatch != currentMatch) {
                                FeaturesViewer.FeaturesInput featuresInput = new FeaturesViewer.FeaturesInput(ComparisonViewer.this.getInput(), newMatch);
                                MatchAndFeature firstMAF = ComparisonViewer.this.getDefaultFeatureSelection(featuresInput);
                                if (firstMAF != null) {
                                    newInput = new ValuesViewer.ValuesInput(ComparisonViewer.this.getInput(), firstMAF);
                                }
                            } else {
                                newInput = currentInput;
                            }
                        }
                        result.setInput(newInput);
                    }
                }
            }
        });
        ((ValuesViewer)result.getInnerViewer()).addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ValuesViewer.ValuesInput input = (ValuesViewer.ValuesInput)event.getViewer().getInput();
                MatchAndFeature maf = input.getMatchAndFeature();
                if (TextMergerDialog.isApplicableTo(maf.getFeature())) {
                    ComparisonViewer.this.openDedicatedViewer(ComparisonViewer.this.getInput(), maf.getMatch(), maf.getFeature());
                }
            }
        });
        return result;
    }

    protected EnhancedFeaturesViewer doCreateViewerFeatures(Composite parent_p) {
        return new EnhancedFeaturesViewer(parent_p);
    }

    protected EnhancedComparisonTreeViewer doCreateViewerSynthesis(Composite parent_p) {
        return new EnhancedComparisonTreeViewer(parent_p);
    }

    protected EnhancedComparisonSideViewer doCreateViewerSynthesisSide(Composite parent_p, boolean isLeftSide_p) {
        return new EnhancedComparisonSideViewer(parent_p, isLeftSide_p);
    }

    protected EnhancedValuesViewer doCreateViewerValues(Composite parent_p, boolean isLeftSide_p) {
        return new EnhancedValuesViewer(parent_p, isLeftSide_p);
    }

    protected TreePath getCurrentPath() {
        ComparisonTreeViewer treeViewer = (ComparisonTreeViewer)((Object)this.getSynthesisViewer().getInnerViewer());
        ITreeSelection selection = treeViewer.getSelection();
        TreePath result = selection == null || selection.isEmpty() ? TreePath.EMPTY : selection.getPaths()[0];
        return result;
    }

    protected int[] getDefaultColumnWeights() {
        return new int[]{3, 2, 2};
    }

    protected MatchAndFeature getDefaultFeatureSelection(FeaturesViewer.FeaturesInput nodeAndMatch_p) {
        FeaturesViewer viewer;
        MatchAndFeature result = null;
        HeaderViewer<?> rawFeaturesViewer = this.getFeaturesViewer();
        if (rawFeaturesViewer instanceof EnhancedFeaturesViewer && (viewer = (FeaturesViewer)((EnhancedFeaturesViewer)rawFeaturesViewer).getInnerViewer()) != null) {
            result = this.getDefaultFeatureSelection(nodeAndMatch_p, viewer);
        }
        return result;
    }

    protected MatchAndFeature getDefaultFeatureSelection(FeaturesViewer.FeaturesInput nodeAndMatch_p, FeaturesViewer viewer_p) {
        MatchAndFeature result = viewer_p.getFirstIn(nodeAndMatch_p);
        return result;
    }

    protected int[] getDefaultRowWeights() {
        return new int[]{5, 2};
    }

    protected List<IDifference<?>> getDifferencesToMerge(final List<IMatch<?>> selectedMatches_p, final Role destination_p, final boolean coverChildren_p, final boolean incrementalMode_p) {
        final ArrayList result = new ArrayList();
        IProgressService progress = PlatformUI.getWorkbench().getProgressService();
        try {
            progress.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                    for (IMatch selectedMatch : selectedMatches_p) {
                        if (coverChildren_p) {
                            ComparisonViewer.this.addDifferencesToMergeRec(result, selectedMatch, destination_p, incrementalMode_p);
                            continue;
                        }
                        ComparisonViewer.this.addDifferencesToMerge(result, selectedMatch, destination_p, incrementalMode_p);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.unmodifiableList(result);
    }

    public HeaderViewer<?> getFeaturesViewer() {
        return this._viewerFeatures;
    }

    protected Collection<Viewer> getInnerViewers() {
        return Arrays.asList(this._viewerSynthesisMain.getInnerViewer(), this._viewerSynthesisLeft.getInnerViewer(), this._viewerSynthesisRight.getInnerViewer(), this._viewerFeatures.getInnerViewer(), this._viewerValuesLeft.getInnerViewer(), this._viewerValuesRight.getInnerViewer());
    }

    protected Logger getLogger() {
        return EMFDiffMergeUIPlugin.getDefault().getDiffMergeLogger();
    }

    public EnhancedComparisonSideViewer getModelScopeViewer(boolean left_p) {
        EnhancedComparisonSideViewer result = left_p ? this._viewerSynthesisLeft : this._viewerSynthesisRight;
        return result;
    }

    @Override
    protected ISelectionProvider getMultiViewerSelectionProvider() {
        return this._multiViewerSelectionProvider;
    }

    protected List<IMatch<?>> getSelectedMatchesForInteractions(ComparisonSelection selection_p) {
        EList<IMatch<?>> treePath;
        Object selectedMatches = selection_p.getSelectedMatches();
        if (selectedMatches.isEmpty() && !(treePath = selection_p.getSelectedTreePath()).isEmpty()) {
            selectedMatches = Collections.singletonList((IMatch)treePath.get(treePath.size() - 1));
        }
        return selectedMatches;
    }

    public ComparisonSelection getSelection() {
        return this._lastUserSelection;
    }

    protected IStructuredSelection getSelectionAsSide(IStructuredSelection selection_p, boolean onLeft_p) {
        FArrayList result = new FArrayList();
        if (this.getInput() != null) {
            Role role = this.getInput().getRoleForSide(onLeft_p);
            Object[] objectArray = selection_p.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element;
                Object selected = objectArray[n2];
                if (selected instanceof IMatch && (element = ((IMatch)selected).get(role)) != null) {
                    result.add(element);
                }
                ++n2;
            }
        }
        return new StructuredSelection((List)result);
    }

    public EnhancedComparisonTreeViewer getSynthesisViewer() {
        return this._viewerSynthesisMain;
    }

    public EnhancedValuesViewer getValuesViewer(boolean left_p) {
        EnhancedValuesViewer result = left_p ? this._viewerValuesLeft : this._viewerValuesRight;
        return result;
    }

    @Override
    protected void handleCompareInputChanged(ICompareInput source_p) {
        if (source_p instanceof EMFDiffNode) {
            EMFDiffNode node = (EMFDiffNode)source_p;
            boolean isFiltering = node.getCategoryManager().isUIMoreFilteringThanDefault();
            this.firePropertyChangeEvent(PROPERTY_FILTERING, isFiltering);
        }
        super.handleCompareInputChanged(source_p);
    }

    @Override
    protected void handleDispose() {
        super.handleDispose();
        if (this._lastUserSelection != null) {
            this._lastUserSelection.dispose();
            this._lastUserSelection = null;
        }
        this._viewerSynthesisLeft = null;
        this._viewerSynthesisRight = null;
        this._viewerValuesLeft = null;
        this._viewerValuesRight = null;
        this._viewerSynthesisMain = null;
        this._viewerFeatures = null;
        this._sorterSynthesis = null;
        this._filterUnchangedElements = null;
        this._filterMoveOrigins = null;
        if (this._filterSelectionListener != null) {
            this._filterSelectionListener.dispose();
            this._filterSelectionListener = null;
        }
    }

    protected void ignore(boolean onLeft_p) {
        ComparisonSelection selection = this.getSelection();
        if (selection == null) {
            return;
        }
        EMFDiffNode input = this.getInput();
        if (input == null) {
            return;
        }
        List<IMatch<?>> selectedMatches = this.getSelectedMatchesForInteractions(selection);
        IgnoreChoiceData choices = new IgnoreChoiceData(input.isUserPropertyTrue(DefaultUserProperties.P_DEFAULT_COVER_CHILDREN), false);
        this.makeIgnoreChoices(choices, input, selectedMatches);
        if (!choices.isProceed()) {
            return;
        }
        List<IDifference<?>> toIgnore = !selectedMatches.isEmpty() ? this.getDifferencesToMerge(selectedMatches, input.getRoleForSide(onLeft_p), choices.isCoverChildren(), choices.isSideExclusive()) : this.getInput().getCategoryManager().getPendingDifferencesFiltered((Iterable<? extends IDifference<?>>)selection.asDifferencesToMerge());
        this.ignore(toIgnore);
    }

    protected void ignore(final Collection<IDifference<?>> differences_p) {
        final EMFDiffNode input = this.getInput();
        final ComparisonSelection selection = this.getSelection();
        if (input != null && !differences_p.isEmpty()) {
            this.executeOnComparison(new Runnable(){

                @Override
                public void run() {
                    input.ignore(differences_p);
                    ComparisonViewer.this.getUIComparison().setLastActionSelection(selection);
                }
            });
            if (!input.isReactive()) {
                this.firePropertyChangeEvent("DIRTY_STATE", true);
                input.updateDifferenceNumbers();
            }
        }
    }

    protected void initialize() {
        this._lastUserSelection = null;
        this._multiViewerSelectionProvider = new SelectionBridge.SingleSource();
        this._multiViewerSelectionProvider.setSource((ISelectionProvider)this);
        this._sorterSynthesis = new ViewerComparator();
        this._filterUnchangedElements = new ViewerFilter(){

            public boolean select(Viewer viewer_p, Object parentElement_p, Object element_p) {
                IMatch match = (IMatch)element_p;
                return ComparisonViewer.this.getInput().getCategoryManager().getDifferenceNumber(match) > 0;
            }
        };
        this._filterMoveOrigins = new ViewerFilter(){

            public boolean select(Viewer viewer_p, Object parentElement_p, Object element_p) {
                TreePath path = parentElement_p instanceof TreePath ? ((TreePath)parentElement_p).createChildPath(element_p) : new TreePath(new Object[]{element_p});
                return !ComparisonViewer.this.getInput().getCategoryManager().isMoveOrigin(path);
            }
        };
    }

    protected boolean interactionsRequiredForIgnore(IgnoreChoiceData choices_p, EMFDiffNode input_p, List<IMatch<?>> selectedMatches) {
        boolean childrenForMerge = false;
        boolean ownDifferences = false;
        for (IMatch<?> selectedMatch : selectedMatches) {
            boolean bl = ownDifferences = ownDifferences || !input_p.getCategoryManager().getDifferenceKind(selectedMatch).isNeutral();
            if (childrenForMerge && ownDifferences) break;
            boolean bl2 = childrenForMerge = childrenForMerge || input_p.getCategoryManager().hasChildrenForMergeFiltered(selectedMatch);
            if (childrenForMerge && ownDifferences) break;
        }
        if (!ownDifferences && childrenForMerge) {
            choices_p.setCoverChildren(true);
        }
        return ownDifferences && childrenForMerge;
    }

    protected boolean interactionsRequiredForMerge(MergeChoiceData choices_p, EMFDiffNode input_p, List<IMatch<?>> selectedMatches) {
        boolean result;
        boolean bl = result = !selectedMatches.isEmpty();
        if (result && selectedMatches.size() == 1) {
            IMatch<?> selectedMatch = selectedMatches.get(0);
            if (!input_p.getCategoryManager().hasChildrenForMergeFiltered(selectedMatch)) {
                DifferenceKind kind = input_p.getCategoryManager().getDifferenceKind(selectedMatch);
                result = !kind.isAddition() && !kind.isDeletion();
            }
        }
        return result;
    }

    @Override
    protected void inputChanged(Object input_p, Object oldInput_p) {
        super.inputChanged(input_p, oldInput_p);
        this._viewerFeatures.setInput(null);
        this._viewerValuesLeft.setInput(null);
        this._viewerValuesRight.setInput(null);
        this._viewerSynthesisMain.setInput(input_p);
        this._viewerSynthesisLeft.setInput(input_p);
        this._viewerSynthesisRight.setInput(input_p);
        EMFDiffNode input = this.getInput();
        if (input != null && input.isUserPropertyTrue(DefaultUserProperties.P_LOG_EVENTS)) {
            this.getLogger().log((Object)new CompareLogEvent(this.getEditingDomain(), input));
        }
    }

    protected boolean isDedicatedViewerApplicable(EMFDiffNode input_p, ComparisonSelection selection_p) {
        boolean result = false;
        if (input_p != null && selection_p != null && !selection_p.isEmpty()) {
            FeaturesViewer.FeaturesInput nodeAndMatch;
            MatchAndFeature defaultMAF;
            IMatch<?> selectedMatch;
            Object feature = selection_p.asFeature();
            if (feature == null && (selectedMatch = selection_p.asMatch()) != null && (defaultMAF = this.getDefaultFeatureSelection(nodeAndMatch = new FeaturesViewer.FeaturesInput(input_p, selectedMatch))) != null) {
                feature = defaultMAF.getFeature();
            }
            result = TextMergerDialog.isApplicableTo(feature);
        }
        return result;
    }

    @Override
    protected boolean isInternalSelectionProvider(ISelectionProvider provider_p) {
        return super.isInternalSelectionProvider(provider_p) || this.getInnerViewers().contains(provider_p);
    }

    protected boolean isLeftRightSynced() {
        return this.isUserPropertyTrue(DefaultUserProperties.P_SYNC_SYNTHESIS_AND_SIDES) && this.isUserPropertyTrue(DefaultUserProperties.P_SHOW_SIDES_POSSIBLE);
    }

    protected void makeIgnoreChoices(IgnoreChoiceData choices_p, EMFDiffNode input_p, List<IMatch<?>> selectedMatches_p) {
        boolean requiresInteractions = this.interactionsRequiredForIgnore(choices_p, input_p, selectedMatches_p);
        if (requiresInteractions) {
            IgnoreChoicesDialog choicesDialog = new IgnoreChoicesDialog(this.getShell(), Messages.ComparisonViewer_IgnoreCommandName, choices_p);
            choicesDialog.open();
            if (choices_p.isProceed()) {
                this.getInput().setUserPropertyValue(DefaultUserProperties.P_DEFAULT_COVER_CHILDREN, choices_p.isCoverChildren());
            }
        }
    }

    protected void makeMergeChoices(MergeChoiceData choices_p, EMFDiffNode input_p, List<IMatch<?>> selectedMatches_p, boolean acceptIncrementalMode_p) {
        boolean requiresInteractions = this.interactionsRequiredForMerge(choices_p, input_p, selectedMatches_p);
        if (requiresInteractions) {
            boolean mayAskAboutChildren = false;
            for (IMatch<?> selectedMatch : selectedMatches_p) {
                if (input_p.getCategoryManager().getDifferenceKind(selectedMatch) == DifferenceKind.COUNTED) {
                    choices_p.setCoverChildren(true);
                    break;
                }
                if (!input_p.getCategoryManager().hasChildrenForMergeFiltered(selectedMatch)) continue;
                mayAskAboutChildren = true;
                break;
            }
            MergeChoicesDialog choicesDialog = new MergeChoicesDialog(this.getShell(), Messages.ComparisonViewer_MergeHeader, choices_p, mayAskAboutChildren, acceptIncrementalMode_p);
            choicesDialog.open();
            if (choices_p.isProceed()) {
                if (mayAskAboutChildren) {
                    input_p.setUserPropertyValue(DefaultUserProperties.P_DEFAULT_COVER_CHILDREN, choices_p.isCoverChildren());
                }
                input_p.setUserPropertyValue(DefaultUserProperties.P_DEFAULT_INCREMENTAL_MODE, choices_p.isIncrementalMode());
                input_p.setUserPropertyValue(DefaultUserProperties.P_DEFAULT_SHOW_MERGE_IMPACT, choices_p.isShowImpact());
            }
        }
    }

    protected void merge(boolean toLeft_p, boolean acceptIncrementalMode_p) {
        this.merge(toLeft_p, acceptIncrementalMode_p, this.getSelection());
    }

    protected void merge(boolean toLeft_p, boolean acceptIncrementalMode_p, final ComparisonSelection selection_p) {
        if (selection_p == null) {
            return;
        }
        EMFDiffNode input = this.getInput();
        List<IMatch<?>> selectedMatches = this.getSelectedMatchesForInteractions(selection_p);
        MergeChoiceData choices = new MergeChoiceData(input.isUserPropertyTrue(DefaultUserProperties.P_DEFAULT_COVER_CHILDREN), input.isUserPropertyTrue(DefaultUserProperties.P_DEFAULT_INCREMENTAL_MODE) && acceptIncrementalMode_p, input.isUserPropertyTrue(DefaultUserProperties.P_DEFAULT_SHOW_MERGE_IMPACT));
        this.makeMergeChoices(choices, input, selectedMatches, acceptIncrementalMode_p);
        if (!choices.isProceed()) {
            return;
        }
        final Role destination = input.getRoleForSide(toLeft_p);
        final List<IDifference<?>> toMerge = !selectedMatches.isEmpty() ? this.getDifferencesToMerge(selectedMatches, destination, choices.isCoverChildren(), choices.isIncrementalMode()) : input.getCategoryManager().getPendingDifferencesFiltered((Iterable<? extends IDifference<?>>)selection_p.asDifferencesToMerge());
        final ArrayList merged = new ArrayList();
        boolean done = false;
        if (!toMerge.isEmpty()) {
            boolean proceed = true;
            if (choices.isShowImpact()) {
                proceed = this.showMergeImpact(toMerge, toLeft_p, input);
            }
            if (proceed) {
                this.executeOnModel(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                        merged.addAll(ComparisonViewer.this.getComparison().merge(toMerge, destination, true, monitor_p));
                        ComparisonViewer.this.getUIComparison().setLastActionSelection(selection_p);
                    }
                }, toLeft_p);
                done = true;
            }
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ComparisonViewer_MergeHeader, (String)Messages.ComparisonViewer_NoDiffsToMerge);
        }
        if (!merged.isEmpty() && done) {
            input.setModified(true, toLeft_p);
            if (!input.isReactive()) {
                this.firePropertyChangeEvent("DIRTY_STATE", true);
                input.updateDifferenceNumbers();
            }
            if (input.isUserPropertyTrue(DefaultUserProperties.P_LOG_EVENTS)) {
                this.getLogger().log((Object)new MergeLogEvent(input, merged, toLeft_p));
            }
        }
    }

    protected void mergeFromDedicatedViewer(EMFDiffNode node_p, IMatch<?> match_p, Object attribute_p, TextMergerDialog.TextDiffNode textDiffNode_p) {
        ComparisonSelection selection = this.getSelection();
        EList<IDifference<?>> toIgnore = selection.asDifferencesToMerge();
        TextCompareContent left = textDiffNode_p.getLeft();
        TextCompareContent right = textDiffNode_p.getRight();
        String leftMergedValue = left.getEditedContent();
        String rightMergedValue = right.getEditedContent();
        if (leftMergedValue != null || rightMergedValue != null) {
            boolean onLeft = leftMergedValue != null;
            String newValue = onLeft ? leftMergedValue : rightMergedValue;
            IEditableTreeDataScope<?> impactedScope = node_p.getScope(onLeft);
            this.executeOnModel(new IRunnableWithProgress((IMatch)match_p, node_p, onLeft, (IEditableTreeDataScope)impactedScope, attribute_p, newValue, (List)toIgnore, selection){
                private final /* synthetic */ IMatch val$match_p;
                private final /* synthetic */ EMFDiffNode val$node_p;
                private final /* synthetic */ boolean val$onLeft;
                private final /* synthetic */ IEditableTreeDataScope val$impactedScope;
                private final /* synthetic */ Object val$attribute_p;
                private final /* synthetic */ String val$newValue;
                private final /* synthetic */ List val$toIgnore;
                private final /* synthetic */ ComparisonSelection val$selection;
                {
                    this.val$match_p = iMatch;
                    this.val$node_p = eMFDiffNode;
                    this.val$onLeft = bl;
                    this.val$impactedScope = iEditableTreeDataScope;
                    this.val$attribute_p = object;
                    this.val$newValue = string;
                    this.val$toIgnore = list;
                    this.val$selection = comparisonSelection;
                }

                public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                    Object holder = this.val$match_p.get(this.val$node_p.getRoleForSide(this.val$onLeft));
                    this.val$impactedScope.addAttributeValue(holder, this.val$attribute_p, (Object)this.val$newValue);
                    this.val$node_p.setModified(true, this.val$onLeft);
                    this.val$node_p.ignore(this.val$toIgnore);
                    ComparisonViewer.this.getUIComparison().setLastActionSelection(this.val$selection);
                }
            }, onLeft);
            this.setSelection(null);
            this.firePropertyChangeEvent("DIRTY_STATE", Boolean.TRUE);
            this.getInput().updateDifferenceNumbers();
        }
    }

    protected boolean navigate(boolean next_p) {
        return this.navigate(this.getCurrentPath(), next_p);
    }

    protected boolean navigate(TreePath origin_p, boolean next_p) {
        TreePath newPath;
        ComparisonTreeViewer treeViewer = (ComparisonTreeViewer)((Object)this._viewerSynthesisMain.getInnerViewer());
        TreePath treePath = newPath = next_p ? treeViewer.getNextUserDifference(origin_p) : treeViewer.getPreviousUserDifference(origin_p);
        if (newPath != null) {
            this.setSelection((ISelection)new ComparisonSelectionImpl(newPath, this.getTargetRole(), this.getInput()), true, true);
        }
        return newPath == null;
    }

    protected void openDedicatedViewer(EMFDiffNode node_p, IMatch<?> match_p, Object feature_p) {
        TextMergerDialog dialog;
        FeaturesViewer.FeaturesInput nodeAndMatch;
        MatchAndFeature defaultMAF;
        assert (feature_p == null || TextMergerDialog.isApplicableTo(feature_p));
        Object attribute = feature_p;
        if (attribute == null && (defaultMAF = this.getDefaultFeatureSelection(nodeAndMatch = new FeaturesViewer.FeaturesInput(node_p, match_p))) != null && TextMergerDialog.isApplicableTo(defaultMAF.getFeature())) {
            attribute = defaultMAF.getFeature();
        }
        if (attribute != null && (dialog = new TextMergerDialog(this.getShell(), node_p, match_p, attribute)).open() == 0) {
            this.mergeFromDedicatedViewer(node_p, match_p, attribute, dialog.getViewerInput());
        }
    }

    protected void populateContextMenu(MenuManager menuManager_p, Viewer viewer_p, ISelectionProvider selectionProvider_p) {
        if (this._viewerSynthesisMain != null && viewer_p != this._viewerSynthesisMain.getInnerViewer()) {
            return;
        }
        final DirectedAction acceptAction = this.createActionAccept();
        final DirectedAction acceptDeletionAction = this.createActionAcceptDeletion();
        final DirectedAction ignoreAction = this.createActionIgnore();
        menuManager_p.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager_p) {
                boolean atLeastOne = false;
                if (acceptAction != null && acceptAction.isEnabled()) {
                    manager_p.add((IAction)acceptAction);
                    atLeastOne = true;
                }
                if (acceptDeletionAction != null && acceptDeletionAction.isEnabled()) {
                    manager_p.add((IAction)acceptDeletionAction);
                    atLeastOne = true;
                }
                if (ignoreAction != null && ignoreAction.isEnabled()) {
                    manager_p.add((IAction)ignoreAction);
                    atLeastOne = true;
                }
                if (atLeastOne) {
                    manager_p.add((IContributionItem)new Separator());
                }
            }
        });
    }

    @Override
    public void refresh() {
        this._viewerSynthesisLeft.refresh();
        this._viewerSynthesisRight.refresh();
        this._viewerValuesLeft.refresh();
        this._viewerValuesRight.refresh();
        this._viewerFeatures.refresh();
        this._viewerSynthesisMain.refresh();
        super.refresh();
    }

    @Override
    protected void refreshTools() {
        ComparisonSelection selection = this.getSelection();
        EMFDiffNode input = this.getInput();
        boolean onLeft = false;
        boolean onRight = false;
        boolean allowDeletion = false;
        boolean allowIgnoring = false;
        if (selection != null && input != null) {
            EList<IMatch<?>> matches;
            allowIgnoring = true;
            IValuePresence<?> presence = selection.asValuePresence();
            if (presence != null && !presence.isMerged()) {
                DifferenceKind kind = input.getCategoryManager().getDifferenceKind((IDifference<?>)presence);
                onLeft = this.canAddToTheRight(kind);
                onRight = this.canAddToTheLeft(kind);
                allowDeletion = input.getCategoryManager().isMany((IDifference<?>)presence) && !input.getCategoryManager().isOwnership((IDifference<?>)presence);
            } else if (selection.asFeature() == null && !(matches = selection.asMatches()).isEmpty()) {
                if (matches.size() > 1) {
                    allowDeletion = true;
                    Iterator it = matches.iterator();
                    while (it.hasNext() && (!onLeft || !onRight || allowDeletion)) {
                        IMatch current = (IMatch)it.next();
                        DifferenceKind kind = input.getCategoryManager().getDifferenceKind(current);
                        if (kind.isAddition()) {
                            onLeft = onLeft || kind.isLeft(true);
                            onRight = onRight || kind.isRight(true);
                            continue;
                        }
                        onLeft = true;
                        onRight = true;
                        allowDeletion = false;
                    }
                    allowDeletion = allowDeletion && onLeft != onRight;
                } else {
                    IMatch match = (IMatch)matches.get(0);
                    if (input.getCategoryManager().representAsModification(match) || input.getCategoryManager().representAsMove(match) || input.getCategoryManager().getDifferenceKind(match) == DifferenceKind.COUNTED) {
                        onLeft = true;
                        onRight = true;
                        allowDeletion = false;
                    } else {
                        DifferenceKind kind = input.getCategoryManager().getDifferenceKind(match);
                        onLeft = this.canAddToTheRight(kind);
                        onRight = this.canAddToTheLeft(kind);
                        allowDeletion = true;
                    }
                }
            }
        }
        if (input != null) {
            this.firePropertyChangeEvent(PROPERTY_ACTIVATION_MERGE_TO_RIGHT, input.isEditable(false) && onLeft);
            this.firePropertyChangeEvent(PROPERTY_ACTIVATION_DELETE_LEFT, input.isEditable(true) && onLeft && allowDeletion);
            this.firePropertyChangeEvent(PROPERTY_ACTIVATION_MERGE_TO_LEFT, input.isEditable(true) && onRight);
            this.firePropertyChangeEvent(PROPERTY_ACTIVATION_DELETE_RIGHT, input.isEditable(false) && onRight && allowDeletion);
        }
        this.firePropertyChangeEvent(PROPERTY_ACTIVATION_IGNORE_LEFT, onLeft && allowIgnoring);
        this.firePropertyChangeEvent(PROPERTY_ACTIVATION_IGNORE_RIGHT, onRight && allowIgnoring);
        this.firePropertyChangeEvent(PROPERTY_ACTIVATION_OPEN_DEDICATED, this.isDedicatedViewerApplicable(input, selection));
        super.refreshTools();
    }

    @Override
    protected void registerUserProperties(EMFDiffNode input_p) {
        input_p.addUserProperty(DefaultUserProperties.P_CUSTOM_ICONS, Boolean.TRUE);
        input_p.addUserProperty(DefaultUserProperties.P_CUSTOM_LABELS, Boolean.FALSE);
        input_p.addUserProperty(DefaultUserProperties.P_DEFAULT_COVER_CHILDREN, Boolean.TRUE);
        input_p.addUserProperty(DefaultUserProperties.P_DEFAULT_INCREMENTAL_MODE, Boolean.FALSE);
        input_p.addUserProperty(DefaultUserProperties.P_DEFAULT_SHOW_MERGE_IMPACT, Boolean.FALSE);
        input_p.addUserProperty(DefaultUserProperties.P_LOG_EVENTS, Boolean.FALSE);
        input_p.addUserProperty(DefaultUserProperties.P_SHOW_DIFFERENCE_NUMBERS, Boolean.TRUE);
        input_p.addUserProperty(DefaultUserProperties.P_SHOW_MERGE_IMPACT, Boolean.FALSE);
        input_p.addUserProperty(DefaultUserProperties.P_SHOW_SIDES_POSSIBLE, Boolean.TRUE);
        input_p.addUserProperty(DefaultUserProperties.P_SUPPORT_UNDO_REDO, Boolean.TRUE);
        input_p.addUserProperty(DefaultUserProperties.P_SUPPORT_UNDO_REDO_OPTIONAL, Boolean.TRUE);
        input_p.addUserProperty(DefaultUserProperties.P_SYNC_SYNTHESIS_AND_SIDES, input_p.getUserPropertyValue(DefaultUserProperties.P_SHOW_SIDES_POSSIBLE));
        input_p.addUserProperty(DefaultUserProperties.P_TECHNICAL_LABELS, Boolean.FALSE);
    }

    protected void restart() {
        IEditorInput rawEditorInput;
        EMFDiffNode input = this.getInput();
        IEditorInput iEditorInput = rawEditorInput = input == null ? null : input.getEditorInput();
        if (input != null && rawEditorInput instanceof EMFDiffMergeEditorInput) {
            EMFDiffMergeEditorInput editorInput = (EMFDiffMergeEditorInput)rawEditorInput;
            IComparisonMethod<?> origMethod = editorInput.getComparisonMethod();
            IModelScopeDefinition originalTargetScopeDef = origMethod.getModelScopeDefinition(Role.TARGET);
            ComparisonSetupManager manager = EMFDiffMergeUIPlugin.getDefault().getSetupManager();
            boolean confirmed = manager.updateEditorInputWithUI(this.getShell(), editorInput);
            if (confirmed) {
                IModelScopeDefinition newTargetScopeDef = editorInput.getComparisonMethod().getModelScopeDefinition(Role.TARGET);
                boolean sidesSwapped = newTargetScopeDef != originalTargetScopeDef;
                RestartJob job = new RestartJob(editorInput, sidesSwapped);
                job.setUser(true);
                job.schedule();
            }
        }
    }

    public void setDelegateLabelProvider(ILabelProvider labelProvider_p) {
        for (Viewer viewer : this.getInnerViewers()) {
            IBaseLabelProvider rawLP;
            if (!(viewer instanceof ContentViewer) || !((rawLP = ((ContentViewer)viewer).getLabelProvider()) instanceof DelegatingLabelProvider)) continue;
            DelegatingLabelProvider delegatingLP = (DelegatingLabelProvider)rawLP;
            delegatingLP.setDelegate(labelProvider_p);
        }
    }

    public void setDiffLabelDecorator(IDiffLabelDecorator diffDecorator_p) {
        for (Viewer viewer : this.getInnerViewers()) {
            IBaseLabelProvider rawLP;
            if (!(viewer instanceof ContentViewer) || !((rawLP = ((ContentViewer)viewer).getLabelProvider()) instanceof DiffDecoratingLabelProvider)) continue;
            DiffDecoratingLabelProvider enhancedLP = (DiffDecoratingLabelProvider)rawLP;
            enhancedLP.setDiffLabelDecorator(diffDecorator_p);
        }
    }

    public void setSelection(ISelection selection_p, boolean reveal_p) {
        this.setSelection(selection_p, reveal_p, false);
    }

    public void setSelection(ISelection selection_p, boolean reveal_p, boolean propagate_p) {
        this.setSelection(selection_p, reveal_p, (ISelectionProvider)(propagate_p ? this : UNKNOWN_SELECTION_PROVIDER));
    }

    protected void setSelection(ISelection selection_p, boolean reveal_p, ISelectionProvider source_p) {
        EMFDiffNode input = this.getInput();
        if (input != null) {
            ComparisonSelection newSelection = selection_p instanceof ComparisonSelection && ((ComparisonSelection)selection_p).getDiffNode() == input ? (ComparisonSelection)selection_p : (selection_p instanceof IStructuredSelection ? this.asComparisonSelection((IStructuredSelection)selection_p) : new ComparisonSelectionImpl(null, null, input));
            this._lastUserSelection = newSelection;
            this.fireSelectionChanged(new SelectionChangedEvent(source_p, (ISelection)this.getSelection()));
        }
    }

    public void setTreeSelection(ISelection selection_p) {
        EMFDiffNode input = this.getInput();
        if (input != null) {
            TreePath treePath = selection_p instanceof IStructuredSelection ? ComparisonSelectionImpl.selectionToTreePath((IStructuredSelection)selection_p, input) : null;
            Object newSelection = treePath != null ? new ComparisonSelectionImpl(treePath, input.getDrivingRole(), input) : selection_p;
            this.setSelection((ISelection)newSelection);
        }
    }

    protected void setupColumns(final SashForm upperRow_p, final SashForm lowerRow_p) {
        int[] horizontalWeights = this.getDefaultColumnWeights();
        upperRow_p.setWeights(horizontalWeights);
        lowerRow_p.setWeights(horizontalWeights);
        Control upperMiddleControl = upperRow_p.getChildren()[1];
        upperMiddleControl.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e_p) {
                int[] weights = upperRow_p.getWeights();
                lowerRow_p.setWeights(weights);
            }

            public void controlMoved(ControlEvent e_p) {
            }
        });
        Control lowerMiddleControl = lowerRow_p.getChildren()[1];
        lowerMiddleControl.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e_p) {
                int[] weights = lowerRow_p.getWeights();
                upperRow_p.setWeights(weights);
            }

            public void controlMoved(ControlEvent e_p) {
            }
        });
    }

    protected IMenuManager setupMenuDetails(ToolBarManager context_p) {
        MenuManager result = UIUtil.createMenuTool((IToolBarManager)context_p);
        this.createItemShowDiffValues((IContributionManager)result);
        this.createItemShowAllValues((IContributionManager)result);
        this.createItemShowAllFeatures((IContributionManager)result);
        result.add((IContributionItem)new Separator());
        this.createItemUseTechnicalRepresentation((IContributionManager)result);
        return result;
    }

    protected IMenuManager setupMenuSynthesis(ToolBarManager context_p) {
        MenuManager result = UIUtil.createMenuTool((IToolBarManager)context_p);
        this.createItemRestart((IContributionManager)result);
        result.add((IContributionItem)new Separator());
        this.createItemShowUncounted((IContributionManager)result);
        this.createItemFilter((IContributionManager)result);
        result.add((IContributionItem)new Separator());
        this.createItemSync((IContributionManager)result);
        this.createItemSort((IContributionManager)result);
        result.add((IContributionItem)new Separator());
        this.setupMenuSynthesisMisc((IContributionManager)result);
        return result;
    }

    protected void setupMenuSynthesisMisc(IContributionManager context_p) {
        this.createItemUseCustomIcons(context_p);
        this.createItemUseCustomLabels(context_p);
        context_p.add((IContributionItem)new Separator());
        this.createItemShowSides(context_p);
        this.createItemShowDifferenceNumbers(context_p);
        this.createItemShowImpact(context_p);
        context_p.add((IContributionItem)new Separator());
        this.createItemSupportUndoRedo(context_p);
        this.createItemLogEvents(context_p);
    }

    protected void setupToolBars() {
        this.setupToolsSynthesis(this._viewerSynthesisMain.getToolbar());
        this.setupToolsSynthesisSide(this._viewerSynthesisLeft.getToolbar(), true);
        this.setupToolsSynthesisSide(this._viewerSynthesisRight.getToolbar(), false);
        this.setupToolsDetails(this._viewerFeatures.getToolbar());
        this.setupToolsDetailsSide(this._viewerValuesLeft.getToolbar(), true);
        this.setupToolsDetailsSide(this._viewerValuesRight.getToolbar(), false);
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ComparisonViewer.this.refreshTools();
            }
        });
        this.refreshTools();
    }

    protected void setupToolsDetails(ToolBar toolbar_p) {
        ToolBarManager toolbarManager = new ToolBarManager(toolbar_p);
        this.createItemOpenDedicated((IContributionManager)toolbarManager);
        IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)toolbarManager, LOCATION_TOOLBAR_DETAILS);
        toolbarManager.add((IContributionItem)new Separator(LOCATION_TOOLBAR_GROUP_MENU));
        this.setupMenuDetails(toolbarManager);
        toolbarManager.update(true);
    }

    protected void setupToolsDetailsSide(ToolBar toolbar_p, boolean onLeft_p) {
        ToolBarManager toolbarManager = new ToolBarManager(toolbar_p);
        this.createItemMerge((IContributionManager)toolbarManager, !onLeft_p);
        this.createItemIgnore((IContributionManager)toolbarManager, onLeft_p);
        this.createItemDelete((IContributionManager)toolbarManager, onLeft_p);
        toolbarManager.update(true);
    }

    protected void setupToolsSynthesis(ToolBar toolbar_p) {
        ToolBarManager toolbarManager = new ToolBarManager(toolbar_p);
        toolbarManager.add((IContributionItem)new Separator(LOCATION_TOOLBAR_GROUP_CONSISTENCY));
        this.createItemInconsistency((IContributionManager)toolbarManager);
        toolbarManager.add((IContributionItem)new Separator(LOCATION_TOOLBAR_GROUP_NAVIGATION));
        this.createItemNavigationNext((IContributionManager)toolbarManager);
        this.createItemNavigationPrevious((IContributionManager)toolbarManager);
        toolbarManager.add((IContributionItem)new Separator(LOCATION_TOOLBAR_GROUP_EXPANSION));
        this.createItemExpand((IContributionManager)toolbarManager);
        this.createItemCollapse((IContributionManager)toolbarManager);
        toolbarManager.add((IContributionItem)new Separator(LOCATION_TOOLBAR_GROUP_FILTERING));
        this.createItemFilter((IContributionManager)toolbarManager);
        if (this.acceptToolBarAdditions(this._viewerSynthesisMain)) {
            IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
            menuService.populateContributionManager((ContributionManager)toolbarManager, LOCATION_TOOLBAR_SYNTHESIS);
        }
        toolbarManager.add((IContributionItem)new Separator(LOCATION_TOOLBAR_GROUP_MENU));
        this.setupMenuSynthesis(toolbarManager);
        toolbarManager.update(true);
    }

    protected void setupToolsSynthesisSide(ToolBar toolbar_p, boolean onLeft_p) {
        ToolBarManager toolbarManager = new ToolBarManager(toolbar_p);
        this.createItemLock((IContributionManager)toolbarManager, onLeft_p);
        toolbarManager.update(true);
    }

    protected boolean showMergeImpact(Collection<IDifference<?>> toMerge_p, boolean toLeft_p, EMFDiffNode input_p) {
        boolean result = true;
        final MergeImpactViewer.ImpactInput mergeInput = new MergeImpactViewer.ImpactInput(toMerge_p, toLeft_p, input_p);
        IProgressService progress = PlatformUI.getWorkbench().getProgressService();
        try {
            progress.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                    mergeInput.compute(monitor_p);
                }
            });
            MergeImpactMessageDialog dialog = new MergeImpactMessageDialog(this.getShell(), mergeInput, this.getResourceManager(), ((ComparisonTreeViewer)((Object)this._viewerSynthesisMain.getInnerViewer())).getLabelProvider());
            result = dialog.openAndConfirm();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void showSides(boolean show_p) {
        Control leftControl = this._viewerSynthesisLeft.getControl();
        if (leftControl != null && !leftControl.isDisposed()) {
            leftControl.setVisible(show_p);
            this._viewerSynthesisRight.getControl().setVisible(show_p);
            leftControl.getParent().layout();
        }
    }

    protected class DirectedAction
    extends Action {
        protected DirectedAction() {
        }

        public boolean isApplicable() {
            return ComparisonViewer.this.getTargetRole() != null;
        }

        public boolean isEnabled() {
            return this.isApplicable() && super.isEnabled();
        }

        public boolean isLeftToRight() {
            boolean result = false;
            EMFDiffNode input = ComparisonViewer.this.getInput();
            if (input != null) {
                result = ComparisonViewer.this.getTargetRole() == input.getRoleForSide(false);
            }
            return result;
        }
    }

    protected class FilterSelectionListener
    implements IDisposable {
        protected final Set<ActionContributionItem> _filterItems = new HashSet<ActionContributionItem>();
        protected CategoryDialog _lastDialog = null;

        public void addItem(ActionContributionItem item_p) {
            this._filterItems.add(item_p);
        }

        public void dispose() {
            if (this._lastDialog != null && !this._lastDialog.getShell().isDisposed()) {
                this._lastDialog.close();
            }
        }

        public void runWithEvent(Event event_p) {
            Widget widget = event_p.widget;
            if (widget instanceof MenuItem || widget instanceof ToolItem) {
                boolean selected = UIUtil.itemGetSelection((Item)widget);
                if (selected) {
                    this._lastDialog = new CategoryDialog(ComparisonViewer.this.getShell(), ComparisonViewer.this.getInput());
                    this._lastDialog.open();
                    this._lastDialog.getShell().addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e_p) {
                            FilterSelectionListener.this._lastDialog = null;
                            FilterSelectionListener.this.setSelectionForAll(false);
                        }
                    });
                } else if (this._lastDialog != null) {
                    this._lastDialog.close();
                }
                this.setSelectionForAll(selected);
            }
        }

        protected void setSelectionForAll(boolean selected_p) {
            for (ActionContributionItem item : this._filterItems) {
                IAction action = item.getAction();
                if (action == null || action.isChecked() == selected_p) continue;
                action.setChecked(selected_p);
            }
        }
    }

    protected class IgnoreAction
    extends DirectedAction {
        protected boolean _activeLeft = false;
        protected boolean _activeRight = false;

        public IgnoreAction() {
            this.setText(Messages.ComparisonViewer_IgnoreAction_Text);
            this.setImageDescriptor(ComparisonViewer.this.getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.CHECKED));
        }

        public void run() {
            if (this._activeLeft) {
                ComparisonViewer.this.ignore(true);
            }
            if (this._activeRight) {
                ComparisonViewer.this.ignore(false);
            }
        }

        public void setActiveLeft(boolean activeLeft_p) {
            this._activeLeft = activeLeft_p;
            this.update();
        }

        public void setActiveRight(boolean activeRight_p) {
            this._activeRight = activeRight_p;
            this.update();
        }

        protected void update() {
            this.setEnabled(this._activeLeft || this._activeRight);
        }
    }

    protected class RestartJob
    extends Job {
        protected final EMFDiffMergeEditorInput _editorInput;
        protected final boolean _sidesSwapped;

        protected RestartJob(EMFDiffMergeEditorInput editorInput_p, boolean sidesSwapped_p) {
            super(Messages.ComparisonViewer_RestartInProgress);
            this._editorInput = editorInput_p;
            this._sidesSwapped = sidesSwapped_p;
        }

        protected IStatus run(IProgressMonitor monitor_p) {
            ResourceSet rs;
            final EMFDiffNode diffNode = this._editorInput.getCompareResult();
            final boolean editionPossibleLeft = diffNode.isEditionPossible(true);
            final boolean editionPossibleRight = diffNode.isEditionPossible(false);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    diffNode.setEditionPossible(false, true);
                    diffNode.setEditionPossible(false, false);
                    ComparisonViewer.this.refreshTools();
                }
            });
            Resource comparisonResource = diffNode.getUIComparison().eResource();
            ResourceSet resourceSet = rs = comparisonResource == null ? null : comparisonResource.getResourceSet();
            if (rs != null) {
                rs.getResources().remove((Object)comparisonResource);
            }
            this.restart(monitor_p);
            if (rs != null) {
                rs.getResources().add((Object)comparisonResource);
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    diffNode.setEditionPossible(editionPossibleLeft, true);
                    diffNode.setEditionPossible(editionPossibleRight, false);
                    ComparisonViewer.this.firePropertyChangeEvent("PROPERTY_CURRENT_INPUT", null);
                    ComparisonViewer.this.refresh();
                }
            });
            this._editorInput.checkInconsistency((IComparison<?>)diffNode.getActualComparison());
            return Status.OK_STATUS;
        }

        protected void restart(IProgressMonitor monitor_p) {
            IComparisonMethod<?> newMethod = this._editorInput.getComparisonMethod();
            newMethod.setVerbose(false);
            EMFDiffNode diffNode = this._editorInput.getCompareResult();
            diffNode.getUIComparison().clear();
            if (this._sidesSwapped) {
                diffNode.setLeftRole(diffNode.getRoleForSide(false));
                diffNode.getActualComparison().swapScopes();
            }
            diffNode.setReferenceRole(newMethod.getTwoWayReferenceRole());
            diffNode.setDrivingRole(newMethod.getTwoWayReferenceRole());
            boolean leftEditable = newMethod.getModelScopeDefinition(diffNode.getRoleForSide(true)).isEditable();
            boolean rightEditable = newMethod.getModelScopeDefinition(diffNode.getRoleForSide(false)).isEditable();
            diffNode.setEditionPossible(leftEditable, true);
            diffNode.setEditionPossible(rightEditable, false);
            diffNode.getActualComparison().compute(newMethod.getMatchPolicy(), newMethod.getDiffPolicy(), newMethod.getMergePolicy(), monitor_p);
            diffNode.getCategoryManager().update();
        }
    }
}

