/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.providers;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class CollectionAsTreeContentProvider
implements ITreeContentProvider {
    private Collection<EObject> _dataInput;
    private AbstractTreeViewer _viewer;
    private boolean expandAddedContent = false;

    public Object[] getChildren(Object element_p) {
        HashSet<EObject> elements = new HashSet<EObject>();
        if (element_p instanceof EObject) {
            EObject current = (EObject)element_p;
            for (EObject obj : current.eContents()) {
                if (!this._dataInput.contains(obj)) continue;
                elements.add(obj);
            }
            return elements.toArray();
        }
        return new Object[0];
    }

    public Object[] getElements(Object element_p) {
        HashSet<EObject> elements = new HashSet<EObject>();
        for (EObject obj : this._dataInput) {
            if (this.getParent(obj) != null) continue;
            elements.add(obj);
        }
        return elements.toArray();
    }

    public Object getParent(Object element_p) {
        if (element_p != null && element_p instanceof EObject && this._dataInput.contains(((EObject)element_p).eContainer())) {
            return ((EObject)element_p).eContainer();
        }
        return null;
    }

    public boolean hasChildren(Object element_p) {
        return this.getChildren(element_p).length > 0;
    }

    public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
        if (this._viewer == null) {
            if (newInput_p instanceof Collection) {
                this._viewer = (AbstractTreeViewer)viewer_p;
                HashSet<EObject> elements = new HashSet<EObject>();
                for (Object obj : (Collection)newInput_p) {
                    if (obj == null || !(obj instanceof EObject)) continue;
                    elements.add((EObject)obj);
                }
                this._dataInput = elements;
            }
        } else {
            HashSet<Object> elements;
            boolean shouldRefresh = false;
            boolean addedContent = false;
            if (newInput_p instanceof Collection) {
                elements = new HashSet();
                for (Object obj : (Collection)newInput_p) {
                    if (obj == null || !(obj instanceof EObject)) continue;
                    elements.add((EObject)obj);
                }
                this._dataInput = elements;
                shouldRefresh = true;
                addedContent = true;
            } else if (oldInput_p instanceof Collection && newInput_p != null) {
                elements = new HashSet<EObject>(this._dataInput);
                for (Object obj : (Collection)oldInput_p) {
                    elements.remove(obj);
                }
                this._dataInput = elements;
                shouldRefresh = true;
            }
            if (shouldRefresh) {
                this._viewer.refresh();
                if (addedContent && this.isExpandingNewContent()) {
                    Object[] objectArray = (Object[])newInput_p;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        this._viewer.expandToLevel(o, 0);
                        ++n2;
                    }
                }
            }
        }
    }

    public boolean isExpandingNewContent() {
        return this.expandAddedContent;
    }

    public void setExpandingNewContent(boolean b) {
        this.expandAddedContent = b;
    }

    public void dispose() {
        this._dataInput = null;
    }
}

