/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.gmf;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.diffmerge.api.config.IConfigurablePolicy;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.gmf.Messages;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableMatchPolicy;
import org.eclipse.emf.diffmerge.structures.common.comparable.ComparableTreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class GMFMatchPolicy
extends ConfigurableMatchPolicy {
    public static final ConfigurableMatchPolicy.FineGrainedMatchCriterion CRITERION_SEMANTICS_DIAGRAMS_VIEWBYTYPE = new ConfigurableMatchPolicy.FineGrainedMatchCriterion(ConfigurableMatchPolicy.MatchCriterionKind.SEMANTICS, Messages.GMFMatchPolicy_Criterion_ShapeType, Messages.GMFMatchPolicy_Criterion_ShapeType_Tooltip);
    public static final ConfigurableMatchPolicy.FineGrainedMatchCriterion CRITERION_SEMANTICS_DIAGRAMS_VIEWBYELEMENT = new ConfigurableMatchPolicy.FineGrainedMatchCriterion(ConfigurableMatchPolicy.MatchCriterionKind.SEMANTICS, Messages.GMFMatchPolicy_Criterion_RepresentedElement, Messages.GMFMatchPolicy_Criterion_RepresentedElement_Tooltip);
    protected static final String SEMANTIC_ID_VIEWTYPE_PROPERTY = "SEMANTIC_VIEWTYPE";
    protected static final String SEMANTIC_ID_ELEMENT_PROPERTY = "SEMANTIC_ELEMENT";
    protected static final String SEMANTIC_ID_DIAGRAM_PROPERTY = "SEMANTIC_DIAGRAM";
    protected static final String SEMANTIC_ID_TYPE_PROPERTY = "SEMANTIC_TYPE";
    protected static final String SEMANTIC_ID_CONTAINER_PROPERTY = "SEMANTIC_ID_CONTAINER";
    protected static final Collection<String> NON_SEMANTIC_VIEWTYPES = Arrays.asList("Note", "NoteAttachment");

    public GMFMatchPolicy() {
    }

    public GMFMatchPolicy(GMFMatchPolicy policy_p) {
        this();
        this.update((IConfigurablePolicy)policy_p);
    }

    public GMFMatchPolicy clone() throws CloneNotSupportedException {
        return new GMFMatchPolicy(this);
    }

    public List<ConfigurableMatchPolicy.FineGrainedMatchCriterion> getAvailableFineGrainedCriteria() {
        List result = super.getAvailableFineGrainedCriteria();
        result.add(CRITERION_SEMANTICS_DIAGRAMS_VIEWBYELEMENT);
        result.add(CRITERION_SEMANTICS_DIAGRAMS_VIEWBYTYPE);
        return result;
    }

    protected String getSemanticID(EObject element_p, IModelScope scope_p) {
        String result = null;
        if (element_p instanceof View && !(element_p instanceof Diagram)) {
            result = this.getViewSemanticID((View)element_p, scope_p);
        }
        if (result == null) {
            result = super.getSemanticID(element_p, scope_p);
        }
        return result;
    }

    protected String getName(EObject element_p, IModelScope scope_p) {
        String result = element_p instanceof Diagram ? ((Diagram)element_p).getName() : super.getName(element_p, scope_p);
        return result;
    }

    protected String getViewSemanticID(View view_p, IModelScope scope_p) {
        String result = null;
        String viewType = view_p.getType();
        if (viewType != null && !NON_SEMANTIC_VIEWTYPES.contains(viewType)) {
            EObject representedElement = this.getViewElement(view_p, scope_p);
            if (representedElement != null) {
                if (this.useFineGrainedCriterion(CRITERION_SEMANTICS_DIAGRAMS_VIEWBYELEMENT)) {
                    result = this.getViewElementBasedSemanticID(view_p, scope_p, representedElement, viewType);
                }
            } else if (this.useFineGrainedCriterion(CRITERION_SEMANTICS_DIAGRAMS_VIEWBYTYPE)) {
                result = this.getViewTypeBasedSemanticID(view_p, scope_p, viewType);
            }
        }
        return result;
    }

    protected EObject getViewElement(View view_p, IModelScope scope_p) {
        EObject result = null;
        EReference VIEW_TO_ELEMENT = NotationPackage.eINSTANCE.getView_Element();
        if (view_p.eIsSet((EStructuralFeature)VIEW_TO_ELEMENT) && scope_p instanceof IFeaturedModelScope) {
            IFeaturedModelScope scope = (IFeaturedModelScope)scope_p;
            List values = scope.get((EObject)view_p, VIEW_TO_ELEMENT);
            if (values.size() == 1) {
                result = (EObject)values.get(0);
            }
        } else {
            result = view_p.getElement();
        }
        return result;
    }

    protected String getViewElementBasedSemanticID(View view_p, IModelScope scope_p, EObject represented_p, String viewType) {
        String representedID;
        String diagramID;
        String result = null;
        Diagram diagram = view_p.getDiagram();
        if (diagram != null && (diagramID = this.getMatchID((EObject)diagram, scope_p)) != null && (representedID = this.getMatchID(represented_p, scope_p)) != null) {
            ComparableTreeMap map = new ComparableTreeMap();
            map.put(SEMANTIC_ID_TYPE_PROPERTY, view_p.eClass().getName());
            map.put(SEMANTIC_ID_DIAGRAM_PROPERTY, diagramID);
            map.put(SEMANTIC_ID_ELEMENT_PROPERTY, representedID);
            map.put(SEMANTIC_ID_VIEWTYPE_PROPERTY, viewType);
            result = map.toString();
        }
        return result;
    }

    protected String getViewTypeBasedSemanticID(View view_p, IModelScope scope_p, String viewType) {
        String containerID;
        String result = null;
        EObject container = this.getContainer((EObject)view_p, scope_p);
        if (container != null && (containerID = this.getMatchID(container, scope_p)) != null) {
            ComparableTreeMap map = new ComparableTreeMap();
            map.put(SEMANTIC_ID_TYPE_PROPERTY, view_p.eClass().getName());
            map.put(SEMANTIC_ID_CONTAINER_PROPERTY, containerID);
            map.put(SEMANTIC_ID_VIEWTYPE_PROPERTY, viewType);
            result = map.toString();
        }
        return result;
    }

    protected boolean isDiscriminatingContainment(EObject element_p, EReference containment_p) {
        return super.isDiscriminatingContainment(element_p, containment_p) || containment_p == NotationPackage.eINSTANCE.getView_Styles();
    }
}

