/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.debug.model;

import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.debug.model.IDebugIDEController;
import org.eclipse.dirigible.repository.ext.debug.DebugModel;
import org.eclipse.dirigible.repository.ext.debug.DebugSessionModel;
import org.eclipse.dirigible.repository.ext.debug.IDebugController;
import org.eclipse.dirigible.repository.logging.Logger;

public class DebugModelFacade {
    private static final Logger logger = Logger.getLogger(DebugModelFacade.class);
    private static DebugModelFacade debugModelFacade;

    public static DebugModelFacade getInstance() {
        if (debugModelFacade == null) {
            debugModelFacade = new DebugModelFacade();
        }
        return debugModelFacade;
    }

    public DebugSessionModel getDebugSessionModel(String executionId) {
        DebugSessionModel debugModel = DebugModelFacade.getDebugModel().getSessionByExecutionId(executionId);
        if (debugModel == null) {
            logger.warn("Getting debug session with executionId: " + executionId + " failed - no such session exists");
        }
        return debugModel;
    }

    public void removeSession(String executionId) {
        DebugSessionModel session = DebugModelFacade.getDebugModel().getSessionByExecutionId(executionId);
        DebugModelFacade.getDebugModel().getSessions().remove(session);
        logger.debug("Debug session with executionId: " + executionId + " removed");
    }

    public static DebugModel getDebugModel() {
        DebugModel debugModel = (DebugModel)CommonParameters.getObject((String)"debug.model");
        if (debugModel == null) {
            logger.debug("Debug model not created!");
        }
        return debugModel;
    }

    public static void createDebugModel(IDebugIDEController debugController) {
        DebugModel debugModel = new DebugModel((IDebugController)debugController);
        CommonParameters.setObject((String)"debug.model", (Object)debugModel);
    }
}

