/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.wizard.project.sample;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.workspace.wizard.project.sample.Messages;
import org.eclipse.dirigible.ide.workspace.wizard.project.sample.SampleProjectWizardGitTemplatePage;
import org.eclipse.dirigible.ide.workspace.wizard.project.sample.SampleProjectWizardModel;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class SampleProjectWizard
extends Wizard {
    private static final String SampleProjectWizard_WINDOW_TITLE = Messages.SampleProjectWizard_WINDOW_TITLE;
    private static final String COULD_NOT_CREATE_PROJECT = Messages.SampleProjectWizard_COULD_NOT_CREATE_PROJECT;
    private static final String OPERATION_FAILED = Messages.SampleProjectWizard_OPERATION_FAILED;
    private static final String PROJECT_S_CREATED_SUCCESSFULLY = Messages.SampleProjectWizard_PROJECT_S_CREATED_SUCCESSFULLY;
    private final SampleProjectWizardModel model;
    private final SampleProjectWizardGitTemplatePage samplesPage;
    private static final Logger logger = Logger.getLogger(SampleProjectWizard.class);

    public SampleProjectWizard() {
        this.setWindowTitle(SampleProjectWizard_WINDOW_TITLE);
        this.model = new SampleProjectWizardModel();
        this.samplesPage = new SampleProjectWizardGitTemplatePage(this.model);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.samplesPage);
    }

    public boolean performFinish() {
        String projectName = this.model.getTemplate().getName();
        logger.info(String.format(PROJECT_S_CREATED_SUCCESSFULLY, projectName));
        boolean result = this.onFinish();
        if (result) {
            StatusLineManagerUtil.setInfoMessage((String)String.format(StatusLineManagerUtil.ARTIFACT_HAS_BEEN_CREATED, projectName));
        }
        return result;
    }

    public boolean onFinish() {
        try {
            this.model.execute();
            return true;
        }
        catch (CoreException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            this.showErrorDialog(OPERATION_FAILED, String.format(COULD_NOT_CREATE_PROJECT, ex.getMessage()));
            return false;
        }
    }

    public void showErrorDialog(String title, String message) {
        logger.error(message);
        MessageDialog.openError(null, (String)title, (String)message);
    }
}

