/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.repository.ui.viewer;

import org.eclipse.dirigible.ide.repository.ui.viewer.ArtifactLabelProvider;
import org.eclipse.dirigible.ide.repository.ui.viewer.ArtifactTreeContentProvider;
import org.eclipse.dirigible.ide.repository.ui.viewer.RepositoryViewerResolveNode;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class RepositoryViewer {
    private static final String REPOSITORY_MENU_MANAGER = "Repository Menu Manager";
    public static final String MENU_REPOSITORY = "menu.repository";
    private final TreeViewer viewer;
    private final MenuManager menuManager;
    private IRepository repository = null;

    public RepositoryViewer(Composite parent, int style) {
        PatternFilter filter = new PatternFilter();
        FilteredTree tree = new FilteredTree(parent, 770, filter, true);
        this.viewer = tree.getViewer();
        this.viewer.setLabelProvider((IBaseLabelProvider)new ArtifactLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArtifactTreeContentProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RepositoryViewer.this.handleSelectionChanged((ITreeSelection)event.getSelection());
            }
        });
        this.menuManager = new MenuManager(REPOSITORY_MENU_MANAGER, MENU_REPOSITORY);
        this.menuManager.add((IContributionItem)new GroupMarker("additions"));
        Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.refresh();
    }

    public RepositoryViewer(IRepository repository, Composite parent, int style) {
        this(parent, style);
        this.setRepository(repository);
    }

    public Control getControl() {
        return this.viewer != null ? this.viewer.getControl() : null;
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public void setFocus() {
        Control control = this.getControl();
        if (control != null) {
            control.setFocus();
        }
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.viewer;
    }

    public void setRepository(IRepository repository) {
        this.repository = repository;
        this.viewer.setInput(this.createViewerInput());
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public void refresh() {
        Object[] expandedElements = this.viewer.getExpandedElements();
        this.viewer.refresh();
        this.viewer.setExpandedElements(expandedElements);
    }

    public boolean isDisposed() {
        Control control = this.getControl();
        return control != null ? control.isDisposed() : true;
    }

    public void dispose() {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            control.dispose();
        }
    }

    private void handleSelectionChanged(ITreeSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof RepositoryViewerResolveNode) {
            this.refresh();
        }
    }

    private Object createViewerInput() {
        if (this.repository == null) {
            return new Object[0];
        }
        ICollection root = this.repository.getRoot();
        return new Object[]{root};
    }
}

