/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.common.ui.util;

import org.eclipse.eatop.common.ui.internal.messages.Messages;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.TreePath;

public class InstanceRefAutoCompleter {
    public static void completeInstanceRefContext(EObject instanceref, EStructuralFeature feature, TreePath treePath) {
        EObject chosenTarget = (EObject)treePath.getLastSegment();
        EClass prototypeClass = null;
        int i = treePath.getSegmentCount() - 1;
        while (i > 0) {
            EObject eo = (EObject)treePath.getSegment(i);
            if (InstanceRefAutoCompleter.isPrototype(eo)) {
                prototypeClass = eo.eClass();
                break;
            }
            --i;
        }
        if (chosenTarget == null || prototypeClass == null) {
            return;
        }
        BasicEList candidates = new BasicEList();
        TreePath path = treePath.getParentPath();
        while (path != null && path.getLastSegment() != null) {
            if (((EObject)path.getLastSegment()).eClass() == prototypeClass) {
                candidates.add((Object)((EObject)path.getLastSegment()));
            }
            path = path.getParentPath();
        }
        if (candidates.size() > 0) {
            instanceref.eSet(feature, (Object)candidates);
        }
    }

    private static boolean isPrototype(EObject eo) {
        if (eo instanceof EClass) {
            if (((EClass)eo).getName().equals(Messages.EAPrototype)) {
                return true;
            }
            for (EObject superclass : ((EClass)eo).getEAllSuperTypes()) {
                if (superclass == eo || !InstanceRefAutoCompleter.isPrototype(superclass)) continue;
                return true;
            }
            return false;
        }
        for (EObject superclass : eo.eClass().getESuperTypes()) {
            if (superclass == eo || !InstanceRefAutoCompleter.isPrototype(superclass)) continue;
            return true;
        }
        return false;
    }
}

