/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.common.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.eatop.common.internal.Activator;
import org.eclipse.eatop.common.internal.messages.Messages;
import org.eclipse.eatop.geastadl.ginfrastructure.gelements.GEAPackage;
import org.eclipse.eatop.geastadl.ginfrastructure.gelements.GEAXML;
import org.eclipse.eatop.geastadl.ginfrastructure.gelements.GReferrable;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.util.EObjectUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public final class EastADLURIFactory {
    public static final int DEPTH_INFINITE = 2;
    public static final int DEPTH_ONE = 1;
    public static final int DEPTH_ZERO = 0;
    public static final String EA_SCHEME = "ea";
    public static final String SCHEME_SEPARATOR = ":";
    public static final String SEGMENT_SEPARATOR = "/";
    public static final String QUERY_SEPARATOR = "?";
    public static final String FRAGMENT_SEPARATOR = "#";
    public static final String KEY_VALUE_SEPARATOR = "=";
    public static final String DESTINATION_TYPE_KEY = "type";
    public static final String NON_IDENTIFIABLE_SEGMENT_PREFIX = "@";
    public static final String EAXML_TYPE_NAME = "EAXML";
    public static final String EAXML_ABSOLUTE_QUALIFIED_NAME_SEGMENT = "/";

    private static String createDestinationTypeSpecifier(String destinationTypeName) {
        if (destinationTypeName != null && destinationTypeName.length() > 0) {
            return "type=" + destinationTypeName;
        }
        return "";
    }

    public static String createURIFragment(String absoluteQualifiedName, String destinationTypeName) {
        String uriFragment = absoluteQualifiedName;
        String destinationTypeSpecifier = EastADLURIFactory.createDestinationTypeSpecifier(destinationTypeName);
        if (destinationTypeSpecifier.length() > 0) {
            uriFragment = String.valueOf(uriFragment) + QUERY_SEPARATOR + destinationTypeSpecifier;
        }
        return uriFragment;
    }

    public static URI createEastADLURI(String absoluteQualifiedName, String destinationTypeName) {
        String uriFragment = EastADLURIFactory.createURIFragment(absoluteQualifiedName, destinationTypeName);
        return EastADLURIFactory.createEastADLURI(uriFragment);
    }

    public static URI createEastADLURI(String uriFragment) {
        if (uriFragment != null && uriFragment.length() > 0) {
            return URI.createURI((String)("ea:/#" + uriFragment), (boolean)true);
        }
        return null;
    }

    public static String getAbsoluteQualifiedName(Object object) {
        return EastADLURIFactory.getAbsoluteQualifiedName(null, null, object);
    }

    public static String getAbsoluteQualifiedName(Object owner, EStructuralFeature feature, Object object) {
        if (!(object instanceof EObject)) {
            return "";
        }
        InternalEObject internalObject = (InternalEObject)object;
        if (internalObject.eIsProxy()) {
            String uriFragment = internalObject.eProxyURI().fragment();
            if (uriFragment != null) {
                int queryStringIndex = uriFragment.indexOf(QUERY_SEPARATOR);
                return queryStringIndex != -1 ? uriFragment.substring(0, queryStringIndex) : uriFragment;
            }
            return "";
        }
        ArrayList<String> segments = new ArrayList<String>();
        InternalEObject currentObject = internalObject;
        InternalEObject currentContainer = internalObject.eInternalContainer();
        while (currentContainer != null) {
            EastADLURIFactory.addURIFragmentSegment(segments, currentContainer, (EObject)currentObject);
            currentObject = currentContainer;
            currentContainer = currentObject.eInternalContainer();
        }
        StringBuilder absoluteQualifiedName = new StringBuilder();
        if (currentObject.eIsProxy()) {
            absoluteQualifiedName.append(EastADLURIFactory.getAbsoluteQualifiedName(currentObject));
        } else {
            if (owner != null) {
                absoluteQualifiedName.append(EastADLURIFactory.getAbsoluteQualifiedName(owner));
            }
            EastADLURIFactory.addURIFragmentSegment(segments, (InternalEObject)owner, (EObject)currentObject);
        }
        Collections.reverse(segments);
        for (String segment : segments) {
            if (absoluteQualifiedName.length() > "/".length()) {
                absoluteQualifiedName.append("/");
            } else if (absoluteQualifiedName.length() == "/".length() && !absoluteQualifiedName.toString().equals("/")) {
                absoluteQualifiedName.append("/");
            } else if (absoluteQualifiedName.length() > 0 && absoluteQualifiedName.length() < "/".length()) {
                absoluteQualifiedName.append("/");
            }
            absoluteQualifiedName.append(segment);
        }
        return absoluteQualifiedName.toString();
    }

    private static void addURIFragmentSegment(List<String> segments, InternalEObject owner, EObject object) {
        Assert.isNotNull(segments);
        Assert.isNotNull((Object)object);
        if (object instanceof GReferrable) {
            String shortName = ((GReferrable)object).gGetShortName();
            segments.add(shortName == null ? "" : shortName);
        } else if (object instanceof GEAXML) {
            segments.add("/");
        } else if (owner != null && (segments.size() == 0 || segments.get(segments.size() - 1).contains(NON_IDENTIFIABLE_SEGMENT_PREFIX))) {
            EStructuralFeature containingFeature;
            try {
                containingFeature = object.eContainingFeature();
            }
            catch (NullPointerException ex) {
                containingFeature = null;
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
            if (containingFeature != null) {
                segments.add(owner.eURIFragmentSegment(containingFeature, object));
            }
        }
    }

    private static String getDestinationTypeSpecifier(EObject object) {
        if (object != null) {
            return "type=" + object.eClass().getName();
        }
        return "";
    }

    public static String getURIFragment(EObject object) {
        return EastADLURIFactory.getURIFragment(null, null, object);
    }

    public static String getURIFragment(EObject owner, EStructuralFeature feature, EObject object) {
        String absoluteQualifiedName = EastADLURIFactory.getAbsoluteQualifiedName(owner, feature, object);
        String destinationTypeSpecifier = EastADLURIFactory.getDestinationTypeSpecifier(object);
        if (destinationTypeSpecifier.length() > 0) {
            return String.valueOf(absoluteQualifiedName) + QUERY_SEPARATOR + destinationTypeSpecifier;
        }
        return "";
    }

    public static URI getURI(EObject object) {
        return EastADLURIFactory.getURI(null, null, object);
    }

    public static URI getURI(EObject owner, EStructuralFeature feature, EObject object) {
        String uriFragment = EastADLURIFactory.getURIFragment(owner, feature, object);
        return EastADLURIFactory.createEastADLURI(uriFragment);
    }

    public static EObject getEObject(EObject eObject, String uriFragment) {
        if (eObject == null || uriFragment == null) {
            return null;
        }
        if (uriFragment.startsWith("/")) {
            EObject resolvedEObject;
            if (!(eObject instanceof GEAXML)) {
                return null;
            }
            GEAXML eaxmlObject = (GEAXML)eObject;
            String remainingSegments = uriFragment.substring(1);
            if (EastADLURIFactory.getLeadingAbsoluteQualifiedNameSegment(remainingSegments).length() == 0 && remainingSegments.indexOf("/") == -1 && EAXML_TYPE_NAME.equals(EastADLURIFactory.getDestinationTypeName(remainingSegments))) {
                return eObject;
            }
            EList eaPackages = eaxmlObject.gGetTopLevelPackage();
            for (GEAPackage eaPackage : eaPackages) {
                resolvedEObject = EastADLURIFactory.resolveAgainstEAPackage(eaPackage, remainingSegments);
                if (resolvedEObject == null) continue;
                return resolvedEObject;
            }
            for (EObject containedEObject : eObject.eContents()) {
                if (containedEObject instanceof GEAPackage || (resolvedEObject = EastADLURIFactory.resolveAgainstAnyObject(containedEObject, remainingSegments, 2)) == null) continue;
                return resolvedEObject;
            }
            return null;
        }
        return EastADLURIFactory.resolveAgainstAnyObject(eObject, uriFragment, 2);
    }

    private static EObject resolveAgainstEAPackage(GEAPackage eaPackage, String uriFragment) {
        Assert.isNotNull((Object)eaPackage);
        Assert.isNotNull((Object)uriFragment);
        String eaPackageSegment = EastADLURIFactory.getAbsoluteQualifiedNameSegment((InternalEObject)eaPackage);
        String leadingSegment = EastADLURIFactory.getLeadingAbsoluteQualifiedNameSegment(uriFragment);
        if (EastADLURIFactory.matchesSegmentOf(leadingSegment, eaPackageSegment)) {
            EObject resolvedEObject = EastADLURIFactory.resolveAgainstAnyObject((EObject)eaPackage, uriFragment, 0);
            if (resolvedEObject != null) {
                return resolvedEObject;
            }
            int nextSeparatorIndex = uriFragment.indexOf("/");
            String remainingSegments = uriFragment.substring(nextSeparatorIndex + 1);
            EList elements = eaPackage.gGetElement();
            for (EObject element : elements) {
                resolvedEObject = EastADLURIFactory.resolveAgainstAnyObject(element, remainingSegments, 2);
                if (resolvedEObject == null) continue;
                return resolvedEObject;
            }
            EList subPackages = eaPackage.gGetSubPackage();
            for (GEAPackage subPackage : subPackages) {
                resolvedEObject = EastADLURIFactory.resolveAgainstEAPackage(subPackage, remainingSegments);
                if (resolvedEObject == null) continue;
                return resolvedEObject;
            }
            EStructuralFeature elementsFeature = eaPackage.eClass().getEStructuralFeature("element");
            EStructuralFeature eaPackagePackagesFeature = eaPackage.eClass().getEStructuralFeature("subPackage");
            resolvedEObject = EastADLURIFactory.resolveAgainstAnyObject((EObject)eaPackage, uriFragment, 2, new EStructuralFeature[]{elementsFeature, eaPackagePackagesFeature});
            if (resolvedEObject != null) {
                return resolvedEObject;
            }
        }
        return null;
    }

    private static EObject resolveAgainstAnyObject(EObject object, String uriFragment, int depth) {
        return EastADLURIFactory.resolveAgainstAnyObject(object, uriFragment, depth, new EStructuralFeature[0]);
    }

    private static EObject resolveAgainstAnyObject(EObject eObject, String uriFragment, int depth, EStructuralFeature[] featuresToBeIgnored) {
        Assert.isNotNull((Object)eObject);
        Assert.isNotNull((Object)uriFragment);
        String eObjectSegment = EastADLURIFactory.getAbsoluteQualifiedNameSegment((InternalEObject)eObject);
        String leadingSegment = EastADLURIFactory.getLeadingAbsoluteQualifiedNameSegment(uriFragment);
        if (EastADLURIFactory.matchesSegmentOf(leadingSegment, eObjectSegment)) {
            int nextSeparatorIndex = uriFragment.indexOf("/");
            if (nextSeparatorIndex == -1 && leadingSegment.equals(eObjectSegment) && EObjectUtil.isAssignableFrom((EClass)eObject.eClass(), (String)EastADLURIFactory.getDestinationTypeName(uriFragment))) {
                return eObject;
            }
            if (depth == 0) {
                return null;
            }
            if (depth == 1) {
                depth = 0;
            }
            String remainingSegments = uriFragment.substring(nextSeparatorIndex + 1);
            List<EStructuralFeature> featuresToBeIgnoredList = Arrays.asList(featuresToBeIgnored);
            EcoreUtil.ProperContentIterator<EObject> contents = EastADLURIFactory.newNonResolvingContentsIterator(eObject);
            while (contents.hasNext()) {
                EObject resolvedEObject;
                EObject containedEObject = (EObject)contents.next();
                if (!EastADLURIFactory.isProperContent(eObject, containedEObject) || featuresToBeIgnoredList.size() != 0 && featuresToBeIgnoredList.contains(containedEObject.eContainingFeature()) || (resolvedEObject = EastADLURIFactory.resolveAgainstAnyObject(containedEObject, remainingSegments, depth, featuresToBeIgnored)) == null) continue;
                return resolvedEObject;
            }
        }
        return null;
    }

    private static boolean isProperContent(EObject eObject, EObject containedEObject) {
        return !containedEObject.eIsProxy() && containedEObject.eContainer() == eObject;
    }

    private static EcoreUtil.ProperContentIterator<EObject> newNonResolvingContentsIterator(EObject eObject) {
        return new EcoreUtil.ProperContentIterator(eObject, false);
    }

    private static String getAbsoluteQualifiedNameSegment(InternalEObject eObject) {
        if (eObject != null) {
            if (eObject instanceof GReferrable) {
                String shortName = ((GReferrable)eObject).gGetShortName();
                if (shortName != null) {
                    return shortName;
                }
            } else if (eObject.eInternalContainer() != null) {
                return eObject.eInternalContainer().eURIFragmentSegment(eObject.eContainingFeature(), (EObject)eObject);
            }
        }
        return "";
    }

    private static String getLeadingAbsoluteQualifiedNameSegment(String uriFragment) {
        if (uriFragment != null) {
            int nextSeparatorIndex = uriFragment.indexOf("/");
            if (nextSeparatorIndex != -1) {
                return uriFragment.substring(0, nextSeparatorIndex);
            }
            int queryStringIndex = uriFragment.indexOf(QUERY_SEPARATOR);
            return queryStringIndex != -1 ? uriFragment.substring(0, queryStringIndex) : uriFragment;
        }
        return "";
    }

    public static String getTrailingAbsoluteQualifiedNameSegment(String uriFragment) {
        if (uriFragment != null) {
            int queryStringIndex;
            String lastSegment = uriFragment;
            int lastSeparatorIndex = uriFragment.lastIndexOf("/");
            if (lastSeparatorIndex != -1 && lastSeparatorIndex < uriFragment.length() - 1) {
                lastSegment = uriFragment.substring(lastSeparatorIndex + 1);
            }
            return (queryStringIndex = lastSegment.indexOf(QUERY_SEPARATOR)) != -1 ? lastSegment.substring(0, queryStringIndex) : lastSegment;
        }
        return "";
    }

    private static boolean matchesSegmentOf(String absoluteQualifiedNameSegment, String eObjectSegment) {
        Assert.isNotNull((Object)eObjectSegment);
        Assert.isNotNull((Object)absoluteQualifiedNameSegment);
        if (!absoluteQualifiedNameSegment.startsWith(NON_IDENTIFIABLE_SEGMENT_PREFIX) && eObjectSegment.startsWith(NON_IDENTIFIABLE_SEGMENT_PREFIX)) {
            return true;
        }
        return eObjectSegment.equals(absoluteQualifiedNameSegment);
    }

    private static String getDestinationTypeName(String uriFragment) {
        if (uriFragment != null) {
            int queryStringIndex = uriFragment.indexOf(QUERY_SEPARATOR);
            int queryStringValueOffset = KEY_VALUE_SEPARATOR.length() + DESTINATION_TYPE_KEY.length() + KEY_VALUE_SEPARATOR.length();
            if (queryStringIndex != -1 && queryStringIndex + queryStringValueOffset < uriFragment.length()) {
                return uriFragment.substring(queryStringIndex + queryStringValueOffset);
            }
        }
        return "";
    }

    public static Diagnostic validateURI(String uri) {
        Diagnostic diagnostic = Diagnostic.OK_INSTANCE;
        String errorMessage = null;
        String scheme = "ea:/#";
        String queryType = "?type=";
        int lastIndexOf = uri.lastIndexOf(queryType);
        String destinationTypeName = null;
        if (lastIndexOf > 0) {
            destinationTypeName = uri.substring(lastIndexOf, uri.length());
        }
        if (!uri.startsWith(scheme)) {
            errorMessage = NLS.bind((String)Messages.error_invalidEastADLURIMustStartWithEastadlScheme, (Object)scheme);
        } else if (destinationTypeName != null) {
            if (destinationTypeName.contains(SCHEME_SEPARATOR)) {
                errorMessage = NLS.bind((String)Messages.error_invalidEastADLURIInvalideDestinationTypeSpecifier, (Object[])new Object[]{destinationTypeName, SCHEME_SEPARATOR});
            } else if (destinationTypeName.contains("/")) {
                errorMessage = NLS.bind((String)Messages.error_invalidEastADLURIInvalideDestinationTypeSpecifier, (Object[])new Object[]{destinationTypeName, "/"});
            } else if (destinationTypeName.contains(FRAGMENT_SEPARATOR)) {
                errorMessage = NLS.bind((String)Messages.error_invalidEastADLURIInvalideDestinationTypeSpecifier, (Object[])new Object[]{destinationTypeName, FRAGMENT_SEPARATOR});
            }
        } else if (destinationTypeName == null) {
            errorMessage = NLS.bind((String)Messages.error_invalidEastADLURIMustContentQueryDestinationTypeSpecifier, (Object)"?type=");
        }
        if (errorMessage != null) {
            return new BasicDiagnostic(Activator.getPlugin().getSymbolicName(), 4, errorMessage, new Object[]{uri});
        }
        return diagnostic;
    }
}

