/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.examples.actions.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.eatop.common.ui.util.ModelSearcher;
import org.eclipse.eatop.examples.actions.FindInstanceRefsAction;
import org.eclipse.eatop.examples.actions.FindReferencesAction;
import org.eclipse.eatop.examples.actions.GoToInstanceReferredItemAction;
import org.eclipse.eatop.examples.actions.GotoTypeAction;
import org.eclipse.eatop.examples.actions.internal.messages.Messages;
import org.eclipse.eatop.examples.actions.providers.AbstractEatopExampleActionProvider;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.platform.ui.util.SelectionUtil;

public class EastadlExampleActionProvider
extends AbstractEatopExampleActionProvider {
    protected FindReferencesAction findReferencesAction;
    protected GotoTypeAction gotoTypeAction;
    protected Collection<IAction> createinstanceRefsActions;
    protected Collection<IAction> createReferenceActions;
    protected Collection<IAction> followAssociationActions;

    protected void doInit() {
        this.gotoTypeAction = new GotoTypeAction();
        if (this.selectionProvider != null) {
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.gotoTypeAction);
            ISelection selection = this.selectionProvider.getSelection();
            IStructuredSelection structuredSelection = SelectionUtil.getStructuredSelection((ISelection)selection);
            this.gotoTypeAction.updateSelection(structuredSelection);
        }
    }

    public void fillContextMenu(IMenuManager contextMenuManager) {
        contextMenuManager.appendToGroup("group.goto", (IContributionItem)new ActionContributionItem((IAction)this.gotoTypeAction));
        super.fillContextMenu(contextMenuManager);
        this.updateActions(this.getContext().getSelection());
        MenuManager findInstanceRefMenuManager = new MenuManager(Messages.act_findInstanceRefs_label);
        this.populateManager((IContributionManager)findInstanceRefMenuManager, this.createinstanceRefsActions, null);
        contextMenuManager.appendToGroup("group.goto", (IContributionItem)findInstanceRefMenuManager);
        MenuManager findRefMenuManager = new MenuManager(Messages.act_findReferences_label);
        this.populateManager((IContributionManager)findRefMenuManager, this.createReferenceActions, null);
        this.populateManager((IContributionManager)findRefMenuManager, this.followAssociationActions, null);
        contextMenuManager.appendToGroup("group.goto", (IContributionItem)findRefMenuManager);
        MenuManager associationMenuManager = new MenuManager("Associations");
        this.populateManager((IContributionManager)associationMenuManager, this.followAssociationActions, null);
        contextMenuManager.appendToGroup("group.goto", (IContributionItem)associationMenuManager);
    }

    public void dispose() {
        if (this.selectionProvider != null && this.gotoTypeAction != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.gotoTypeAction);
        }
        super.dispose();
    }

    protected void updateActions(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.createinstanceRefsActions = this.generateCreateInstanceRefActions((IStructuredSelection)selection);
            this.createReferenceActions = this.generateCreateRefActions((IStructuredSelection)selection);
            this.followAssociationActions = this.generateJumpToReferredActions((IStructuredSelection)selection);
        }
    }

    protected Collection<IAction> generateCreateInstanceRefActions(IStructuredSelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (selection.getFirstElement() instanceof EObject) {
            ArrayList refs = ModelSearcher.findInstanceReferences((EObject)((EObject)selection.getFirstElement()));
            for (EObject ref : refs) {
                actions.add((IAction)new FindInstanceRefsAction(ref, selection));
            }
            Collections.sort(actions, new Comparator<IAction>(){

                @Override
                public int compare(IAction a1, IAction a2) {
                    if (a1.getText() == null && a2.getText() != null) {
                        return -1;
                    }
                    if (a1.getText() == null && a2.getText() == null) {
                        return 0;
                    }
                    if (a1.getText() != null && a2.getText() == null) {
                        return 1;
                    }
                    return CommonPlugin.INSTANCE.getComparator().compare(a1.getText(), a2.getText());
                }
            });
        }
        return actions;
    }

    protected Collection<IAction> generateCreateRefActions(IStructuredSelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (selection.getFirstElement() instanceof EObject) {
            ArrayList refs = ModelSearcher.findReferences((EObject)((EObject)selection.getFirstElement()));
            for (EObject ref : refs) {
                actions.add((IAction)new FindReferencesAction(ref, selection));
            }
            Collections.sort(actions, new Comparator<IAction>(){

                @Override
                public int compare(IAction a1, IAction a2) {
                    if (a1.getText() == null && a2.getText() != null) {
                        return -1;
                    }
                    if (a1.getText() == null && a2.getText() == null) {
                        return 0;
                    }
                    if (a1.getText() != null && a2.getText() == null) {
                        return 1;
                    }
                    return CommonPlugin.INSTANCE.getComparator().compare(a1.getText(), a2.getText());
                }
            });
        }
        return actions;
    }

    protected Collection<IAction> generateJumpToReferredActions(IStructuredSelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (selection.getFirstElement() instanceof EObject) {
            for (EObject ref : ModelSearcher.getAssociationChildren((EObject)((EObject)selection.getFirstElement()))) {
                actions.add((IAction)new GoToInstanceReferredItemAction(ref, selection));
            }
            Collections.sort(actions, new Comparator<IAction>(){

                @Override
                public int compare(IAction a1, IAction a2) {
                    if (a1.getText() == null && a2.getText() != null) {
                        return -1;
                    }
                    if (a1.getText() == null && a2.getText() == null) {
                        return 0;
                    }
                    if (a1.getText() != null && a2.getText() == null) {
                        return 1;
                    }
                    return CommonPlugin.INSTANCE.getComparator().compare(a1.getText(), a2.getText());
                }
            });
        }
        return actions;
    }
}

