/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.workspace.ui.wizards;

import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.eatop.workspace.jobs.CreateEatopProjectJob;
import org.eclipse.eatop.workspace.ui.internal.Activator;
import org.eclipse.eatop.workspace.ui.internal.messages.Messages;
import org.eclipse.eatop.workspace.ui.messages.ErrorUIMessages;
import org.eclipse.eatop.workspace.ui.messages.WorkspaceUIMessages;
import org.eclipse.eatop.workspace.ui.wizards.pages.EastADLProjectWizardFirstPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class BasicEastADLProjectWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    private EastADLProjectWizardFirstPage mainPage;
    private WizardNewProjectReferencePage referencePage;
    private IConfigurationElement configElement;
    private static String WINDOW_PROBLEMS_TITLE = ErrorUIMessages.error_newProjectOpeningWindow;
    private static final String FINAL_PERSPECTIVE = "finalPerspective";
    private static final String PREFERRED_PERSPECTIVES = "preferredPerspectives";
    private static final String WIZBAN_ICON_FILE = "full/wizban/neweaprj_wiz.png";

    public BasicEastADLProjectWizard() {
        IDialogSettings workbenchSettings = Activator.getPlugin().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("BasicNewProjectResourceWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("BasicNewProjectResourceWizard");
        }
        this.setDialogSettings(section);
    }

    private static void addPerspectiveAndDescendants(List<String> perspectiveIds, String id) {
        IPerspectiveDescriptor[] perspectives;
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = perspectives = registry.getPerspectives();
        int n = perspectives.length;
        int n2 = 0;
        while (n2 < n) {
            IPerspectiveDescriptor element = iPerspectiveDescriptorArray[n2];
            PerspectiveDescriptor descriptor = (PerspectiveDescriptor)element;
            if (descriptor.getOriginalId().equals(id)) {
                perspectiveIds.add(descriptor.getId());
            }
            ++n2;
        }
    }

    private static void replaceCurrentPerspective(IPerspectiveDescriptor persp) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        page.setPerspective(persp);
    }

    private static boolean confirmPerspectiveSwitch(IWorkbenchWindow window, IPerspectiveDescriptor finalPersp) {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String pspm = store.getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!"prompt".equals(pspm)) {
            return "always".equals(pspm);
        }
        String desc = finalPersp.getDescription();
        String message = desc == null || desc.length() == 0 ? NLS.bind((String)WorkspaceUIMessages.label_newProjectPerspSwitchMessage, (Object)finalPersp.getLabel()) : NLS.bind((String)WorkspaceUIMessages.label_newProjectPerspSwitchMessageWithDesc, (Object[])new String[]{finalPersp.getLabel(), desc});
        String toggleMessage = null;
        boolean toggleState = false;
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)WorkspaceUIMessages.label_newProjectPerspSwitchTitle, (String)message, toggleMessage, (boolean)toggleState, (IPreferenceStore)store, (String)"SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        int result = dialog.getReturnCode();
        if (dialog.getToggleState()) {
            String preferenceValue = result == 2 ? "OPEN_PERSPECTIVE_REPLACE" : "NO_NEW_PERSPECTIVE";
            PrefUtil.getAPIPreferenceStore().setValue("PROJECT_OPEN_NEW_PERSPECTIVE", preferenceValue);
        }
        return result == 2;
    }

    private static void openInNewWindow(IPerspectiveDescriptor desc) {
        block2: {
            try {
                PlatformUI.getWorkbench().openWorkbenchWindow(desc.getId(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot());
            }
            catch (WorkbenchException e) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) break block2;
                ErrorDialog.openError((Shell)window.getShell(), (String)WINDOW_PROBLEMS_TITLE, (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
    }

    protected void updatePerspective() {
        BasicEastADLProjectWizard.updatePerspective(this.configElement);
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = Activator.getPlugin().getImageDescriptor(WIZBAN_ICON_FILE);
        this.setDefaultPageImageDescriptor(desc);
    }

    public boolean performFinish() {
        this.mainPage.saveDialogSettings();
        URI location = !this.mainPage.useDefaults() ? this.mainPage.getLocationURI() : null;
        IProject[] referencedProjects = this.referencePage != null ? this.referencePage.getReferencedProjects() : null;
        final IProject projectHandle = this.mainPage.getProjectHandle();
        CreateEatopProjectJob job = new CreateEatopProjectJob(Messages.job_creatingEastADLProject, projectHandle, location, this.mainPage.getRelease());
        job.setReferencedProjects(referencedProjects);
        job.setUiInfoAdaptable(WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display display;
                if (event.getResult().getSeverity() == 0 && (display = ExtendedPlatformUI.getDisplay()) != null) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            BasicEastADLProjectWizard.this.updatePerspective();
                            BasicEastADLProjectWizard.selectAndReveal((IResource)projectHandle, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                        }
                    });
                }
            }
        });
        job.schedule();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(WorkspaceUIMessages.wizard_newEastADLProject_title);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new EastADLProjectWizardFirstPage("basicNewProjectPage");
        this.mainPage.setTitle(WorkspaceUIMessages.page_newEastADLProjectCreation_title);
        this.mainPage.setDescription(WorkspaceUIMessages.page_neweEastADLProjectCreation_description);
        this.addPage((IWizardPage)this.mainPage);
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length > 0) {
            this.referencePage = new WizardNewProjectReferencePage("basicReferenceProjectPage");
            this.referencePage.setTitle(WorkspaceUIMessages.label_newProjectReferenceTitle);
            this.referencePage.setDescription(WorkspaceUIMessages.label_newProjectReferenceDescription);
            this.addPage((IWizardPage)this.referencePage);
        }
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    public static void updatePerspective(IConfigurationElement configElement) {
        int workbenchPerspectiveSetting;
        IWorkbenchWindow window;
        if (configElement == null) {
            return;
        }
        String perspSetting = PrefUtil.getAPIPreferenceStore().getString("PROJECT_OPEN_NEW_PERSPECTIVE");
        String promptSetting = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!promptSetting.equals("prompt") && perspSetting.equals("NO_NEW_PERSPECTIVE")) {
            return;
        }
        String finalPerspId = configElement.getAttribute(FINAL_PERSPECTIVE);
        if (finalPerspId == null) {
            return;
        }
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor finalPersp = reg.findPerspectiveWithId(finalPerspId);
        if (finalPersp != null && finalPersp instanceof IPluginContribution) {
            HashSet enabledIds;
            IWorkbenchActivitySupport workbenchActivitySupport;
            IActivityManager activityManager;
            IIdentifier identifier;
            Set idActivities;
            IPluginContribution contribution = (IPluginContribution)finalPersp;
            if (contribution.getPluginId() != null && !(idActivities = (identifier = (activityManager = (workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport()).getActivityManager()).getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)contribution))).getActivityIds()).isEmpty() && (enabledIds = new HashSet(activityManager.getEnabledActivityIds())).addAll(idActivities)) {
                workbenchActivitySupport.setEnabledActivityIds(enabledIds);
            }
        } else {
            PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)new RuntimeException(MessageFormat.format(ErrorUIMessages.error_unableToFindPerspective, finalPerspId)));
            return;
        }
        ArrayList<String> preferredPerspIds = new ArrayList<String>();
        BasicEastADLProjectWizard.addPerspectiveAndDescendants(preferredPerspIds, finalPerspId);
        String preferred = configElement.getAttribute(PREFERRED_PERSPECTIVES);
        if (preferred != null) {
            StringTokenizer tok = new StringTokenizer(preferred, " \t\n\r\f,");
            while (tok.hasMoreTokens()) {
                BasicEastADLProjectWizard.addPerspectiveAndDescendants(preferredPerspIds, tok.nextToken());
            }
        }
        if ((window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            IPerspectiveDescriptor currentPersp;
            IWorkbenchPage page = window.getActivePage();
            if (page != null && (currentPersp = page.getPerspective()) != null && preferredPerspIds.contains(currentPersp.getId())) {
                return;
            }
            if (!BasicEastADLProjectWizard.confirmPerspectiveSwitch(window, finalPersp)) {
                return;
            }
        }
        if ((workbenchPerspectiveSetting = WorkbenchPlugin.getDefault().getPreferenceStore().getInt("OPEN_PERSPECTIVE_MODE")) == 2) {
            BasicEastADLProjectWizard.openInNewWindow(finalPersp);
            return;
        }
        BasicEastADLProjectWizard.replaceCurrentPerspective(finalPersp);
    }
}

